theory HeapSortProof = HeapSortProg + VCG:

defs SPEC_def:"SPEC M == 
  (if M = Insert then \<lbrace> {t_}, 1, emptyfinmap(t_ \<mapsto>\<^sub>f(TreeET 0 0)) \<ggreater> TreeET 0 0, 0\<rbrace> else
  if M = Removesome then \<lbrace> {t_}, 0, emptyfinmap(t_ \<mapsto>\<^sub>f(TreeET 0 0)) \<ggreater> ResultET 0 (TreeET 0 0) 0, 0\<rbrace> else
  if M = Removetop then \<lbrace> {t_}, 0, emptyfinmap(t_ \<mapsto>\<^sub>f(TreeET 0 0)) \<ggreater> ResultET 0 (TreeET 0 0) 0, 0\<rbrace> else
  if M = Make_heap then \<lbrace> {l_}, 0, emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0 0)) \<ggreater> TreeET 0 0, 0\<rbrace> else
  if M = Extract then \<lbrace> {h_}, 0, emptyfinmap(h_ \<mapsto>\<^sub>f(TreeET 0 0)) \<ggreater> ListET 0 0, 0\<rbrace> else
  if M = Siftdown then \<lbrace> {t1_, t2_}, 1, emptyfinmap(t1_ \<mapsto>\<^sub>f(TreeET 0 0))(t2_ \<mapsto>\<^sub>f(TreeET 0 0)) \<ggreater> TreeET 0 0, 0\<rbrace> else
  if M = Sort then \<lbrace> {l_}, 0, (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0 0))) \<ggreater> ListET 0 0, 0\<rbrace> else 
  (\<lambda> E h hh v p . False))"
text{*FST and vMST remain unspecified.*}

text {*In order to prove the body correct we define a 
       context which contains an one entry for each syntactic method invocation.*}
constdefs  HeapSortContext:: vdmcontext
"HeapSortContext \<equiv> 
  {(HS\<bullet>Insert([INarg x_,RNarg r2_]), sMST HS Insert [INarg x_,RNarg r2_]),
  (HS\<bullet>Insert([INarg v4_,RNarg r2_]), sMST HS Insert [INarg v4_,RNarg r2_]),
  (HS\<bullet>Insert([INarg v2_,RNarg l_]), sMST HS Insert [INarg v2_,RNarg l_]),
  (HS\<bullet>Removesome([RNarg r1_]), sMST HS Removesome [RNarg r1_]),
  (HS\<bullet>Removetop([RNarg h_]), sMST HS Removetop [RNarg h_]),
  (HS\<bullet>Extract([RNarg r1_]), sMST HS Extract [RNarg r1_]),
  (HS\<bullet>Make_heap([RNarg l_]), sMST HS Make_heap [RNarg l_]),
  (HS\<bullet>Make_heap([RNarg r1_]), sMST HS Make_heap [RNarg r1_]),
  (HS\<bullet>Siftdown([INarg v2_, RNarg r3_, RNarg r1_]), sMST HS Siftdown [INarg v2_, RNarg r3_, RNarg r1_]),
  (HS\<bullet>Siftdown([INarg w_, RNarg r5_, RNarg r4_]), sMST HS Siftdown [INarg w_, RNarg r5_, RNarg r4_]),
  (HS\<bullet>Siftdown([INarg w_, RNarg r8_, RNarg r7_]), sMST HS Siftdown [INarg w_, RNarg r8_, RNarg r7_]),
  (HS\<bullet>Sort([RNarg l_]), sMST HS Sort [RNarg l_])}"

lemma HSContext_finite[simp]: "finite HeapSortContext"
by (simp add: HeapSortContext_def)

lemmas dmp_defs = dominates_def isMergePoint_def
lemmas meth_defs = Meth_Sort Meth_Extract Meth_Insert Meth_Make_heap Meth_Removesome Meth_Removetop 
                   Meth_Siftdown SPEC_def
lemmas fun_defs = 
  Fun_fSort
  Fun_fExtract Fun_fzeroExtract Fun_foneExtract
  Fun_fInsert Fun_fzeroInsert Fun_foneInsert Fun_ftwoInsert Fun_fthreeInsert
   Fun_fMake_heap  Fun_fzeroMake_heap Fun_foneMake_heap
  Fun_fRemovesome Fun_fzeroRemovesome Fun_foneRemovesome 
		  Fun_ftwoRemovesome  Fun_fthreeRemovesome
  Fun_fRemovetop Fun_fzeroRemovetop Fun_foneRemovetop Fun_ftwoRemovetop  Fun_fthreeRemovetop
  Fun_fSiftdown Fun_fzeroSiftdown Fun_foneSiftdown Fun_ftwoSiftdown Fun_fthreeSiftdown
  Fun_ffourSiftdown Fun_ffiveSiftdown Fun_fsixSiftdown Fun_fsevenSiftdown Fun_feightSiftdown
  Fun_fnineSiftdown Fun_ftenSiftdown Fun_felevenSiftdown Fun_ftwelveSiftdown Fun_fthirteenSiftdown
  Fun_ffourteenSiftdown Fun_ffifteenSiftdown Fun_fsixteenSiftdown Fun_fseventeenSiftdown 
  Fun_feighteenSiftdown Fun_fnineteenSiftdown
lemmas ctxt_def  = HeapSortContext_def

method_setup method_W = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) ctxt 1)) *}
  "Method for starting: use weakening, simplification with args, fast" 

method_setup Wp = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", pdefs, thms "ctxt_def")) ctxt 1)) *}
  "parametric Method for starting: use weakening, simplification with args, fast" 

lemmas sort_prog_defs = Meth_Sort Fun_fSort Meth_Extract Meth_Make_heap SPEC_def
lemmas ex_prog_defs = Meth_Removetop Meth_Extract Fun_fExtract Fun_fzeroExtract
                      Fun_foneExtract SPEC_def
lemmas ins_prog_defs =  Meth_Insert Fun_fInsert Fun_fzeroInsert Fun_foneInsert
                        Fun_ftwoInsert Fun_fthreeInsert SPEC_def
lemmas rs_prog_defs = Meth_Removesome Fun_fRemovesome
                      Fun_fzeroRemovesome Fun_foneRemovesome
                      Fun_ftwoRemovesome Fun_fthreeRemovesome SPEC_def
lemmas mh_prog_defs = Meth_Make_heap  Fun_fMake_heap  Fun_fzeroMake_heap
                      Fun_foneMake_heap Meth_Insert SPEC_def
lemmas rt_prog_defs = Meth_Removetop Fun_fRemovetop Fun_fzeroRemovetop
                      Fun_foneRemovetop Fun_ftwoRemovetop Fun_fthreeRemovetop
                      Meth_Removesome Meth_Siftdown SPEC_def
lemmas sd_prog_defs = Meth_Siftdown Fun_fSiftdown Fun_fzeroSiftdown Fun_foneSiftdown
                      Fun_ftwoSiftdown Fun_fthreeSiftdown Fun_ffourSiftdown
                      Fun_ffiveSiftdown Fun_fsixSiftdown Fun_fsevenSiftdown Fun_feightSiftdown
                      Fun_fnineSiftdown Fun_ftenSiftdown Fun_felevenSiftdown
                      Fun_ftwelveSiftdown Fun_fthirteenSiftdown
                      Fun_ffourteenSiftdown Fun_ffifteenSiftdown Fun_fsixteenSiftdown
                      Fun_fseventeenSiftdown Fun_feighteenSiftdown Fun_fnineteenSiftdown SPEC_def

lemma Sort_DAss:
"HeapSortContext \<rhd> snd (methtable HS Sort) : SPEC Sort"
by (Wp sort_prog_defs)(*2secs*)

lemma Extract_DAss:
"HeapSortContext \<rhd> snd (methtable HS Extract) : SPEC Extract"
by (Wp ex_prog_defs)(*2secs*)

lemma Insert_DAss:
"HeapSortContext \<rhd> snd (methtable HS Insert) : SPEC Insert"
by (Wp ins_prog_defs)(*4 secs*)

lemma Removesome_DAss:
"HeapSortContext \<rhd> snd (methtable HS Removesome) : SPEC Removesome"
by (Wp rs_prog_defs)(*3secs*)

lemma Make_heap_DAss:
"HeapSortContext \<rhd> snd (methtable HS Make_heap) : SPEC Make_heap"
by (Wp mh_prog_defs)(*3secs*)

lemma Removetop_DAss:
"HeapSortContext \<rhd> snd (methtable HS Removetop) : SPEC Removetop"
by (Wp rt_prog_defs)(*5secs*)

lemma Siftdown_DAss:
"HeapSortContext \<rhd> snd (methtable HS Siftdown) : SPEC Siftdown"
by (Wp sd_prog_defs)(*27secs*)

lemmas DAss_lemmas = Sort_DAss Extract_DAss Insert_DAss Removesome_DAss Make_heap_DAss Removetop_DAss Siftdown_DAss

(*This lemma is absolutely trivial, but it allows us to unfold the HeapsortContext more cautiously*)
lemma triv: "\<lbrakk>x:S; S=S1; x:S1 \<longrightarrow> P\<rbrakk>\<Longrightarrow> P" by simp

lemma HeapSortContext_good: "goodContext FST vMST sMST HeapSortContext"
apply (simp add: goodContext_def)
apply (rule, rule, rule)
apply (rule disjI2, rule disjI2)
apply (erule triv, simp add: HeapSortContext_def)
apply safe
by (simp only: sMST_def, clarsimp, rule vdm_conseq, rule DAss_lemmas, 
    clarify, simp add: SPEC_def , erule DAss_PConst)+

text {*Thus, we can prove that arbitrary invocations of @{text Sort} honour
       the entry in the specification table, in the empty VDM context.*}
theorem HSCorrect: "\<rhd> HS\<bullet>Sort([RNarg x]): sMST HS Sort [RNarg x]"
apply (rule GCInvs)
apply (rule HeapSortContext_good)
apply (simp_all add: HeapSortContext_def)
apply fastsimp
done 

theorem "\<rhd> HS\<bullet>Sort([RNarg y]): \<lbrace> {y}, 0 , (emptyfinmap(y \<mapsto>\<^sub>f(ListET 0 0)))  \<ggreater> (ListET 0 0) , 0 \<rbrace>"
apply (rule InvokeRename)
apply (rule HSCorrect)
apply (simp_all add: meth_defs newframe_env_def evalARGS_def)
apply (fastsimp intro: REN.intros)
apply simp+
done

end

(* Adaptation lemmas and previous tactics and methods:
lemma Siftdown_Invoke1:
"\<lbrakk>sMST HS Siftdown [INarg x, RNarg y, RNarg z] E h hh v p; distinct [y,z]\<rbrakk> \<Longrightarrow>
  \<lbrace> {y,z} , 1 , (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0 0))(z \<mapsto>\<^sub>f(TreeET 0 0))) \<ggreater>  (TreeET 0 0), 0 \<rbrace> E h hh v p"
apply (simp add: SPEC_def)
apply (erule AdaptRename)
apply (subgoal_tac "distinct (fst (methtable HS Siftdown))", assumption)
apply (simp add: MFS_defs)
apply (subgoal_tac "distinct [INarg x, RNarg y, RNarg z]", assumption)
apply simp
apply (simp add: MFS_defs)
apply (rule REN_IN)
apply (rule REN_RN)
apply (rule REN_RN)
apply (rule REN_NIL)
apply simp
apply simp
apply (simp add: MFS_defs)
apply simp
apply (simp add: MFS_defs)
apply clarsimp
apply (case_tac "xa=y", clarsimp)
apply (case_tac "xa=z", clarsimp)
apply clarsimp
apply clarsimp
apply (case_tac "x=y", clarsimp)
apply (case_tac "x=z", clarsimp)
apply clarsimp
done

(&uses Renaming with functions
lemma Siftdown_Invoke1:
"\<lbrakk>sMST HS Siftdown [INarg x, RNarg y, RNarg z] E h hh v p; f y = t1_; f z=t2_\<rbrakk> \<Longrightarrow>
  \<lbrace> {y,z} , 1 , (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0 0))(z \<mapsto>\<^sub>f(TreeET 0 0))) \<ggreater>  (TreeET 0 0), 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (erule DAss_Rename)
apply fastsimp
apply fastsimp
apply clarsimp
apply (erule disjE, rule, simp)
apply (subgoal_tac "renv E z =
            renv \<lparr>ienv = emptyi, renv = emptyr(RN ''self'' := Nullref)\<rparr><w_:=ienv E x>\<lfloor>t1_:=renv E y\<rfloor>\<lfloor>t2_:=renv E z\<rfloor> (f z)", assumption) apply simp
apply simp
apply simp
apply (subgoal_tac "y \<noteq> z", simp) apply fastsimp
apply fastsimp
apply fastsimp
done
&)

lemma LL2: "\<lbrakk>(E, h, U,C,R,m):CS; U = V\<rbrakk> \<Longrightarrow> (E, h, V,C,R,m):CS" (&<&)by simp(&>&)

lemma Siftdown_Invoke:
"\<lbrakk>sMST HS Siftdown [INarg x, RNarg y, RNarg z] E h hh v p; y \<noteq>z\<rbrakk> \<Longrightarrow>
  \<lbrace> {y,z} , 1 , (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0 0))(z \<mapsto>\<^sub>f(TreeET 0 0))) \<ggreater>  (TreeET 0 0), 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Make_heap_Invoke:
"sMST HS Make_heap [RNarg x] E h hh v p 
 \<Longrightarrow> \<lbrace> {x}, 0 , (emptyfinmap(x \<mapsto>\<^sub>f(ListET 0)))  \<ggreater> (TreeET 0 0) , 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Sort_Invoke:
"sMST HS Sort [RNarg x] E h hh v p 
 \<Longrightarrow> \<lbrace>{x}, 0, emptyfinmap(x \<mapsto>\<^sub>f(ListET 0)) \<ggreater> ListET 0, 0\<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Extract_Invoke:
"sMST HS Extract [RNarg x] E h hh v p 
\<Longrightarrow> \<lbrace> {x}, 0 , (emptyfinmap(x \<mapsto>\<^sub>f(TreeET 0 0)))  \<ggreater> (ListET 0) , 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Insert_Invoke:
"sMST HS Insert [INarg x, RNarg y] E h hh v p 
\<Longrightarrow> \<lbrace> {y} , 1 , (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0 0))) \<ggreater>  (TreeET 0 0), 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Removetop_Invoke:
"sMST HS Removetop [RNarg x] E h hh v p 
\<Longrightarrow> \<lbrace> {x} , 0 , (emptyfinmap(x \<mapsto>\<^sub>f(TreeET 0 0))) \<ggreater>  (ResultET 0 (TreeET 0 0) 0), 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Removesome_Invoke:
"sMST HS Removesome [RNarg x] E h hh v p 
\<Longrightarrow> \<lbrace> {x} , 0 , (emptyfinmap(x \<mapsto>\<^sub>f(TreeET 0 0))) \<ggreater>  (ResultET 0 (TreeET 0 0) 0), 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemmas adaptations = 
   Siftdown_Invoke Make_heap_Invoke Sort_Invoke Extract_Invoke
   Insert_Invoke 
   Removetop_Invoke Removesome_Invoke 
(&=================================================================&)
(& Methods &)

ML_setup {&
  fun localsimp_tac ctxt = simp_tac (Simplifier.get_local_simpset ctxt)
  fun asm_localsimp_tac ctxt = asm_simp_tac (Simplifier.get_local_simpset ctxt)
  fun localsimp_tac_thms ctxt thms = 
     simp_tac ((Simplifier.get_local_simpset ctxt) addsimps thms)
  fun asm_localsimp_tac_thms ctxt thms = 
     asm_simp_tac ((Simplifier.get_local_simpset ctxt) addsimps thms)

  fun repeat 0 tac = all_tac
    | repeat n tac = tac THEN (repeat (n-1) tac)


  (& Bind Isar ids to ML ids &)
  val vcg_weak = thm "DA_Weak"

  val vcg_int = thm "vcg_int"
  val vcg_ivar = thm "vcg_ivar"
  val vcg_rvar = thm "vcg_rvar"
  val vcg_prim = thm "vcg_prim"
  val vcg_rprim = thm "vcg_rprim"
  val vcg_if = thm "DA_If"
  val vcg_letint = thm "DA_Let_Int"
  val vcg_letprim = thm "vcg_letprim"
  val vcg_letrprim = thm "vcg_letrprim"
  val vcg_letnull = thm "vcg_letnull"
  val vcg_call = thm "vcg_call"

  val vcg_nullresult = thm "DA_NullResult"
  val vcg_nulltree = thm "DA_NullTree"
  val vcg_nulllist = thm "DA_NullList"
  val vcg_listmatchd = thm "vcg_ListMatchD"
  val vcg_treematchd = thm "vcg_TreeMatchD"
  val vcg_resultmatchd = thm "vcg_ResultMatchD"

  val vcg_domcallcons = thm "vcg_domcallcons"
  val vcg_domcallnil = thm "vcg_domcallnil"

  val vcg_makelist = thm "vcg_makelist"
  val vcg_makeresult = thm "vcg_makeresult"
  val vcg_maketree = thm "vcg_maketree"
  val vcg_letrmaketree = thm "vcg_letrmaketree"

  val vcg_letrinvokeconst = thm "vcg_letrinvokeconst"
  val vcg_letrinvokeconstRename = thm "vcg_letrinvokeconstRename"

  val vcg_ren_in = thm "REN_IN"
  val vcg_ren_rn = thm "REN_RN"
  val vcg_ren_nil = thm "REN_NIL"

  val vcg_rinvokeconst = thm "DA_InvokeConst"
  val vcg_rinvokeconstRename = thm "vcg_invokeconstRename"

  val Siftdown_Invoke = thm "Siftdown_Invoke"
  val Make_heap_Invoke = thm "Make_heap_Invoke"
  val Sort_Invoke = thm "Sort_Invoke"
  val Extract_Invoke = thm "Extract_Invoke"
  val Insert_Invoke = thm "Insert_Invoke"
  val Removetop_Invoke = thm "Removetop_Invoke"
  val Removesome_Invoke = thm "Removesome_Invoke"

  (& Define tactics &)

  fun adapt_tac ctxt i =
   FIRST [EVERY [etac Siftdown_Invoke i, localsimp_tac ctxt i],
          etac Make_heap_Invoke i,
          etac Sort_Invoke i,
          etac Extract_Invoke i,
          etac Insert_Invoke i,
          etac Removetop_Invoke i,
          etac Removesome_Invoke i]

   (& apply (fast intro: REN.intros) i.e. (apply (rule REN_IN | rule REN_RN | rule REN_NIL)+&)
   fun REN_tac i state = state |> 
    FIRST [EVERY [rtac vcg_ren_in i, REN_tac i],
           EVERY [rtac vcg_ren_rn i, REN_tac i],
           rtac vcg_ren_nil i]

  fun invr_tac ctxt (f_defs,d_defs,c_defs) i =
          EVERY [rtac vcg_rinvokeconst i,
                 localsimp_tac_thms ctxt c_defs i,
                 clarify_tac HOL_cs i,
                 adapt_tac ctxt i,
                 repeat 3 (localsimp_tac ctxt i)]

  fun invrRename_tac ctxt (f_defs,d_defs,c_defs) i =
          EVERY [rtac vcg_rinvokeconstRename i,
                 localsimp_tac_thms ctxt c_defs i,
                 repeat 3 (localsimp_tac_thms ctxt d_defs i),
                 repeat 6 (localsimp_tac ctxt i),
                 localsimp_tac_thms ctxt d_defs i, REN_tac i,
                 localsimp_tac_thms ctxt d_defs i,
                 localsimp_tac ctxt i]

  fun leaf_tac ctxt thms i = 
  FIRST
   [resolve_tac [vcg_int, vcg_ivar, vcg_rvar, vcg_prim] i,
    (EVERY [resolve_tac [vcg_rprim] i,
	    localsimp_tac ctxt i,
	    localsimp_tac ctxt i]),
    (EVERY [resolve_tac [vcg_makelist] i,
	    repeat 2 (localsimp_tac ctxt i)]),
    (EVERY [resolve_tac [vcg_makeresult] i,
	    repeat 2 (localsimp_tac ctxt i)]),
    (EVERY [resolve_tac [vcg_maketree] i,
	    repeat 4 (localsimp_tac ctxt i)]),
    invrRename_tac ctxt thms i]

  fun if_tac ctxt rec_tacTHEN rec_tacELSE i =
   EVERY [rtac vcg_if i,
	  rec_tacELSE ctxt (i+1),
          rec_tacTHEN ctxt i]
  (& for datatypes &)

  fun null_tac ctxt i =
   EVERY [TRY (localsimp_tac ctxt i),
          ((rtac vcg_nullresult i) THEN (localsimp_tac ctxt i))
          ORELSE (rtac vcg_nulltree i)
          ORELSE (rtac vcg_nulllist i)]


  fun res_matchd_tac ctxt rec_tac i state = state |> 
          EVERY
           [rtac vcg_resultmatchd i,
            localsimp_tac ctxt (i+1),
	    rtac conjI (i+1),
            localsimp_tac ctxt (i+1),
	    rtac conjI (i+1),
            localsimp_tac ctxt (i+1),
	    repeat 3 (localsimp_tac ctxt (i+1)),
            rec_tac ctxt (i+1),
            localsimp_tac ctxt i]

  fun tree_matchd_tac ctxt rec_tac i state = state |> 
          EVERY
           [rtac vcg_treematchd i,
	    repeat 3 (localsimp_tac ctxt (i+1)),
            rec_tac ctxt (i+1),
            localsimp_tac ctxt i]

  fun list_matchd_tac ctxt rec_tac i state = state |> 
    EVERY [(rtac vcg_listmatchd i),
           (localsimp_tac ctxt (i+1)),
           (localsimp_tac ctxt (i+1)),
	   (CHANGED (localsimp_tac ctxt (i+1))),
            rec_tac ctxt (i+1),
            localsimp_tac ctxt i]

  fun matchd_tac ctxt rec_tac i =
   FIRST [list_matchd_tac ctxt rec_tac i,
          tree_matchd_tac ctxt rec_tac i,
          res_matchd_tac ctxt rec_tac i]

  (& works for: Letint, Letprim, LetRPrim, LetNull &)
  fun let_tac ctxt (f_defs,d_defs,c_defs) rec_tac i =
   FIRST [EVERY [rtac vcg_letint i,
		 rec_tac ctxt i],
          EVERY [rtac vcg_letprim i,
		 rec_tac ctxt i],
          EVERY [resolve_tac [vcg_letrprim] i,
	         localsimp_tac ctxt i,
	         localsimp_tac ctxt i,
	         rec_tac ctxt i],
	  EVERY [rtac vcg_letnull i,
	         localsimp_tac ctxt (i+1),
	         localsimp_tac ctxt (i+1),
	         rec_tac ctxt (i+1),
                 null_tac ctxt (i+1),
		 localsimp_tac ctxt i],
	  EVERY [rtac vcg_letrmaketree i,
	         repeat 4 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i]]

   fun letinv_tac ctxt (f_defs,d_defs,c_defs) rec_tac i =
          EVERY [rtac vcg_letrinvokeconst i,
                 localsimp_tac_thms ctxt c_defs (i+1),
                 clarify_tac HOL_cs (i+1),
                 adapt_tac ctxt (i+1),
                 repeat 4 (localsimp_tac ctxt (i+1)),
                 rec_tac ctxt (i+1),
                 localsimp_tac ctxt i]

   fun letrinvRename_tac ctxt (f_defs,d_defs,c_defs) rec_tac i =
          EVERY [rtac vcg_letrinvokeconstRename i,
                 localsimp_tac_thms ctxt c_defs (i+1),
                 localsimp_tac_thms ctxt d_defs (i+1),
                 localsimp_tac_thms ctxt d_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac_thms ctxt d_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac_thms ctxt d_defs (i+1), REN_tac (i+1),
                 localsimp_tac_thms ctxt d_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 rec_tac ctxt (i+1),
                 localsimp_tac ctxt i]

  fun call_tac ctxt thms tac i =
   EVERY [rtac vcg_call i, 
	  localsimp_tac_thms ctxt thms i,
          tac i]

     (& here: solve a subgoal of the same form, then simplify with MFS_defs to expand method body
        in other subgoals (for each of the dominators?)
	We want to do this to maintain invariant for VCG.
        asm_localsimp_tac_thms ctxt thms 2
     &)
  (& rec_tac : ctxt \<rightarrow> thms \<rightarrow> int \<rightarrow> tactic \<rightarrow> tactic \<rightarrow> int \<rightarrow> tactic&)
  fun dom_tac ctxt thms rec_tac tac2 i =
    let fun domcall n state = state |> 
       ((((rtac vcg_domcallcons i) THEN domcall (n+1))
	 ORELSE
	 (EVERY 
	  ([(rtac vcg_domcallnil i),
	    asm_localsimp_tac ctxt i,
	    asm_localsimp_tac_thms ctxt thms i,
	    rec_tac ctxt i] @
	   (map (tac2 ctxt) (rev (i upto (i+n-1)))))))
	 ORELSE
	 (& solve for a merge point by projecting on the context, 
	    solving a set-equality subgoal &)
	 (EVERY
	  [rtac conjI i,  (& leaves subgoal of form ?U = X &)
           localsimp_tac_thms ctxt thms i,
	   rtac disjI1 i,
	   localsimp_tac_thms ctxt thms i]))
      in domcall 0 end

  fun stop ctxt i = all_tac
  fun stop_thms thms ctxt i = all_tac

  fun fst_tac i = fast_tac (claset()) i

  fun weak_tac ctxt thms tac i = 
    EVERY
      [localsimp_tac_thms ctxt thms i,  (& expand SPEC, methtable &)
       rtac vcg_weak i,
       tac ctxt i]
  
  fun w_tac thms tac ctxt i = 
    EVERY
      [localsimp_tac_thms ctxt thms i,  (& expand SPEC, methtable &)
       rtac vcg_weak i,
       tac ctxt i,
       fst_tac i]

   fun l_tac (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac thms) (l_tac thms) i,
           let_tac ctxt thms (l_tac thms) i,
           call_tac ctxt f_defs (l_tac thms ctxt) i,
           dom_tac ctxt d_defs (l_tac thms) (w_tac d_defs (l_tac thms)) i,
           matchd_tac ctxt (l_tac thms) i,
           letinv_tac ctxt thms (l_tac thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac2 (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt stop stop i,
           let_tac ctxt thms (l_tac2 thms) i,
           call_tac ctxt f_defs (l_tac2 thms ctxt) i,
           dom_tac ctxt d_defs (l_tac2 thms) stop i,
           matchd_tac ctxt stop i,
           letinv_tac ctxt thms (l_tac2 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac3 (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac3 thms) (l_tac3 thms) i,
           let_tac ctxt thms (l_tac3 thms) i,
           call_tac ctxt f_defs (l_tac3 thms ctxt) i,
           dom_tac ctxt d_defs (l_tac3 thms) stop i,
           res_matchd_tac ctxt (l_tac3 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac4 (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt stop (l_tac4 thms) i,
           let_tac ctxt thms (l_tac4 thms) i,
           call_tac ctxt f_defs (l_tac4 thms ctxt) i,
           dom_tac ctxt d_defs (l_tac4 thms) stop i,
           matchd_tac ctxt (l_tac4 thms) i,
           letinv_tac ctxt thms (l_tac4 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac5 (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac5 thms) (l_tac5 thms) i,
           let_tac ctxt thms (l_tac5 thms) i,
           call_tac ctxt f_defs (l_tac5 thms ctxt) i,
           dom_tac ctxt d_defs (l_tac5 thms) (w_tac d_defs (l_tac5 thms)) i,
           matchd_tac ctxt (l_tac5 thms) i,
           letinv_tac ctxt thms (l_tac5 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac6 (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac6 thms) (l_tac6 thms) i,
           let_tac ctxt thms (l_tac6 thms) i,
           call_tac ctxt f_defs (l_tac6 thms ctxt) i,
           dom_tac ctxt d_defs (l_tac6 thms) (w_tac d_defs (l_tac6 thms)) i,
           matchd_tac ctxt (l_tac6 thms) i,
           letrinvRename_tac ctxt thms (l_tac6 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]
&}
method_setup method_leaf = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => leaf_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 1))  &}
 "Method for solving leaf cases in the derivation."    
 
method_setup method_If = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => if_tac ctxt stop stop 1)) &}
  "Method for If, reduces to two subgoals"

method_setup method_Let = {& Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => let_tac ctxt (thms,thms,thms) stop 1)) &}
  "Method for LetPrim/LetRPrim/LetNull, reduces to one subgoal"

method_setup method_Letinv = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letinv_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 
                                             (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) &}
  "Method for Letrinvoke"

method_setup method_Letinvs = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letinv_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 
                                             stop 1)) &}
  "Method for Letrinvoke"

(& apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def) &)
method_setup method_Call = {& Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => call_tac ctxt thms (stop ctxt) 1)) &}
  "Method for Call, leaves dominates subgoal"
(&
method_setup method_CallDom = {& Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => call_tac ctxt thms (fn ctxt => fn thms => dom_tac ctxt thms (K stop)) 1)) &}
  "Method for Call, leaves dominates subgoal"
&)

(& apply (simp?, (rule DA_NullResult, simp) | rule DA_NullTree | rule DA_NullList) &)
method_setup method_Null = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => null_tac ctxt 1)) &}
  "Method for Nullresult, nulltree and nulllist"

(& FIXME: to combine method_Call with method_Dom or mergepoint stuff, we need to
   ideally need a method which accepts more than one parameter &)

(& apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs) &)
method_setup method_Dom = {& Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => dom_tac ctxt thms stop stop 1)) &}
  "Method for Dom" 

method_setup ltac = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup ltac2 = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac2 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup ltac3 = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac3 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup ltac4 = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac4 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup ltac5 = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac5 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup ltac6 = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup rmd = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => res_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) &}
  "test for resultmatchd"

method_setup rmds = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => res_matchd_tac ctxt stop 1)) &}
  "test for resultmatchd"

method_setup lmd = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => list_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) &}
  "test for listmatchd"

method_setup lmds = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => list_matchd_tac ctxt stop 1)) &}
  "test for listmatchd"

method_setup tmd = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => tree_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) &}
  "test for treematchd"

method_setup tmds = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => tree_matchd_tac ctxt stop 1)) &}
  "test for treematchd"
method_setup method_fast = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => fst_tac 1)) &}
  "Method for fast"

method_setup method_simp = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac ctxt 1)) &}
  "Method for simp"

method_setup method_Weaks = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => weak_tac ctxt (thms "meth_defs") stop 1)) &}
  "Method for starting: use weakening, simplification with args" 

method_setup method_Weak = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => weak_tac ctxt (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) &}
  "Method for starting: use weakening, simplification with args" 

method_setup method_REN = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => REN_tac 1)) &}
  "Method for starting: use weakening, simplification with args, fast"

*)
