(* Word64.sig
 *
 * Peter Bertelsen
 * October 1997
 *)

eqtype word
exception Word64Overflow of string

val fromWord  : Word.word -> word
val toWord    : word -> Word.word
val fromInt   : int -> word
val toInt     : word -> int
val toIntX    : word -> int
val toString  : word -> string
val fromBytes : Word8Vector.vector -> word option
val toBytes   : word -> Word8Vector.vector
val compare   : word * word -> order
val compareX  : word * word -> order

val emit : (Word8.word -> unit) -> word -> unit
val scan : (unit -> Word8.word option) -> word option

