(* Realn.sig
 *
 * Peter Bertelsen
 * August 1997
 *)

type real

val fromReal  : Real.real -> real
val toReal    : real -> Real.real
val fromBytes : Word8Vector.vector -> real option
val toBytes   : real -> Word8Vector.vector

val emit : (Word8.word -> unit) -> real -> unit
val scan : (unit -> Word8.word option) -> real option
