(* Real64.sml
 *
 * Peter Bertelsen
 * August 1997
 *)

open Word8Vector

datatype real = REAL of vector

fun fromReal r = REAL (Mosml.doubleVec r)

fun toReal (REAL bs) = Mosml.vecDouble bs

fun toString x = Real.toString (toReal x)

fun fromBytes bs = if length bs = 8 then SOME (REAL bs)
		   else NONE

fun toBytes (REAL bs) = bs

fun emit out (REAL bs) = app out bs

fun scan src =
    (let val b7 = valOf(src())
	 val b6 = valOf(src())
	 val b5 = valOf(src())
	 val b4 = valOf(src())
	 val b3 = valOf(src())
	 val b2 = valOf(src())
	 val b1 = valOf(src())
	 val b0 = valOf(src())
     in
	 SOME (REAL (fromList[b7, b6, b5, b4, b3, b2, b1, b0]))
     end)
	 handle Option => NONE
