(* Real32.sml
 *
 * Peter Bertelsen
 * August 1997
 *)

open Word8Vector

datatype real = REAL of vector

fun fromReal r = REAL (Mosml.floatVec r)

fun toReal (REAL bs) = Mosml.vecFloat bs
(* Previously unimplemented.  This gives some rather unpleasant
   rounding errors.  For instance,  0.9 comes out as 0.899999976158.
   The 64-bit version is much better.*)

fun toString x = Real.toString (toReal x)

fun fromBytes bs = if length bs = 4 then SOME (REAL bs)
		   else NONE

fun toBytes (REAL bs) = bs

fun emit out (REAL bs) = app out bs

fun scan src =
    (let val b3 = valOf(src())
	 val b2 = valOf(src())
	 val b1 = valOf(src())
	 val b0 = valOf(src())
     in
	 SOME (REAL (fromList[b3, b2, b1, b0]))
     end)
	 handle Option => NONE
