(* Localvar.sml
 *
 * Peter Bertelsen
 * December 1997
 *)

exception LocalvarsFull

datatype index  = VAR of int
datatype locals = LOCALS of int

val maxIndex1 = 0xfffe    (* maximum number of local vars is 65535 *)
val maxIndex2 = maxIndex1 - 1

val this = VAR 0

fun fromInt n =
    if n <= maxIndex1 then VAR n
    else raise Domain

fun toInt (VAR n) = n

fun toString (VAR n) = "var " ^ (Int.toString n)

fun compare (VAR m, VAR n) = Int.compare(m, n)

val freshLocals = LOCALS 0

fun count (LOCALS n) = n

fun nextVar1 (LOCALS n) =
 	if n <= maxIndex1 then (LOCALS (n+1), VAR n)
	else raise LocalvarsFull

fun nextVar2 (LOCALS n) =
	if n <= maxIndex2 then (LOCALS (n+2), VAR n)
	else raise LocalvarsFull
