(* Localvar.sig
 *
 * Peter Bertelsen
 * December 1997
 *)

exception LocalvarsFull

type locals
eqtype index

val this     : index
val fromInt  : int -> index
val toInt    : index -> int
val toString : index -> string
val compare  : index * index -> order

val freshLocals : locals
val count       : locals -> int   (* calculate the number of slots used *)
val nextVar1    : locals -> locals * index
val nextVar2    : locals -> locals * index

(* NOTE:
 * fromInt raises Domain if the specified index is invalid
 *
 * nextVar1 allocates a slot for a one-word variable
 *
 * nextVar2 allocates a slot for a two-word variable
 *)
