(* Jvmtype.sig
 *
 * Peter Bertelsen
 * December 1997
 *)

exception InvalidType of string

eqtype jclass

val class     : {pkgs: string list, name: string} -> jclass
val packages  : jclass -> string list
val className : jclass -> string
val qualName  : jclass -> string
val qualNameToClass : string -> jclass
datatype jtype =
    Tboolean
  | Tchar
  | Tfloat
  | Tdouble
  | Tbyte
  | Tshort
  | Tint
  | Tlong
  | Tarray of jtype
  | Tclass of jclass

val isSimple : jtype -> bool

val arrayOf   : int * jtype -> jtype
val arrayDim  : jtype -> int
val arrayBase : jtype -> jtype

type method_sig = jtype list * jtype option

val width          : jtype -> int
val typeDesc       : jtype -> string
val scanTypeDesc   : string -> jtype option
val methodDesc     : method_sig -> string
val scanMethodDesc : string -> method_sig option

val parseType_aux : char list -> jtype * char list
val parseType : string -> jtype
val parseType_option : char list -> jtype option * char list
val parseTypes : string -> jtype list * jtype option
