(* IntCvt.sml
 *
 * Peter Bertelsen
 * November 1997
 *)

fun int32To64 k =
    let val bs = Int32.toBytes k
	val b0 = Word8Vector.sub(bs, 0)
	val hb = if Word8.andb(b0, 0wx80) = 0w0 then 0w0
		 else 0wxff : Word8.word

	fun h i = if i < 4 then hb
		  else Word8Vector.sub(bs, i-4)
    in
	valOf(Int64.fromBytes (Word8Vector.tabulate(8, h)))
    end

fun int64To32 k =
    let val bs = Int64.toBytes k
	val b4 = Word8Vector.sub(bs, 4)
	val hb = if Word8.andb(b4, 0wx80) = 0w0 then 0w0
		 else 0wxff : Word8.word

	fun h (_, w, ok) = ok andalso w = hb
    in
	if Word8Vector.foldli h true (bs, 0, SOME 4) then
	    let val bs' = Word8Vector.extract(bs, 4, NONE)
	    in
		valOf(Int32.fromBytes bs')
	    end
	else raise Overflow
    end
