(* Int64.sml
 *
 * Peter Bertelsen
 * November 1997
 *)

datatype int = INT of Word64.word

exception Int64Overflow of string

local
    val min = Word8Vector.fromList [0wx80, 0w0, 0w0, 0w0, 0w0, 0w0, 0w0, 0w0]
    val max = Word8Vector.fromList [0wx7f, 0wxff, 0wxff, 0wxff,
				    0wxff, 0wxff, 0wxff, 0wxff]
in
    val minInt = SOME (INT (valOf(Word64.fromBytes min)))
    val maxInt = SOME (INT (valOf(Word64.fromBytes max)))
end

fun fromInt k = INT (Word64.fromInt k)

fun toInt (INT n) = Word64.toIntX n
    handle Word64.Word64Overflow s => raise Int64Overflow s

fun toString w = (Int.toString (toInt w))
    handle Int64Overflow s => s

fun fromBytes bs =
    (case Word64.fromBytes bs of
	 NONE   => NONE
       | SOME n => SOME (INT n))

fun toBytes (INT n) = Word64.toBytes n

fun compare (INT x, INT y) = Word64.compareX(x, y)

fun emit out (INT n) = Word64.emit out n

fun scan src =
    (case Word64.scan src of
	 NONE   => NONE
       | SOME n => SOME (INT n))
