(* Intn.sig
 *
 * Peter Bertelsen
 * November 1997
 *)

eqtype int

exception Int32Overflow of string

val minInt : int option
val maxInt : int option

val fromInt   : Int.int -> int
val toInt     : int -> Int.int
val toString  : int -> string
val fromBytes : Word8Vector.vector -> int option
val toBytes   : int -> Word8Vector.vector
val compare   : int * int -> order

val emit : (Word8.word -> unit) -> int -> unit
val scan : (unit -> Word8.word option) -> int option

val + : int * int -> int
val - : int * int -> int
