structure Util =
struct

(* IO *)

fun println s = TextIO.print (s^"\n")
fun quit() = OS.Process.exit OS.Process.failure

fun exit s = 
    (println ("mkTheory error: " ^ s); quit())

			     
(* finite maps *)

structure FM = Splaymap

(* addListToFM : ('a, 'b) FM.dict -> ('a * 'b) list -> ('a, 'b) FM.dict *)
fun addListToFM fm [] = fm
  | addListToFM fm ((key,value) :: rest) =
    let
	val rest_fm = addListToFM fm rest
    in FM.insert (rest_fm, key, value)
    end
(* mergeListToFM : ('a, 'b list) FM.dict -> ('a * 'b) list -> ('a, 'b list) FM.dict *)
fun mergeListToFM fm [] = fm
  | mergeListToFM fm ((key,value) :: rest) =
    let
	val rest_fm = mergeListToFM fm rest
	val vallist = case FM.peek (rest_fm, key) of NONE => []
						   | SOME list => list
    in FM.insert (rest_fm, key, value :: vallist)
    end
    
	
(* listToFM : (string, 'b) list -> (string, 'b) FM.dict *)
fun listToFM keyvals = addListToFM (FM.mkDict String.compare) keyvals


fun FMfind_err (fm, key) error_string =
    case FM.peek (fm, key) of
	NONE => exit ("Failed FM.peek on key " ^ key ^ ": " ^ error_string)
      | SOME a => a
				   
(* sets *)
		       
structure Set = Splayset

(* auxiliary operations to glue a list of strings in various ways *)
fun wrap_list prefix strings postfix =
    foldl (fn (s, done) => done ^ prefix ^ s ^ postfix) "" strings

fun glue_list glue [] = ""
  | glue_list glue (x::xs) = x ^ wrap_list glue xs ""
    
fun glue_wrap_list glue prefix [] postfix = ""
  | glue_wrap_list glue prefix (x::xs) postfix =
    prefix ^ x ^ postfix ^ wrap_list (glue ^ prefix) xs postfix

(* list processing *)
    
fun isPrefix [] _ = true
  | isPrefix _ [] = false 
  | isPrefix (hp :: tp) (h :: t) =
    (hp = h) andalso isPrefix tp t

fun isPostfix postfix list =
    isPrefix (rev postfix) (rev list)

fun minusPrefix [] list = SOME list
  | minusPrefix _ [] = NONE
  | minusPrefix (hp::tp) (h::t) =
    if hp = h then minusPrefix tp t else NONE

fun minusPostfix postfix list =
    let
	val res = 
	    (Option.map rev) (minusPrefix (rev postfix) (rev list))
	    (*
	val _ = println (glue_list "," postfix ^ " \\ " ^ glue_list "," list ^ " = ")
	val _ = case res of NONE => ()
			  | SOME list => println ("  " ^ glue_list "," list)
					 *)
    in res end

fun filter_optlist [] = []
  | filter_optlist (NONE::t) = filter_optlist t
  | filter_optlist ((SOME e)::t) = e::(filter_optlist t)

(* pairs_ord : a list -> (a,a) list *)
fun pairs_ord [] = []
  | pairs_ord (h :: t) =
    (map (fn e => (h,e)) t) @ (pairs_ord t)

(* factor : (a -> b) -> (b -> b -> bool) -> (a list) -> ((a, a list) list) *)
fun factor getkey compare list =
    let
	val initFM = FM.mkDict compare (* initFM : b -> a list *)
	fun additem (item, fm) =
	    let
		val key = getkey item
		val items = case FM.peek (fm, key) of NONE => []
						    | SOME items => items
	    in
		FM.insert (fm, key, item :: items)
	    end
	val finalFM = List.foldl additem initFM list
	val res = FM.listItems finalFM  
    in
	res
    end
				  
(* isabelle comments *)
    
fun mini_comment comment =
    "(* " ^ comment ^ " *)"
    
fun big_comment comment =
    let
	val size = String.size comment
	val stars = StringCvt.padRight #"*" size ""
    in
	"\n(**" ^ stars ^ "**)" ^
	"\n(* " ^ comment ^ " *)" ^
	"\n(**" ^ stars ^ "**)\n"
    end

fun section name =
    big_comment name ^ "\n" ^
    "section {* " ^ name ^ " *}\n\n"

fun subsection name =
    "subsection {* " ^ name ^ " *}\n\n"
    
fun subsubsection name =
    "subsubsection {* " ^ name ^ " *}\n"
    
end
