open Util
	     
val usage = ["Usage:",
" mkTheory [options] hints_file theoryname",
"",
" Convert the hints_file generated by camelot to an Isabelle threory",
" which defines heap representation predicates, heap portion predicates,",
" separation predicates and states an assertion theorem for each function.",
" ",
" OPTIONS",
(* "   All options are accepted with either one or two dashes in the long form.", *)
"",
" -l n, -dt-level n",
"   Include definition to the level n. (Default is the highest level.)",
"     level 1: representation predicates only",
"     level 2: add portion predicates",
"     level 3: add internal separation predicates",
" -t, -theorems",
"   Translate program assertions into theorems. (NO SENSIBLE OUTPUT YET)",
"   (Make sure -dt-level is sufficient for the theorems.)",
" -h, -help, -usage",
"   Output this help message."
]

fun mkTheory hints_file theoryname level doThms =
    let
	(* read hints *)
	val pkl_in = BinIO.openIn hints_file
	val hints = Camelot_absyn_ASDLUtil.read_hints pkl_in
	val _ = BinIO.closeIn pkl_in
	val Camelot_absyn_ASDL.HINTS (typeDecLs, funAssnss) = hints
        (* compute sections of the theory *)
	val thy_file = theoryname ^ ".thy"
	val header =
	    "(* " ^ thy_file ^ " generated by " ^ CommandLine.name () ^
	    "\n   on " ^ Date.toString (Date.fromTimeLocal (Time.now ())) ^ " *)\n" ^
	    "theory " ^ theoryname ^ " = FunMachine:\n"
	val models_portions_seps = DT2Pred.mkTheory typeDecLs level
	val thms = if doThms
		   then Assn2Thm.mkTheory funAssnss
		   else ""
        (* write theory *)
	val thy_out = TextIO.openOut thy_file
    in
	TextIO.output (thy_out,
		       header ^
		       models_portions_seps ^
		       thms ^
		       "\nend\n"
		      )
    end
    
fun parseArgs [] files level doThms = 
    let in case files of
	       [theoryname, hints_file] =>
	       mkTheory hints_file theoryname level doThms
	     | _ =>
	       (app println usage;
		exit "Wrong number of arguments")
    end
  | parseArgs (arg::args) files level doThms = 
    if (String.substring (arg,0,1)) = "-" then
	if arg = "-h" orelse arg = "-help" orelse arg = "--help" 
	   orelse arg = "-usage" orelse arg = "--usage" then
	    app println usage
	else if arg = "-t" orelse arg = "-theorems" orelse arg = "--theorems" then
	    parseArgs args files level true
	else if arg = "-l" orelse arg = "-dt-level" orelse arg = "--dt-level" then
	    let 
		val l_arg = case args of [] => exit ("No level number specified for " ^ arg)
				       | h::_ => h
		val l = case Int.fromString l_arg
			 of NONE => exit (arg ^ " should be followed by a level number")
			  | SOME n => n
	    in
		parseArgs (tl args) files l doThms
	    end
	else 
	    (println ("Unknown option " ^ arg ^ " (Use -h to get usage information.)");
	     quit ())
    else 
	parseArgs args (arg::files) level doThms
    
val _ = parseArgs (CommandLine.arguments()) [] 100 false
