theory jGrailRawCost = jGrailState:

(* Section 5.1 - Parameters *)

(* directInt has domain {0,1} *)
constdefs
  wordSize       :: "nat"
  "wordSize       \<equiv> 4"

  objectOverhead :: "nat"
  "objectOverhead \<equiv> 4"

  directInt      :: "nat"
  "directInt      \<equiv> 0"




(* Section 5.2 - Size of instructions *)

consts
  sizeOfInstr  ::  "jGrailInstr \<Rightarrow> nat"

primrec
  "sizeOfInstr (aconst_null)            = 1"
  "sizeOfInstr (sipush val)             = 3"
  "sizeOfInstr (ldc n)                  = 2"
  "sizeOfInstr (aload n)  	        = 2"
  "sizeOfInstr (iload n)  	        = 2"
  "sizeOfInstr (astore n)      	        = 2"
  "sizeOfInstr (istore n)  	        = 2"
  "sizeOfInstr (iinc n c)	        = 3"
  "sizeOfInstr (dup)	                = 1"
  "sizeOfInstr (pop)	                = 1"
  "sizeOfInstr (iadd)	                = 1"
  "sizeOfInstr (isub)	                = 1"
  "sizeOfInstr (imul)	                = 1"
  "sizeOfInstr (if_icmpeq i)            = 3"
  "sizeOfInstr (if_icmplt i)	        = 3"
  "sizeOfInstr (ifnull i)               = 3"
  "sizeOfInstr (goto i)	                = 3"
  "sizeOfInstr (invokevirtual i)   = 3"
  "sizeOfInstr (invokestatic i)    = 3"
  "sizeOfInstr (invokespecial i)   = 3"
  "sizeOfInstr (invokeinterface i) = 5"
  "sizeOfInstr (return)	                = 1"
  "sizeOfInstr (areturn)	        = 1"
  "sizeOfInstr (ireturn)	        = 1"
  "sizeOfInstr (new i)                 = 3"
  "sizeOfInstr (putfield i)      = 3"
  "sizeOfInstr (getfield i)      = 3"
  "sizeOfInstr (putstatic i)     = 3"
  "sizeOfInstr (getstatic i)     = 3"
  "sizeOfInstr (checkcast i)           = 3"
  "sizeOfInstr (instanceof i)          = 3"
  (* missing aconst_null / ldc / instanceof / iinc *)




(* Section 5.3 - Size of values, types and numbers *)

consts
  sizeOfVal      :: "val     \<Rightarrow> nat"
  sizeOfPrimType :: "prim_ty \<Rightarrow> nat"
  sizeOfType     :: "ty      \<Rightarrow> nat"
  sizeNum        :: "nat     \<Rightarrow> nat"

primrec (* defs has no pattern matching *)
  "sizeOfVal Unit     = 0"
  "sizeOfVal Null     = wordSize"
  "sizeOfVal (Intg i) = wordSize"
  "sizeOfVal (Bool b) = wordSize"
  "sizeOfVal (Addr a) = wordSize"

primrec
  "sizeOfPrimType Void    = 0"
  "sizeOfPrimType Integer = wordSize"
  "sizeOfPrimType Boolean = wordSize"

primrec
  "sizeOfType (PrimT t) = sizeOfPrimType t"
  "sizeOfType (RefT r)  = wordSize"

(*
defs
  sizeNum: "size n \<equiv> ceiling (log_2 (n+1) / 8)"
*)

(* typeof :: [loc \<Rightarrow> ty option, val] \<Rightarrow> ty option *)
(* the    :: 'a option \<Rightarrow> 'a *)
lemma sizeOfVal_eq_sizeOfType:
  "sizeOfVal val = sizeOfType (the(typeof (\<lambda>a. Some(RefT NullT)) val))"
  apply(induct_tac val)  (* apply(rule val.induct) *)
  apply(auto)
done




(* Section 5.4 - Object heap *)

constdefs
  sizeOfObjState    :: "fields_   \<Rightarrow> nat"
  "sizeOfObjState f  \<equiv> \<Sum> fn \<in> dom f. sizeOfVal(the(f(fn))) "

  objInt            :: "cname     \<Rightarrow> nat"
  "objInt cname      \<equiv> directInt * wordSize * 0" (* * |(interfaces cname)| *)

  sizeOfObject      :: "obj       \<Rightarrow> nat"
  "sizeOfObject obj  \<equiv> sizeOfObjState (snd obj) + objInt (fst obj) + objectOverhead"

  HpSize            :: "jGrailState \<Rightarrow> nat"
  "HpSize s          \<equiv> \<Sum> addr \<in> dom (fst(snd s)). sizeOfObject (the((fst(snd s)) addr))"




(* Section 5.5 - Frame stack size *)

constdefs
  sizeOfLocals          :: "frame \<Rightarrow> nat"
  "sizeOfLocals fr       \<equiv> length (fst(snd fr)) * wordSize" (* !!!!!! should Sum using sizeOfVal(\<dots>) *)

  sizeOfOpstack         :: "frame \<Rightarrow> nat"
  "sizeOfOpstack fr      \<equiv> length (fst fr) * wordSize"

  sizeOfClassPtr        :: "frame \<Rightarrow> nat"
  "sizeOfClassPtr fr     \<equiv> wordSize"

  sizeOfPrevframePtr    :: "frame \<Rightarrow> nat"
  "sizeOfPrevframePtr fr \<equiv> wordSize"

  sizeOfPC              :: "frame \<Rightarrow> nat"
  "sizeOfPC fr           \<equiv> wordSize"          

  FrameSize             :: "frame \<Rightarrow> nat"
  "FrameSize fr          \<equiv> sizeOfLocals fr + sizeOfOpstack fr + sizeOfClassPtr fr
                           + sizeOfPC fr + sizeOfPrevframePtr fr"


consts
  FStackSize :: "jGrailState \<Rightarrow> nat"

recdef FStackSize "measure(\<lambda>(F,H,M,C). length F)"
  "FStackSize ([],H,M,C)  = 0"
  "FStackSize (f#F',H,M,C) = FrameSize f + FStackSize (F',H,M,C)"

end