(*
 * jGrailInstructions.thy
 * Matthew Prowse.
 * 17th November 2002
 *)

theory jGrailInstructions = Main:


(* jGrailCode give opcodes only *)
datatype jGrailCode =

  (* constants *)
    Aconst_null | Sipush | Ldc

  (* local variables *)
  | Aload | Iload | Astore | Istore | Iinc

  (* stack operations *)
  | Dup | Pop

  (* arithmetic *)
  | Iadd | Isub | Imul

  (* branches *)
  | If_icmpeq | If_icmplt | Ifnull | Goto

  (* methods *)
  | Invokestatic | Invokevirtual | Invokespecial | Invokeinterface | Return | Ireturn | Areturn

  (* objects *)
  | New | Putfield | Putstatic | Getfield | Getstatic | Checkcast | Instanceof 


(* jGrailInstr gives constructors for full instructions *)
datatype jGrailInstr =
    aconst_null
  | sipush int
  | ldc nat

  | aload nat
  | iload nat
  | astore nat
  | istore nat
  | iinc nat int

  | dup | pop

  | iadd | isub | imul

  | if_icmpeq int
  | if_icmplt int
  | ifnull int
  | goto int

  | invokevirtual nat
  | invokestatic nat
  | invokespecial nat
  | invokeinterface nat
  | ireturn | areturn | return

  | new nat
  | putfield nat
  | getfield nat
  | putstatic nat
  | getstatic nat
  | checkcast nat
  | instanceof nat


end
