(*
 * jGrailExecInstr.thy - UNFINISHED
 * Matthew Prowse
 * 17th November 2002
 *)

theory jGrailExecInstr = jGrailState:


(* Parameter for deallocating frame space when methods return. *)
constdefs
  frameDealloc :: "bool"
  "frameDealloc \<equiv> True"


(*
 * All reductions take the form:
 *
 *     "jGrailExecInstr <instr> state =
 *     (let
 *         (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
 *         \<dots>
 *     in (F',H',M',C'))"
 *
 *)



(* CHANGES TO STATE
 *
 * F - All instructions change F
 *         but only 'invoke\<dots>' and '\<dots>return' change the number of frames in F
 * H - Only 'new' and 'putfield' change H 
 * M - Only 'putstatic' changes M
 *
 * f - Only 'invoke\<dots>' and '\<dots>return' change f in C
 * h - Only 'new' changes h in C
 * m - \<dots> change m in C
 * t - All instructions change t in C
 *
 *)



consts
  jGrailExecInstr :: "[jGrailInstr, jGrailState] \<Rightarrow> jGrailState option"

primrec


  (* Section 3.3.1 - Instructions for loading constants *)

  "jGrailExecInstr (aconst_null) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
      F'=(env,Null#stk,cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Aconst_null)
  in Some(F',H,M,C'))" (*checked*)


  "jGrailExecInstr (sipush s) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
      F'=(env,Intg(s)#stk,cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Sipush)
  in Some(F',H,M,C'))" (*checked*)


  "jGrailExecInstr (ldc i) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          (cfile,cvars)=the(M cn); (sc,fdecls,mdecls,cp)=cfile;
          v = the_val (the(cp i));
      F'=(env, v#stk,cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Ldc)
  in Some(F',H,M,C'))" (*checked*)





  (* Section 3.3.2 - Instructions for operand stack manipulation *)

  "jGrailExecInstr (dup) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
      F'=(env,hd(stk)#stk,cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Dup)
  in Some(F',H,M,C'))" (*checked*)


  "jGrailExecInstr (pop) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
      F'=(env,tl stk,cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Pop)
  in Some(F',H,M,C'))" (*checked*)





  (* Section 3.3.3 - Arithmetic instructions *)

  "jGrailExecInstr (iadd) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          int1=the_Intg(hd stk); int2=the_Intg(hd(tl stk));
      F'=(env,Intg(int1+int2)#tl(tl stk),cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Iadd)
  in Some(F',H,M,C'))" (*checked*)


  "jGrailExecInstr (isub) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          int1=the_Intg(hd stk); int2=the_Intg(hd(tl stk));
      F'=(env,Intg(int2-int1)#tl(tl stk),cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Isub)
  in Some(F',H,M,C'))" (*checked*)


  "jGrailExecInstr (imul) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          int1=the_Intg(hd stk); int2=the_Intg(hd(tl stk));
      F'=(env,Intg(int1*int2)#tl(tl stk),cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Imul)
  in Some(F',H,M,C'))" (*checked*)





  (* Section 3.3.4 - Instructions accessing local variables *)

  "jGrailExecInstr (iinc n int2) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          int1=the_Intg(env!n); v=Intg(int1+int2);
      F'=(env[n:=v],stk,cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Iinc)
  in Some(F',H,M,C'))" (*checked*)


  "jGrailExecInstr (aload n) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
      F'=(env,(env!n)#stk,cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Aload)
  in Some(F',H,M,C'))" (*checked*)


  "jGrailExecInstr (iload n) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
      F'=(env,(env!n)#stk,cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Iload)
  in Some(F',H,M,C'))" (*checked*)


  "jGrailExecInstr (astore n) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
      F'=(env[n:=hd stk],tl stk,cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Astore)
  in Some(F',H,M,C'))" (*checked*)


  "jGrailExecInstr (istore n) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
      F'=(env[n:=hd stk],tl stk,cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Istore)
  in Some(F',H,M,C'))" (*checked*)





  (* Section 3.3.5 - Instructions involving objects *)



  (* Class instantiation *)

  "jGrailExecInstr (new i) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          (cfile,cvars)=the(M cn); (sc,fdecls,mdecls,cp)=cfile;
          my_ref=newAddr H; cn'=the_cn(the(cp(i)));
          (cfile',cvars)=the(M cn'); (sc',fdecls',mdecls',cp')=cfile';
      F'=(env,Addr(my_ref)#stk,cn,sig,nextPC pc)#tl F;
      H'=H(my_ref\<mapsto>(cn',init_vars (fields (M,cn'))));
      C'=(f,h(cn':=h(cn')+1),m,instrInc t New)
  in Some(F',H',M,C'))" (*NOT checked*)



  (* Instructions for accessing fields *)

  "jGrailExecInstr (putfield i) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          (cfile,cvars)=the(M cn); (sc,fdecls,mdecls,cp)=cfile;
          (cn',fn,type')=the_fref(the(cp i)); 
          v=hd stk;
          my_ref=the_Addr(hd(tl stk)); (cn'',st)=the(H my_ref);
      H'=H(my_ref\<mapsto>(cn'',st((fn,cn')\<mapsto>v)));
      F'=(env,tl(tl stk),cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Putfield)
  in Some(F',H',M,C'))" (*checked*)


  "jGrailExecInstr (putstatic i) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          (cfile,cvars)=the(M cn); (sc,fdecls,mdecls,cp)=cfile;
          (cn',fn,type')=the_fref(the(cp i));
          (cfile',cvars')=the(M cn); v=hd stk;
      F'=(env,tl stk,cn,sig,nextPC pc)#tl F;
      M'=M(cn'\<mapsto>(cfile',cvars'(fn\<mapsto>(Value' v))));
      C'=(f,h,m,instrInc t Putstatic)
  in Some(F',H,M',C'))" (*checked*)


  "jGrailExecInstr (getfield i) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          (cfile,cvars)=the(M cn); (sc,fdecls,mdecls,cp)=cfile;
          (cn',fn,type')=the_fref(the(cp i));
          my_ref=the_Addr(hd stk); (cn'',st)=the(H my_ref);
          v=the(st (fn,cn''));
      F'=(env,v#(tl stk),cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Getfield)
  in Some(F',H,M,C'))" (*checked*)


  "jGrailExecInstr (getstatic i) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          (cfile,cvars)=the(M cn); (sc,fdecls,mdecls,cp)=cfile;
          (cn',fn,type')=the_fref(the(cp i));
          (cfile',cvars')=the(M cn'); v=the_val'(the(cvars' fn));
      F'=(env,v#stk,cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Getstatic)
  in Some(F',H,M,C'))" (*checked*)



  (* Instructions for dynamic type-check *)

  "jGrailExecInstr (checkcast i) state = Some state"
  (*"jGrailExecInstr (checkcast i) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
      \<dots>
      C'=(f,h,m,instrInc t Checkcast)
  in Some(F',H,M,C'))"*) (*NOT needed*)


  "jGrailExecInstr (instanceof i) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          (cfile,cvars)=the(M cn); (sc,fdecls,mdecls,cp)=cfile;
          cn'=the_cn(the(cp i)); my_ref=the_Addr(hd stk);
         v=Intg(if (instanceOf cn' my_ref H M) then 1 else 0);
      F'=(env,v#tl stk,cn,sig,nextPC pc)#tl F;
      C'=(f,h,m,instrInc t Instanceof)
  in Some(F',H,M,C'))" (*NOT checked*)



  (* Instructions for method invocation and return *)

  "jGrailExecInstr (invokestatic i) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          (cfile,cvars)=the(M cn); (sc,fdecls,mdecls,cp)=cfile;
          (cn',sig',type')=the_mref(the(cp i)); (mn,tys)=sig';
          n=length tys; args=take n stk; env'=rev args;
      F'=(env',[],cn',sig',0)#(env,drop n stk,cn,sig,nextPC pc)#tl F;
      C'=(frameInc f (sig',cn'),h,m,instrInc t Invokestatic)
  in Some(F',H,M,C'))" (*NOT checked*)


  "jGrailExecInstr (invokevirtual i) state = 
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          (cfile,cvars)=the(M cn); (sc,fdecls,mdecls,cp)=cfile;
          (cn',sig',type')=the_mref(the(cp i)); (mn,tys)=sig';
          n=length tys; args=take (n+1) stk;
          env'=rev args; my_ref=the_Addr(hd env');
          (cn'',st)=the(H my_ref);
          (cn''',md)=the(lookup (M,cn'') sig');
      F'=(env',[],cn''',sig',0)#(env,drop (n+1) stk,cn,sig,nextPC pc)#tl F;
      C'=(frameInc f (sig',cn'''),h,m,instrInc t Invokevirtual)
  in Some(F',H,M,C'))" (*NOT checked*)


  "jGrailExecInstr (invokeinterface i) state = Some state"
  (*"jGrailExecInstr (invokeinterface i) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
      \<dots>
      C'=(f,h,m,instrInc t Invokeinterface)
  in Some(F',H,M,C'))"*) (*NOT needed*)


  "jGrailExecInstr (invokespecial i) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          (cfile,cvars)=the(M cn); (sc,fdecls,mdecls,cp)=cfile;
          (cn',sig',type')=the_mref(the(cp i)); (mn,tys)=sig';
          n=length tys; args=take (n+1) stk;
          env'=rev args; my_ref=the_Addr(hd env');
          (cn''',md)=the(lookup (M,the sc) sig');
      F'=(env',[],cn''',sig',0)#(env,drop (n+1) stk,cn,sig,nextPC pc)#tl F;
      C'=(frameInc f (sig',cn'''),h,m,instrInc t Invokespecial)
  in Some(F',H,M,C'))" (*NOT checked*)



  "jGrailExecInstr (return) state = None"
  (*"jGrailExecInstr (return) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
      f'=if frameDealloc then frameDec f (sig,cn) else f;
      C'=(f',h,m,instrInc t Return)
  in Some(tl F,H,M,C'))"*) (*checked*)



  "jGrailExecInstr (ireturn) state = None"
  (*"jGrailExecInstr (ireturn) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          (env',stk',cn',sig',pc')=hd(tl F);
          v=hd(stk);
      F'=(env',v#stk',cn',sig',pc')#tl(tl F);
      f'=if frameDealloc then frameDec f (sig,cn) else f;
      C'=(f',h,m,instrInc t Ireturn)
  in Some(F',H,M,C'))"*) (*checked*)


  "jGrailExecInstr (areturn) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          (env',stk',cn',sig',pc')=hd(tl F);
          v=hd(stk);
      F'=(env',v#stk',cn',sig',pc')#tl(tl F);
      f'=if frameDealloc then frameDec f (sig,cn) else f;
      C'=(f',h,m,instrInc t Areturn)
  in Some(F',H,M,C'))" (*checked*)





  (* Section 3.3.6 - Branch Instructions *)

  "jGrailExecInstr (goto i) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          pc'=nat((int pc)+i);
      F'=(env,stk,cn,sig,pc')#tl F;
      C'=(f,h,m,instrInc t Goto)
  in Some(F',H,M,C'))" (*checked*)


  "jGrailExecInstr (if_icmpeq i) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          int1=the_Intg(hd stk); int2=the_Intg(hd(tl stk));
          pc'=if int1=int2 then nat((int pc)+i) else nextPC pc;
      F'=(env,tl(tl stk),cn,sig,pc')#tl F;
      C'=(f,h,m,instrInc t If_icmpeq)
  in Some(F',H,M,C'))" (*checked*)


  "jGrailExecInstr (if_icmplt i) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          int1=the_Intg(hd stk); int2=the_Intg(hd(tl stk));
          pc'=if int2<int1 then nat((int pc)+i) else nextPC pc;
      F'=(env,tl(tl stk),cn,sig,pc')#tl F;
      C'=(f,h,m,instrInc t If_icmplt)
  in Some(F',H,M,C'))" (*checked*)


  "jGrailExecInstr (ifnull i) state =
  (let
      (F,H,M,C)=state; (env,stk,cn,sig,pc)=hd F; (f,h,m,t)=C;
          pc'=if (hd stk)=Null then nat((int pc)+i) else nextPC pc;
      F'=(env,tl stk,cn,sig,pc')#tl F;
      C'=(f,h,m,instrInc t Ifnull)
  in Some(F',H,M,C'))" (*checked*)


end

