theory Test = jGrailExec + Grail_path + GrailDynSem + GrailTrans:


(* Predicate that holds if a given 'Result' expression evaluates to a given 'RTVal' *)
constdefs 
  works :: "LetDecs \<Rightarrow> RTVal \<Rightarrow> bool"
 "works \<equiv> (\<lambda> p. \<lambda> r. (\<exists> s. ? v. (\<langle>p,emptyState\<rangle> \<longrightarrow>\<^sub>l \<langle>v,s\<rangle> & v = r)))"


(* Create a jGrailState given some parameters - unfinished but sufficient *)
constdefs createState :: "[cname, mname, jGrailInstr list, nat, nat] \<Rightarrow> jGrailState"
  "createState cname_ mname_ code_ num_locals max_stack \<equiv>
      (let
          sig_   = (mname_, []);
          frame_ = ([], [], cname_, sig_, 0);
          heap_  = \<lambda>x. None;
          mdecl_ = (sig_, PrimT Integer, num_locals, max_stack, code_);
          cfile_ = (None, [], [mdecl_], \<lambda>x. None);
          marea_ = \<lambda>x. (if x=cname_ then (Some (cfile_, \<lambda>x. None)) else None);
          cost_  = (\<lambda>x. 0, \<lambda>x. 0, [], \<lambda>x. 0)
      in
          ([frame_], heap_, marea_, cost_))"



(* Gets the next instruction to be executed *)
(* Don't leave this like this!!! *)
constdefs nextInstr :: "jGrailState => jGrailInstr"
"nextInstr s \<equiv> (let
                   frame_ = hd(fst s);
                   pc_    = snd(snd(snd(snd frame_)));
                   cname_ = fst(snd(snd frame_))
               in
                   snd(snd(snd(snd(hd(fst(snd(snd(fst(the((fst(snd(snd s))) cname_))))))))))!pc_)"


(* Gets the operand stack from the current frame *)
constdefs stack :: "jGrailState => (val list)"
 "stack s \<equiv> fst(snd(hd(fst(s))))"


(* Repeat "jGrailExec.exec" on a given state, a given number of times *)
consts multi_exec :: "jGrailState \<times> nat \<Rightarrow> jGrailState"
recdef multi_exec "measure (\<lambda>(s,t).t)"
  "multi_exec (s,0)     = s"
  "multi_exec (s,Suc n) = (let s' = exec s in multi_exec (s',n))"







(* A small phrase to do proofs on *)


types_code
  Vname   ("char list")
  Cname   ("char list")
  Fname   ("char list")
  Mname   ("char list")
  Fldname ("char list")
  vname   ("char list")
  cname   ("char list")
  fname   ("char list")
  mname   ("char list")
  fldname ("char list")
  loc_ ("int")
constdefs
  phrase  :: "MethBody"
  "phrase == MBODY [] (PRIMres (OPres
               (BINop ADDop (INTval 1) (INTval 1) )))"

constdefs
  jphrase :: "jGrailInstr list"
  "jphrase == fst (transMethBody [] phrase)"

(* Sanity check *)
generate_code
  grail = "phrase"
  jgrail = "jphrase"
ML{*grail*}
ML{*jgrail*}


consts
  my_cname  :: "cname"
  my_mname  :: "mname"
  my_state  :: "jGrailState"


consts_code
  my_cname ("[Char (Nibble0,Nibble0)]")
  my_mname ("[Char (Nibble0,Nibble1)]")

defs
  my_state : "my_state  \<equiv> createState my_cname my_mname jphrase 0 2"



(* Lemmas - tiddly proofs *)

(* Automatically simplify certain things *)
consts_code
  "newAddr" ("new'_addr {* %x. case x of None => True | Some y => False *}/ {* None *}/ {* Loc *}")

  "wf" ("true?")

  "arbitrary" ("(raise ERROR)")
  "arbitrary" :: "val" ("{* Unit *}")
  "arbitrary" :: "cname" ("Object")

ML {*
fun newAddr p none loc hp =
  let fun nr i = if p (hp (loc i)) then (loc i, none) else nr (i+1);
  in nr 0 end;
*}


generate_code
  runit = "nextInstr my_state"
  exec = exec

ML{*val s = ref my_state*}
ML{*val s = ref (jGrailExec.exec (!s))*}
ML{*runit*}


declare Let_def         [simp]
declare stack_def       [simp]
declare exec_def        [simp]
declare nextPC_def      [simp]
declare method_def      [simp]
declare createState_def [simp]


(* 1+1 in Grail equals 2 *)
lemma "works phrase (rtInt 2)"
apply (unfold works_def)
apply (rule exI)+
apply  (rule conjI)
apply  (unfold phrase_def)
apply  (rule GrailDynSem.eval_PrimOp_eval_PrimRes_eval_LetDecs.PRIMres)
apply  (rule GrailDynSem.eval_PrimOp_eval_PrimRes_eval_LetDecs.OPres)
apply   (rule GrailDynSem.eval_PrimOp_eval_PrimRes_eval_LetDecs.BINop)
apply (rule GrailDynSem.eval_Value.INTval)+
apply (unfold evalBOP_def)
oops
(*done*)


(* 1+1 in jGrail (step by step) equals 2 *)
(*lemma "hd (stack (exec (exec (exec my_state)))) = (Intg 2)"
apply (unfold my_state jphrase_def phrase_def)
apply (simp)
done
*)

(* 1+1 in jGrail (with multi_exec) equals 2 *)
lemma "hd (stack (the (multi_exec (my_state, Suc(Suc(Suc 0)))))) = (Intg 2)"
apply (unfold my_state jphrase_def phrase_def)
apply (simp)
done




(* Thoughts\<dots> *)

(* At some point in execution (n), the next instruction is an ireturn instruction - ie. execution will terminate *)
lemma "\<exists>n. nextInstr(multi_exec (my_state,n)) = ireturn"
oops





























consts
 f_else :: "Fname"
 n :: "Vname"
 f :: "Fname"
 b :: "Vname"

constdefs fac :: "MethBody"
"fac == 
   MBODY 
         [
            (FDEC f [(ARG  Ty.INTty   n), (ARG  Ty.INTty   b)]
               (CHOICEres 
                     (VARval n) LESStest (INTval 1) 
                     (OPres  (VALop  (VARval b) ) ) 
                     (FUNres f_else  [n,b])))
          ,
            (FDEC f_else [(ARG  Ty.INTty   n), (ARG  Ty.INTty   b)] 
               (VALdec b (BINop  MULop  (VARval b)   (VARval n) ) 
                     (VALdec n (BINop  SUBop   (VARval n)   (INTval 1) ) 
                      (PRIMres  (FUNres f  [n, b] ) ) ) ) )
         ]
         (VALdec b (VALop (INTval 1)) (PRIMres  (FUNres f [n, b]))) "
constdefs jfac :: "jGrailInstr list"
"jfac == fst(transMethBody [] fac)"



types_code
  Vname ("string")
  Cname ("string")
  Fname ("string")
  Mname ("string")
  Fldname ("string")


consts_code
 f ("f")
 f_else ("f_else")
 n ("n")
 b ("b")

generate_code
  g_fac = "fac"

generate_code
  jg_fac = "jfac"

