header {* Annotated Grail Abstract Syntax *}

theory GrailAbsyn_annotated = Grail_path + GrailAbsynDec:

text {*\subsection*{Annotated Expressions}*}

datatype Value_a =
  VARval_a nat Vname
| INTval_a nat int
| NULLval_a nat Cname

datatype Test_a =
  EQUALStest_a nat
| IStest_a nat
| LESStest_a nat

datatype BinOp_a =
  ADDop_a nat
| SUBop_a nat
| MULop_a nat

datatype PrimOp_a =
  VALop_a nat Value_a
| BINop_a nat BinOp_a Value_a Value_a
| NEWop_a nat Cname
| GETFIELDop_a nat Vname FieldDesc
| PUTFIELDop_a nat Vname FieldDesc Value_a
| GETSTATICop_a nat FieldDesc
| PUTSTATICop_a nat FieldDesc Value_a
| INVOKESTATICop_a nat MethDesc "Vname list"

datatype PrimRes_a =
  OPres_a nat PrimOp_a
| VOIDres_a nat
| FUNres_a nat Fname "Vname list"

datatype LetDecs_a = 
  VALdec_a nat Vname PrimOp_a LetDecs_a
| VOIDdec_a nat PrimOp_a LetDecs_a
| PRIMres_a nat PrimRes_a
| CHOICEres_a nat Value_a Test_a Value_a PrimRes_a PrimRes_a


text {*\subsection*{Annotated Declarations}*}

datatype FunDec_a =
  FDEC_a nat "Fname" "Arg list" "LetDecs_a"

datatype MethBody_a =
  MBODY_a "FunDec_a list" "LetDecs_a" 

datatype MethDef_a =
  METHOD_a "Modifiers" "RTy" "Mname" "Arg list" "MethBody"
end