
fun withOpenFile fname f = 
    let val out = TextIO.openOut fname
    in (f out before TextIO.closeOut out) 
       handle e => (TextIO.closeOut out; raise e)
    end 
	
(*	
fun main _ "" = TextIO.output(TextIO.stdOut, "Empty input file")
  | main false file = let val prog = Translate.translate (Parse.parse file)
		      in Output.Output TextIO.stdOut prog
		      end
  | main true file = let val prog = Translate.translate (Parse.parse file)
		     in withOpenFile (file ^ ".hll")
				     (fn out => Output.Output out prog)
		     end
		    
val _ = main true ""
*)

fun work [file] =
    let 
	(*val fname = List.last (String.tokens (fn x => x = #"/") file);
	      val class = List.hd (String.tokens (fn x => x = #".") fname);*)
	
	val prog = Translate.translate (Parse.parse file)
    in withOpenFile (file ^ ".hll")
		    (fn out => Output.Output out prog)
    end
  | work ["-s", file] =
    let 
	(*val fname = List.last (String.tokens (fn x => x = #"/") file);
	      val class = List.hd (String.tokens (fn x => x = #".") fname);*)
	
	val prog = Translate.translate (Parse.parse file)
    in withOpenFile (file ^ ".sml")
		    (fn out => Outputsml.Output out prog)
    end
  | work _ = (TextIO.print "Usage: galahad [-s] filename.ext\n");
	 

fun main () = 
    work (CommandLine.arguments());

val _ = main()
