(* Copyright (C) 2002 Allan Clark
 * 	     
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *)

structure Table =
struct
functor IntMapTable (K:sig type key
			   val getInt: key -> int
		       end) : 
	sig 
	    type key
	    type 'a table
	    val empty : 'a table
	    val enter : 'a table * key * 'a -> 'a table
	    val look : 'a table * key -> 'a option
	end
  =
struct
type key=K.key
type 'a table = 'a Intmap.intmap
val empty = Intmap.empty()
fun enter(t,k,a) = Intmap.insert(t,K.getInt k,a)
fun look(t,k) = Intmap.peek(t,K.getInt k)
end

end