structure Outputsml =
struct
structure C = CamelotAbsyn

exception Unimplemented

(* Originally I had far too many parantheses in this code, and now I have far too
 * few, this will have to be cleaned up before any real code can be written*)
fun Output outstream p =
    let 
	fun say s =  TextIO.output(outstream,s)
	fun saysp s = (say s; say " ")
	fun sayln s= (say s; say "\n") 
	
	(* The general rule should be that a printing function should NOT indent its
	 * first line by itself, but only use its indent parameter to indent other lines
	 * of itself and to pass as sub printing functions*)


	fun indent 0 = ()
	  | indent i = (say "    "; indent(i-1))

		    
	(* We could change the representation of var, so rather than put
	 * say var everywhere we put printVar then if we change the representation
	 * of var we just need to change the implementation of printVar*)
	val printVar = saysp



	(* Prints out a list of separated constructs using
	 * the given funtion (pfun) to print out each function,
	 * and printing a separator (sep) between each one.
	 * If the separator string contains a \n character then
	 * you will probably want to set i to a number, other wise
	 * it you probably want i = 0.
	 * NOTE that the first one is not indented, this is because
	 * the first one of such lists are often written inline, if
	 * you want the first to be indented then indent it before
	 * calling printSeparatedList.
	 * Also note this does not work to well when there is something
	 * after the \n in a separator, for example "\n|" in match expressions
	 * since the bar will be printed at the beginning of the line and then
	 * the rest of the match rule will be indented*)
	fun printSeparatedList i sep pfun list =
	    case list
	     of [] => ()
	      | h::t => (pfun 0 h;
			 app (fn x => (say sep; pfun i x)) t)

	(* Same as the above function except that 
	 * in between each
	 * list item there will be a newline and ten indentation
	 * then the separator, then the printed function used. The
	 * printing function should therefore take note of this and
	 * not indent itself on the first line. You might ask why don't
	 * then just give pfun the argument 0, but this whould not look
	 * right if pfun itself calls another function which should get
	 * an indent argument of i+1, basically if pfun needs to indent
	 * at all*)
	fun printSeparatedIndList i sep pfun list =
	    case list
	     of [] => ()
	      | h::t => (pfun i h;
			 app (fn x => (say "\n"; indent i; say sep; pfun i x)) t)

	(* br_prn takes a printing function and a construct and
	 * uses the printing function to print out the construct
	 * surrounded by brackets*)
	fun br_prn pfun c = (say "(";
			     pfun c;
			     say ")")

	(* brln_prn is the same as br_prn above,
	 * except that it prints out a new line after
	 * the closing bracket*)
	fun brln_prn pfun c = (say "(";
			       pfun c;
			       say ")\n")


	fun printTypeDecL i (_,C.TYPEdec(tvarl,var,tyconl)) =
	    (saysp "datatype";
	     app (printVarL i) tvarl;
	     printVar var;
	     saysp " =";
	     printSeparatedIndList (i+1) "| " printTypeConL tyconl;
	     say "\n")

	and printTypeConL i (_, C.TYPEcon (var, [])) =
	    (printVar var)
	  | printTypeConL i (_,C.TYPEcon (var, tylist)) =
	    (printVar var;
	     say "of (";
	     printSeparatedList i " * " printTyL tylist;
	     say ")")

	    
	and printTyL i (_,C.INTty) = (say "int")
          | printTyL i (_,C.CHARty) = (say "char")
	  | printTyL i (_,C.BOOLty) = (say "bool")
	  | printTyL i (_,C.FLOATty) = (say "float")
	  | printTyL i (_,C.STRINGty) = (say "string")
	  | printTyL i (_,C.UNITty) = (say "unit")
	  | printTyL i (_,C.ARRAYty(ty)) = (*raise Unimplemented *)(printTyL i ty; say " array")
	  | printTyL i (_,C.ARROWty(ty1, ty2)) = (printTyL i ty1; 
						  say " -> "; 
						  printTyL i ty2)
	  | printTyL i (_,C.LISTty(ty)) = (printTyL i ty;
					   say " list")
	  | printTyL i (_,C.TVARty(v)) = (say v)
	  | printTyL i (_,C.CONty(tylist, var)) =
	    (printSeparatedList i " * " printTyL tylist;
	     say (" " ^ var))

	and printVarL i (_,s) = (saysp s)
	(*	and printTVarL i (_,s) = (saysp s)*)
				
	and printValDecL i (p,C.VALdec(v,tyl)) = 
	    if String.sub(v, 0) = #"A"
	    then (say "val ";
		  printVarL i (p,v);
		  (* This has the problem that we don't know
		   * how large to create the array.
		   * An even larger problem is that it only creates int
		   * arrays, this is because Array.array accepts a expression of
		   * the type to make the array, we can't output this because
		   * we don't know how to make up an expression of an arbitrary type.
		   * This could all be fixed by introducing an array 
		   * creation expression in Galahad*)
		  say " = Array.array (256, 1)\n")
	    else
		(say "val _ = ";
		 printVarL i (p,v);
		 say " : ";
		 printTyL i tyl;
		 say "\n")

	and printFunDefLList _ ([]) = ()
	  (* If the function has no arguments
	   * then we output it as a val instead of fun, note
	   * that if it has no arguments then it should have only
	   * one definition (ie it can't have multiple pattern cases)
	   * if it does then this won't match, and we will output it as
	   * a function, but either way it won't type check anyway*)
	  | printFunDefLList i ([(_,C.FUNdef(v,[],e))]) =
	    (say ("val " ^ v ^ " = ");
	     printExpL (i+1) e)
	  | printFunDefLList i (fundefs) = 
	    let fun printFunDefL i (pos, C.FUNdef(v,vl,e)) =
		    (sayln ("(*Function definition for " ^ v ^ "*)");
		     saysp v;
		     app saysp vl;
		     sayln " = ";
		     indent (i+1);
		     printExpL (i+1) e;
		     sayln "")
	    in (saysp "fun";
		(* Again unfortunately these will be printed out with
		 * the and unindented but the rest indented*)
		printSeparatedIndList (i+1) "and" printFunDefL fundefs)
	    end

	and printValue i (C.VARval(v)) = (saysp v)
	  | printValue i (C.INTval(n)) = (saysp (Int.toString n))
	  | printValue i (C.FLOATval(n)) = (saysp (Real.toString n))
	  | printValue i (C.STRINGval(s)) = (saysp ("\"" ^ s ^ "\""))
	  | printValue i (C.BOOLval(C.TRUEval)) = (say "true ")
	  | printValue i (C.BOOLval(C.FALSEval)) = (say "false ")

	(* These operators are temporary until I know what Camelot accepts*)
	and printUnary C.NOTop = say "~"
	  | printUnary C.FTOIop = say "\\/"
	  | printUnary C.ITOFop = say "/\\"

	and printBinary C.TIMESop = say "* "
	  | printBinary C.DIVop = say "/ "
	  | printBinary C.PLUSop = say "+ "
	  | printBinary C.MINUSop = say "- "
	  | printBinary C.LESSop = say "< "
	  | printBinary C.GREATERop = say "> "
	  | printBinary C.EQUALSop = say "= "
	  | printBinary C.CONSop = say "::"
				
	(* This has been superseeded by the printSeparatedList function*)
	(*and printMatchRuleList i list =
	    let
		fun printRule i (_,C.MATCHrule(v,list,e)) = (printVarL i v;
							     (map (printVarL i) list);
							     say"=> ";
							     printExpL i e)
							    
	    in case list
		of [] => ()
		 | h::t => (printRule i h;
			    app (fn x => (say "\n| "; printRule i x)) t)
			   
	    end*)

	and printMatchRule i (_,C.MATCHrule(v,list,e)) = (printVarL i v;
						(case list 
						 of [] => ()
						  | l => (say " ( ";
							  (printSeparatedIndList (i+1) ", " printVarL list);
							  say " ) "));
						say"=> ";
						printExpL i e)
							 
	  (* There are far too many brackets printed here, but too many is better
	   * than too few*)
	and printExpL i (_,C.VALexp(v)) = (printValue i v)
	  | printExpL i (_,C.UNARYexp(u, e)) = (say "(";
						printUnary u;
						printExpL i e;
						say ")")
	  | printExpL i (_, C.BINexp (b, e1, e2)) = (say "(";
						     printExpL i e1;
						     printBinary b;
						     printExpL i e2;
						     say ")")
	  | printExpL i (_, C.IFexp (e1, e2, e3)) = (say "(if ";
						     printExpL (i+1) e1;
						     say "\n";
						     indent i;
						     saysp "then";
						     printExpL (i+1) e2;
						     say "\n";
						     indent i;
						     saysp"else";
						     printExpL (i+1) e3;
						     say ")")
	  | printExpL i (_, C.MATCHexp (e1, mrlist)) = (say "(";
							say "case (";
							printExpL i e1;
							sayln ") of";
							indent (i+2);
							printSeparatedIndList (i+2) "| " printMatchRule mrlist;
							say ")")
	  (* This extra case just takes care of nested let expressions which are often
	   * the result of either a for loop, or a galahad let expression in which there
	   * are many declarations before the IN*)
	  | printExpL i (_,C.LETexp(v,e1,e2 as (_,C.LETexp(_)))) = 
	    (say ("let val " ^ v ^ " = ");
	     printExpL i e1;
	     say "in\n";
	     indent i;
	     (* This should really be i+1, but since
	      * we get a lot of these that are really just
	      * let declarations, they look nicer without
	      * the stepped indentation, this is
	      * precisely why we have this extra case*)
	     printExpL (i+0) e2;
	     say "\n";
	     indent i;
	     say "end\n")
	  | printExpL i (_,C.LETexp(v,e1,e2)) = (say ("let val " ^ v ^ " = ");
						 printExpL i e1;
						 say "in\n";
						 indent (i+1);
						 printExpL (i+1) e2;
						 say "\n";
						 indent i;
						 say "end\n")
	  | printExpL i (_,C.APPexp((_, C.VALexp(C.VARval ("exit"))),_)) =
	    say ("( raise Fail ( \"assertion failure\" ) )")
	  | printExpL i (_,C.APPexp(e1, el)) = (say "(";
						(case e1
						  of (_,C.VALexp(C.VARval(s))) =>
						     if String.sub (s, 0) = #"T"
						     then (say (s ^ " (");
							   printSeparatedList i ", " printExpL el;
							   say ")")
						     else (printExpL i e1;
							   app (printExpL i) el)
						   | _ => (printExpL i e1;
							   app (printExpL i) el));
						say ")")
	  | printExpL i (_,C.LISTexp(expr_list)) = (say "[";
						    printSeparatedList i ", " printExpL expr_list;
						    say "]")

	(* Camelot main expressions now seem to need a val for each expression, rather
	 * than a let, but this can be changed easily, this is one reason we print
	 * the main expression with a different function, rather than just using printExpL
	 * and letting the Let expression clause take care of it (the other is that inside
	 * the main there shouldn't be an IN keyword between each val or let declaration).
	 * Here we just print out the main expression in a similar fashion to Let expression.
	 * The main expression should be a lot of nested let expressions (by this point, after
	 * translation from the galahad form of a let expression), so we only have two clauses,
	 * one for a Let expression which should print out all the main except the very last expression,
	 * which should be caught by the second clause which will just output it as the final
	 * val declaration (with an underscore of course)*)
	and (*printMain (_, C.LETexp(v, e1, e2)) = (say ("val main = let val " ^ v ^ " = ");
						  printExpL 0 e1;
						  say "in\n";
						  printExpL 0 e2;
						  say "\nend\n")
	  | *)printMain a = (say "val galahad_result = "; printExpL 0 a)

	fun printCamelotProg (C.PROG(tdl,vdl,fdll,e)) = (sayln "(*********Type declarations**********)";
							 app (printTypeDecL 0) tdl;
							 sayln "(*********Variable declarations******)";
							 app (printValDecL 0) vdl;
							 sayln "(*********Implementations************)";
							 app (printFunDefLList 0) fdll;
							 sayln "(*********Main part of the program***)";
							 printMain e;
							 say "\n\n(*End of Camelot program*)\n\n")
    in printCamelotProg(p)
    end
end