functor IntMapTable (K:sig type key
			   val getInt: key -> int
		       end)
(*type key
		     val getInt: key -> int)*) : sig 
    type key
    type 'a table
    val empty : 'a table
    val enter : 'a table * key * 'a -> 'a table
    val look : 'a table * key -> 'a option
end
  =
struct
type key=K.key
type 'a table = 'a Intmap.intmap
val empty = Intmap.empty()
fun enter(t,k,a) = Intmap.insert(t,K.getInt k,a)
fun look(t,k) = Intmap.peek(t,K.getInt k)
end