
(* Here we have the abstract syntax of the Camelot
 * language, the idea is that the abstract syntax
 * for galahad is a superset of this, we then
 * have a simplifying step which takes galahad abstract
 * syntax and removes any compenents which are not in
 * the camelot abstract syntax.
 *)
structure CamelotAbsyn =
struct

type pos = Location.Location

datatype Ty =
         INTty
       | CHARty
       | BOOLty
       | FLOATty
       | STRINGty
       | UNITty
       | ARRAYty of TyL
       | ARROWty of TyL * TyL
       | LISTty of TyL
       | TVARty of TVar
       | CONty of (TyL list) * Var
and Value =
    VARval of Var
  | INTval of int
  | FLOATval of real
  | STRINGval of string
  | BOOLval of Bool
and Bool =
    TRUEval
  | FALSEval
and Exp =
    VALexp of Value
  | UNARYexp of UnaryOperator * ExpL
  | BINexp of BinaryOperator * ExpL * ExpL
  | IFexp of ExpL * ExpL * ExpL
  | MATCHexp of ExpL * (MatchRuleL list)
  | LETexp of Var * ExpL * ExpL
  | APPexp of ExpL * (ExpL list)
  | LISTexp of (ExpL list)
and ValDec =
    VALdec of Var * TyL
and TypeDec =
    TYPEdec of (TVarL list) * Var * (TypeConL list)
and TypeCon =
    TYPEcon of Var * (TyL list)
and FunDef =
    FUNdef of Var * (Var list) * ExpL
and MatchRule =
    MATCHrule of VarL * VarL list * ExpL
and Program =
    PROG of (TypeDecL list) * (ValDecL list) * (FunDefL list list) * ExpL
and UnaryOperator =
    NOTop
  | FTOIop
  | ITOFop
and BinaryOperator =
    TIMESop
  | DIVop
  | PLUSop
  | MINUSop
  | LESSop
  | GREATERop
  | EQUALSop
  | CONSop
withtype Var = string
and VarL = (pos * string)
and TVar = string
and TVarL = (pos * string)
and TyL = (pos * Ty)
and ValDecL = (pos * ValDec)
and TypeConL = (pos * TypeCon)
and TypeDecL = (pos * TypeDec)
and FunDefL = (pos * FunDef)
and MatchRuleL = (pos * MatchRule)
and ExpL = (pos * Exp)


end