;;; galahad-mode-el -- Major mode for editing galahad programs

;; Author: Allan Clark

;; Copyright (C) 2002 Allan Clark

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2 of
;; the License, or (at your option) any later version.

;; This program is distributed in the hope that it will be
;; useful, but WITHOUT ANY WARRANTY; without even the implied
;; warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
;; PURPOSE.  See the GNU General Public License for more details.

;; You should have received a copy of the GNU General Public
;; License along with this program; if not, write to the Free
;; Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
;; MA 02111-1307 USA

;;; To use this I put the following in my .emacs file
;;; (Obviously without the commenting out the code)
;;;(autoload 'galahad-mode "galahad-mdoe" "A major mode for editing galahad programs." t)

;;; ;;; And galahad emacs mode
;;; (require 'galahad-mode)

;;; ;;; Invoke galahad mode automatically on galahad programs
;;; (setq auto-mode-alist (cons '("\\.gal$" . galahad-mode) auto-mode-alist))



;;; Code:
(defvar galahad-mode-hook nil)
(defvar galahad-mode-map nil
  "Keymap for galahad major mode.")

(if galahad-mode-map nil
  (setq galahad-mode-map (make-keymap)))

(setq auto-mode-alist
	  (append
	   '(("\\.tig\\'" . galahad-mode))
	   auto-mode-alist))


;;; Highlighting, this is mostly copied from David Aspinall's
;;; grail mode.
(defun galahad-ids-to-regexp (l)
  "Maps a non-empty list of tokens `l' to a regexp matching any element"
  (mapconcat (lambda (s) (concat "\\<" s "\\>")) l "\\|"))

(defconst galahad-types
  '("int" "float" "string" "unit" "bool" "char" "array" "list"))

(defconst galahad-keywords 
  '("not" "or" "type" "if" "then"
    "else" "match" "with" "let" "rec"
    "in" "val" "of" "and" "end"
    "float_of_int" "int_of_float"
    "true" "false" "functor" "for" 
    "to" "do" "main" "return" 
    "module" "external" "until" 
    "final" "fn" "sig" ;;; "signature" "is" "mod"
    "given" "assert" "struct" "typealias"))


(defconst galahad-font-lock-keywords
  (list 
   (galahad-ids-to-regexp galahad-keywords)
   (cons (galahad-ids-to-regexp galahad-types) font-lock-type-face)))


;;; Define the default tab width to be 2
(defvar galahad-default-tab-width 2)


;;; Indentation, TODO:
(defun galahad-indent-line ()
  "Indent current line of GALAHAD code."
  (if (bobp)
      (indent-line-to 0) ; First line is always non-indented
  (indent-line-to 1)))



(defvar galahad-mode-syntax-table nil
  "Syntax table for galahad-mode.")

(defun galahad-create-syntax-table ()
  (if galahad-mode-syntax-table
      ()
    (setq galahad-mode-syntax-table (make-syntax-table))
    (set-syntax-table galahad-mode-syntax-table)
    
    ;;;  This is added so entity names with underscores can be more easily parsed
    (modify-syntax-entry ?_ "w" galahad-mode-syntax-table)
    
    ;;; These are the comments, the ( can be the start of a two character starter 1
    ;;; or the end of a two character closer 4, the n makes the comments nestable
    ;;; the * can be the end of a two character starter 2 or the start of a two
    ;;; the start of a two character closer 3.
    
    (modify-syntax-entry ?( "()1" galahad-mode-syntax-table)
    (modify-syntax-entry ?) ")(4" galahad-mode-syntax-table)
    (modify-syntax-entry ?* ". 23n" galahad-mode-syntax-table)))

(defun galahad-mode ()
  "Major mode for editing Galahad source files."
  (interactive)
  (kill-all-local-variables)
  (galahad-create-syntax-table)
  
  ;; Set up font-lock
  (make-local-variable 'font-lock-defaults)
  (setq font-lock-defaults
		'(galahad-font-lock-keywords))
  
  ;; Register our indentation function
  (make-local-variable 'indent-line-function)
  (setq indent-line-function 'galahad-indent-line)
  
  (setq major-mode 'galahad-mode)
  (setq mode-name "GALAHAD")
  (run-hooks 'galahad-mode-hook))

(provide 'galahad-mode)

;;; tiger-mode.el ends here



