/*
 * Created on Apr 6, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package mrg.security;
import java.security.*;
import mrg.utils.MRGUtils;
import mrg.proofchecker.MRGProofChecker;
import java.io.*;
import java.util.PropertyPermission;

/**
 * The MRGSecurityManager is a subclass of <code>SecurityManager</code>. The <code>checkPermission()</code> has been extended to handle <code>MRGPermission</code> objects, invoking the <code>MRGProofChecker.check()</code> method.
 *
 * @author mprowse
 *
 * @see java.security.SecurityManager
 * @see mrg.security.MRGPermission
 * @see mrg.proofchecker.MRGProofChecker
 */
public class MRGSecurityManager extends SecurityManager {

    public MRGSecurityManager() {
	super();
    }

    /**
     * Will invoke <code>MRGProofChecker.check()</code> when given an instance of <code>MRGPermission</code>.
     * Otherwise this method should behave in the same way as an instance of <code>SecurityManger</code>.<p>
     * If the <code>check()</code> method returns successfully, the permission is granted, and this method will simply return. In the event of the proof checking failing, a SecurityException will be thrown, thus preventing execution of the <code>main()</code> method (the call to <code>checkPermission()</code> is that which has been transparantly inserted into the client code by the <code>transform(...)</code> method of <code>MRGAgent</code>).
     */
    public void checkPermission(Permission p) {
	    if (p instanceof MRGPermission) {
		MRGUtils.debug("MRGSec.Manager\t: checking MRGPermission(\""+p.getName()+"\")");
		if (!MRGProofChecker.check(System.getProperty("mrg.classname"))) {

		    System.out.println("********************************************************************************");
		    System.out.println("*** !!! ERROR !!! ERROR !!!                                                  ***");
		    System.out.println("***                                                                          ***");
		    System.out.println("*** MRGProofChecker failed to verify the given class file.                   ***");
		    System.out.println("*** This code may have undesirable effects.                                  ***");
		    System.out.println("***                                                                          ***");
		    System.out.println("*** To execute the code anyway, respond 'yes' to the following question...   ***");
		    System.out.println("********************************************************************************");
		    System.out.println();
		    System.out.println("Do you wish to execute unverified code:");
		    try {
			String ans = (new BufferedReader(new InputStreamReader(System.in))).readLine();
			if (!ans.equals("yes")) throw new SecurityException("MRGProofChecker could not verify "+p.getName());
		    } catch (IOException f) {
			throw new SecurityException("MRGProofChecker could not verify "+p.getName());
		    }
		}
		MRGUtils.debug("MRGSec.Manager\t: granted");
	    }


	    //
	    // FilePermission
	    //
	    else if (p instanceof FilePermission) {
		if (p.getActions().equals("read")) {
		    // Allow read access to anything...
		    return;

		} else if (p.getActions().equals("write")) {
		    // Allow write access only to tmp directory
		    if (p.getName().startsWith(System.getProperty("mrg.tmp.directory"))) return;
		}

		else if (p.getActions().equals("delete")) {
		    // Only allow deletions in the tmp directory
		    if (p.getName().startsWith(System.getProperty("mrg.tmp.directory"))) return;
		}
		
		else if (p.getActions().equals("execute")) {
		    if (p.getName().equals(System.getProperty("mrg.jvm.home")+"/gf")) return;
		    if (p.getName().equals(System.getProperty("mrg.jvm.home")+"/isabelle")) return;
		    return; // catchall
		}

		// catch all
		super.checkPermission(p);
	    }


	    //
	    // PropertyPermission
	    //
	    else if (p instanceof PropertyPermission) {
		if (p.getActions().equals("read")) {
		    return;
		    //if (p.getName().startsWith("mrg.")) return;
		}
		
		// catch all
		super.checkPermission(p);
	    }

	    else {
		try {
	    	super.checkPermission(p);
	 	} catch (SecurityException e) {
		//System.out.println(e);
		}
	    }
    }
}
