package mrg.proofchecker;

import java.io.*;
import java.net.*;

class MRGProofCheckerServer extends Thread {
    private static int port = 4444;

    public static void main(String[] args) {
	MRGProofCheckerServer server = new MRGProofCheckerServer();
	while (true) {
	    server.run();
	}
    }

    private ServerSocket serverSocket = null;

    public MRGProofCheckerServer() {
	try {
	    serverSocket = new ServerSocket(port);
	} catch (IOException e) {
	    System.out.println("Could not listen on port: "+port);
	    System.exit(-1);
	}

    }

    public void run() {
	Socket clientSocket = null;
	
	try {
	    clientSocket = serverSocket.accept();
	} catch (IOException e) {
	    System.out.println("Accept failed: "+port);
	    System.exit(-1);
	}

	try {
	    InputStream is = clientSocket.getInputStream();
	    InputStreamReader isr = new InputStreamReader(is);
	    
	    int i = isr.read();
	    while (i != -1) {
		System.out.print((char)i);
		i = isr.read();
	    }

	    isr.close();
	    clientSocket.close();
	} catch (IOException e) {
	    System.out.println("Communication failed: "+port);
	    System.exit(-1);
	}

    }
}
