package mrg.proofchecker;

import mrg.utils.MRGUtils;
import java.io.*;
import java.util.Date;

class MRGProofCheckerLocal implements MRGProofCheckerInstance
{
    private static String tmp_dir_root = System.getProperty("mrg.tmp.directory"); //"/tmp/mrg/";
    private static String tmp_dir;

    private static File createFile(String name, String suffix, byte[] buffer) throws Exception {
	if (!tmp_dir.equals("") && !tmp_dir.endsWith("/")) tmp_dir+="/";
	File f = new File (tmp_dir+name+"."+suffix);
	f.createNewFile();
	MRGUtils.debug("MRGProofCheckerLocal\t: Writing file \""+name+"."+suffix+"\"");
	FileOutputStream fos = new FileOutputStream(f);
	fos.write(buffer);
	fos.close();
	//f.deleteOnExit();
	return f;
    }

    public static Integer readIntFromFile(String file) { 
            String thisLine = null;
            Integer n = 0;

            try {
              FileInputStream fin =  new FileInputStream(file);
              BufferedReader myInput = new BufferedReader (new InputStreamReader(fin));
	      try {
		  thisLine = myInput.readLine();
	      } catch (java.io.IOException e) {
		  System.out.println("java.io.IOException");
	      }
	      if (thisLine != null) {  
		  try {
		      n = java.lang.Integer.decode(thisLine);
		  } catch (NumberFormatException e) {
		      n = 0;
		  }
	      }
	    } catch (java.io.FileNotFoundException e) {
		System.out.println("java.io.FileNotFoundException");
	    }
	    return n;
          }

	public static Integer grabTag(String file, String se_str, Integer tg_len) { 
            String thisLine = null, str = null;
            Integer n = 0, i = 0, len = se_str.length();

            try {
              FileInputStream fin =  new FileInputStream(file);
              BufferedReader myInput = new BufferedReader (new InputStreamReader(fin));
	      try {
		  thisLine = myInput.readLine();
	      } catch (java.io.IOException e) {
		  System.out.println("java.io.IOException");
	      }
	      while (thisLine != null) {  
		  try {
		      str=thisLine.substring(0,len);
		  } catch (StringIndexOutOfBoundsException e) {
		      //System.out.println("StringIndexOutOfBoundsException");
		      str="";
		  }
		  // System.out.println(str);
		  if (str.compareTo(se_str)==0) {
		      //System.out.println("FOUND IT");
		      try { 
			  n = java.lang.Integer.decode(thisLine.substring(len,len+tg_len));
			  break;
		      } catch (NumberFormatException e) {
			  n = 0;
		      }
		  }
		  thisLine = myInput.readLine();
	      }
	    } catch (java.io.FileNotFoundException e) {
		System.out.println("java.io.FileNotFoundException"+e);
	    } catch (java.io.IOException e) {
		System.out.println("java.io.IOException"+e);
	    }
	    return n;
          }

    public boolean check(String classfileName, byte[] classfileBuffer, String certificateName, byte[] certificateBuffer) {
	try {
	    String rndstring = ""+(new java.util.Random()).nextInt(100000);
	    if (!tmp_dir_root.endsWith("/")) tmp_dir_root = tmp_dir_root + "/";
	    tmp_dir = tmp_dir_root + classfileName + rndstring + "/";
	    MRGUtils.debug("MRGProofChecker\t: Using temporary directory \""+tmp_dir+"\"");
	    File tmp_dir_handle = new File(tmp_dir);
	    tmp_dir_handle.mkdirs();
	    //tmp_dir_handle.deleteOnExit();
	}catch (Exception e) {
	    e.printStackTrace();
	    return false;
	}

	long start_time = (new Date()).getTime();

	try {
	    MRGUtils.debug("MRGProofChecker\t: Request to verify \""+classfileName+"\" ("+classfileBuffer.length+" bytes) with certificate \""+certificateName+"\" ("+certificateBuffer.length+" bytes)");
		    

	    Integer lyt, tg;

	    //File klass = createFile(classfileName, "class", classfileBuffer);
	    File cert = createFile(certificateName, "thy", certificateBuffer);
	    
	    MRGUtils.debug("MRGProofCheckerLocal\t: Checking "+classfileName+"...");
	    Runtime rt = Runtime.getRuntime();


	    String mrgjvmhome = System.getProperty("mrg.jvm.home");

// 	    // UNUSED: going via sed does not work properly
// 	    // getting data layout and tag offset from certificate:
//             MRGUtils.debug("cat "+certificateName+".thy | sed '/^(\\*# DATA_LAYOUT/!d' | sed 's/^(\\*# *DATA_LAYOUT: \"\\([0-9]*\\).*$/\\1/' > BONZO" );
//             Process get_lyt_process = rt.exec("cat "+certificateName+".thy | sed '/^(\\*# DATA_LAYOUT/!d' | sed 's/^(\\*# *DATA_LAYOUT: \"\\([0-9]*\\).*$/\\1/' > BONZO");
// 	    lyt = readIntFromFile("BONZO");
// 	    MRGUtils.debug(".. Found data layout of "+java.lang.Integer.toString(lyt));

// 	    // Run gf process
//             Process get_tg_process = rt.exec("cat "+certificateName+".thy | sed '/^(\\*# DATA_LAYOUT/!d' | sed 's/^(\\*# *TAG_OFFSET: \"\\([0-9]*\\).*$/\\1/' > BONZO");
// 	    tg = readIntFromFile("BONZO");
// 	    MRGUtils.debug(".. Found tag offset of "+java.lang.Integer.toString(tg));

	    String cert_file = certificateName+".thy";
 	    // getting data layout and tag offset from certificate:
	    lyt = grabTag(cert_file,"(*# DATA_LAYOUT: \"",2);
	    MRGUtils.debug(".. Grabbed layout "+java.lang.Integer.toString(lyt));
	    tg = grabTag(cert_file,"(*# TAG_OFFSET: \"",1);
	    MRGUtils.debug(".. Grabbed tag "+java.lang.Integer.toString(tg));

	    // Run gf process
 	    MRGUtils.debug("MRGProofCheckerLocal\t: Running gf... |"+mrgjvmhome+"/gf -C -L "+java.lang.Integer.toString(lyt)+" -T "+java.lang.Integer.toString(tg)+" -t vcg|");
            
	    Process gf_process = rt.exec(mrgjvmhome+"/gf -C -L "+java.lang.Integer.toString(lyt)+" -T "+java.lang.Integer.toString(tg)+" -t vcg");
	    BufferedOutputStream gf_process_os = new BufferedOutputStream(gf_process.getOutputStream());
	    gf_process_os.write(classfileBuffer,0,classfileBuffer.length); // pass classfileBuffer straight to gf
	    gf_process_os.flush();
	    gf_process_os.close();

	    /*
	    System.out.println("InputStream");	    
	    BufferedInputStream gf_process_is = new BufferedInputStream(gf_process.getInputStream());
	    while (gf_process_is.available()>0) {
		System.out.print((char)gf_process_is.read());
	    }
            gf_process_is.close();
	    */

	    // Build ROOT.ML bootstrap as input to Isabelle
     	    String certName = (cert.getName()).substring(0,(cert.getName()).length()-4);
	    String root_ml_contents = "add_path \""+cert.getParent()+"\";\nuse_thy \""+certName+"\"\nhandle _ => OS.Process.exit OS.Process.failure\n";
	    
	    // Run isabelle process
	    MRGUtils.debug("MRGProofCheckerLocal\t: Running isabelle...HWL was here!");

	    MRGUtils.debug("Launching isabelle as: |isabelle -r "+mrgjvmhome+"/SLACK|\n");
	    Process isabelle_process = rt.exec("isabelle -r "+mrgjvmhome+"/SLACK");

	    OutputStream isabelle_process_os = isabelle_process.getOutputStream();
	    isabelle_process_os.write(root_ml_contents.getBytes(),0,root_ml_contents.length());
	    isabelle_process_os.close();

// 	    String line;
// 	    BufferedReader in =
// 		new BufferedReader(new InputStreamReader(gf_process.getInputStream()));
// 	    BufferedReader err =
// 		new BufferedReader(new InputStreamReader(gf_process.getErrorStream()));
// 	    line = in.readLine();
// 	    System.out.println("Subprocess output:");
// 	    while (line != null) {
// 		System.out.println(line);
// 		line = in.readLine();
// 	    }
// 	    line = err.readLine();
// 	    System.out.println("Subprocess Errors:");
// 	    while (line != null) {
// 		System.out.println(line);
// 		line = err.readLine();
// 	    }


	    int isabelle_exit_value = isabelle_process.waitFor();

	    return (isabelle_exit_value == 0);

	} catch (Exception e) {
	    e.printStackTrace();
	}
	return false;
    }
}
