/*
 * Created on Apr 8, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package mrg.proofchecker;

import mrg.utils.MRGUtils;
import java.io.*;
import java.util.HashMap;

/**
 * A class with static fields and methods, to perform proof-checking a la MRG.
 * The implementation of the shell script is unfinished, although the Java code should not change much.
 *
 * @author mprowse
 *
 * @see mrg.security.MRGSecurityManager
 */
public class MRGProofChecker {
		
    /**
     * Performs the proof verification of PCC code and returns the success or failure of this process.
     * <p>
     * The proof verification can only be performed by invoking a series of system commands (<code>gf</code>, <code>gdf</code>, <code>isabelle</code>, etc...). For this, we use <code>Runtime.exec()</code>. To simplify this code, only a shell wrapper script is called, which in turns performs all subsequent system commands. The return value is based on the exit status of the wrapper script.
     *
     * @return <code>true</code> on successful termination of the proof verification shell script
     */

    // Maps classnames to HashMaps of related filenames/filebuffers
    private static HashMap<String,HashMap<String,MRGFile>> hashmap = new HashMap<String,HashMap<String,MRGFile>>();

    // Adds a new class and its files to the 'master' table
    public static void set(String cname, HashMap<String,MRGFile> hm) {
	hashmap.put(cname,hm);
    }

    public static boolean check(String cname) {
	// check for null argument
	if (cname == null) {
	    MRGUtils.debug("MRGProofChecker\t: ERROR: Null className");
	    return false;
	}

	// retreive the corresponding entry hashmap
	HashMap hm = (HashMap)hashmap.get(cname);

	// check it for being null
	if (hm==null) {
	    MRGUtils.debug("MRGProofChecker\t: ERROR: Unknown class to be verified");
	    return false;
	}

	// get the class and certificate objects
	Object o_class = hm.get("class");
	Object o_cert  = hm.get("certificate");

	// check them both for being null
	if (o_class==null) {
	    System.out.println("Error getting class buffer");
	    System.exit(1);
	}
	if (o_cert==null) {
	    System.out.println("Error getting certificate buffer");
            System.exit(1);
        }
	 
	// Get classfile name and buffer
	String classfileName = ((MRGFile)o_class).getName();
	byte[] classfileBuffer = ((MRGFile)o_class).getBuffer();

	// get certificate name and buffer
	String certificateName = ((MRGFile)o_cert).getName();
	byte[] certificateBuffer = ((MRGFile)o_cert).getBuffer();

	MRGProofCheckerInstance instance = new MRGProofCheckerLocal();
	//MRGProofCheckerInstance instance = new MRGProofCheckerRemote("127.0.0.1",10001);

	boolean success = instance.check(classfileName, classfileBuffer, certificateName, certificateBuffer);
	return success;
    }
}
