package mrg.jarbuilder;

import java.io.*;
import javax.swing.*;          
import java.awt.*;
import java.awt.event.*;
import java.util.jar.*;

class MRGJarBuilder implements ActionListener {

    private File mainclass = null;
    private File diamondclass = null;
    private File certificate = null;

    public Component createComponents() {
        JButton button1 = new JButton("Select Main Class");
	JButton button2 = new JButton("Select Diamond Class");
	JButton button3 = new JButton("Select Certificate");
	JButton button4 = new JButton("Create Jar");

	button1.setActionCommand("mainclass");
	button2.setActionCommand("diamondclass");
	button3.setActionCommand("certificate");
	button4.setActionCommand("createjar");
	
        button1.addActionListener(this);
        button2.addActionListener(this);
        button3.addActionListener(this);
	button4.addActionListener(this);

        JPanel pane = new JPanel(new GridLayout(0, 1));

        pane.add(button1);
        pane.add(button2);
        pane.add(button3);
        pane.add(button4);

        return pane;
    }

    public void actionPerformed(ActionEvent e) {
	String action = e.getActionCommand();
	if (action.equals("createjar")) {
	    if (mainclass!=null & diamondclass!=null & certificate!=null) {
		JFileChooser save = new JFileChooser();
		save.showSaveDialog(null);
		File f = save.getSelectedFile();
		if (f != null)
		    makeJar(f);
	    }
	} else if (action.equals("mainclass")) {
	    this.mainclass = getFile();
	} else if (action.equals("diamondclass")) {
	    this.diamondclass = getFile();
	} else if (action.equals("certificate")) {
	    this.certificate = getFile();
	}
    }

    private static File getFile() {
	JFileChooser chooser = new JFileChooser();
	chooser.showOpenDialog(null);
	return chooser.getSelectedFile();
    }

    private void makeJar(File f) {
	System.out.println("Main Class\t: "+this.mainclass);
	System.out.println("Diamond Class\t: "+this.diamondclass);
	System.out.println("Certificate\t: "+this.certificate);
    }
	

    /**
     * Create the GUI and show it.  For thread safety,
     * this method should be invoked from the
     * event-dispatching thread.
     */
    private static void createAndShowGUI() {
	//Make sure we have nice window decorations.
        JFrame.setDefaultLookAndFeelDecorated(true);

        //Create and set up the window.
        JFrame frame = new JFrame("MRGJarBuilder");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        MRGJarBuilder app = new MRGJarBuilder();
        Component contents = app.createComponents();
        frame.getContentPane().add(contents, BorderLayout.CENTER);

        //Display the window.
        frame.pack();
        frame.setVisible(true);
	frame.setResizable(false);
    }

    public static void main(String[] args) {
	if (args.length==0) {
	    System.out.println("Must supply arguments");
	    System.exit(1);
	}

	for (int i=0; i<args.length; i++) {
	    System.out.println("Including: "+args[i]);
	}

        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }

}
