theory InsSortProof = InsSortProg + Aux:

text {*Result of lfg-infer -olhs 4:
 \begin{verbatim}
  ins        : 1, int -> iList[0|int,#,0] -> iList[0|int,#,0], 0
  sort       : 0, iList[0|int,#,0] -> iList[0|int,#,0], 0
 \end<verbatim} *}

constdefs Ins_Spec::"vdmassn"
"Ins_Spec == DAss {InsSort'ins'l} 1 (emptyfinmap(InsSort'ins'l \<mapsto>\<^sub>f(ListET 0))) (ListET 0) 0"

constdefs Sort_Spec::"vdmassn"
"Sort_Spec == DAss {InsSort'sort'l} 0 (emptyfinmap(InsSort'sort'l \<mapsto>\<^sub>f(ListET 0))) (ListET 0) 0"

constdefs FST :: FS_T
"FST == \<lambda> f E h hh v p . False"

constdefs MST :: MS_T
"MST == (\<lambda> M args E h hh v p.
         if M = InsSort'ins then Ins_Spec (newframe_env ((fst (methtable InsSort InsSort'ins)) @ [RNpar self]) args E) h hh v p else
         if M = InsSort'sort then Sort_Spec (newframe_env ((fst (methtable InsSort InsSort'sort)) @ [RNpar self]) args E) h hh v p else
         False)"

constdefs  InsSortContext:: vdmcontext
"InsSortContext \<equiv> {(InsSort\<bullet>InsSort'ins([INarg InsSort'ins'a,RNarg InsSort'ins'l]), MST InsSort'ins [INarg InsSort'ins'a,RNarg InsSort'ins'l,VALarg (RVal Nullref)]),
                   (InsSort\<bullet>InsSort'ins([INarg InsSort'ins'v3,RNarg InsSort'ins'r2]), MST InsSort'ins [INarg InsSort'ins'v3, RNarg InsSort'ins'r2,VALarg (RVal Nullref)]),
                   (InsSort\<bullet>InsSort'ins([INarg InsSort'sort'v2,RNarg InsSort'sort'l]), MST InsSort'ins [INarg InsSort'sort'v2, RNarg InsSort'sort'l,VALarg (RVal Nullref)]),
                   (InsSort\<bullet>InsSort'ins([INarg InsSort'ins'a,RNarg InsSort'ins'r2]), MST InsSort'ins [INarg InsSort'ins'a, RNarg InsSort'ins'r2,VALarg (RVal Nullref)]),
                   (InsSort\<bullet>InsSort'sort([RNarg InsSort'sort'l]), MST InsSort'sort [RNarg InsSort'sort'l,VALarg (RVal Nullref)]),
                   (InsSort\<bullet>InsSort'sort([RNarg InsSort'sort'r1]), MST InsSort'sort [RNarg InsSort'sort'r1,VALarg (RVal Nullref)])}"

lemma InsInvoke: "MST InsSort'ins [INarg InsSort'ins'x, RNarg InsSort'ins'y, VALarg (RVal Nullref)] = \<lbrace> {InsSort'ins'y} , Suc 0 , emptyfinmap(InsSort'ins'y\<mapsto>\<^sub>fListET 0) \<ggreater>  ListET 0 , 0 \<rbrace>"
apply (simp add: MST_def)
apply (simp add: Meth_InsSort'ins Ins_Spec_def newframe_env_def evalARGS_def self_def)
apply rule 
apply (rule, rule, rule, rule, simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def DOM_def GETr_def)
apply (simp add: regionsDistinct_def DOM_def GETr_def)
apply (simp add: distinctFrom_def DOM_def GETr_def)
apply (erule ContextSize.elims, clarsimp, clarsimp)
apply (erule ContextSize.elims, clarsimp)
apply (rule ContextSizeCONS,fast) apply (simp add: GETr_def) apply simp
  apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def DOM_def GETr_def)
apply (simp add: regionsDistinct_def DOM_def GETr_def)
apply (simp add: distinctFrom_def DOM_def GETr_def)
apply (erule ContextSize.elims, clarsimp, clarsimp)
apply (erule ContextSize.elims, clarsimp)
apply (rule ContextSizeCONS,fast) apply (simp add: GETr_def) apply simp
  apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
done


lemma SortInvoke:
"MST InsSort'sort [RNarg InsSort'y, VALarg (RVal Nullref)] = \<lbrace> {InsSort'y} , 0 , (emptyfinmap(InsSort'y \<mapsto>\<^sub>f(ListET 0))) \<ggreater> (ListET 0), 0 \<rbrace>"
apply (simp add: MST_def)
apply (simp add: Meth_InsSort'sort Sort_Spec_def newframe_env_def evalARGS_def self_def)
apply rule 
apply (rule, rule, rule, rule, simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def DOM_def GETr_def)
apply (simp add: regionsDistinct_def DOM_def GETr_def)
apply (simp add: distinctFrom_def DOM_def GETr_def)
apply (erule ContextSize.elims, clarsimp, clarsimp)
apply (erule ContextSize.elims, clarsimp)
apply (rule ContextSizeCONS,fast) apply (simp add: GETr_def) apply simp
  apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def DOM_def GETr_def)
apply (simp add: regionsDistinct_def DOM_def GETr_def)
apply (simp add: distinctFrom_def DOM_def GETr_def)
apply (erule ContextSize.elims, clarsimp, clarsimp)
apply (erule ContextSize.elims, clarsimp)
apply (rule ContextSizeCONS,fast) apply (simp add: GETr_def) apply simp
  apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
done

lemma Ins_DAss:
"\<lbrakk>G = InsSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable InsSort InsSort'ins) : Ins_Spec"
apply (simp add: Meth_InsSort'ins Ins_Spec_def)
apply (rule DA_Weak)
apply (rule DA_Call)
apply (simp add: Fun_InsSort'ins'f_ins)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all add: DOM_def)
(*first branch*)
apply (rule DA_Call)
apply (simp only: Fun_InsSort'ins'f_0)
apply (rule DA_Letr, rule DA_Null) defer 1 apply simp
(*invocation of make*)
apply (rule DA_make_IID) (* HWL: DA_Make_IID) *)
apply (simp add: GETr_def) 
apply simp
apply simp
apply simp
apply simp
apply simp
(*second branch*)
apply (rule DA_Call)
apply (simp only:  Fun_InsSort'ins'f_1)
apply (rule DA_ListMatchD) apply (simp add: GETr_def) apply simp 
apply (rule DA_Let_Prim)
apply (rule DA_If)
apply (simp_all (no_asm))
(*f2-branch*)
apply (rule DA_Call)
apply (simp only: Fun_InsSort'ins'f_2)
apply (rule DA_Letr)
(*invocation of make*)
apply (rule DA_Make_IID)
apply (simp add: GETr_def) 
apply simp
apply simp
(*invocation of make*)
apply (rule DA_Make_IID)
apply (simp add: GETr_def) 
apply simp
apply simp
apply simp
apply simp
(*f3-branch*)
apply (rule DA_Call)
apply (simp only:  Fun_InsSort'ins'f_3)
apply (rule DA_Letr)
(*invocation of ins*)
  apply (rule DA_Const, rule DAss_Contexts_same_on_U) 
  apply (rule vdm_ax)
  apply (simp add: InsSortContext_def InsInvoke)
  apply (simp add: GETr_def)  
  apply simp+
(*invocation of make*)
apply (rule DA_Make_IID)
apply (simp add: GETr_def) 
apply fastsimp+
done

lemma Sort_DAss:
"\<lbrakk>G = InsSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable InsSort InsSort'sort) : Sort_Spec"
apply (simp add: Meth_InsSort'sort Sort_Spec_def)
apply (rule DA_Weak)
apply (rule DA_Call)
apply (simp add: Fun_InsSort'sort'f_sort)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all add: DOM_def)
(*first branch*)
apply (rule DA_Call)
apply (simp only: Fun_InsSort'sort'f_0)
apply (rule DA_Null) apply (simp, simp)
(*second branch*)
apply (rule DA_Call)
apply (simp only:  Fun_InsSort'sort'f_1)
apply (rule DA_ListMatchD) apply (simp add: GETr_def) apply simp
apply (rule DA_Letr)
(*invocation of sort*)
  apply (rule DA_Const, rule DAss_Contexts_same_on_U) 
  apply (rule vdm_ax)
  apply (simp add: InsSortContext_def SortInvoke)
  apply (simp add: GETr_def)  
  apply simp+
(*new invocation of ins*)
  apply (rule DA_Const, rule DAss_Contexts_same_on_U) 
  apply (rule vdm_ax)
  apply (simp add: InsSortContext_def InsInvoke)
  apply (simp add: GETr_def)  
  apply simp+
done

lemma InsSortContext_good: "goodContext FST MST InsSortContext"
apply (simp add: goodContext_def InsSortContext_def, safe)
(*Ins*)
  apply (rule vdm_conseq, rule Ins_DAss)
  apply (simp add: MST_def InsSortContext_def, clarsimp)
  apply (simp add: MST_def Meth_InsSort'ins Ins_Spec_def newframe_env_def evalARGS_def self_def) 
  apply (erule DAss_PConst)
(*Ins*)
  apply (rule vdm_conseq, rule Ins_DAss)
  apply (simp add: MST_def InsSortContext_def, clarsimp)
  apply (simp add: MST_def Meth_InsSort'ins Ins_Spec_def newframe_env_def evalARGS_def self_def) 
  apply (erule DAss_PConst)
(*Ins*)
  apply (rule vdm_conseq, rule Ins_DAss)
  apply (simp add: MST_def InsSortContext_def, clarsimp)
  apply (simp add: MST_def Meth_InsSort'ins Ins_Spec_def newframe_env_def evalARGS_def self_def) 
  apply (erule DAss_PConst)
(*Sort*)
  apply (rule vdm_conseq) apply(rule Ins_DAss)
  apply (simp add: MST_def InsSortContext_def, clarsimp)
  apply (simp add: MST_def Meth_InsSort'ins Ins_Spec_def newframe_env_def evalARGS_def self_def) 
  apply (erule DAss_PConst)
(*Sort*)
  apply (rule vdm_conseq, rule Sort_DAss)
  apply (simp add: MST_def InsSortContext_def, clarsimp)
  apply (simp add: MST_def Meth_InsSort'sort Sort_Spec_def newframe_env_def evalARGS_def self_def) 
  apply (erule DAss_PConst)
(*Sort*)
  apply (rule vdm_conseq, rule Sort_DAss)
  apply (simp add: MST_def InsSortContext_def, clarsimp)
  apply (simp add: MST_def Meth_InsSort'sort Sort_Spec_def newframe_env_def evalARGS_def self_def) 
  apply (erule DAss_PConst)
done

text {*Thus, we can prove that arbitrary invocations of @{text Ins} and  @{text Sort} honour
       their entries in the specification table MST, in the empty VDM context.*}
theorem "\<rhd> InsSort\<bullet>InsSort'ins([RNarg x, RNarg y]): MST InsSort'ins ([RNarg x, RNarg y] @ [VALarg (RVal Nullref)])"
apply (rule GCInvs)
apply (rule InsSortContext_good)
apply (simp_all add: InsSortContext_def)
apply (rule, simp)
apply fastsimp
done 

theorem "\<rhd> InsSort\<bullet>InsSort'sort([RNarg x]): MST InsSort'sort ([RNarg x] @ [VALarg (RVal Nullref)])"
apply (rule GCInvs)
apply (rule InsSortContext_good)
apply (simp_all add: InsSortContext_def)
apply (rule, simp)
apply fastsimp
done 

end
