theory HeapSortProg = TreeVCG:

subsection{*Heapsort for integers*}

text{*Camelot code in progs/Camelot/examples/HeapSort.cmlt*}
text {*Grail code in progs/Camelot/examples/HeapSort.gr*}

syntax HS    :: cname
       Sort :: mname
       Insert :: mname
       Siftdown :: mname
       Extract :: mname
       Make_heap :: mname
       Removetop :: mname
       Removesome :: mname
translations
 "HS"         == "(CN ''HS'') "
 "Sort"       == "(MN ''0'')"
 "Insert"     == "(MN ''1'')"
 "Siftdown"   == "(MN ''2'')"
 "Extract"    == "(MN ''3'')"
 "Make_heap"  == "(MN ''4'')"
 "Removesome" == "(MN ''5'')"
 "Removetop"  == "(MN ''6'')"

syntax fSort :: funame
translations
 "fSort" == "(FN ''0_'') "

syntax fInsert :: funame
       fzeroInsert :: funame
       foneInsert :: funame
       ftwoInsert :: funame
       fthreeInsert :: funame
translations
 "fInsert" == "(FN ''1_'') "
 "fzeroInsert" == "(FN ''1_0'')"
 "foneInsert" == "(FN ''1_1'')"
 "ftwoInsert" == "(FN ''1_2'')"
 "fthreeInsert" == "(FN ''1_3'')"

syntax
       w_     :: iname
       v3_    :: iname
       v6_    :: iname
       v9_     :: iname
       r4_    :: rname
       r5_    :: rname
       r7_    :: rname
       r8_    :: rname
       t1_    :: rname
       t2_    :: rname
       fSiftdown :: funame
       fzeroSiftdown :: funame
       foneSiftdown :: funame
       ftwoSiftdown :: funame
       fthreeSiftdown :: funame
       ffourSiftdown :: funame
       ffiveSiftdown :: funame
       fsixSiftdown :: funame
       fsevenSiftdown :: funame
       feightSiftdown :: funame
       fnineSiftdown :: funame
       ftenSiftdown :: funame
       felevenSiftdown :: funame
       ftwelveSiftdown :: funame
       fthirteenSiftdown :: funame
       ffourteenSiftdown :: funame
       ffifteenSiftdown :: funame
       fsixteenSiftdown :: funame
       fseventeenSiftdown :: funame
       feighteenSiftdown :: funame
       fnineteenSiftdown :: funame
translations
 "w_" == "(In ''w'') "
 "v3_" == "(In ''v3'') "
 "v6_" == "(In ''v6'') "
 "v9_" == "(In ''v9'') "
 "r4_" == "(RN ''r4'') "
 "r5_" == "(RN ''r5'') "
 "r7_" == "(RN ''r7'') "
 "r8_" == "(RN ''r8'') "
 "t1_" == "(RN ''t1'') "
 "t2_" == "(RN ''t2'') "
 "fSiftdown" == "(FN ''2_'') "
 "fzeroSiftdown" == "(FN ''2_0'')"
 "foneSiftdown" == "(FN ''2_1'')"
 "ftwoSiftdown" == "(FN ''2_2'')"
 "fthreeSiftdown" == "(FN ''2_3'')"
 "ffourSiftdown" == "(FN ''2_4'')"
 "ffiveSiftdown" == "(FN ''2_5'')"
 "fsixSiftdown" == "(FN ''2_6'')"
 "fsevenSiftdown" == "(FN ''2_7'')"
 "feightSiftdown" == "(FN ''2_8'')"
 "fnineSiftdown" == "(FN ''2_9'')"
 "ftenSiftdown" == "(FN ''2_10'')"
 "felevenSiftdown" == "(FN ''2_11'')"
 "ftwelveSiftdown" == "(FN ''2_12'')"
 "fthirteenSiftdown" == "(FN ''2_13'')"
 "ffourteenSiftdown" == "(FN ''2_14'')"
 "ffifteenSiftdown" == "(FN ''2_15'')"
 "fsixteenSiftdown" == "(FN ''2_16'')"
 "fseventeenSiftdown" == "(FN ''2_17'')"
 "feighteenSiftdown" == "(FN ''2_18'')"
 "fnineteenSiftdown" == "(FN ''2_19'')"

syntax h_ :: rname
       fExtract :: funame
       fzeroExtract :: funame
       foneExtract :: funame
translations
 "h_" == "(RN ''h'')"
 "fExtract" == "(FN ''3_'') "
 "fzeroExtract" == "(FN ''3_0'')"
 "foneExtract" == "(FN ''3_1'')"

syntax l_ :: rname
       fMake_heap :: funame
       fzeroMake_heap :: funame
       foneMake_heap :: funame

translations
 "l_" == "(RN ''l'')"
 "fMake_heap" == "(FN ''4_'') "
 "fzeroMake_heap" == "(FN ''4_0'')"
 "foneMake_heap" == "(FN ''4_1'')"

syntax v2_    :: iname
       fRemovesome :: funame
       fzeroRemovesome :: funame
       foneRemovesome :: funame
       ftwoRemovesome :: funame
       fthreeRemovesome :: funame
translations
 "v2_" == "(In ''v2'') "
 "fRemovesome" == "(FN ''5_'') "
 "fzeroRemovesome" == "(FN ''5_0'')"
 "foneRemovesome" == "(FN ''5_1'')"
 "ftwoRemovesome" == "(FN ''5_2'')"
 "fthreeRemovesome" == "(FN ''5_3'')"


syntax fRemovetop :: funame
       fzeroRemovetop :: funame
       foneRemovetop :: funame
       ftwoRemovetop :: funame
       fthreeRemovetop :: funame
translations
 "fRemovetop" == "(FN ''6_'') "
 "fzeroRemovetop" == "(FN ''6_0'')"
 "foneRemovetop" == "(FN ''6_1'')"
 "ftwoRemovetop" == "(FN ''6_2'')"
 "fthreeRemovetop" == "(FN ''6_3'')"

syntax x_    :: iname
       b_    :: iname
       v4_   :: iname
       t_    :: rname
       r3_    :: rname
translations
 "x_" == "(In ''x'') "
 "b_" == "(In ''b'') "
 "v4_" == "(In ''v4'') "
 "t_" == "(RN ''t'') "
 "r3_" == "(RN ''r3'') "

axioms Meth_Insert: 
"methtable HS Insert = ([INpar x_,RNpar t_], CALL fInsert)"

axioms Fun_fInsert:
"funtable fInsert = ([RNpar t_],
                     LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t_ t_
                     IN IF b_ THEN CALL fzeroInsert ELSE CALL foneInsert END)"
axioms Fun_fzeroInsert:
"funtable fzeroInsert = ([],
                          LET rf r2_ = Null;
                               rf t_ = Null 
                          IN DIAM\<bullet>Make_IIDD ([VALarg (IVal 3),INarg x_, RNarg r2_, RNarg t_]) END)"
axioms Fun_foneInsert:
"funtable foneInsert =
      ([RNpar t_],
        LET v4_ = GetFi t_ V0;
        rf r3_ = GetFr t_ R1;
        rf r2_ = GetFr t_ R2;
             _ = DIAM\<bullet>Free ([RNarg t_]);
            b_ = Primop (\<lambda> x y . if x < y then 1 else 0) x_ v4_
       IN IF b_ THEN CALL ftwoInsert ELSE CALL fthreeInsert END)"
axioms Fun_ftwoInsert:
"funtable ftwoInsert =
      ([RNpar r3_, RNpar r2_],
       LET rf t_ = HS\<bullet>Insert ([INarg v4_, RNarg r2_])
       IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg x_, RNarg t_, RNarg r3_]) END)"

axioms Fun_fthreeInsert:
"funtable fthreeInsert =
      ([RNpar r3_, RNpar r2_],
        LET rf t_ = HS\<bullet>Insert ([INarg x_, RNarg r2_])
       IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v4_, RNarg t_, RNarg r3_]) END)"

axioms Meth_Siftdown: 
"methtable HS Siftdown = ([INpar w_, RNpar t1_, RNpar t2_], CALL fSiftdown)"
axioms Fun_fSiftdown:
"funtable fSiftdown =
      ([RNpar t1_, RNpar t2_],
        LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t1_ t1_
        IN IF b_ THEN CALL fzeroSiftdown ELSE CALL foneSiftdown END)"
axioms Fun_fzeroSiftdown:
"funtable fzeroSiftdown = ([], LET rf t2_ = Null;
                                   rf t1_ = Null 
                               IN DIAM\<bullet>Make_IIDD ([VALarg (IVal 3),INarg w_, RNarg t2_, RNarg t1_]) END)"
axioms Fun_foneSiftdown:
"funtable foneSiftdown =
       ([RNpar t1_, RNpar t2_],
        LET v9_ = GetFi t1_ V0;
                          rf r8_ = GetFr t1_ R1;
                          rf r7_ = GetFr t1_ R2;
                               _ = DIAM\<bullet>Free ([RNarg t1_]);
                              b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t2_ t2_
                         IN IF b_ THEN CALL ftwoSiftdown ELSE CALL fthreeSiftdown END)"
axioms Fun_ftwoSiftdown:
"funtable ftwoSiftdown = ([], LET b_ = Primop (\<lambda> z y. if z < y then 1 else 0) w_ v9_
                              IN IF b_ THEN CALL feighteenSiftdown ELSE CALL fnineteenSiftdown END)"
axioms Fun_fthreeSiftdown:
"funtable fthreeSiftdown =
                         ([RNpar r8_, RNpar r7_, RNpar t2_],
                           LET v6_ = GetFi t2_ V0;
                            rf r5_ = GetFr t2_ R1;
                            rf r4_ = GetFr t2_ R2;
                                 _ = DIAM\<bullet>Free ([RNarg t2_]);
                                b_ = Primop (\<lambda> z y. if z < y then 1 else 0) w_ v6_
                          IN IF b_ THEN CALL ffiveSiftdown ELSE CALL fsixSiftdown END)"
axioms Fun_ffourSiftdown:
"funtable ffourSiftdown = ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
                               LET b_ = Primop (\<lambda> z y. if z = 1 then 1 else 0) v3_ v3_
                               IN IF b_ THEN CALL fnineSiftdown ELSE CALL ftenSiftdown END)"
axioms Fun_ffiveSiftdown:
"funtable ffiveSiftdown = ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
                               LET b_ = Primop (\<lambda> z y. if z < y then 1 else 0) w_ v9_
                               IN IF b_ THEN CALL fsevenSiftdown ELSE CALL feightSiftdown END)"
axioms Fun_fsixSiftdown:
"funtable fsixSiftdown =
 ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_], LET v3_ = expr.Int 0 IN CALL ffourSiftdown END)"
axioms Fun_fsevenSiftdown:
"funtable fsevenSiftdown = 
  ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
   LET v3_ = expr.Int 1 IN CALL ffourSiftdown END)"
axioms Fun_feightSiftdown:
"funtable feightSiftdown =
  ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],LET v3_ = expr.Int 0 IN CALL ffourSiftdown END)"
axioms Fun_fnineSiftdown:
"funtable fnineSiftdown =
  ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
                          LET rf t2_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg r8_, RNarg r7_]);
                              rf t1_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v6_, RNarg r5_, RNarg r4_])
                          IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg w_, RNarg t2_, RNarg t1_]) END)"
axioms Fun_ftenSiftdown:
"funtable ftenSiftdown =([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
                         LET b_ = Primop (\<lambda> z y. if z < y then 1 else 0) v6_ w_
                         IN IF b_ THEN CALL ftwelveSiftdown ELSE CALL fthirteenSiftdown END)"
axioms Fun_felevenSiftdown:
"funtable felevenSiftdown = ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
                             LET b_ = Primop (\<lambda> z y. if z = 1 then 1 else 0) v3_ v3_
                             IN IF b_ THEN CALL fsixteenSiftdown ELSE CALL fseventeenSiftdown END)"
axioms Fun_ftwelveSiftdown:
"funtable ftwelveSiftdown = ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
                             LET b_ = Primop (\<lambda> z y. if z < y then 1 else 0) v6_ v9_
                             IN IF b_ THEN CALL ffourteenSiftdown ELSE CALL ffifteenSiftdown END)"
axioms Fun_fthirteenSiftdown:
"funtable fthirteenSiftdown = 
  ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_], LET v3_ = expr.Int 0 IN CALL felevenSiftdown END)"
axioms Fun_ffourteenSiftdown:
"funtable ffourteenSiftdown =
 ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_], LET v3_ = expr.Int 1 IN CALL felevenSiftdown END)"
axioms Fun_ffifteenSiftdown:
"funtable ffifteenSiftdown =
 ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_], LET v3_ = expr.Int 0 IN CALL felevenSiftdown END)"
axioms Fun_fsixteenSiftdown:
"funtable fsixteenSiftdown =
  ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
         LET rf t2_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg r8_, RNarg r7_]);
             rf t1_ = HS\<bullet>Siftdown([INarg w_, RNarg r5_, RNarg r4_])
         IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v6_, RNarg t2_, RNarg t1_]) END)"
axioms Fun_fseventeenSiftdown:
"funtable fseventeenSiftdown =
   ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
    LET rf t2_ = HS\<bullet>Siftdown([INarg w_, RNarg r8_, RNarg r7_]);
        rf t1_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v6_, RNarg r5_, RNarg r4_])
    IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg t2_, RNarg t1_]) END)"
axioms Fun_feighteenSiftdown:
"funtable feighteenSiftdown =([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
                               LET rf r4_ = Null;
                                   rf t1_ = Null;
                                   rf t2_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg r4_, RNarg t1_]);
                                   rf t1_ = Null
                               IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg w_, RNarg t2_, RNarg t1_]) END)"
axioms Fun_fnineteenSiftdown:
"funtable fnineteenSiftdown =([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
                              LET rf r4_ = Null;
                                  rf t1_ = Null;
                                  rf t2_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg w_, RNarg r4_, RNarg t1_]);
                                  rf t1_ = Null
                              IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg t2_, RNarg t1_]) END)"


axioms Meth_Removesome: 
"methtable HS Removesome = ([RNpar t_], CALL fRemovesome)"
axioms Fun_fRemovesome:
"funtable fRemovesome = ([RNpar t_],
                         LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t_ t_
                         IN IF b_ THEN CALL fzeroRemovesome ELSE CALL foneRemovesome END)"
axioms Fun_fzeroRemovesome: "funtable fzeroRemovesome = ([], Null)"
axioms Fun_foneRemovesome:
"funtable foneRemovesome =
     ([RNpar t_],
       LET v4_ = GetFi t_ V0;
        rf r1_ = GetFr t_ R1;
        rf r3_ = GetFr t_ R2;
             _ = DIAM\<bullet>Free ([RNarg t_]);
         rf t_ = HS\<bullet>Removesome ([RNarg r1_]);
            b_ = RPrimop (\<lambda> z y . if z = Nullref then 1 else 0) t_ t_
       IN IF b_ THEN CALL ftwoRemovesome ELSE CALL fthreeRemovesome END)"
axioms Fun_ftwoRemovesome:
"funtable ftwoRemovesome = ([RNpar r3_],DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v4_, RNarg r3_]))"
axioms Fun_fthreeRemovesome:
"funtable fthreeRemovesome =
      ([RNpar t_, RNpar r3_],
       LET v2_ = GetFi t_ V0;
        rf r1_ = GetFr t_ R1;
             _ = DIAM\<bullet>Free ([RNarg t_]);
         rf t_ = DIAM\<bullet>Make_IIDD ([VALarg (IVal 3), INarg v4_, RNarg r3_, RNarg r1_])
       IN DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v2_, RNarg t_]) END)"

axioms Meth_Removetop: 
"methtable HS Removetop = ([RNpar t_], CALL fRemovetop)"
axioms Fun_fRemovetop:
"funtable fRemovetop = ([RNpar t_],
                        LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t_ t_
                        IN IF b_ THEN CALL fzeroRemovetop ELSE CALL foneRemovetop END)"
axioms Fun_fzeroRemovetop: "funtable fzeroRemovetop = ([],Null)"
axioms Fun_foneRemovetop:
"funtable foneRemovetop =
     ([RNpar t_],
       LET v4_ = GetFi t_ V0;
        rf r1_ = GetFr t_ R1;
        rf r3_ = GetFr t_ R2;
             _ = DIAM\<bullet>Free ([RNarg t_]);
         rf t_ = HS\<bullet>Removesome ([RNarg r1_]);
            b_ = RPrimop (\<lambda> z y . if z = Nullref then 1 else 0) t_ t_
       IN IF b_ THEN CALL ftwoRemovetop ELSE CALL fthreeRemovetop END)"
axioms Fun_ftwoRemovetop:
"funtable ftwoRemovetop = ([RNpar r3_],DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v4_, RNarg r3_]))"
axioms Fun_fthreeRemovetop:
"funtable fthreeRemovetop =
      ([RNpar t_, RNpar r3_],
       LET v2_ = GetFi t_ V0;
        rf r1_ = GetFr t_ R1;
             _ = DIAM\<bullet>Free ([RNarg t_]);
         rf t_ = HS\<bullet>Siftdown ([INarg v2_, RNarg r3_, RNarg r1_])
       IN DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v4_, RNarg t_]) END)"

axioms Meth_Make_heap: 
"methtable HS Make_heap = ([RNpar l_], CALL fMake_heap)"
axioms Fun_fMake_heap:
"funtable fMake_heap = ([RNpar l_],LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l_ l_
                                   IN IF b_ THEN CALL fzeroMake_heap ELSE CALL foneMake_heap END)"
axioms Fun_fzeroMake_heap: "funtable fzeroMake_heap = ([],Null)"
axioms Fun_foneMake_heap:
"funtable foneMake_heap =
      ([RNpar l_],
       LET v2_ = GetFi l_ V0;
        rf r1_ = GetFr l_ R1;
             _ = DIAM\<bullet>Free ([RNarg l_]);
         rf l_ = HS\<bullet>Make_heap ([RNarg r1_])
       IN HS\<bullet>Insert([INarg v2_, RNarg l_]) END)"

axioms Meth_Extract: 
"methtable HS Extract = ([RNpar h_], CALL fExtract)"
axioms Fun_fExtract:
"funtable fExtract =([RNpar h_],
                     LET rf r3_ = HS\<bullet>Removetop ([RNarg h_]);
                             b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) r3_ r3_
                     IN IF b_ THEN CALL fzeroExtract ELSE CALL foneExtract END)"
axioms Fun_fzeroExtract: "funtable fzeroExtract = ([],Null)"
axioms Fun_foneExtract:
"funtable foneExtract =
      ([RNpar r3_],
       LET v2_ = GetFi r3_ V0;
        rf r1_ = GetFr r3_ R1;
             _ = DIAM\<bullet>Free ([RNarg r3_]);
         rf h_ = HS\<bullet>Extract ([RNarg r1_])
       IN DIAM\<bullet>Make_IID([VALarg (IVal 5), INarg v2_, RNarg h_]) END)"

axioms Meth_Sort: 
"methtable HS Sort = ([RNpar l_], CALL fSort)"
axioms Fun_fSort:
"funtable fSort =([RNpar l_],
                  LET rf r1_ = HS\<bullet>Make_heap ([RNarg l_])
                  IN HS\<bullet>Extract ([RNarg r1_]) END)"

defs
isMergePoint_def: "isMergePoint f == f \<in> {ffourSiftdown, felevenSiftdown}"

dominates_def:
"dominates f == (if f = fthreeSiftdown then [ffourSiftdown] else
                if f = ftenSiftdown then [felevenSiftdown] else [])"

text {*Here is what Steffen's analysis claims, using -olhs 4:
 \begin{verbatim}
  insert     : 1, int -> iTree[0|int,#,#,0] -> iTree[0|int,#,#,0], 0;
  siftdown   : 1, int -> iTree[0|int,#,#,0] -> iTree[0|int,#,#,0] -> iTree[0|int,#,#,0], 0;
  removesome : 0, iTree[0|int,#,#,0] -> iresult[0|int,iTree[0|int,#,#,0],0], 0;
  removetop  : 0, iTree[0|int,#,#,0] -> iresult[0|int,iTree[0|int,#,#,0],0], 0;
  make_heap  : 0, iList[0|int,#,0] -> iTree[0|int,#,#,0], 0;
  extract    : 0, iTree[0|int,#,#,0] -> iList[0|int,#,0], 0;
  sort       : 0, iList[0|int,#,0] -> iList[0|int,#,0], 0;
\end<verbatim} *}

text {*The outcome -olhs 3 is   
  removesome : 1, iTree[0|int,#,#,0] -> iresult[1|int,iTree[0|int,#,#,0],1], 0;
    This spec cannot be verified!*}


(*sanity lemmas - need not be generated by the compiler *)
lemma "methtable HS Insert = ([INpar x_,RNpar t_], CALL fInsert)" by (simp add: Meth_Insert)
lemma "funtable fInsert = ([RNpar t_],
                            LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t_ t_
                            IN IF b_ THEN CALL fzeroInsert ELSE CALL foneInsert END)"
by (simp add: Fun_fInsert)
lemma  "funtable fzeroInsert = ([],
                                 LET rf r2_ = Null;
                                      rf t_ = Null 
                                 IN DIAM\<bullet>Make_IIDD ([VALarg (IVal 3),INarg x_, RNarg r2_, RNarg t_]) END)"
by (simp add: Fun_fzeroInsert)
lemma "funtable foneInsert =
      ([RNpar t_],
        LET v4_ = GetFi t_ V0;
        rf r3_ = GetFr t_ R1;
        rf r2_ = GetFr t_ R2;
             _ = DIAM\<bullet>Free ([RNarg t_]);
            b_ = Primop (\<lambda> x y . if x < y then 1 else 0) x_ v4_
       IN IF b_ THEN CALL ftwoInsert ELSE CALL fthreeInsert END)"
by (simp add: Fun_foneInsert)     
lemma "funtable ftwoInsert =
      ([RNpar r3_, RNpar r2_],
       LET rf t_ = HS\<bullet>Insert ([INarg v4_, RNarg r2_])
       IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg x_, RNarg t_, RNarg r3_]) END)"
by (simp add: Fun_ftwoInsert)
lemma "funtable fthreeInsert =
      ([RNpar r3_, RNpar r2_],
        LET rf t_ = HS\<bullet>Insert ([INarg x_, RNarg r2_])
       IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v4_, RNarg t_, RNarg r3_]) END)"
by (simp add: Fun_fthreeInsert)
lemma "methtable HS Siftdown = ([INpar w_, RNpar t1_, RNpar t2_], CALL fSiftdown)" by (simp add: Meth_Siftdown)
lemma "funtable fSiftdown = 
      ([RNpar t1_, RNpar t2_],
        LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t1_ t1_
        IN IF b_ THEN CALL fzeroSiftdown ELSE CALL foneSiftdown END)"
by (simp add: Fun_fSiftdown)
lemma  "funtable fzeroSiftdown = 
                      ([],LET rf t2_ = Null;
                              rf t1_ = Null 
                          IN DIAM\<bullet>Make_IIDD ([VALarg (IVal 3),INarg w_, RNarg t2_, RNarg t1_]) END)"
by (simp add: Fun_fzeroSiftdown)
lemma  "funtable foneSiftdown = 
                       ([RNpar t1_, RNpar t2_],
                         LET v9_ = GetFi t1_ V0;
                          rf r8_ = GetFr t1_ R1;
                          rf r7_ = GetFr t1_ R2;
                               _ = DIAM\<bullet>Free ([RNarg t1_]);
                              b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t2_ t2_
                         IN IF b_ THEN CALL ftwoSiftdown ELSE CALL fthreeSiftdown END)"
by (simp add: Fun_foneSiftdown)
lemma  "funtable ftwoSiftdown = ([], LET b_ = Primop (\<lambda> z y. if z < y then 1 else 0) w_ v9_
                                     IN IF b_ THEN CALL feighteenSiftdown ELSE CALL fnineteenSiftdown END)"
by (simp add: Fun_ftwoSiftdown)
lemma  "funtable fthreeSiftdown = 
                         ([RNpar r8_, RNpar r7_, RNpar t2_],
                                  LET v6_ = GetFi t2_ V0;
                                   rf r5_ = GetFr t2_ R1;
                                   rf r4_ = GetFr t2_ R2;
                                        _ = DIAM\<bullet>Free ([RNarg t2_]);
                                       b_ = Primop (\<lambda> z y. if z < y then 1 else 0) w_ v6_
                                  IN IF b_ THEN CALL ffiveSiftdown ELSE CALL fsixSiftdown END)"
by (simp add: Fun_fthreeSiftdown)
lemma  "funtable ffourSiftdown = ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
                                      LET b_ = Primop (\<lambda> z y. if z = 1 then 1 else 0) v3_ v3_
                                      IN IF b_ THEN CALL fnineSiftdown ELSE CALL ftenSiftdown END)"
by (simp add: Fun_ffourSiftdown)
lemma  "funtable ffiveSiftdown = ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
                                     LET b_ = Primop (\<lambda> z y. if z < y then 1 else 0) w_ v9_
                                     IN IF b_ THEN CALL fsevenSiftdown ELSE CALL feightSiftdown END)"
by (simp add: Fun_ffiveSiftdown)
lemma  "funtable fsixSiftdown =
        ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_], LET v3_ = expr.Int 0 IN CALL ffourSiftdown END)"
by (simp add: Fun_fsixSiftdown)
lemma  "funtable fsevenSiftdown = 
        ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_], LET v3_ = expr.Int 1 IN CALL ffourSiftdown END)"
by (simp add: Fun_fsevenSiftdown)
lemma  "funtable feightSiftdown =
        ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_], LET v3_ = expr.Int 0 IN CALL ffourSiftdown END)"
by (simp add: Fun_feightSiftdown)
lemma  "funtable fnineSiftdown = 
          ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
                          LET rf t2_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg r8_, RNarg r7_]);
                              rf t1_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v6_, RNarg r5_, RNarg r4_])
                          IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg w_, RNarg t2_, RNarg t1_]) END)"
by (simp add: Fun_fnineSiftdown)
lemma  "funtable ftenSiftdown = ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
                                 LET b_ = Primop (\<lambda> z y. if z < y then 1 else 0) v6_ w_
                                 IN IF b_ THEN CALL ftwelveSiftdown ELSE CALL fthirteenSiftdown END)"
by (simp add: Fun_ftenSiftdown)
lemma  "funtable felevenSiftdown = ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
                                    LET b_ = Primop (\<lambda> z y. if z = 1 then 1 else 0) v3_ v3_
                                    IN IF b_ THEN CALL fsixteenSiftdown ELSE CALL fseventeenSiftdown END)"
by (simp add: Fun_felevenSiftdown)
lemma  "funtable ftwelveSiftdown = 
        ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
         LET b_ = Primop (\<lambda> z y. if z < y then 1 else 0) v6_ v9_
         IN IF b_ THEN CALL ffourteenSiftdown ELSE CALL ffifteenSiftdown END)"
by (simp add: Fun_ftwelveSiftdown)
lemma  "funtable fthirteenSiftdown =
         ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_], LET v3_ = expr.Int 0 IN CALL felevenSiftdown END)"
by (simp add: Fun_fthirteenSiftdown)
lemma  "funtable ffourteenSiftdown =
        ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_], LET v3_ = expr.Int 1 IN CALL felevenSiftdown END)"
by (simp add: Fun_ffourteenSiftdown)
lemma  "funtable ffifteenSiftdown = 
        ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],LET v3_ = expr.Int 0 IN CALL felevenSiftdown END)"
by (simp add: Fun_ffifteenSiftdown)
lemma  "funtable fsixteenSiftdown = 
           ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
            LET rf t2_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg r8_, RNarg r7_]);
                rf t1_ = HS\<bullet>Siftdown([INarg w_, RNarg r5_, RNarg r4_])
            IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v6_, RNarg t2_, RNarg t1_]) END)"
by (simp add: Fun_fsixteenSiftdown)
lemma  "funtable fseventeenSiftdown =
   ([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
     LET rf t2_ = HS\<bullet>Siftdown([INarg w_, RNarg r8_, RNarg r7_]);
         rf t1_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v6_, RNarg r5_, RNarg r4_])
     IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg t2_, RNarg t1_]) END)"
by (simp add: Fun_fseventeenSiftdown)
lemma  "funtable feighteenSiftdown =([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
                                      LET rf r4_ = Null;
                                          rf t1_ = Null;
                                          rf t2_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg r4_, RNarg t1_]);
                                          rf t1_ = Null
                                      IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg w_, RNarg t2_, RNarg t1_]) END)"
by (simp add: Fun_feighteenSiftdown)
lemma  "funtable fnineteenSiftdown =([RNpar r8_, RNpar r7_, RNpar r5_, RNpar r4_],
                                     LET rf r4_ = Null;
                                         rf t1_ = Null;
                                         rf t2_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg w_, RNarg r4_, RNarg t1_]);
                                         rf t1_ = Null
                                     IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg t2_, RNarg t1_]) END)"
by (simp add: Fun_fnineteenSiftdown)
lemma "methtable HS Removesome = ([RNpar t_], CALL fRemovesome)" by (simp add: Meth_Removesome)
lemma "funtable fRemovesome =
        ([RNpar t_], LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t_ t_
                     IN IF b_ THEN CALL fzeroRemovesome ELSE CALL foneRemovesome END)"
by (simp add: Fun_fRemovesome)
lemma  "funtable fzeroRemovesome = ([], Null)" by (simp add: Fun_fzeroRemovesome)
lemma "funtable foneRemovesome =
      ([RNpar t_],
       LET v4_ = GetFi t_ V0;
        rf r1_ = GetFr t_ R1;
        rf r3_ = GetFr t_ R2;
             _ = DIAM\<bullet>Free ([RNarg t_]);
         rf t_ = HS\<bullet>Removesome ([RNarg r1_]);
            b_ = RPrimop (\<lambda> z y . if z = Nullref then 1 else 0) t_ t_
       IN IF b_ THEN CALL ftwoRemovesome ELSE CALL fthreeRemovesome END)"
by (simp add: Fun_foneRemovesome)     

lemma "funtable ftwoRemovesome = ([RNpar r3_],DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v4_, RNarg r3_]))"
by (simp add: Fun_ftwoRemovesome)
lemma "funtable fthreeRemovesome =
     ([RNpar t_, RNpar r3_],
       LET v2_ = GetFi t_ V0;
        rf r1_ = GetFr t_ R1;
             _ = DIAM\<bullet>Free ([RNarg t_]);
         rf t_ = DIAM\<bullet>Make_IIDD ([VALarg (IVal 3), INarg v4_, RNarg r3_, RNarg r1_])
       IN DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v2_, RNarg t_]) END)"
by (simp add: Fun_fthreeRemovesome)
lemma "methtable HS Removetop = ([RNpar t_], CALL fRemovetop)" by (simp add: Meth_Removetop)
lemma "funtable fRemovetop = ([RNpar t_],
                              LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t_ t_
                              IN IF b_ THEN CALL fzeroRemovetop ELSE CALL foneRemovetop END)"
by (simp add: Fun_fRemovetop)
lemma  "funtable fzeroRemovetop = ([],Null)" by (simp add: Fun_fzeroRemovetop)
lemma "funtable foneRemovetop =
     ([RNpar t_],
       LET v4_ = GetFi t_ V0;
        rf r1_ = GetFr t_ R1;
        rf r3_ = GetFr t_ R2;
             _ = DIAM\<bullet>Free ([RNarg t_]);
         rf t_ = HS\<bullet>Removesome ([RNarg r1_]);
            b_ = RPrimop (\<lambda> z y . if z = Nullref then 1 else 0) t_ t_
       IN IF b_ THEN CALL ftwoRemovetop ELSE CALL fthreeRemovetop END)"
by (simp add: Fun_foneRemovetop)     
lemma "funtable ftwoRemovetop = ([RNpar r3_],DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v4_, RNarg r3_]))"
by (simp add: Fun_ftwoRemovetop)
lemma "funtable fthreeRemovetop =
      ([RNpar t_, RNpar r3_],
       LET v2_ = GetFi t_ V0;
        rf r1_ = GetFr t_ R1;
             _ = DIAM\<bullet>Free ([RNarg t_]);
         rf t_ = HS\<bullet>Siftdown ([INarg v2_, RNarg r3_, RNarg r1_])
       IN DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v4_, RNarg t_]) END)"
by (simp add: Fun_fthreeRemovetop)
lemma "methtable HS Make_heap = ([RNpar l_], CALL fMake_heap)" by (simp add: Meth_Make_heap)

lemma "funtable fMake_heap = ([RNpar l_],LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l_ l_
                                         IN IF b_ THEN CALL fzeroMake_heap ELSE CALL foneMake_heap END)"
by (simp add: Fun_fMake_heap)
lemma  "funtable fzeroMake_heap = ([],Null)" by (simp add: Fun_fzeroMake_heap)
lemma "funtable foneMake_heap =
      ([RNpar l_],
       LET v2_ = GetFi l_ V0;
        rf r1_ = GetFr l_ R1;
             _ = DIAM\<bullet>Free ([RNarg l_]);
         rf l_ = HS\<bullet>Make_heap ([RNarg r1_])
       IN HS\<bullet>Insert([INarg v2_, RNarg l_]) END)"
by (simp add: Fun_foneMake_heap)     
lemma "methtable HS Extract = ([RNpar h_], CALL fExtract)" by (simp add: Meth_Extract)
lemma "funtable fExtract =
                    ([RNpar h_],
                     LET rf r3_ = HS\<bullet>Removetop ([RNarg h_]);
                             b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) r3_ r3_
                           IN IF b_ THEN CALL fzeroExtract ELSE CALL foneExtract END)"
by (simp add: Fun_fExtract)
lemma  "funtable fzeroExtract = ([],Null)" by (simp add: Fun_fzeroExtract)
lemma "funtable foneExtract =
      ([RNpar r3_],
       LET v2_ = GetFi r3_ V0;
        rf r1_ = GetFr r3_ R1;
             _ = DIAM\<bullet>Free ([RNarg r3_]);
         rf h_ = HS\<bullet>Extract ([RNarg r1_])
       IN DIAM\<bullet>Make_IID([VALarg (IVal 5), INarg v2_, RNarg h_]) END)"
by (simp add: Fun_foneExtract)     
lemma "methtable HS Sort = ([RNpar l_], CALL fSort)" by (simp add: Meth_Sort)
lemma "funtable fSort = ([RNpar l_],
                         LET rf r1_ = HS\<bullet>Make_heap ([RNarg l_])
                         IN HS\<bullet>Extract ([RNarg r1_]) END)"
by (simp add: Fun_fSort)
end
