#!/bin/bash

RTJAR=/usr/lib/jvm/java-1.4.2-sun-1.4.2.06/jre/lib/rt.jar

TMPDIR="/tmp/mrg-`whoami`"
BINDIR="$TMPDIR/bin"
OUTDIR="$TMPDIR/out"

mkdir -p $TMPDIR
mkdir -p $BINDIR
mkdir -p $OUTDIR

echo "This set of tests is performed in the directory: $TMPDIR"

# Checkout sml-jvm library
cvs -d /group/project/mrg/src/ checkout -d $TMPDIR/sml-jvm mrg/progs/sml-jvm


# Checkout and compile Grail (gdf/gf)
cvs -d /group/project/mrg/src/ checkout -d $TMPDIR/Grail mrg/progs/Grail

#make -C $TMPDIR/Grail/gdf/src clean
make -C $TMPDIR/Grail/gdf/src
cp $TMPDIR/Grail/gdf/src/gdf $BINDIR

#make -C $TMPDIR/Grail/gf/src clean
make -C $TMPDIR/Grail/gf/src
cp $TMPDIR/Grail/gf/src/gf $BINDIR


# Checkout and compile Camelot
cvs -d /group/project/mrg/src/ checkout -d $TMPDIR/Camelot mrg/progs/Camelot

#make -C $TMPDIR/Camelot/src clean
make -C $TMPDIR/Camelot/src
cp $TMPDIR/Camelot/src/camelot $BINDIR


# run Camelot on example programs
SRCDIR="$TMPDIR/Camelot/examples"

for file in $SRCDIR/*.cmlt
do
  echo "Compiling $file..."
  $BINDIR/camelot -cp $RTJAR -d $OUTDIR $file
done
