--  2001, 2002 Peter Thiemann
module HTMLMonadBase where
import HTMLBase
type Element = ELEMENT_
type Attributes = [Attribute]
type Attribute = ATTR_
data WithHTML x m a =
  WithHTML { unWithHTML :: ELEMENT_ -> m (a, ELEMENT_) }
instance Monad m => Monad (WithHTML x m) where
  return a = WithHTML (\elem -> return (a, elem))
  ma >>= f = WithHTML (\elem -> unWithHTML ma elem >>= \(a, elem') ->
                                unWithHTML (f a) elem')
lift :: Monad m => m a -> WithHTML x m a
lift ma = WithHTML (\elem -> ma >>= \a -> return (a, elem))
get_attrs :: Monad m => WithHTML x m Attributes
get_attrs = WithHTML (\elem -> return (get_attrs_ elem, elem))
-- empty element collection
empty :: Monad m => WithHTML x m ()
empty = return ()
-- concatenation of collections
infixl 1 ##
x ## y = x >>= \a -> y >> return a
-- cleanup of attribute values
av (str@('\"':_)) = let str1 = read str :: String in str1
av str = str
--
type HTMLCons x y m a = WithHTML x m a -> WithHTML y m a
text, rawtext, formattedtext :: Monad m => String -> WithHTML x m ()
text s = WithHTML (\elem -> return ((), add_ elem (cdata_ [] s)))
rawtext s = WithHTML (\elem -> return ((), add_ elem (cdata_ [CDATA_ENCODED] s)))
formattedtext s = WithHTML (\elem -> return ((), add_ elem (cdata_ [CDATA_FORMATTED] s)))
attr :: Monad m => String -> String -> WithHTML x m ()
attr a v = WithHTML (\ elem -> return ((), add_attr_ elem (attr_ a v)))
(@@) :: Monad m => String -> String -> WithHTML x m ()
a @@ v = attr a v
addMaker subelem ma =
  WithHTML (\elem -> unWithHTML ma subelem >>= \(a, subelem') ->
                     return (a, add_ elem subelem'))
build_document :: Monad m => WithHTML x m a -> m ELEMENT_
build_document ma = unWithHTML ma
  (doctype_ ["HTML", "PUBLIC", "\"-//W3C//DTD XHTML 1.0 Strict//EN\"", "\"DTD/xhtml1-strict.dtd\""] [])
  >>= \ (a, elem) -> return elem
