--  2001 Peter Thiemann
module HTMLBase 
  (ATTR_(), attr_, attr_name, attr_value
  ,ELEMENT_(), element_, empty_, cdata_, comment_, doctype_
  ,CDATA_OPTIONS(..)
  ,add_, add_attr_
  ,get_attrs_
  ,BT(..)
  ,attr_S, element_S, empty_S, cdata_S, comment_S, doctype_S)
where

import Char

data BT = STATIC | DYNAMIC

-- untyped layer
-- attributes

data ATTR_ =
  ATTR_ { attr_BT :: BT
	, attr_name :: String
        , attr_value :: String
	}

attr_  = ATTR_ DYNAMIC
attr_S = ATTR_ STATIC

-- elements

data ELEMENT_ =
    ELEMENT_ { elem_BT :: BT
	     , tag :: String
    	     , attrs :: [ATTR_]
	     , elems :: [ELEMENT_]
	     }
  | EMPTY_   { elem_BT :: BT
	     , tag :: String
  	     , attrs :: [ATTR_]
	     }
  | CDATA_   { elem_BT :: BT
	     , elem_cdata :: String
	     }
  | COMMENT_ { elem_BT :: BT
	     , elem_comment :: String
	     }
  | DOCTYPE_ { elem_BT :: BT
	     , doctype :: [String]
  	     , elems :: [ELEMENT_]
	     }

data CDATA_OPTIONS = CDATA_ENCODED | CDATA_FORMATTED
  deriving (Eq)

element_  = ELEMENT_ DYNAMIC
element_S = ELEMENT_ STATIC
empty_    = EMPTY_ DYNAMIC
empty_S   = EMPTY_ STATIC
makeEncoder opt = format . encode
  where format | CDATA_FORMATTED `elem` opt = id
	       | otherwise = htmlFormat
	encode | CDATA_ENCODED `elem` opt = id
	       | otherwise = htmlEncode
cdata_  opt = CDATA_ DYNAMIC . makeEncoder opt
cdata_S opt = CDATA_ STATIC . makeEncoder opt
comment_  = COMMENT_ DYNAMIC
comment_S = COMMENT_ STATIC
doctype_  = DOCTYPE_ DYNAMIC
doctype_S = DOCTYPE_ STATIC

add_ e_ e'_ = e_ { elems = e'_ : elems e_}
add_attr_ e_ att = 
  let nameOfAtt = attr_name att
      all_attrs = attrs e_
      f [] = Nothing
      f (att' : attrs) = if attr_name att' == nameOfAtt 
      			 then return (att : attrs)
			 else f attrs >>= \ attrs' -> return (att' : attrs')
      new_attrs = case f all_attrs of
		    Nothing -> att : all_attrs
		    Just attrs -> attrs
  in  e_ { attrs = new_attrs }

get_attrs_ = attrs

-- show functions

instance Show ATTR_ where
  showsPrec i = shows_attribute
  showList    = shows_attributes

shows_attributes :: [ATTR_] -> ShowS
shows_attributes atts = foldr (.) id (map shows_attribute atts)

shows_attribute :: ATTR_ -> ShowS
shows_attribute a =
  showChar ' ' . showString (attr_name a) .
  case attr_value a of
    "()" ->
      id
    str@('\"':_) ->
      showString "=\"" . showString (read str) . showString "\""
    str ->
      showString "=\"" . showString str . showString "\""

instance Show ELEMENT_ where
  showsPrec i = shows_element
  showList = shows_elements

shows_elements :: [ELEMENT_] -> ShowS
shows_elements elts = foldr (.) id (reverse (map shows_element elts))

shows_element :: ELEMENT_ -> ShowS
shows_element (EMPTY_ bt tag atts) =
  showChar '<' . showString tag . shows atts . showString "\n/>"
shows_element (ELEMENT_ bt tag atts elts) =
  showChar '<' . showString tag . shows atts . showChar '>'
  . shows_elements elts
  . showString "</" . showString tag . showString "\n>"
shows_element (DOCTYPE_ bt strs elems) =
  showString "<!DOCTYPE" . 
  foldr (\str f -> showChar ' ' . showString str . f) id strs . showString "\n>" .
  showString "<!-- generated by WASH/HTML 0.9\n-->" .
  shows_elements elems .
  showChar '\n'
shows_element (CDATA_ bt str) =
  showString str
shows_element (COMMENT_ bt str) =
  showString "<!-- " . showString str . showString "\n-->"

htmlEncode "" = ""
htmlEncode (x:xs) = 
	case x of
	  '&' -> "&amp;" ++ htmlEncode xs
	  '<' -> "&lt;"  ++ htmlEncode xs
	  '>' -> "&gt;"  ++ htmlEncode xs
	  '\"' -> "&quot;" ++ htmlEncode xs
	  _ -> x : htmlEncode xs

htmlFormat s = s
{--htmlFormat "" = ""
htmlFormat (x:xs) =
	if isSpace x then
	  "\n " ++ htmlFormat (dropWhile isSpace xs)
	else
	  x : htmlFormat xs	  
--}

