module Misc where

import FiniteMap
import Set
import System.IO.Unsafe

instance (Show a, Ord a) => Show (Set a) where
    show set = show $ setToList set

instance (Show a, Show b, Ord b) => Show (FiniteMap a b) where
    show fm = show $ fmToList fm

instance (Ord a, Ord b) => Ord (FiniteMap a b) where
    compare x y = compare (fmToList x) (fmToList y)

instance (Ord a) => Ord (Set a) where
    compare x y = compare (setToList x) (setToList y)



mapPair :: ((a -> a') , (b -> b')) -> [(a,b)] -> [(a',b')]
mapPair (f,g) [] = []
mapPair (f,g) ((x,y):pairs) = (f x,g y):(mapPair (f,g) pairs)

maybeSet :: Maybe a -> Set a
maybeSet Nothing = emptySet
maybeSet (Just a) = unitSet a

{-- debugging --}

mikdebug (name, toshow) result = 
    unsafePerformIO $ do
		      putStrLn $ name ++ " = " ++ (indent_term "" $ show toshow)
		      return $ result
mikdebugOFF _ = id


{----- one-line term -> indented term --}

indent_term i (c1:c2:cs) = s ++ indent_term i' (c2:cs)
    where
    (s,i') = t c1 c2
    t '\n' _ = (nl i, i)
    t '(' _ = (nl i ++ "(", '(':i)
    t '[' ']' = ("[", '[':i)
    t '[' _ = (nl i ++ "[", '[':i)
    t ')' _ = (")", tail i)
    t ']' _ = ("]", tail i)
    t ',' _ = if head i == '[' then ("," ++ nl i, i) else (",", i)
    t c _ = ([c], i)
    nl i = "\n" ++ replicate (length i) ' '
indent_term i s = s

