module Camelot_infer_destr where

import Camelot_absyn_ASDL
import Camelot_absyn
import Camelot_annot
import Camelot_infer_annot
import Misc

import Set

infer_destr :: ProgramA -> ProgramA
infer_destr (PROGA typedecs valdecs afundef_groups) =
    fst $ infer_annot $
    PROGA typedecs valdecs afundef_groups'
	where
	afundef_groups' = map (map destr_fundef) afundef_groups

destr_fundef :: FunDefA -> FunDefA
destr_fundef (FUNdefA loc funcnm vars inst aexp) =  -- kwxm
    FUNdefA loc funcnm vars inst aexp'
	where
	aexp' = destr_aexp aexp

destr_aexp :: ExpA -> ExpA
destr_aexp (ExpA loc ea ty contextFM eannot) =
    ExpA loc ea' ty contextFM min_EAnnot
	where
	ea' =
	  case ea
	       of
	       IFexpA tst exp1 exp2 -> IFexpA tst exp1' exp2'     -- kwxm:  deal with vars in tst
		   where
		   exp1' = destr_aexp exp1
		   exp2' = destr_aexp exp2
	       LETexpA x exp1 exp2 -> LETexpA x exp1' exp2'
		   where
		   exp1' = destr_aexp exp1
		   exp2' = destr_aexp exp2
	       TYPEDexpA exp ty -> TYPEDexpA exp' ty
		   where
		   exp' = destr_aexp exp
	       ASSERTexpA exp conds guars -> ASSERTexpA exp' conds guars
		   where
		   exp' = destr_aexp exp
	       MATCHexpA x rules -> MATCHexpA x rules'
		   where
		   rules' = map (destr_rule x nonsep pv) rules
		   (EAnnot _ _ (pv, nonsep)) = eannot
	       _ -> ea

destr_rule x nonsep up_pv (MATCHruleA loc consNmL varLs matchdiam aexp) =
    mikdebug ("match " ++ x ++ " rule " ++ consNm, safe_destr) $
    MATCHruleA loc consNmL varLs matchdiam' aexp'
	where
	aexp' = destr_aexp aexp
	matchdiam' =
		 case matchdiam
		      of NOWHERE | safe_destr -> DISPOSE
			 _ -> matchdiam
	safe_destr =
	    isEmptySet $ up_down_pv `intersect` nonsep_vars
	up_down_pv =
	    (unPreserveVars up_pv) `union` ((unUsedVars uv) `minusSet` pat_vars)
	(ExpA _ _ _ _ (EAnnot _ uv _)) = aexp
	nonsep_vars =
	    mkSet $ concat $ map pick_var $ setToList $ unNonSep nonsep
		where
		pick_var (AAsep padr1 padr2) =
		    if padr1 == d_padr
		       then [padr2var padr2]
		       else if padr2 == d_padr
			    then [padr2var padr1]
			    else []
		pick_var _ = []
	d_padr = PortionCAddr $ CAddr x $ AddrDataCons consNm
	consNm = snd consNmL
	pat_vars = mkSet $ snd $ unzip varLs
