module Camelot_infer_annot_UA where

import Camelot_absyn_ASDL
import Camelot_absyn
import Camelot_annot_UA
import Misc

import List (elemIndex, unzip4)
import FiniteMap
import Set

import System.IO.Unsafe


infer_annot_UA :: ProgramA -> ProgramA
infer_annot_UA = id

{-

infer_annot_UA (PROGA typedecs valdecs afundef_groups0) =
    mikdebugOFF("dataFM", dataFM) $
    (PROGA typedecs' valdecs afundef_groups, dataFM)
	where
	afundef_groups = map reverse afundef_groups4
	-- replace all heap-free types with UNITty
	typedecs' = map simplify_typedecA typedecs
	simplify_typedecA (TYPEdecA loc d tcs _) =
	    TYPEdecA loc d' (map simplify_typeconL $ filter usingHeap tcs) adrs
	    where
	    adrs = all_PortionZAddr dataFM id $ CONty ([], d')
	    d' = no_dollar_prefix d
	    simplify_typeconL (loc, TYPEcon (c, tys, heapUsage)) =
		(loc, TYPEcon (c, map simplify_ty tys, heapUsage))
	    usingHeap (loc, TYPEcon (c, tys, HEAP)) = True
	    usingHeap _ = False
	-- variables used and exp types (1 simple pass only)
	(afundef_groups1, _) =
	    annot_groups uv_ty_annot_exp afundef_groups0
	(afundef_groups2, _) =
	    annot_groups pv_annot_exp afundef_groups1
	(afundef_groups3, _) =
	    annot_groups sep_annot_exp afundef_groups2 -- deel separation analysed bottom-up
	(afundef_groups4, _) =
	    scann_groups nonsep_scann_exp afundef_groups3 -- used sharing analysed top-down
			       -- IMPORTANT: annot_groups/ scann_groups reverse the group list
	annot_groups _ [] = ([], emptyFM)
	annot_groups annot_exp (group:rest) =
	    annot_fundef_group annot_exp (dataFM, consFM, valdecFM, paramsFM)
				   (annot_groups annot_exp rest) group
	scann_groups _ [] = ([], emptyFM)
	scann_groups scann_exp (group:rest) =
	    scann_fundef_group scann_exp (dataFM, consFM, valdecFM, paramsFM)
				   (scann_groups scann_exp rest) group
	(dataFM, consFM) = extract_typedecs datadecFM typedecs'
	paramsFM =
	    listToFM $ concat $ map (map f) afundef_groups0
		where
		f (FUNdefA _ funcnm params _) = (funcnm, params)
	valdecFM =
	    listToFM $ map f valdecs
		where
		f (_, VALdec (fnm, typ)) = (fnm, (styp, get_restyp styp))
		    where
		    styp = simplify_ty typ' -- replace all heap-free types with UNITty
		    typ' = case typ of -- replace UNITty -> t with t if t is not ARROWty
				    ARROWty (UNITty, t) ->
					case t of ARROWty _ -> typ
						  _ -> t
				    _ -> typ
	datadecFM =
	    listToFM $ map f typedecs'
		where
		f (TYPEdecA _ dataNm typeCons _) = (dataNm, typeCons)


type ExpScannFn = DeclFMs -> AnnotFM -> ContextFM -> FuncNm -> [VarNm] -> ExpA -> AnnotFM

scann_fundef_group :: ExpScannFn
		   -> DeclFMs
		   -> ([[FunDefA]], AnnotFM) -- previous annotations
		   -> [FunDefA] -- new group to be annotated
		   -> ([[FunDefA]], AnnotFM) 
scann_fundef_group scann_exp declFMs (done_groups, done_annotFM) fundefs =
    (afundefs : done_groups, annotFM)
	where
	(afundefs, annotFM) = f 0 fundefs done_annotFM
	f prev_runs prev_fundefs prev_annotFM =
	    if new_fundefs == prev_fundefs
	       then mikdebug ("Total runs = " ++ show (prev_runs + 1), "") $
			(prev_fundefs, prev_annotFM)
	       else f (prev_runs + 1) new_fundefs new_annotFM
	    where
	    new_annotFM = scann_fundefs $ reverse fundefs
	    scann_fundefs [] = prev_annotFM
	    scann_fundefs (fundef:rest) = annotFM
		where
		annotFM = scann_fundef scann_exp declFMs rest_annotFM fundef
		rest_annotFM = scann_fundefs rest
	    new_fundefs = amend_fundefs_pvnonsep new_annotFM fundefs

amend_fundefs_pvnonsep :: AnnotFM -> [FunDefA] -> [FunDefA]
amend_fundefs_pvnonsep annotFM fundefs = map f fundefs
    where
    f (FUNdefA floc funcnm params (ExpA eloc ea ty contextFM eannot)) =
	FUNdefA floc funcnm params (ExpA eloc ea ty contextFM eannot')
	    where
	    eannot' = EAnnot assert uv (pv, nonsep)
	    pv = PreserveVars $ (unPreserveVars pv1) `union` (unPreserveVars pv2)
	    (EAnnot assert uv (pv1, _)) = eannot
	    (EAnnot _ _ (pv2, nonsep)) = eannot_nonsep
	    eannot_nonsep = lookupWithDefaultFM annotFM min_EAnnot funcnm

scann_fundef :: ExpScannFn
	     -> DeclFMs
	     -> AnnotFM
	     -> FunDefA
	     -> AnnotFM
scann_fundef scann_exp declFMs annotFM (FUNdefA loc funcnm vars aexp) =
    scann_exp declFMs annotFM contextFM funcnm vars aexp
	where
	contextFM = mkContextFM vars typ
	(typ, _) = lookupWithDefaultFM valdecFM err funcnm
	(_, _, valdecFM, _) = declFMs
	err = error $ "scann_fundef: function not declared: " ++ show funcnm

type ExpAnnotFn = DeclFMs -> AnnotFM -> ContextFM -> ExpA -> ExpA

annot_fundef_group :: ExpAnnotFn
		   -> DeclFMs
		   -> ([[FunDefA]], AnnotFM) -- previous annotations
		   -> [FunDefA] -- new group to be annotated
		   -> ([[FunDefA]], AnnotFM) 
annot_fundef_group annot_exp declFMs (done_groups, done_annotFM) fundefs =
    (afundefs : done_groups, annotFM)
	where
	(afundefs, annotFM) = f 0 fundefs $ amend_annotFM done_annotFM fundefs
	f prev_runs prev_fundefs prev_annotFM =
	    if new_fundefs == prev_fundefs -- || prev_runs > 0
	       then mikdebug ("Total runs = " ++ show (prev_runs + 1), "") $
			(prev_fundefs, prev_annotFM)
	       else f (prev_runs + 1) new_fundefs new_annotFM
	    where
	    new_fundefs = map (annot_fundef annot_exp declFMs prev_annotFM) fundefs
	    new_annotFM = amend_annotFM prev_annotFM new_fundefs

amend_annotFM :: AnnotFM -> [FunDefA] -> AnnotFM
amend_annotFM annotFM fundefs = addListToFM annotFM (map f fundefs)
    where
    f (FUNdefA _ funcnm _ (ExpA _ _ _ _ eannot)) = (funcnm, eannot)

annot_fundef :: ExpAnnotFn
	     -> DeclFMs
	     -> AnnotFM
	     -> FunDefA
	     -> FunDefA
annot_fundef annot_exp declFMs annotFM (FUNdefA loc funcnm vars aexp) =
    FUNdefA loc funcnm vars aexp'
	where
	aexp' = annot_exp declFMs annotFM contextFM aexp
	contextFM = mkContextFM vars typ
	(typ, _) = lookupWithDefaultFM valdecFM err funcnm
	(_, _, valdecFM, _) = declFMs
	err = error $ "annot_fundef: function not declared: " ++ show funcnm


type AnnotFM = FiniteMap FuncNm EAnnot
type ParamsFM = FiniteMap FuncNm [VarNm]

type DeclFMs = (DataFM, ConsFM, ValDecFM, ParamsFM)
type ValDecFM = FiniteMap FuncNm (Ty, Ty) -- whole function type and the 0-order result type
type DataDecFM = FiniteMap DataNm [TypeConL]

type DataFM = FiniteMap DataNm ([ZAddr], -- all portions addresses within the datatype
				[ZBasicSepCond], -- all basic separation conditions for the datatype
				[UnFolder], -- 
				Folder)
type ConsFM = FiniteMap ConsNm (Ty, (TJAssert, [PortionCAddr]), (CAdrTrans, ZBCTrans))

-- translator of addresses within unfolded datatype to addresses in the folded version
type Folder = ZAddr -> ZAddr
type UnFolder = ZAddr -> ZAddr


-- this fn translates the addresses in a match clause to the addresses of a match expression
type CAdrTrans = VarNm -- matched variable
	       -> [VarNm] -- parameters in match pattern
	       -> (Maybe VarNmL) -- optional diamond var in match pattern
	       -> CAddr -> CAddr -- the transformer

-- same as above for basic separation conditions
type ZBCTrans = VarNm
	      -> [VarNm]
	      -> (Maybe VarNmL)
	      -> ZBasicSepCond -> [CBasicSepCond]

extract_typedecs :: DataDecFM
		 -> [TypeDecA]
		 -> (DataFM, ConsFM)
extract_typedecs datadecFM typedecs = (dataFM, consFM)
    where
    dataFM = mk_dataFM datadecFM typedecs
    consFM = mk_consFM dataFM typedecs

mk_dataFM :: DataDecFM -> [TypeDecA] -> DataFM
mk_dataFM datadecFM [] = emptyFM
mk_dataFM datadecFM (TYPEdecA _ dataNm typeCons _ : rest) =
    mikdebugOFF(show dataNm,bcs')
    dataFM
    where
    dataFM = addToFM rest_dataFM dataNm (adrs, bcs', unfolders, folder)
    (adrs, xadrs, unfolders) = all_PortionX_ZAddr_data datadecFM emptySet dataNm id (CONty ([], dataNm))
    bcs' =
       if length unfolders > 1
       then bcs
       else filter noacross bcs
	   where
	   noacross (ACROSSsep _ _ _) = False
	   noacross _ = True
    bcs = all_ZBasicSepCond_data datadecFM emptySet id (CONty ([], dataNm))
    rest_dataFM = mk_dataFM datadecFM rest
    folder zadr = mikdebugOFF ("folder " ++ dataNm, (zadr,f id zadr)) f id zadr
	where
	f pos zadr =
	    if (pos AddrDataX) `elementOf` xadrs
	    then zadr -- pos chopped off
	    else case zadr of
			   AddrDataDown (consNm, i, ad) -> 
			       f (pos . (\ ad -> AddrDataDown (consNm, i, ad))) ad
			   -- AddrListDown ad -> f (pos . AddrListDown) ad
			   AddrArray ad -> f (pos . AddrArray) ad
			   _ -> pos zadr


mk_consFM :: DataFM -> [TypeDecA] -> ConsFM
mk_consFM dataFM [] = emptyFM
mk_consFM dataFM (TYPEdecA _ dataNm typeCons _ : rest) =
    mikdebugOFF(dataNm, length unfolders) consFM
    where
    consFM = addListToFM rest_consFM $ map f typeCons
    rest_consFM = mk_consFM dataFM rest
    (zadrs, _, unfolders, folder) = lookupWithDefaultFM dataFM err dataNm
    err = error $ "in mk_consFM: unknown datatype " ++ dataNm
    f (_, TYPEcon (consNm, tys, _heapUsage)) =
	(consNm, (ty, (assert, all_padrs), (adrTrans, bcTrans)))
	where
	ty = foldr (\ t1 t2 -> ARROWty (t1, t2)) (CONty ([], dataNm)) $ map simplify_ty tys
	assert = foldl join_asserts acl_assert copy_asserts
	acl_assert = TJAssert min_SepCond min_Containment guar min_DSet
	    where
	    guar = foldl join_guar guar0 guars
	    guar0 = if length unfolders < 2
		    then min_SepGuar
		    else
		    SepGuar $ unitFM
		    (ACROSSsep z2c zadr dataNm) $
		    SepCond $ mkSet $ [SIMPLEsep $
				       aasep (mk_padr $ unf1 zadr) (mk_padr $ unf2 zadr) |
				       unf1 <- consnm_unfolders,
				       unf2 <- consnm_unfolders,
				       unf1 AddrDataX /= unf2 AddrDataX]
		where
		zadr = AddrDataCons consNm
	    guars = map acl_guar consnm_zadrs
	    acl_guar zadr = SepGuar $ listToFM $
			    if length unfolders < 2
			    then [(ALONGsep z2c zadr dataNm, SepCond along)]
			    else [(ALONGsep z2c zadr dataNm, SepCond along),
				  (ACROSSsep z2c zadr dataNm, SepCond across)]
		where
		across = mkSet $ [SIMPLEsep $
				  aasep (mk_padr $ unf1 zadr) (mk_padr $ unf2 zadr) |
				  unf1 <- consnm_unfolders,
				  unf2 <- consnm_unfolders,
				  unf1 AddrDataX /= unf2 AddrDataX]
		along = mkSet $ [SIMPLEsep $
				 aasep (mk_padr $ unf zadr) (mk_padr zadr) |
				 unf <- consnm_unfolders]
	    z2c = CAddrRes
	    consnm_zadrs = filter is_consnm_adr zadrs
	    consnm_unfolders = filter (\ unf -> is_consnm_adr $ unf $ AddrDataX ) unfolders
	    is_consnm_adr (AddrDataDown (consnm, _, _)) | consnm == consNm = True
	    is_consnm_adr _ = False
	    mk_padr (AddrDataDown (_, i, zadr)) = PortionCAddr $ CAddr v zadr
		where
		v = default_vars !! (i - 1)
	    mk_padr zadr = error $ "address " ++ (show zadr) ++ " mismatches the constructor " ++ consNm
	copy_asserts = map mka $ zip3 nats default_vars tys
	mka (n, x, t) = fold_res_type dataNm folder $ copy_assert dataFM x id fr t
	    where
	    fr ad = AddrDataDown (consNm, n, ad)
	all_padrs = concat $ map get_padrs $ zip default_vars tys
	    where
	    get_padrs (x,ty) = map (PortionCAddr . CAddr x) $ all_PortionZAddr dataFM id ty
	adrTrans x vars maybevar cadr =
	    case cadr of
	    CAddr y zadr ->
		case elemIndex y vars of
		Nothing ->
		    case maybevar of
		    Just (_, d) | d == y -> CAddr x (AddrDataCons consNm)
		    otherwise -> cadr
		Just n -> CAddr x (folder $ AddrDataDown (consNm, n + 1, zadr))
	    _ -> cadr
	bcTrans x vars maybevar bc = map SIMPLEsep zbcs
	    where
	    zbcs =
		case bc of
		AAsep padr1 padr2 ->
		    case maybevar of
		    Nothing -> newseps
		    Just (_, d) ->
			if (x1 == d && x2 `elem` vars)
			       || (x2 == d && x1 `elem` vars)
			then []
			else newseps
		    where
		    newseps = if (padr1N == padr2N)
			      then if prolonged zadr1N zadr1 || prolonged zadr2N zadr2
				   then [ALONGsep z2c zadr1N dataNm]
				   else [ACROSSsep z2c zadr1N dataNm]
			      else [aasep padr1N padr2N]
		    PortionCAddr (CAddr x1 zadr1) = padr1
		    PortionCAddr (CAddr x2 zadr2) = padr2
		    prolonged zadrN zadr = 
			length (show zadrN) > length (show zadr)
		    padr1N = mapCAddr at padr1
		    padr2N = mapCAddr at padr2
		    PortionCAddr (CAddr _ zadr1N) = padr1N
		    PortionCAddr (CAddr _ zadr2N) = padr2N
		    z2c = CAddr x
		ALONGsep z2c zadr dtnm -> [ALONGsep (at . z2c) zadr dtnm]
		ACROSSsep z2c zadr dtnm -> [ACROSSsep (at . z2c) zadr dtnm]
		where
		at cadr = adrTrans x vars maybevar cadr

default_vars = map (\ n -> "x" ++ (show n)) nats
nats = iterate ((+) 1) 1

fold_res_type :: DataNm -> Folder -> TJAssert -> TJAssert
fold_res_type dataNm folder (TJAssert cond cont guar dset) =
    TJAssert cond cont' guar' dset
	where
	cont' = Containment $ addListToFM_C union emptyFM $ cont_list'
	cont_list' = map (\ (k,e) -> (folder k, e) ) cont_list
	cont_list = fmToList $ unContainment cont
	guar' = SepGuar $ addListToFM_C join_cond emptyFM $ guar_list'
	guar_list' = map (\ (k,e) -> (f k, e) ) guar_list
	guar_list = fmToList $ unSepGuar guar
	f zbc = case zbc of
		AAsep padr1 padr2 ->
		    if padr1N /= padr2N
		    then aasep padr1N padr2N
		    else if (padr1 /= padr1N) && (padr2 /= padr2N)
			 then ACROSSsep z2c zadr1N dataNm
			 else ALONGsep z2c zadr1N dataNm
			where
			padr1N = mapZAddr folder padr1
			padr2N = mapZAddr folder padr2
			PortionCAddr (CAddrRes zadr1N) = padr1N
			z2c = CAddrRes
		ALONGsep z2c zadr dtnm -> 
		    ALONGsep (mapZAddr folder . z2c) zadr dtnm
		ACROSSsep z2c zadr dtnm ->
		    ACROSSsep (mapZAddr folder . z2c) zadr dtnm


{---------------------------------------------------------------------}
{---------------------------------------------------------------------}
{---------------------------------------------------------------------}

-- type ExpAnnotFn = DeclFMs -> AnnotFM -> ContextFM -> ExpA -> ExpA
-- type ExpScannFn = DeclFMs -> AnnotFM -> ContextFM -> ExpA -> (ExpA, AnnotFM)


uv_ty_annot_exp :: ExpAnnotFn
uv_ty_annot_exp (_, consFM, valdecFM, _) _ contextFM aexp = uva contextFM aexp
    where 
    uva contextFM (ExpA loc ea _ _ _) = (ExpA loc ea' ty' contextFM eannot')
	where
	eannot' = EAnnot min_TJAssert (UsedVars usedvars'') (min_PreserveVars, min_NonSep)
	usedvars'' = usedvars' `intersect` mkSet (keysFM contextFM)
	(ea', usedvars', ty') =
	    case ea of
	    VALexpA val -> (ea, uvVal val, tyVal val)
	    UNARYexpA unop val -> (ea, uvVal val, UNITty) -- all unops are heap-free
	    BINexpA binop val1 val2 -> (ea, (uvVal val1) `union` (uvVal val2), tyVal val2) -- trickery
	    IFexpA val exp1 exp2 -> (IFexpA val exp1' exp2', usedvars, get_ty exp1')
		where
		exp1' = uva contextFM exp1
		exp2' = uva contextFM exp2
		usedvars = (uvVal val) `union` (get_uv exp1') `union` (get_uv exp2')
	    MATCHexpA val rules -> (MATCHexpA val rules', usedvars, ty)
		where
		rules' = map (uvaM contextFM) rules
		usedvars = (uvVal val) `union` (unionManySets $ map uvM rules')
		ty = get_ty $ get_aexp $ head rules'
	    LETexpA x exp1 exp2 -> (LETexpA x exp1' exp2', usedvars, get_ty exp2')
		where
		exp1' = uva contextFM exp1
		exp2' = uva contextFM2 exp2
		contextFM2 = addToFM contextFM x $ get_ty exp1'
		usedvars = (get_uv exp1') `union` ((get_uv exp2') `delFromSet` x)
	    APPexpA val vals _ext -> (ea, usedvars, ty)
		where
		usedvars = (uvVal val) `union` (unionManySets $ map uvVal vals)
		ty = get_restyp $ tyVal val
	    CONexpA consnm vals maybevar -> (ea, usedvars, ty)
		where
		usedvars = (maybeSet_unL maybevar) `union` (unionManySets $ map uvVal vals)
		ty = get_restyp $ tyCons consnm
	{-
	    LISTexpA vals -> (ea, unionManySets $ map uvVal vals, ty)
		where
		ty = case vals of
		     [] -> error "DEEC cannot handle the empty list expression at present"
		     (val:_) -> tyVal val
	-}
	    TYPEDexpA exp ty -> (TYPEDexpA exp' ty, usedvars',ty')
		where
		exp' = uva contextFM exp
		(ExpA _ _ ty' _ (EAnnot _ (UsedVars usedvars) _)) = exp'
	    ASSERTexpA exp conds guars -> (ASSERTexpA exp' conds guars, usedvars', ty')
		where
		exp' = uva contextFM exp
		(ExpA _ _ ty' _ (EAnnot _ (UsedVars usedvars) _)) = exp'
	tyVal (VARval x) = var_fn_type contextFM valdecFM x
	tyVal val = UNITty -- represents all heap-free types in this analysis
	tyCons consnm = case lookupFM consFM consnm of
			Nothing -> error $ "Invalid constructor " ++ consnm
			Just (ty, _, _) -> ty
    uvVal (VARval x) = unitSet x
    uvVal _ = emptySet
    uvaM contextFM (MATCHruleA loc consnmL varLs matchdiam aexp) =
	MATCHruleA loc consnmL varLs matchdiam $ uva contextFM2d aexp
	    where
	    contextFM2d = case matchdiam of
			  SOMEWHERE (_,d) -> addToFM contextFM2 d (DIAMONDty "")
			  _ -> contextFM2
	    contextFM2 = addListToFM contextFM $ vartyps vars ty
	    vars = snd $ unzip varLs
	    vartyps [] _ = []
	    vartyps (x:xs) (ARROWty (t1, t2)) = (x, t1) : (vartyps xs t2)
	    vartyps _ _ = error "vartyps: less arg types than vars"
	    (ty, _, _) = lookupWithDefaultFM consFM err consnm
	    err = error $ "unknown constructor " ++ (show consnm) ++ " in match"
	    (_, consnm) = consnmL
    uvM (MATCHruleA loc consnmL varLs matchdiam aexp) =
	(get_uv aexp) `minusSet` (mkSet vars `union` diamSet_unL matchdiam)
	    where
	    vars = snd $ unzip varLs
    diamSet_unL (SOMEWHERE (_,x)) = unitSet x
    diamSet_unL _ = emptySet
    maybeSet_unL (Just (_,x)) = unitSet x
    maybeSet_unL _ = emptySet
    get_uv (ExpA _ _ _ _ (EAnnot _ (UsedVars uv) _)) = uv
    get_ty (ExpA _ _ ty _ _) = ty
    get_aexp (MATCHruleA _ _ _ _ aexp) = aexp


{---------------------------------------------------------------------}
{--------------------- DEEL separation inference ---------------------}
{---------------------------------------------------------------------}


sep_annot_exp :: ExpAnnotFn
sep_annot_exp declFMs annotFM _ aexp = sae aexp
    where
    (dataFM, consFM, valdecFM, paramsFM) = declFMs
    sae (ExpA loc ea ty contextFM (EAnnot _ (UsedVars uv) (pv,_))) =
	(ExpA loc ea' ty contextFM (EAnnot assert' (UsedVars uv) (pv,min_NonSep)))
	    where
	    assert' = no_tautos $ TJAssert cond cont guar dset
	    {- 
	    -- remove all functions which might have been treated as variables
	    -- OOPS: no such thing actually exists in Camelot..
	    assert' = no_tautos $ TJAssert cond' cont' guar' dset'
	    cond' = mapZBC remove_fns cond
	    guar' = mapZBC remove_fns guar
	    cont' = cont_remove_fns cont
	    dset' = dset_remove_fns dset
	    remove_fns zbc =
		case zbc of
		AAsep padr1 padr2 -> if x1_is_fn
				     then if x2_is_fn
					  then if consistent
					       then []
					       else [IMPOSSIBLEsep]
					  else []
				     else if x2_is_fn
					  then []
					  else if padr1 == padr2
					       then [IMPOSSIBLEsep]
					       else [SIMPLEsep $ zbc]
		    where
		    x1_is_fn = not $ in_ctxt x1 
		    x2_is_fn = not $ in_ctxt x2
		    PortionCAddr (CAddr x1 zadr1) = padr1
		    PortionCAddr (CAddr x2 zadr2) = padr2
		    consistent = -- NOT TESTED as Camelot does not support nullary fns yet
			if x1 /= x2
			then True
			else cond_consistent bc_cond
			    where
			    bc_cond = get_guar_cond guar_f $ AAsep pradr1 pradr2
			    pradr1 = PortionCAddr (CAddrRes zadr1)
			    pradr2 = PortionCAddr (CAddrRes zadr2)
			    EAnnot (TJAssert _ _ guar_f _) _ _ = fun_annot annotFM x1
		ALONGsep z2c zadr dtnm ->
		    if not $ in_ctxt x
		       then if consistent
			    then []
			    else [IMPOSSIBLEsep]
		       else [SIMPLEsep $ zbc]
		    where
		    (CAddr x _) = z2c $ AddrDataX
		    consistent = True -- TODO
		ACROSSsep z2c zadr dtnm ->
		    if not $ in_ctxt x
		       then if consistent
			    then []
			    else [IMPOSSIBLEsep]
		       else [SIMPLEsep $ zbc]
		    where
		    (CAddr x _) = z2c $ AddrDataX
		    consistent = True -- TODO
	    cont_remove_fns (Containment contFM) =
		Containment $ mapFM ( \ key -> set_remove_fns) contFM
	    dset_remove_fns (DSet set) = DSet $ set_remove_fns set
	    set_remove_fns set = mkSet $ filter (in_ctxtC) $ setToList set
	    in_ctxtC (CAddr x _) = in_ctxt x
	    in_ctxtC _ = True
	    in_ctxt x = if result then result
			else mikdebug("not_in_ctxt", (x,ctxt_vars)) result
		where result = x `elementOf` ctxt_vars
	    ctxt_vars = mkSet $ keysFM contextFM
	    -}
	    -- annotate the expression
            (ea', TJAssert cond cont guar dset) =
		case ea of
		VALexpA (VARval x) -> (ea, copy_assert dataFM x id id xtyp)
		    where xtyp = var_fn_type contextFM valdecFM x
		VALexpA val -> (ea, min_TJAssert)
	        APPexpA (VARval f) vals _ext ->  (ea, assert)
		    where
		    assert = mapVars tr_var assert_f
		    EAnnot assert_f _ _ = fun_annot annotFM f
		    tr_var x = lookupWithDefaultFM vFM (varerr x vFM) x
		    varerr x vFM = error $ "Reference to an absent parameter: " ++ x ++ " " ++ (show vFM)
		    vFM = listToFM $ zip params vars
		    params = fun_params paramsFM f
		    vars = map val2var vals
		    val2var (VARval x) = x
		    val2var _ = error "A heap reference to a primitive value"
	        APPexpA _ vals _ -> error $ "invalid application"
		UNARYexpA unop val -> (ea, min_TJAssert) -- all unops are heap-free
		-- BINexpA CONSop val1 val2 -> error "not yet"
		BINexpA binop val1 val2 -> (ea, min_TJAssert)
		IFexpA val aexp1 aexp2 -> (IFexpA val aexp1' aexp2', assert)
		    where
		    aexp1' = sae aexp1
		    aexp2' = sae aexp2
		    assert = assert1 `join_asserts` assert2
		    ExpA _ _ _ _ (EAnnot assert1 _ _) = aexp1'
		    ExpA _ _ _ _ (EAnnot assert2 _ _) = aexp2'
	        CONexpA consnm vals maybevar ->
		    (CONexpA consnm vals maybevar, assert)
		    where
		    assert = mapVars tr_var assert_pre
		    assert_pre = case maybevar of
				 Nothing -> assert_c
				 Just (_,d) -> assert_c `join_asserts` assert_d
				     where
				     assert_d = TJAssert cond cont guar dset
				     cond = SepCond $ mkSet [ SIMPLEsep $ aasep pdadr padr |
							      padr <- all_padrs]
				     cont = Containment $ unitFM con_zadr $ unitSet dadr
				     guar = min_SepGuar
				     dset = DSet $ unitSet $ dadr
				     con_zadr = AddrDataCons consnm
				     pdadr = PortionCAddr dadr
				     dadr = CAddr d AddrDiam
		    (_, (assert_c, all_padrs), _) = lookupWithDefaultFM consFM err consnm
		    err = error $ "unknown constructor " ++ (show consnm)
		    tr_var x = lookupWithDefaultFM vFM x x
		    vFM = listToFM $ zip default_vars vars
		    vars = map val2var vals
		    val2var (VARval x) = x
		    val2var _ = error "A heap reference to a primitive value"
		MATCHexpA (VARval x) rules -> (MATCHexpA (VARval x) rules', assert)
		    where
		    (rules', asserts) = unzip $ map (saeM x) rules
		    assert = foldl1 join_asserts asserts
		MATCHexpA _ rules -> error "trying to match a primitive value?"
	        LETexpA x aexp1 aexp2 -> (LETexpA x aexp1' aexp2', assert)
		    where
		    aexp1' = sae aexp1
		    aexp2' = sae aexp2
		    ExpA _ _ xtyp _ (EAnnot assert1 _ _) = aexp1'
		    ExpA _ _ _ _ (EAnnot assert2 uv2 _) = aexp2'
		    assert = TJAssert cond cont guar dset
		    TJAssert cond1 cont1 guar1 dset1 = assert1
		    TJAssert cond2 cont2 guar2 dset2 = assert2
		    cond = cond1 `join_cond` t_SC cond2 `join_cond` benign
			where
			benign =
			    SepCond $ mkSet $ [aasep_ cadr1 cadr2 |
					       cadr1 <- setToList $ unDSet dset1,
					       cadr2 <- uv_cadrs]
			aasep_ cadr1 cadr2 =
			    SIMPLEsep $ aasep (PortionCAddr cadr1) (PortionCAddr cadr2)
			uv_cadrs = concat $ map gps $ setToList $ unUsedVars uv2
			gps y = if y == x then []
				else map (CAddr y) $ all_PortionZAddr dataFM id $ var_type contextFM y
		    cont = Containment $ mapFM ( \ key -> t_cadr_set ) $ unContainment cont2
		    guar = mapSC t_SC guar2
		    dset = dset1 `join_dset` dset2x
			where
			dset2x = DSet $ t_cadr_set $ unDSet dset2
		    t_cadr_set set =
			unionManySets $ map tcadr $ setToList set
			    where
			    tcadr cadr = case cadr of
					 CAddr y zadr | x == y ->
						   lookupWithDefaultFM (unContainment cont1) emptySet zadr
					 _ -> unitSet cadr
		    t_SC c = mikdebugOFF ("", (c,cxx,cnoxx)) $
			     (t_use_guar1 cxx) `join_cond` (t_use_cont1 cnoxx)
			where
			(cxx, cnoxx) = split c
			    where
			    split (SepCond cset) = s $ setToList cset
			    s [] = ([],[])
			    s (cbc : rest) = if xx
					     then (zbc : rcxx, rcnoxx)
					     else (rcxx, cbc : rcnoxx)
				where
				(rcxx, rcnoxx) = s rest
				(xx, zbc) = case cbc of
					    IMPOSSIBLEsep -> (False, error "")
					    SIMPLEsep zbc -> (xx, mapCAddr ctxt2res zbc)
						where
						xx = case zbc of
						     AAsep padr1 padr2 -> f padr1 && f padr2
						     ALONGsep z2c _ _ -> f $ PortionCAddr $ z2c AddrDataX
						     ACROSSsep z2c _ _ -> f $ PortionCAddr $ z2c AddrDataX
						f (PortionCAddr (CAddr y _)) = x == y
						f _ = False
						ctxt2res (CAddr _ zadr) = CAddrRes zadr
						ctxt2res _ = error "in ctxt2res"
			t_use_guar1 cxx =
			    SepCond $ unionManySets $ map tg1 cxx
			tg1 zbc =
			    unSepCond $ lookupWithDefaultFM (unSepGuar guar1) min_SepCond zbc
			t_use_cont1 cnoxx =
			    SepCond $ unionManySets $ map tc1 cnoxx
			tc1 IMPOSSIBLEsep = unitSet IMPOSSIBLEsep
			tc1 (SIMPLEsep zbc) =
			    case zbc of
			    AAsep padr1 padr2 ->
				if xin1 then mapSet (\ cadr -> caasep_cp cadr padr2) set1
				else if xin2 then mapSet (\ cadr -> caasep_cp cadr padr1) set2
				     else unitSet $ SIMPLEsep zbc
				    where
				    (xin1, zadr1) = case unPortionCAddr padr1 of
						    CAddr y zadr -> (x == y, zadr)
						    _ -> (False, error "")
				    (xin2, zadr2) = case unPortionCAddr padr2 of
						    CAddr y zadr -> (x == y, zadr)
						    _ -> (False, error "")
				    caasep_cp cadr padr = SIMPLEsep $ aasep (PortionCAddr cadr) padr
				    set1 = lookupWithDefaultFM (unContainment cont1) emptySet zadr1
				    set2 = lookupWithDefaultFM (unContainment cont1) emptySet zadr2
			    _ -> unitSet $ SIMPLEsep zbc
		TYPEDexpA exp ty -> (TYPEDexpA exp' ty, assert')
		    where
		    exp' = sae exp
		    (ExpA _ _ ty' _ (EAnnot assert' _ _)) = exp'
		ASSERTexpA exp conds guars -> (ASSERTexpA exp' conds guars, assert')
		    where
		    exp' = sae exp
		    (ExpA _ _ ty' _ (EAnnot assert' _ _)) = exp'

    saeM x (MATCHruleA  loc consnmL varLs matchdiam aexp) =
	(MATCHruleA loc consnmL varLs matchdiam aexp', assert)
	    where
	    aexp' = sae aexp
	    vars = snd $ unzip varLs
	    vartyps [] _ = []
	    vartyps (x:xs) (ARROWty (t1, t2)) = (x, t1) : (vartyps xs t2)
	    vartyps _ _ = error "vartyps: less arg types than vars"
	    (ty, _, (adrTrans, bcTrans)) = lookupWithDefaultFM consFM err consnm
	    err = error $ "unknown constructor " ++ (show consnm) ++ " in match"
	    (_, consnm) = consnmL
	    assert = TJAssert cond cont guar dset
	    cont = mapCAddr (adrTrans x vars maybevar) cont'
	    dset = mapCAddr (adrTrans x vars maybevar) dset' `join_dset` dset0
	    dset0 = case matchdiam of
		    DISPOSE -> DSet $ unitSet $ CAddr x $ AddrDataCons consnm
		    _ -> min_DSet
	    cond = mapZBC (bcTrans x vars maybevar) $ cond' `join_cond` cond0
	    cond0 = case matchdiam of
		    DISPOSE -> SepCond $ mkSet $
			       [SIMPLEsep $
				aasep (PortionCAddr cadr) (PortionCAddr $ CAddr y yadr) |
				y <- setToList $ unUsedVars uv' `minusSet` mkSet vars,
				yadr <- all_PortionZAddr dataFM id $ var_type contextFM' y]
			where
			cadr = CAddr x $ AddrDataCons consnm
		    _ -> min_SepCond
	    guar = mapZBC (bcTrans x vars maybevar) guar'
	    maybevar = case matchdiam of
		       SOMEWHERE x -> Just x
		       _ -> Nothing
	    TJAssert cond' cont' guar' dset' = assert'
	    ExpA _ _ _ contextFM' (EAnnot assert' uv' _) = aexp'

var_fn_type contextFM valdecFM x = 
    case lookupFM valdecFM x of
    Nothing ->  var_type contextFM x
    Just (ty, _) -> ty

var_type contextFM x = 
    lookupWithDefaultFM contextFM err x
	where
	err = error $ (show x) ++ " not in context " ++ (show contextFM) ++ "\n"

fun_annot annotFM funcnm = lookupWithDefaultFM annotFM err funcnm
    where
    err = error $ "function's annotation not found: " ++ funcnm ++ " " ++ (show annotFM)

fun_params paramsFM funcnm = lookupWithDefaultFM paramsFM err funcnm
    where
    err = error $ "function's parameters not found: " ++ funcnm ++ " " ++ (show paramsFM)

get_guar_cond guar zbc =
    lookupWithDefaultFM (unSepGuar guar) min_SepCond zbc

cond_consistent cond =
    (cardinality bcs) /= 1 &&
    (not $ IMPOSSIBLEsep `elementOf` bcs)
	where
	bcs = unSepCond cond

-- a value copied from context to the result
copy_assert :: DataFM
	    -> VarNm -- from which context variable
	    -> AddrFn -- where within the type of x
	    -> AddrFn -- where within the result type
	    -> Ty -- type of the copied value
	    -> TJAssert
copy_assert dataFM x fx fr t =
    mikdebugOFF("in copy_assert: t", t) $
    TJAssert min_SepCond cont guar min_DSet
    where
    cont = Containment $ listToFM $ [(fr adr, unitSet $ CAddr x $ fx adr) |
				     adr <- all_PortionZAddr dataFM id t]
    guar = SepGuar $ listToFM $ [(mapZAddr fr bc, SepCond $ unitSet $ SIMPLEsep $ mapCAddr cfx bc) |
				 bc <- all_ZBasicSepCond dataFM id t]
    cfx (CAddrRes zadr) = (CAddr x $ fx zadr)
    cfx _ = error "wrong address returned by all_ZBasicSepCond"

-- all portion addresses in a type
all_PortionZAddr :: DataFM -- precomputed info for datatypes
		 -> AddrFn -- type below is a subterm - this is its address
		 -> Ty
		 -> [ZAddr]
all_PortionZAddr dataFM f t =
    case t of
    DIAMONDty str -> [f AddrDiam]
    PRODUCTty tys -> error "products: not yet" -- concat $ ? (all_PortionZAddr $ f . AddrProd i) tys
    CONty (_, dataNm) ->
	case lookupFM dataFM dataNm of
	Nothing -> error $ "in all_PortionZAddr: unknown data name " ++ dataNm
	Just (zadrs, _, _, _) -> map f zadrs
    ARROWty (ty1, ty2) -> error $ "no portions in ARROWty " ++ (show t)
    _ -> []

-- the above function uses pre-computed values for datatypes
-- this one does the pre-computation
-- and also gathers the X addresses of recursive occurrences inside the types
all_PortionX_ZAddr_data :: DataDecFM -- a finitemap representation of program's typedecs
			-> (Set DataNm) -- bound names
			-> DataNm -- main datatype whose recursive occurrences are collected
			-> AddrFn
			-> Ty
			-> ([ZAddr], Set ZAddr, [UnFolder])
all_PortionX_ZAddr_data datadecFM boundSet main_dataNm f t =
    case t of
    DIAMONDty str -> ([f AddrDiam],emptySet, [])
    PRODUCTty tys -> error "products: not yet"
    CONty (_, dataNm) | dataNm `elementOf` boundSet -> ([], xadrs, unfolders)
		      | otherwise -> (top ++ (concat sub), unionManySets subX, concat sub_UF)
	where
	(xadrs, unfolders) = if dataNm == main_dataNm
			     then (unitSet $ f $ AddrDataX, [f])
			     else (emptySet, [])
	(top, sub, subX, sub_UF) = unzip4 $ map fcon typeCons
	typeCons = lookupWithDefaultFM datadecFM err dataNm
	err = error $ "in all_PortionX_ZAddr_data: unknown data name " ++ dataNm
	fcon (_, TYPEcon (consNm, tys, _heapUsage)) =
	    (f $ AddrDataCons consNm, adrs, unionManySets xadrs, concat unfolders)
	    where
	    (adrs, xadrs, unfolders) = fcon2 1 tys
	    fcon2 i [] = ([], [], [])
	    fcon2 i (t:ts) = (adrs ++ rest_adrs, xadrs : rest_xadrs, unfolders : rest_unfolders)
		where
		(rest_adrs, rest_xadrs, rest_unfolders) = fcon2 (i + 1) ts
		(adrs, xadrs, unfolders) = all_PortionX_ZAddr_data datadecFM boundSet' main_dataNm fd t
		boundSet' = addToSet boundSet dataNm
		fd = f . (\ ad -> AddrDataDown (consNm, i, ad))
    ARROWty (ty1, ty2) -> error "no portions in ARROWty"
    _ -> ([], emptySet, [])

-- all basic separation conditions of a zero-order type
all_ZBasicSepCond :: DataFM
		  -> AddrFn
		  -> Ty
		  -> [ZBasicSepCond]
all_ZBasicSepCond dataFM f t = 
    case t of
    DIAMONDty str -> []
    PRODUCTty tys -> error "products: not yet"
    CONty (_, dataNm) ->
	case lookupFM dataFM dataNm of
	Nothing -> error $ "in all_ZBasicSepCond: unknown data name " ++ dataNm
	Just (_, zbcs, _, _) -> mapZAddr f zbcs
    ARROWty (ty1, ty2) -> error "no portions in ARROWty"
    _ -> []

all_ZBasicSepCond_data :: DataDecFM
		       -> (Set DataNm) -- bound names
		       -> AddrFn
		       -> Ty
		       -> [ZBasicSepCond]
all_ZBasicSepCond_data datadecFM boundSet f t =
    case t of
    DIAMONDty str -> []
    PRODUCTty tys -> error "products: not yet"
    CONty (_, dataNm) | dataNm `elementOf` boundSet -> []
		      | otherwise -> sepaas ++ separs ++ sub
	where
	sub = concat $ map bcs_con typeCons
	typeCons = lookupWithDefaultFM datadecFM err dataNm
	err = error $ "in all_ZBasicSepCond_data: unknown data name " ++ dataNm
	bcs_con (_, TYPEcon (consNm, tys, _heapUsage)) = fcon2 1 tys
	    where
	    fcon2 i [] = []
	    fcon2 i (t:ts) = bcs ++ (fcon2 (i + 1) ts)
		where
		bcs = all_ZBasicSepCond_data datadecFM boundSet' fd t
		boundSet' = addToSet boundSet dataNm
		fd = f . (\ ad -> AddrDataDown (consNm, i, ad))
	sepaas = [AAsep (pa zadr1) (pa zadr2) |
		  block1 <- zadr_blocks,
		  block2 <- zadr_blocks,
		  -- block1 /= block2, -- need separation within top
		  zadr1 <- block1,
		  zadr2 <- block2,
		  zadr1 < zadr2] 
	separs = [ALONGsep z2c zadr dataNm |
		  block <- tail zadr_blocks, zadr <- block] ++
		 [ACROSSsep z2c zadr dataNm |
		  block <- zadr_blocks, zadr <- block]
	pa zadr = PortionCAddr $ CAddrRes $ f zadr
	ra zadr = RecTypeCAddr $ CAddrRes $ f zadr
	z2c = CAddrRes . f
	zadr_blocks = top : (concat $ sub2)
	(top, sub2) = unzip $ map bls_con typeCons
	bls_con (_, TYPEcon (consNm, tys, _heapUsage)) = (AddrDataCons consNm, fcon2 1 tys)
	    where
	    fcon2 i [] = []
	    fcon2 i (t:ts) = block : (fcon2 (i + 1) ts)
		where
		(block, _, _) = all_PortionX_ZAddr_data datadecFM boundSet' dataNm fd t
		boundSet' = addToSet boundSet dataNm
		fd ad = AddrDataDown (consNm, i, ad)
    ARROWty (ty1, ty2) -> error "no portions in ARROWty"
    _ -> []


join_asserts :: TJAssert -> TJAssert -> TJAssert
join_asserts assert1 assert2 = TJAssert cond cont guar dset
    where
    cond = cond1 `join_cond` cond2
    cont = cont1 `join_cont` cont2
    guar = guar1 `join_guar` guar2
    dset = dset1 `join_dset` dset2
    TJAssert cond1 cont1 guar1 dset1 = assert1
    TJAssert cond2 cont2 guar2 dset2 = assert2

join_cond (SepCond set1) (SepCond set2) = SepCond (set1 `union` set2)
join_dset (DSet set1) (DSet set2) = DSet (set1 `union` set2)
join_cont (Containment fm1) (Containment fm2) = Containment (plusFM_C union fm1 fm2)
join_guar (SepGuar fm1) (SepGuar fm2) = SepGuar (plusFM_C join_cond fm1 fm2)

no_tautos (TJAssert cond cont guar dset) = TJAssert cond' cont guar' dset
    where
    cond' = fc cond
    guar' = SepGuar $ listToFM $ concat $ map fg $ fmToList $ unSepGuar guar
    fc (SepCond bcs) = SepCond $ mkSet $ filter no_tauto $ setToList bcs
    fg (zbc, cond) = if no_tauto_z zbc then [(zbc,  fc cond)] else []
    no_tauto (SIMPLEsep zbc) = no_tauto_z zbc
    no_tauto _ = True
    no_tauto_z (AAsep padr1 padr2) = consnm1 == "<>" || consnm2 == "<>" || consnm1 == consnm2
	where
	consnm1 = paddr_consnm padr1
	consnm2 = paddr_consnm padr2
    no_tauto_z _ = True
		     

paddr_consnm (PortionCAddr cadr) =
    case cadr of
    CAddrRes zadr -> zaddr_consnm zadr
    CAddr _ zadr -> zaddr_consnm zadr
    _ -> error "in paddr_consnm"

zaddr_consnm zadr =
    case zadr of
    AddrDiam -> "<>"
    AddrDataCons consNm -> consNm
    AddrDataDown (_, _, zadr) -> zaddr_consnm zadr
    -- AddrListDown zadr -> zaddr_consnm zadr
    AddrArray zadr -> zaddr_consnm zadr
    _ -> error $ "in zaddr_consnm: " ++ (show zadr)

{---------------------------------------------------------------------}
{---------------------- Variables for preserving ---------------------}
{---------------------------------------------------------------------}

pv_annot_exp :: ExpAnnotFn
pv_annot_exp declFMs annotFM contextFM expa = f emptySet expa
    where
    f pv (ExpA loc ea ty contextFM (EAnnot assert uv _)) =
	ExpA loc ea' ty contextFM (EAnnot assert uv (PreserveVars pv, min_NonSep))
	where
	ea' =
	  case ea of
	  IFexpA val exp1 exp2 -> IFexpA val (f pv exp1) (f pv exp2)
	  MATCHexpA val rules -> MATCHexpA val $ map (fM pv) rules
	  LETexpA x exp1 exp2 -> LETexpA x (f (pv `union`(uv2 `delFromSet` x)) exp1) (f pv exp2)
	      where
	      (ExpA _ _ _ _ (EAnnot _ (UsedVars uv2) _)) = exp2
	  TYPEDexpA exp ty -> TYPEDexpA (f pv exp) ty
	  ASSERTexpA exp conds guars -> ASSERTexpA (f pv exp) conds guars
	  _ -> ea
    fM pv (MATCHruleA loc consnmL varLs maybevar exp) =
	MATCHruleA loc consnmL varLs maybevar $ f pv exp

{---------------------------------------------------------------------}
{-------------------- Non-guaranteeable separation -------------------}
{---------------------------------------------------------------------}

nonsep_scann_exp :: ExpScannFn
nonsep_scann_exp declFMs annotFM _contextFM funcnm args expa =
    annotFM `join_annotFM_nonsep` (f nonsep expa)
    where
    nonsep = f_nonsep `join_nonsep` in_nonsep
    (EAnnot _ _ (_, f_nonsep)) = f_annot
    f_annot = lookupWithDefaultFM annotFM min_EAnnot funcnm
    (ExpA _ _ _ _ (EAnnot _ _ (_, in_nonsep))) = expa
    f nonsep (ExpA _ ea _ _ _) =
	case ea of
	APPexpA (VARval fnm) vals _ext ->
	    mikdebug(fnm,nonsep_f)
	    unitFM fnm $ EAnnot min_TJAssert min_UsedVars (min_PreserveVars, nonsep_f)
		where
		nonsep_f = NonSep $ unionManySets $ map v2vs $ setToList $ unNonSep nonsep
		    where
		    v2vs sep =
			case sep of
			AAsep (PortionCAddr (CAddr x1 zadr1)) (PortionCAddr (CAddr x2 zadr2)) ->
			    mkSet $ [aasep (PortionCAddr $ CAddr x1' zadr1)
				           (PortionCAddr $ CAddr x2' zadr2) |
				     x1' <- lookupWithDefaultFM vFM [] x1,
				     x2' <- lookupWithDefaultFM vFM [] x2]
			ALONGsep z2c zadr dtnm ->
			    asep ALONGsep z2c zadr dtnm
			ACROSSsep z2c zadr dtnm ->
			    asep ACROSSsep z2c zadr dtnm
			_ -> error "in nonsep_scann_exp"
			where
			asep sepconstr z2c zadr dtnm =
			    mkSet $ [sepconstr (mapVars (sub x x') . z2c) zadr dtnm |
				     x' <- lookupWithDefaultFM vFM [] x]
				where
				(CAddr x _) = z2c AddrDataX
				sub x x' y | x == y = x'
				sub _ _ y = y
		vFM = addListToFM_C ( ++ ) emptyFM $ zip vars $ map (\ a -> [a]) params
		params = fun_params paramsFM fnm
		(_, _, _, paramsFM) = declFMs
		vars = map val2var vals
		val2var (VARval x) = x
		val2var _ = error "A heap reference to a primitive value"
	IFexpA val exp1 exp2 -> annotFM `join_annotFM_nonsep`
				(f nonsep exp1) `join_annotFM_nonsep` (f nonsep exp2)
	MATCHexpA val rules -> foldl1 join_annotFM_nonsep $ map (fM nonsep) rules
	LETexpA x exp1 exp2 -> (f nonsep exp1) `join_annotFM_nonsep` (f nonsep2 exp2)
	    where
	    nonsep2 = nonsep `join_nonsep` nonsep_x `join_nonsep`
		      nonsep_cont_aa `join_nonsep` nonsep_cont_inherit
	    nonsep_x = NonSep $ mkSet $ map (mapCAddr addx) $
		       keysFM $ filterFM nc $ unSepGuar guar
		where
		nc _ cond = not $ cond_consistent cond
		addx (CAddrRes zadr) = CAddr x zadr
		addx _ = error "in nonsep LET rule"
	    (ExpA _ _ xtyp _ (EAnnot (TJAssert _ cont guar _) _ _)) = exp1
	    nonsep_cont_inherit =
		NonSep $ unionManySets $ map f $ setToList $ unNonSep nonsep
		    where
		    f (AAsep (PortionCAddr cadr1) (PortionCAddr cadr2)) =
			mkSet $ [aasep (PortionCAddr (CAddr x zadr1))
				       (PortionCAddr (CAddr x zadr2)) |
				 zadr1 <- invCont cadr1,
				 zadr2 <- invCont cadr2 ]
		    f (ALONGsep z2c zadr dtnm) =
			mkSet $ [ALONGsep (CAddr x . to_fn radr) zadr dtnm |
				 radr <- invCont $ z2c $ AddrDataRec dtnm]
		    f (ACROSSsep z2c zadr dtnm) =
			mkSet $ [ACROSSsep (CAddr x . to_fn radr) zadr dtnm |
				 radr <- invCont $ z2c $ AddrDataRec dtnm]
		    to_fn radr = to_fn_aux id radr
		    to_fn_aux fn radr =
			case radr of
			AddrDataRec _ -> fn
			AddrDataDown (consnm, i, a) ->
			    to_fn_aux (fn . \ ad -> AddrDataDown (consnm, i, ad)) a
			AddrArray a ->
			    to_fn_aux (fn . AddrArray) a
			_ -> error "in to_fn"
		    invCont cadr = lookupWithDefaultFM invContFM [] cadr
		    invContFM =
			addListToFM_C ( ++ ) emptyFM $ concat $ map inv $ fmToList $ unContainment cont 
		    inv (zadr,cadrs) = [(cadr,[zadr]) | cadr <- setToList cadrs]
	    nonsep_cont_aa =
		NonSep $ mkSet $
			   [aasep (PortionCAddr (CAddr x xzadr)) (PortionCAddr cadr) |
			    xzadr <- keysFM $ unContainment cont,
			    cadr <- setToList $ get_cont_cadrs cont xzadr]
	_ -> emptyFM
    fM nonsep (MATCHruleA _ _ _ _ exp) = f nonsep exp

annotFM1 `join_annotFM_nonsep` annotFM2 = annotFM
    where
    annotFM = plusFM_C f annotFM1 annotFM2
    f (EAnnot assert uv (pv, nonsep1)) (EAnnot _ _ (_, nonsep2)) =
	EAnnot assert uv (pv, nonsep1 `join_nonsep` nonsep2)

nonsep1 `join_nonsep` nonsep2 =
    NonSep $ unNonSep nonsep1 `union` unNonSep nonsep2
    
get_cont_cadrs cont zadr =
    lookupWithDefaultFM (unContainment cont) emptySet zadr

---

complete_guars :: DataFM -> ProgramA -> ProgramA
complete_guars dataFM (PROGA typedecs valdecs afundef_groups) =
    PROGA typedecs valdecs afundef_groups'
	where
	afundef_groups' = map (map do_fundef) afundef_groups
	do_fundef (FUNdefA loc fnm params expa) =
	    FUNdefA loc fnm params (do_expa expa)
	do_expa (ExpA loc ea ty contextFM (EAnnot assert uv (pv, nonsep))) =
	    ExpA loc ea ty contextFM (EAnnot (do_assert assert) uv (pv, nonsep))
		where
		do_assert (TJAssert cond cont guar dset) =
		    TJAssert cond cont (do_guar guar) dset
		do_guar (SepGuar fm) = SepGuar $ triv_fm `plusFM` fm
		    where
		    triv_fm =
			listToFM $ zip (all_ZBasicSepCond dataFM id ty) (repeat min_SepCond)

-}
