module Camelot_infer_annot where

import Camelot_absyn_ASDL
import Camelot_absyn
import Camelot_annot
import Misc

import List (elemIndex, unzip6)
import FiniteMap
import Set

infer_annot :: ProgramA -> (ProgramA, DataFM)
infer_annot (PROGA typedecs valdecs afundef_groups0) =
    mikdebugOFF("dataFM", dataFM) $
    (PROGA typedecs valdecs afundef_groups, dataFM)
	where
	afundef_groups = afundef_groups3
	-- replace all heap-free types with UNITty
	typedecs' = map simplify_typedecA typedecs
	simplify_typedecA (TYPEdecA loc d tcs _) =
	    TYPEdecA loc d' (map simplify_typeconL $ filter usingHeap tcs) adrs
	    where
	    adrs = all_PortionZAddr dataFM id $ CONty ([], d')
	    d' = no_dollar_prefix d
	    simplify_typeconL (loc, TYPEcon (c, tys, heapUsage)) =
		(loc, TYPEcon (c, map simplify_ty tys, heapUsage))
	    usingHeap (loc, TYPEcon (c, tys, _ {--HEAP--})) = True   -- ####  kwxm: was missing nil-constructors
	    usingHeap _ = False
	-- variables used and exp types (1 simple pass only)
	(afundef_groups1, _) =
	    annot_groups uv_ty_annot_exp $ reverse afundef_groups0
	(afundef_groups2, _) =
	    annot_groups sep_annot_exp afundef_groups1 -- deel separation analysed bottom-up
	(afundef_groups3, _) =
	    scann_groups nonsep_pv_scann_exp $ afundef_groups2
	    -- used sharing analysed top-down
	    -- IMPORTANT: annot_groups/ scann_groups reverse the group list
	annot_groups _ [] = ([], emptyFM)
	annot_groups annot_exp (group:rest) =
	    annot_fundef_group annot_exp (dataFM, consFM, valdecFM, paramsFM)
				   (annot_groups annot_exp rest) group
	scann_groups _ [] = ([], emptyFM)
	scann_groups scann_exp (group:rest) =
	    scann_fundef_group scann_exp (dataFM, consFM, valdecFM, paramsFM)
				   (scann_groups scann_exp rest) group
	(dataFM, consFM) = extract_typedecs datadecFM typedecs'
	paramsFM =
	    listToFM $ concat $ map (map f) afundef_groups0
		where
		f (FUNdefA _ funcnm params _ _) = (funcnm, map varName params) -- kwxm
	valdecFM =
	    listToFM $ map f valdecs
		where
		f (_, VALdec (fnm, typ,_)) = (fnm, (styp, get_restyp styp))
		    where
		    styp = simplify_ty typ' -- replace all heap-free types with UNITty
		    typ' = case typ of -- replace UNITty -> t with t if t is not ARROWty
				    ARROWty (UNITty, t) ->
					case t of ARROWty _ -> typ
						  _ -> t
				    _ -> typ
	        f _ = error "CLASSdec found in Camelot_infer_annot.valdecFM"
	datadecFM =
	    listToFM $ map f typedecs'
		where
		f (TYPEdecA _ dataNm typeCons _) = (dataNm, typeCons)


type ExpScannFn = DeclFMs -> AnnotFM -> ContextFM -> FuncNm -> [VarNm] -> ExpA -> (ExpA, AnnotFM)

scann_fundef_group :: ExpScannFn
		   -> DeclFMs
		   -> ([[FunDefA]], AnnotFM) -- previous annotations
		   -> [FunDefA] -- new group to be annotated
		   -> ([[FunDefA]], AnnotFM) 
scann_fundef_group scann_exp declFMs (done_groups, done_annotFM) fundefs =
    (afundefs : done_groups, annotFM)
	where
	(afundefs, annotFM) = f 0 fundefs done_annotFM
	f prev_runs prev_fundefs prev_annotFM =
	    if not_changed
	       then mikdebugOFF ("Scann total runs", prev_runs + 1) $
		    mikdebugOFF ("funcnms", map get_fundefA_funcnm fundefs) $
			(new_fundefs, new_annotFM)
	       else f (prev_runs + 1) new_fundefs new_annotFM
	    where
	    (new_fundefs, new_annotFM, not_changed) =
		annot2fundefs_nonsep_pv $ scann_fundefs prev_fundefs
	    scann_fundefs [] = ([], prev_annotFM)
	    scann_fundefs (fundef : rest) = (new_fundef : rest_fundefs, new_annotFM)
		where
		(new_fundef, new_annotFM) =
		    scann_fundef scann_exp declFMs rest_annotFM fundef
		(rest_fundefs, rest_annotFM) = scann_fundefs rest

annot2fundefs_nonsep_pv (fundefs, annotFM) =
    (new_fundefs, annotFM, not_changed)
	where
	(new_fundefs, not_changed) = f fundefs
	f [] = ([], True)
	f (FUNdefA loc_f funcnm vars inst
	   (ExpA loc_e ea ty c (EAnnot assert uv (pv_f, nonsep_f)))
	   : rest) =
	    mikdebugOFF ("", (funcnm, nonsep_f, nonsep_a))
	    (FUNdefA loc_f funcnm vars inst
	     (ExpA loc_e ea ty c (EAnnot assert uv (pv_a, nonsep_a)))
	     : done_rest,
	     nonsep_a == nonsep_f && rest_not_changed)
		where
		EAnnot _ _ (pv_a, nonsep_a) =
		    lookupWithDefaultFM annotFM min_EAnnot funcnm
		(done_rest, rest_not_changed) = f rest

get_nonsep (EAnnot _ _ (_, nonsep)) = nonsep


scann_fundef :: ExpScannFn
	     -> DeclFMs
	     -> AnnotFM
	     -> FunDefA
	     -> (FunDefA, AnnotFM)
scann_fundef scann_exp declFMs annotFM (FUNdefA loc funcnm vars inst aexp) =
    (FUNdefA loc funcnm vars inst aexp', annotFM')
	where
	(aexp', annotFM') = scann_exp declFMs annotFM contextFM funcnm (map varName vars) aexp
	contextFM = mkContextFM vars typ
	(typ, _) = lookupWithDefaultFM valdecFM err funcnm
	(_, _, valdecFM, _) = declFMs
	err = error $ "scann_fundef: function not declared: " ++ show funcnm

type ExpAnnotFn = DeclFMs -> AnnotFM -> ContextFM -> ExpA -> ExpA

annot_fundef_group :: ExpAnnotFn
		   -> DeclFMs
		   -> ([[FunDefA]], AnnotFM) -- previous annotations
		   -> [FunDefA] -- new group to be annotated
		   -> ([[FunDefA]], AnnotFM) 
annot_fundef_group annot_exp declFMs (done_groups, done_annotFM) fundefs =
    (afundefs : done_groups, annotFM)
	where
	(afundefs, annotFM) = f 0 fundefs $ amend_annotFM done_annotFM fundefs
	f prev_runs prev_fundefs prev_annotFM =
	    if new_fundefs == prev_fundefs -- || prev_runs > 0
	       then mikdebugOFF ("Total runs", prev_runs + 1) $
		    mikdebugOFF ("funcnms", map get_fundefA_funcnm fundefs) $
			(prev_fundefs, prev_annotFM)
	       else f (prev_runs + 1) new_fundefs new_annotFM
	    where
	    new_fundefs = map (annot_fundef annot_exp declFMs prev_annotFM) fundefs
	    new_annotFM = amend_annotFM prev_annotFM new_fundefs

amend_annotFM :: AnnotFM -> [FunDefA] -> AnnotFM
amend_annotFM annotFM fundefs = addListToFM annotFM (map f fundefs)
    where
    f (FUNdefA _ funcnm _ _ (ExpA _ _ _ _ eannot)) = (funcnm, eannot)

annot_fundef :: ExpAnnotFn
	     -> DeclFMs
	     -> AnnotFM
	     -> FunDefA
	     -> FunDefA
annot_fundef annot_exp declFMs annotFM (FUNdefA loc funcnm vars inst aexp) =
    FUNdefA loc funcnm vars inst aexp'
	where
	aexp' = annot_exp declFMs annotFM contextFM aexp
	contextFM = mkContextFM vars typ
	(typ, _) = lookupWithDefaultFM valdecFM err funcnm
	(_, _, valdecFM, _) = declFMs
	err = error $ "annot_fundef: function not declared: " ++ show funcnm


type AnnotFM = FiniteMap FuncNm EAnnot
type ParamsFM = FiniteMap FuncNm [VarNm]

type DeclFMs = (DataFM, ConsFM, ValDecFM, ParamsFM)
type ValDecFM = FiniteMap FuncNm (Ty, Ty) -- whole function type and the 0-order result type
type DataDecFM = FiniteMap DataNm [TypeConL]

type DataFM = FiniteMap DataNm (([ZAddr],[ZAddr]), -- all portion and rectype addrs within the datatype
				[ZBasicSepCond], -- all basic separation conditions for the datatype
				[UnFolder], -- 
				Folder)
type ConsFM = FiniteMap ConsNm (Ty, (TJAssert, [PortionCAddr]), (CAdrTrans, ZBCTrans))

-- translator of addresses within unfolded datatype to addresses in the folded version
type Folder = ZAddr -> ZAddr
type UnFolder = ZAddr -> ZAddr


-- this fn translates the addresses in a match clause to the addresses of a match expression
type CAdrTrans = VarNm -- matched variable
	       -> [VarNm] -- parameters in match pattern
	       -> (Maybe VarNmL) -- optional diamond var in match pattern
	       -> CAddr -> CAddr -- the transformer

-- same as above for basic separation conditions
type ZBCTrans = VarNm
	      -> [VarNm]
	      -> (Maybe VarNmL)
	      -> ZBasicSepCond -> [CBasicSepCond]

extract_typedecs :: DataDecFM
		 -> [TypeDecA]
		 -> (DataFM, ConsFM)
extract_typedecs datadecFM typedecs = (dataFM, consFM)
    where
    dataFM = mk_dataFM datadecFM typedecs
    consFM = mk_consFM dataFM typedecs

mk_dataFM :: DataDecFM -> [TypeDecA] -> DataFM
mk_dataFM datadecFM [] = emptyFM
mk_dataFM datadecFM (TYPEdecA _ dataNm typeCons _ : rest) =
    mikdebugOFF(show dataNm,bcs')
    dataFM
    where
    dataFM = addToFM rest_dataFM dataNm ((padrs, radrs), bcs', unfolders, folder)
    (padrs, radrs, xadrs, unfolders) = all_PRX_ZAddr_data datadecFM emptySet dataNm id (CONty ([], dataNm))
    bcs' =
       if length unfolders > 1
       then bcs
       else filter noacross bcs
	   where
	   noacross (ACROSSsep _ _ _) = False
	   noacross _ = True
    bcs = all_ZBasicSepCond_data datadecFM emptySet id (CONty ([], dataNm))
    rest_dataFM = mk_dataFM datadecFM rest
    folder zadr = mikdebugOFF ("folder " ++ dataNm, (zadr,f id zadr)) f id zadr
	where
	f pos zadr =
	    if (pos AddrDataX) `elementOf` xadrs
	    then zadr -- pos chopped off
	    else case zadr of
			   AddrDataDown (consNm, i, ad) -> 
			       f (pos . (\ ad -> AddrDataDown (consNm, i, ad))) ad
			   -- AddrListDown ad -> f (pos . AddrListDown) ad
			   AddrArray ad -> f (pos . AddrArray) ad
			   _ -> pos zadr


mk_consFM :: DataFM -> [TypeDecA] -> ConsFM
mk_consFM dataFM [] = emptyFM
mk_consFM dataFM (TYPEdecA _ dataNm typeCons _ : rest) =
    mikdebugOFF(dataNm, length unfolders) consFM
    where
    consFM = addListToFM rest_consFM $ map f typeCons
    rest_consFM = mk_consFM dataFM rest
    ((zadrs, _), _, unfolders, folder) = lookupWithDefaultFM dataFM err dataNm
    err = error $ "in mk_consFM: unknown datatype " ++ dataNm
    f (_, TYPEcon (consNm, tys, _heapUsage)) =
	(consNm, (ty, (assert, all_padrs), (adrTrans, bcTrans)))
	where
	ty = foldr (\ t1 t2 -> ARROWty (t1, t2)) (CONty ([], dataNm)) $ map simplify_ty tys
	assert = foldl join_asserts acl_assert copy_asserts
	acl_assert = TJAssert min_SepCond min_Containment guar min_DSet
	    where
	    guar = foldl join_guar guar0 guars
	    guar0 = if length unfolders < 2
		    then min_SepGuar
		    else
		    SepGuar $ unitFM
		    (ACROSSsep z2c zadr dataNm) $
		    SepCond $ mkSet $ [SIMPLEsep $
				       aasep (mk_padr $ unf1 zadr) (mk_padr $ unf2 zadr) |
				       unf1 <- consnm_unfolders,
				       unf2 <- consnm_unfolders,
				       unf1 AddrDataX /= unf2 AddrDataX]
		where
		zadr = AddrDataCons consNm
	    guars = map acl_guar zadrs
	    acl_guar zadr = SepGuar $ listToFM $
			    (if length consnm_unfolders >= 2
			     then [(ACROSSsep z2c zadr dataNm, SepCond across)]
			     else []) ++
			    (if is_consnm_adr zadr
			     then [(ALONGsep z2c zadr dataNm, SepCond along)]
			     else [])
		where
		across = mkSet $ [SIMPLEsep $
				  aasep (mk_padr $ unf1 zadr) (mk_padr $ unf2 zadr) |
				  unf1 <- consnm_unfolders,
				  unf2 <- consnm_unfolders,
				  unf1 AddrDataX /= unf2 AddrDataX]
		along = mkSet $ [SIMPLEsep $
				 aasep (mk_padr $ unf zadr) (mk_padr zadr) |
				 unf <- consnm_unfolders]
	    z2c = CAddrRes
	    -- consnm_zadrs = filter is_consnm_adr zadrs
	    consnm_unfolders = filter (\ unf -> is_consnm_adr $ unf $ AddrDataX ) unfolders
	    is_consnm_adr (AddrDataDown (consnm, _, _)) | consnm == consNm = True
	    is_consnm_adr _ = False
	    mk_padr (AddrDataDown (_, i, zadr)) = PortionCAddr $ CAddr v zadr
		where
		v = default_vars !! (i - 1)
	    mk_padr zadr = error $ "address " ++ (show zadr) ++ " mismatches the constructor " ++ consNm
	copy_asserts = map mka $ zip3 nats default_vars tys
	mka (n, x, t) = fold_res_type dataNm folder $ copy_assert dataFM x id fr t
	    where
	    fr ad = AddrDataDown (consNm, n, ad)
	all_padrs = concat $ map get_padrs $ zip default_vars tys
	    where
	    get_padrs (x,ty) = map (PortionCAddr . CAddr x) $ all_PortionZAddr dataFM id ty
	adrTrans x vars maybevar cadr =
	    case cadr of
	    CAddr y zadr ->
		case elemIndex y vars of
		Nothing ->
		    case maybevar of
		    Just (_, d) | d == y -> CAddr x (AddrDataCons consNm)
		    otherwise -> cadr
		Just n -> CAddr x (folder $ AddrDataDown (consNm, n + 1, zadr))
	    _ -> cadr
	bcTrans x vars maybevar bc = map SIMPLEsep zbcs
	    where
	    zbcs =
		case bc of
		AAsep padr1 padr2 ->
		    case maybevar of
		    Nothing -> newseps
		    Just (_, d) ->
			if (x1 == d && x2 `elem` vars)
			       || (x2 == d && x1 `elem` vars)
			then []
			else newseps
		    where
		    newseps = if (padr1N == padr2N)
			      then if prolonged zadr1N zadr1 || prolonged zadr2N zadr2
				   then [ALONGsep z2c zadr1N dataNm]
				   else [ACROSSsep z2c zadr1N dataNm]
			      else [aasep padr1N padr2N]
		    PortionCAddr (CAddr x1 zadr1) = padr1
		    PortionCAddr (CAddr x2 zadr2) = padr2
		    prolonged zadrN zadr = 
			length (show zadrN) > length (show zadr)
		    padr1N = mapCAddr at padr1
		    padr2N = mapCAddr at padr2
		    PortionCAddr (CAddr _ zadr1N) = padr1N
		    PortionCAddr (CAddr _ zadr2N) = padr2N
		    z2c = CAddr x
		ALONGsep z2c zadr dtnm -> [ALONGsep (at . z2c) zadr dtnm]
		ACROSSsep z2c zadr dtnm -> [ACROSSsep (at . z2c) zadr dtnm]
		where
		at cadr = adrTrans x vars maybevar cadr

default_vars = map (\ n -> "x" ++ (show n)) nats
nats = iterate ((+) 1) 1

fold_res_type :: DataNm -> Folder -> TJAssert -> TJAssert
fold_res_type dataNm folder (TJAssert cond cont guar dset) =
    TJAssert cond cont' guar' dset
	where
	cont' = Containment $ addListToFM_C sndunion emptyFM $ cont_list'
	cont_list' = map (\ (k,e) -> (folder k, e) ) cont_list
	cont_list = fmToList $ unContainment cont
	guar' = SepGuar $ addListToFM_C join_cond emptyFM $ guar_list'
	guar_list' = map (\ (k,e) -> (f k, e) ) guar_list
	guar_list = fmToList $ unSepGuar guar
	f zbc = case zbc of
		AAsep padr1 padr2 ->
		    if padr1N /= padr2N
		    then aasep padr1N padr2N
		    else if (padr1 /= padr1N) && (padr2 /= padr2N)
			 then ACROSSsep z2c zadr1N dataNm
			 else ALONGsep z2c zadr1N dataNm
			where
			padr1N = mapZAddr folder padr1
			padr2N = mapZAddr folder padr2
			PortionCAddr (CAddrRes zadr1N) = padr1N
			z2c = CAddrRes
		ALONGsep z2c zadr dtnm -> 
		    ALONGsep (mapZAddr folder . z2c) zadr dtnm
		ACROSSsep z2c zadr dtnm ->
		    ACROSSsep (mapZAddr folder . z2c) zadr dtnm



{---------------------------------------------------------------------}
{---------------------------------------------------------------------}
{---------------------------------------------------------------------}

-- type ExpAnnotFn = DeclFMs -> AnnotFM -> ContextFM -> ExpA -> ExpA
-- type ExpScannFn = DeclFMs -> AnnotFM -> ContextFM -> ExpA -> (ExpA, AnnotFM)

uv_ty_annot_exp :: ExpAnnotFn
uv_ty_annot_exp (_, consFM, valdecFM, _) _ contextFM aexp = uva contextFM aexp
    where 
    uva contextFM (ExpA loc ea _ _ _) = (ExpA loc ea' ty' contextFM eannot')
	where
	eannot' = EAnnot min_TJAssert (UsedVars usedvars'') (min_PreserveVars, min_NonSep)
	usedvars'' = usedvars' `intersect` mkSet (keysFM contextFM)
	(ea', usedvars', ty') =
	    case ea of
	    VALexpA val -> (ea, uvVal val, tyVal val)
	    UNARYexpA unop val -> (ea, uvVal val, UNITty) -- all unops are heap-free
	    BINexpA binop val1 val2 -> (ea, (uvVal val1) `union` (uvVal val2), tyVal val2) -- trickery
	    IFexpA tst exp1 exp2 -> (IFexpA tst exp1' exp2', usedvars, get_ty exp1')
		where  
		exp1' = uva contextFM exp1
		exp2' = uva contextFM exp2
		usedvars = (uvTst tst) `union` (get_uv exp1') `union` (get_uv exp2')
	    MATCHexpA x rules -> (MATCHexpA x rules', usedvars, ty)
		where {-- Eek! --}
		rules' = map (uvaM contextFM) rules  {-- Do we need to add x to the context as with LETexp? --}
		usedvars = (unitSet x) `union` (unionManySets $ map uvM rules')
		ty = get_ty $ get_aexp $ head rules'
	    LETexpA x exp1 exp2 -> (LETexpA x exp1' exp2', usedvars, get_ty exp2')
		where
		exp1' = uva contextFM exp1
		exp2' = uva contextFM2 exp2
		contextFM2 = addToFM contextFM x $ get_ty exp1'
		usedvars = (get_uv exp1') `union` ((get_uv exp2') `delFromSet` x)
	    APPexpA x vals ext -> (ea, usedvars, ty)
		where  {-- Do we really want to put x in usedvars? kwxm --}
		usedvars = (unitSet x) `union` (unionManySets $ map uvVal vals)
		ty = if ext == BUILTIN then UNITty  -- BAD HACK: kwxm
		     else get_restyp $ tyVal (VARval x)  {-- DANGEROUS kwxm --}
	    CONexpA consnm vals maybevar -> (ea, usedvars, ty)
		where
		usedvars = (maybeSet_unL maybevar) `union` (unionManySets $ map uvVal vals)
		ty = get_restyp $ tyCons consnm
	{-
	    LISTexpA vals -> (ea, unionManySets $ map uvVal vals, ty)
		where
		ty = case vals of
		     [] -> error "DEEC cannot handle the empty list expression at present"
		     (val:_) -> tyVal val
	-}
	    TYPEDexpA exp ty -> (TYPEDexpA exp' ty, usedvars',ty')
		where
		exp' = uva contextFM exp
		(ExpA _ _ ty' _ (EAnnot _ (UsedVars usedvars) _)) = exp'
	    ASSERTexpA exp conds guars -> (ASSERTexpA exp' conds guars, usedvars', ty')
		where
		exp' = uva contextFM exp
		(ExpA _ _ ty' _ (EAnnot _ (UsedVars usedvars) _)) = exp'
	tyVal (VARval x) = var_fn_type contextFM valdecFM x
	tyVal val = UNITty -- represents all heap-free types in this analysis
	tyCons consnm = case lookupFM consFM consnm of
			Nothing -> error $ "Invalid constructor " ++ consnm
			Just (ty, _, _) -> ty
    uvVal (VARval x) = unitSet x
    uvVal _ = emptySet
    uvTst  (TESTA op val1 val2) = (uvVal val1) `union` (uvVal val2)

    uvaM contextFM (MATCHruleA loc consnmL varLs matchdiam aexp) =
	MATCHruleA loc consnmL varLs matchdiam $ uva contextFM2d aexp
	    where
	    contextFM2d = case matchdiam of
			  SOMEWHERE (_,d) -> addToFM contextFM2 d (DIAMONDty "")
			  _ -> contextFM2
	    contextFM2 = addListToFM contextFM $ vartyps vars ty
	    vars = snd $ unzip varLs
	    vartyps [] _ = []
	    vartyps (x:xs) (ARROWty (t1, t2)) = (x, t1) : (vartyps xs t2)
	    vartyps _ _ = error "vartyps: less arg types than vars"
	    (ty, _, _) = lookup_consFM consFM consnm
	    (_, consnm) = consnmL
    uvM (MATCHruleA loc consnmL varLs matchdiam aexp) =
	(get_uv aexp) `minusSet` (mkSet vars `union` diamSet_unL matchdiam)
	    where
	    vars = snd $ unzip varLs
    diamSet_unL (SOMEWHERE (_,x)) = unitSet x
    diamSet_unL _ = emptySet
    maybeSet_unL (Just (_,x)) = unitSet x
    maybeSet_unL _ = emptySet
    get_uv (ExpA _ _ _ _ (EAnnot _ (UsedVars uv) _)) = uv
    get_ty (ExpA _ _ ty _ _) = ty
    get_aexp (MATCHruleA _ _ _ _ aexp) = aexp


lookup_consFM consFM consNm =
    lookupWithDefaultFM consFM err consNm
	where
	err = error $ "unknown constructor " ++ show consNm

{---------------------------------------------------------------------}
{--------------------- DEEL separation inference ---------------------}
{---------------------------------------------------------------------}


sep_annot_exp :: ExpAnnotFn
sep_annot_exp declFMs annotFM _ aexp = sae aexp
    where
    (dataFM, consFM, valdecFM, paramsFM) = declFMs
    sae (ExpA loc ea ty contextFM (EAnnot _ (UsedVars uv) (pv,_))) =
	(ExpA loc ea' ty contextFM (EAnnot assert' (UsedVars uv) (pv,min_NonSep)))
	    where
	    assert' = no_tautos $ TJAssert cond' cont guar' dset
	    cond' = simplify_cond cond
	    guar' = mapSC simplify_cond guar
	    {- 
	    -- remove all functions which might have been treated as variables
	    -- OOPS: no such thing actually exists in Camelot..
	    assert' = no_tautos $ TJAssert cond' cont' guar' dset'
	    cond' = mapZBC remove_fns cond
	    guar' = mapZBC remove_fns guar
	    cont' = cont_remove_fns cont
	    dset' = dset_remove_fns dset
	    remove_fns zbc =
		case zbc of
		AAsep padr1 padr2 -> if x1_is_fn
				     then if x2_is_fn
					  then if consistent
					       then []
					       else [IMPOSSIBLEsep]
					  else []
				     else if x2_is_fn
					  then []
					  else if padr1 == padr2
					       then [IMPOSSIBLEsep]
					       else [SIMPLEsep $ zbc]
		    where
		    x1_is_fn = not $ in_ctxt x1 
		    x2_is_fn = not $ in_ctxt x2
		    PortionCAddr (CAddr x1 zadr1) = padr1
		    PortionCAddr (CAddr x2 zadr2) = padr2
		    consistent = -- NOT TESTED as Camelot does not support nullary fns yet
			if x1 /= x2
			then True
			else cond_consistent bc_cond
			    where
			    bc_cond = get_guar_cond guar_f $ AAsep pradr1 pradr2
			    pradr1 = PortionCAddr (CAddrRes zadr1)
			    pradr2 = PortionCAddr (CAddrRes zadr2)
			    EAnnot (TJAssert _ _ guar_f _) _ _ = fun_annot annotFM x1
		ALONGsep z2c zadr dtnm ->
		    if not $ in_ctxt x
		       then if consistent
			    then []
			    else [IMPOSSIBLEsep]
		       else [SIMPLEsep $ zbc]
		    where
		    (CAddr x _) = z2c $ AddrDataX
		    consistent = True -- TODO
		ACROSSsep z2c zadr dtnm ->
		    if not $ in_ctxt x
		       then if consistent
			    then []
			    else [IMPOSSIBLEsep]
		       else [SIMPLEsep $ zbc]
		    where
		    (CAddr x _) = z2c $ AddrDataX
		    consistent = True -- TODO
	    cont_remove_fns (Containment contFM) =
		Containment $ mapFM ( \ key -> set_remove_fns) contFM
	    dset_remove_fns (DSet set) = DSet $ set_remove_fns set
	    set_remove_fns set = mkSet $ filter (in_ctxtC) $ setToList set
	    in_ctxtC (CAddr x _) = in_ctxt x
	    in_ctxtC _ = True
	    in_ctxt x = if result then result
			else mikdebug("not_in_ctxt", (x,ctxt_vars)) result
		where result = x `elementOf` ctxt_vars
	    ctxt_vars = mkSet $ keysFM contextFM
	    -}
	    -- annotate the expression
            (ea', TJAssert cond cont guar dset) =
		case ea of
		VALexpA (VARval x) -> (ea, copy_assert dataFM x id id xtyp)
		    where xtyp = var_fn_type contextFM valdecFM x
		VALexpA val -> (ea, min_TJAssert)
	        APPexpA f vals ext ->  (ea, assert)
		    where
		    assert = mapVars tr_var assert_f
		    assert_f = if ext == BUILTIN then min_Assert 
			       else a where EAnnot a _ _ = fun_annot annotFM f
		    min_Assert = TJAssert min_SepCond min_Containment min_SepGuar min_DSet -- kwxm
		    tr_var x = lookupWithDefaultFM vFM (varerr x vFM) x
		    varerr x vFM = error $ "Reference to an absent parameter: " ++ x ++ " " ++ (show vFM)
		    vFM = listToFM $ zip params vars
		    params = fun_params paramsFM f
		    vars = map val2var vals
--	        APPexpA _ vals _ -> error $ "invalid application"
		UNARYexpA unop val -> (ea, min_TJAssert) -- all unops are heap-free
		BINexpA binop val1 val2 -> (ea, min_TJAssert) -- all binops are heap-free
		IFexpA val aexp1 aexp2 -> (IFexpA val aexp1' aexp2', assert)
		    where
		    aexp1' = sae aexp1
		    aexp2' = sae aexp2
		    assert = assert1 `join_asserts` assert2
		    ExpA _ _ _ _ (EAnnot assert1 _ _) = aexp1'
		    ExpA _ _ _ _ (EAnnot assert2 _ _) = aexp2'
	        CONexpA consnm vals maybevar ->
		    (CONexpA consnm vals maybevar, assert)
		    where
		    assert = mapVars tr_var assert_pre
		    assert_pre = case maybevar of
				 Nothing -> assert_c
				 Just (_,d) -> assert_c `join_asserts` assert_d
				     where
				     assert_d = TJAssert cond cont guar dset
				     cond = SepCond $ mkSet [ SIMPLEsep $ aasep pdadr padr |
							      padr <- all_padrs]
				     cont = Containment $ unitFM con_zadr $ (True, unitSet dadr)
				     guar = min_SepGuar
				     dset = DSet $ unitSet $ dadr
				     con_zadr = AddrDataCons consnm
				     pdadr = PortionCAddr dadr
				     dadr = CAddr d AddrDiam
		    (_, (assert_c, all_padrs), _) = lookup_consFM consFM consnm
		    tr_var x = lookupWithDefaultFM vFM x x
		    vFM = listToFM $ zip default_vars vars
		    vars = map val2var vals
		MATCHexpA x rules -> (MATCHexpA x rules', assert)
		    where
		    (rules', asserts) = unzip $ map (saeM x) rules
		    assert = foldl1 join_asserts asserts
--		MATCHexpA _ rules -> error "trying to match a primitive value?"
	        LETexpA x aexp1 aexp2 -> (LETexpA x aexp1' aexp2', assert)
		    where
		    aexp1' = sae aexp1
		    aexp2' = sae aexp2
		    ExpA _ _ xtyp _ (EAnnot assert1 _ _) = aexp1'
		    ExpA _ _ _ _ (EAnnot assert2 uv2 _) = aexp2'
		    assert = TJAssert cond cont guar dset
		    TJAssert cond1 cont1 guar1 dset1 = assert1
		    TJAssert cond2 cont2 guar2 dset2 = assert2
		    cond = cond1 `join_cond` t_SC cond2 `join_cond` benign
			where
			benign =
			    SepCond $ mkSet $ [aasep_ cadr1 cadr2 |
					       cadr1 <- setToList $ unDSet dset1,
					       cadr2 <- uv_cadrs]
			aasep_ cadr1 cadr2 =
			    SIMPLEsep $ aasep (PortionCAddr cadr1) (PortionCAddr cadr2)
			uv_cadrs = concat $ map gps $ setToList $ unUsedVars uv2
			gps y = if y == x then []
				else map (CAddr y) $ all_PortionZAddr dataFM id $ var_type contextFM y
		    cont = Containment $ mapFM ( \ key (b, set) -> (b, t_cadr_set set)) $
			   unContainment cont2
		    guar = mapSC t_SC guar2
		    dset = dset1 `join_dset` dset2x
			where
			dset2x = DSet $ t_cadr_set $ unDSet dset2
		    t_cadr_set set =
			unionManySets $ map tcadr $ setToList set
			    where
			    tcadr cadr =
				case cadr of
				CAddr y zadr | x == y -> get_cont_cadrs cont1 zadr
				_ -> unitSet cadr
		    t_SC c = mikdebugOFF ("", (c,cxx,cnoxx)) $
			     (t_use_guar1 cxx) `join_cond` (t_use_cont1 cnoxx)
			where
			(cxx, cnoxx) = split c
			    where
			    split (SepCond cset) = s $ setToList cset
			    s [] = ([],[])
			    s (cbc : rest) = if xx
					     then (zbc : rcxx, rcnoxx)
					     else (rcxx, cbc : rcnoxx)
				where
				(rcxx, rcnoxx) = s rest
				(xx, zbc) = case cbc of
					    IMPOSSIBLEsep -> (False, error "")
					    SIMPLEsep zbc -> (xx, mapCAddr ctxt2res zbc)
						where
						xx = case zbc of
						     AAsep padr1 padr2 -> f padr1 && f padr2
						     ALONGsep z2c _ _ -> f $ PortionCAddr $ z2c AddrDataX
						     ACROSSsep z2c _ _ -> f $ PortionCAddr $ z2c AddrDataX
						f (PortionCAddr (CAddr y _)) = x == y
						f _ = False
						ctxt2res (CAddr _ zadr) = CAddrRes zadr
						ctxt2res _ = error "in ctxt2res"
			t_use_guar1 cxx =
			    SepCond $ unionManySets $ map tg1 cxx
			tg1 zbc =
			    unSepCond $ lookupWithDefaultFM (unSepGuar guar1) min_SepCond zbc
			t_use_cont1 cnoxx =
			    SepCond $ unionManySets $ map tc1 cnoxx
			tc1 IMPOSSIBLEsep = unitSet IMPOSSIBLEsep
			tc1 (SIMPLEsep zbc) =
			    case zbc of
			    AAsep padr1 padr2 ->
				if xin1 then mapSet (\ cadr -> caasep_cp cadr padr2) set1
				else if xin2 then mapSet (\ cadr -> caasep_cp cadr padr1) set2
				     else unitSet $ SIMPLEsep zbc
				    where
				    (xin1, zadr1) = case unPortionCAddr padr1 of
						    CAddr y zadr -> (x == y, zadr)
						    _ -> (False, error "")
				    (xin2, zadr2) = case unPortionCAddr padr2 of
						    CAddr y zadr -> (x == y, zadr)
						    _ -> (False, error "")
				    caasep_cp cadr padr = SIMPLEsep $ aasep (PortionCAddr cadr) padr
				    (_,set1) =
					lookupWithDefaultFM (unContainment cont1) (True, emptySet) zadr1
				    (_,set2) =
					lookupWithDefaultFM (unContainment cont1) (True, emptySet) zadr2
			    _ -> unitSet $ SIMPLEsep zbc
		TYPEDexpA exp ty -> (TYPEDexpA exp' ty, assert')
		    where
		    exp' = sae exp
		    (ExpA _ _ ty' _ (EAnnot assert' _ _)) = exp'
		ASSERTexpA exp conds guars -> (ASSERTexpA exp' conds guars, assert')
		    where
		    exp' = sae exp
		    (ExpA _ _ ty' _ (EAnnot assert' _ _)) = exp'

    saeM x (MATCHruleA  loc consnmL varLs matchdiam aexp) =
	(MATCHruleA loc consnmL varLs matchdiam aexp', assert)
	    where
	    aexp' = sae aexp
	    vars = snd $ unzip varLs
	    vartyps [] _ = []
	    vartyps (x:xs) (ARROWty (t1, t2)) = (x, t1) : (vartyps xs t2)
	    vartyps _ _ = error "vartyps: less arg types than vars"
	    (ty, _, (adrTrans, bcTrans)) = lookup_consFM consFM consnm
	    (_, consnm) = consnmL
	    assert = TJAssert cond cont guar dset
	    cont = mapCAddr (adrTrans x vars maybevar) cont'
	    dset = mapCAddr (adrTrans x vars maybevar) dset' `join_dset` dset0
	    dset0 = case matchdiam of
		    DISPOSE -> DSet $ unitSet $ CAddr x $ AddrDataCons consnm
		    _ -> min_DSet
	    cond = mapZBC (bcTrans x vars maybevar) $ cond' `join_cond` cond0
	    cond0 = case matchdiam of
		    DISPOSE -> SepCond $ mkSet $
			       [SIMPLEsep $
				aasep (PortionCAddr cadr) (PortionCAddr $ CAddr y yadr) |
				y <- setToList $ unUsedVars uv' `minusSet` mkSet vars,
				yadr <- all_PortionZAddr dataFM id $ var_type contextFM' y]
			where
			cadr = CAddr x $ AddrDataCons consnm
		    _ -> min_SepCond
	    guar = mapZBC (bcTrans x vars maybevar) guar'
	    maybevar = case matchdiam of
		       SOMEWHERE x -> Just x
		       _ -> Nothing
	    TJAssert cond' cont' guar' dset' = assert'
	    ExpA _ _ _ contextFM' (EAnnot assert' uv' _) = aexp'

var_fn_type contextFM valdecFM x = 
    case lookupFM valdecFM x of
    Nothing ->  var_type contextFM x
    Just (ty, _) -> ty

var_type contextFM x = 
    lookupWithDefaultFM contextFM err x
	where
	err = error $ (show x) ++ " not in context " ++ (show contextFM) ++ "\n"

fun_annot annotFM funcnm = lookupWithDefaultFM annotFM err funcnm
    where
    err = error $ "function's annotation not found: " ++ funcnm ++ " " ++ (show annotFM)
-- kwxm: This seems to be problematical (sometimes) with functions in "and" blocks

fun_params paramsFM funcnm = lookupWithDefaultFM paramsFM err funcnm
    where
    err = error $ "function's parameters not found: " ++ funcnm ++ " " ++ (show paramsFM)

get_guar_cond guar zbc =
    lookupWithDefaultFM (unSepGuar guar) min_SepCond zbc

cond_consistent cond =
    (cardinality bcs) /= 1 ||
    (not $ IMPOSSIBLEsep `elementOf` bcs)
	where
	bcs = unSepCond cond

-- a value copied from context to the result
copy_assert :: DataFM
	    -> VarNm -- from which context variable
	    -> AddrFn -- where within the type of x
	    -> AddrFn -- where within the result type
	    -> Ty -- type of the copied value
	    -> TJAssert
copy_assert dataFM x fx fr t =
    mikdebugOFF("in copy_assert: t", t) $
    TJAssert min_SepCond cont guar min_DSet
    where
    cont = Containment $ listToFM $
	   [(fr adr, (True, unitSet $ CAddr x $ fx adr)) |
	    adr <- all_PortionZAddr dataFM id t ] ++
	   [(fr adr, (False, unitSet $ CAddr x $ fx adr)) |
	    adr <- all_RecZAddr dataFM id t ]
    guar = SepGuar $ listToFM $ [(mapZAddr fr bc, SepCond $ unitSet $ SIMPLEsep $ mapCAddr cfx bc) |
				 bc <- all_ZBasicSepCond dataFM id t]
    cfx (CAddrRes zadr) = (CAddr x $ fx zadr)
    cfx _ = error "wrong address returned by all_ZBasicSepCond"

-- all portion addresses in a type
all_PortionZAddr :: DataFM -- precomputed info for datatypes
		 -> AddrFn -- type below is a subterm - this is its address
		 -> Ty
		 -> [ZAddr]
all_PortionZAddr dataFM f t =
    case t of
    DIAMONDty str -> [f AddrDiam]
    PRODUCTty tys -> error "products: not yet" -- concat $ ? (all_PortionZAddr $ f . AddrProd i) tys
    CONty (_, dataNm) ->
	case lookupFM dataFM dataNm of
	Nothing -> error $ "in all_PortionZAddr: unknown data name " ++ dataNm
	Just ((zadrs, _), _, _, _) -> map f zadrs
    ARROWty (ty1, ty2) -> error $ "no portions in ARROWty " ++ (show t)
    _ -> []

-- all rectype constructor addresses in a type
all_RecZAddr :: DataFM -- precomputed info for datatypes
	     -> AddrFn -- type below is a subterm - this is its address
	     -> Ty
	     -> [ZAddr]
all_RecZAddr dataFM f t =
    case t of
    PRODUCTty tys -> error "products: not yet" -- concat $ ? (all_RecZAddr $ f . AddrProd i) tys
    CONty (_, dataNm) ->
	case lookupFM dataFM dataNm of
	Nothing -> error $ "in all_PortionZAddr: unknown data name " ++ dataNm
	Just ((_, zadrs), _, _, _) -> map f zadrs
    ARROWty (ty1, ty2) -> error $ "no portions in ARROWty " ++ (show t)
    _ -> []

-- the above two functions use pre-computed values for datatypes
-- this one does the pre-computation
-- and also gathers the X addresses of recursive occurrences inside the types
all_PRX_ZAddr_data :: DataDecFM -- a finitemap representation of program's typedecs
		  -> (Set DataNm) -- bound names
		  -> DataNm -- main datatype whose recursive occurrences are collected
		  -> AddrFn
		  -> Ty
		  -> ([ZAddr], [ZAddr], Set ZAddr, [UnFolder])
all_PRX_ZAddr_data datadecFM boundSet main_dataNm f t =
    case t of
    DIAMONDty str -> ([f AddrDiam], [], emptySet, [])
    PRODUCTty tys -> error "products: not yet"
    CONty (_, dataNm) | dataNm `elementOf` boundSet -> ([], [], xadrs, unfolders)
		      | otherwise -> (topP ++ (concat subP),
				      topR ++ (concat subR),
				      unionManySets subX, concat sub_UF)
	where
	(xadrs, unfolders) = if dataNm == main_dataNm
			     then (unitSet $ f $ AddrDataX, [f])
			     else (emptySet, [])
	(topP, subP, topR, subR, subX, sub_UF) = unzip6 $ map fcon typeCons
	typeCons = lookupWithDefaultFM datadecFM err dataNm
	err = error $ "in all_PRX_ZAddr_data: unknown data name " ++ dataNm
	fcon (_, TYPEcon (consNm, tys, _heapUsage)) =
	    (f $ AddrDataCons consNm, padrs,
	     f $ AddrDataRec dataNm, radrs,
	     unionManySets xadrs, concat unfolders)
	    where
	    (padrs, radrs, xadrs, unfolders) = fcon2 1 tys
	    fcon2 i [] = ([], [], [], [])
	    fcon2 i (t:ts) = (padrs ++ rest_padrs, radrs ++ rest_radrs,
			      xadrs : rest_xadrs, unfolders : rest_unfolders)
		where
		(rest_padrs, rest_radrs, rest_xadrs, rest_unfolders) = fcon2 (i + 1) ts
		(padrs, radrs, xadrs, unfolders) =
		    all_PRX_ZAddr_data datadecFM boundSet' main_dataNm fd t
		boundSet' = addToSet boundSet dataNm
		fd = f . (\ ad -> AddrDataDown (consNm, i, ad))
    ARROWty (ty1, ty2) -> error "no portions in ARROWty"
    _ -> ([], [], emptySet, [])

-- all basic separation conditions of a zero-order type
all_ZBasicSepCond :: DataFM
		  -> AddrFn
		  -> Ty
		  -> [ZBasicSepCond]
all_ZBasicSepCond dataFM f t = 
    case t of
    DIAMONDty str -> []
    PRODUCTty tys -> error "products: not yet"
    CONty (_, dataNm) ->
	case lookupFM dataFM dataNm of
	Nothing -> error $ "in all_ZBasicSepCond: unknown data name " ++ dataNm
	Just (_, zbcs, _, _) -> mapZAddr f zbcs
    ARROWty (ty1, ty2) -> error "no portions in ARROWty"
    _ -> []

all_ZBasicSepCond_data :: DataDecFM
		       -> (Set DataNm) -- bound names
		       -> AddrFn
		       -> Ty
		       -> [ZBasicSepCond]
all_ZBasicSepCond_data datadecFM boundSet f t =
    case t of
    DIAMONDty str -> []
    PRODUCTty tys -> error "products: not yet"
    CONty (_, dataNm) | dataNm `elementOf` boundSet -> []
		      | otherwise -> sepaas ++ separs ++ sub
	where
	sub = concat $ map bcs_con typeCons
	typeCons = lookupWithDefaultFM datadecFM err dataNm
	err = error $ "in all_ZBasicSepCond_data: unknown data name " ++ dataNm
	bcs_con (_, TYPEcon (consNm, tys, _heapUsage)) = fcon2 1 tys
	    where
	    fcon2 i [] = []
	    fcon2 i (t:ts) = bcs ++ (fcon2 (i + 1) ts)
		where
		bcs = all_ZBasicSepCond_data datadecFM boundSet' fd t
		boundSet' = addToSet boundSet dataNm
		fd = f . (\ ad -> AddrDataDown (consNm, i, ad))
	sepaas = [AAsep (pa zadr1) (pa zadr2) |
		  block1 <- zadr_blocks,
		  block2 <- zadr_blocks,
		  -- block1 /= block2, -- need separation within top
		  zadr1 <- block1,
		  zadr2 <- block2,
		  zadr1 < zadr2] 
	separs = [ALONGsep z2c zadr dataNm |
		  block <- tail zadr_blocks, zadr <- block] ++
		 [ACROSSsep z2c zadr dataNm |
		  block <- zadr_blocks, zadr <- block]
	pa zadr = PortionCAddr $ CAddrRes $ f zadr
	ra zadr = RecTypeCAddr $ CAddrRes $ f zadr
	z2c = CAddrRes . f
	zadr_blocks = top : (concat $ sub2)
	(top, sub2) = unzip $ map bls_con typeCons
	bls_con (_, TYPEcon (consNm, tys, _heapUsage)) = (AddrDataCons consNm, fcon2 1 tys)
	    where
	    fcon2 i [] = []
	    fcon2 i (t:ts) = block : (fcon2 (i + 1) ts)
		where
		(block, _, _, _) = all_PRX_ZAddr_data datadecFM boundSet' dataNm fd t
		boundSet' = addToSet boundSet dataNm
		fd ad = AddrDataDown (consNm, i, ad)
    ARROWty (ty1, ty2) -> error "no portions in ARROWty"
    _ -> []


join_asserts :: TJAssert -> TJAssert -> TJAssert
join_asserts assert1 assert2 = TJAssert cond cont guar dset
    where
    cond = cond1 `join_cond` cond2
    cont = cont1 `join_cont` cont2
    guar = guar1 `join_guar` guar2
    dset = dset1 `join_dset` dset2
    TJAssert cond1 cont1 guar1 dset1 = assert1
    TJAssert cond2 cont2 guar2 dset2 = assert2

join_cond (SepCond set1) (SepCond set2) = SepCond (set1 `union` set2)
join_dset (DSet set1) (DSet set2) = DSet (set1 `union` set2)
join_cont (Containment fm1) (Containment fm2) = Containment (plusFM_C sndunion fm1 fm2)
join_guar (SepGuar fm1) (SepGuar fm2) = SepGuar (plusFM_C join_cond fm1 fm2)

(b, set1) `sndunion` (_, set2) = (b, set1 `union` set2)


no_tautos (TJAssert cond cont guar dset) = TJAssert cond' cont guar' dset
    where
    cond' = fc cond
    guar' = SepGuar $ listToFM $ concat $ map fg $ fmToList $ unSepGuar guar
    fc (SepCond bcs) = SepCond $ mkSet $ filter no_tauto $ setToList bcs
    fg (zbc, cond) = if no_tauto_z zbc then [(zbc,  fc cond)] else []
    no_tauto (SIMPLEsep zbc) = no_tauto_z zbc
    no_tauto _ = True
    no_tauto_z (AAsep padr1 padr2) = consnm1 == "<>" || consnm2 == "<>" || consnm1 == consnm2
	where
	consnm1 = paddr_consnm padr1
	consnm2 = paddr_consnm padr2
    no_tauto_z _ = True
		     

paddr_consnm (PortionCAddr cadr) =
    case cadr of
    CAddrRes zadr -> zaddr_consnm zadr
    CAddr _ zadr -> zaddr_consnm zadr
    _ -> error "in paddr_consnm"

zaddr_consnm zadr =
    case zadr of
    AddrDiam -> "<>"
    AddrDataCons consNm -> consNm
    AddrDataDown (_, _, zadr) -> zaddr_consnm zadr
    -- AddrListDown zadr -> zaddr_consnm zadr
    AddrArray zadr -> zaddr_consnm zadr
    _ -> error $ "in zaddr_consnm: " ++ (show zadr)


{---------------------------------------------------------------------}
{-------------------- Non-guaranteeable separation -------------------}
{-------------------------------- and --------------------------------}
{--------------------------- Live variables --------------------------}
{---------------------------------------------------------------------}

nonsep_pv_scann_exp :: ExpScannFn
nonsep_pv_scann_exp (dataFM, consFM, _, paramsFM) annotFM _contextFM funcnm args expa =
    f (unPreserveVars pv, nonsep) (expa, annotFM)
    where
    nonsep = in_nonsep -- f_nonsep `join_nonsep` in_nonsep
    pv = f_pv `join_pv` in_pv
    (EAnnot _ _ (f_pv, f_nonsep)) = f_annot
    f_annot = lookupWithDefaultFM annotFM min_EAnnot funcnm
    (ExpA _ _ _ _ (EAnnot _ _ (in_pv, in_nonsep))) = expa
    f (upv, nonsep) (ExpA loc ea ty contextFM (EAnnot assert uv (_, _)), annotFM) =
	(ExpA loc ea' ty contextFM (EAnnot assert uv (PreserveVars upv, nonsep)), annotFM')
	where
	(ea',annotFM') =
	       case ea of
	       APPexpA fnm vals ext ->
		   mikdebugOFF (fnm, (nonsep_f, get_nonsep $ fun_annot new_annotFM fnm))
		   (ea, new_annotFM)
		       where
		       new_annotFM =
			   annotFM
			   `join_annotFM_nonsep`
			   (unitFM fnm $ EAnnot min_TJAssert min_UsedVars (pv_f, nonsep_f))
		       pv_f = PreserveVars $ mkSet $ concat $ map (lookupWithDefaultFM vFM []) pv_list
		       pv_list = setToList upv
		       uv_list = setToList $ unUsedVars uv
		       nonsep_f = NonSep $ self_sharing `union` nonsep_inter
			   where
			   self_sharing =
			       mkSet $ [aasep (PortionCAddr $ CAddr x1' zadr)
				                  (PortionCAddr $ CAddr x2' zadr) |
					x <- uv_list,
					zadr <- all_PortionZAddr dataFM id $ var_type contextFM x,
					x1' <- lookupWithDefaultFM vFM [] x,
					x2' <- lookupWithDefaultFM vFM [] x,
					x1' < x2'
				       ]
			   nonsep_inter =
			       unionManySets $ map v2vs $ setToList $ unNonSep nonsep
			   v2vs sep =
			       case sep of
			       AAsep (PortionCAddr (CAddr x1 zadr1)) (PortionCAddr (CAddr x2 zadr2)) ->
				   mkSet $ [aasep (PortionCAddr $ CAddr x1' zadr1)
				                  (PortionCAddr $ CAddr x2' zadr2) |
					    x1' <- lookupWithDefaultFM vFM [] x1,
					    x2' <- lookupWithDefaultFM vFM [] x2]
			       ALONGsep z2c zadr dtnm ->
				   asep ALONGsep z2c zadr dtnm
			       ACROSSsep z2c zadr dtnm ->
				   asep ACROSSsep z2c zadr dtnm
			       _ -> error "in nonsep_scann_exp"
			       where
			       asep sepconstr z2c zadr dtnm =
				   mkSet $ [sepconstr (mapVars (sub x x') . z2c) zadr dtnm |
					    x' <- lookupWithDefaultFM vFM [] x]
				       where
				       (CAddr x _) = z2c AddrDataX
				       sub x x' y | x == y = x'
				       sub _ _ y = y
		       vFM = addListToFM_C ( ++ ) emptyFM $ zip vars $ map (\ a -> [a]) params
		       params = fun_params paramsFM fnm
		       vars = map val2var vals
	       IFexpA tst exp1 exp2 -> (IFexpA tst exp1' exp2', annotFM2)
		   where
		   (exp1', annotFM1) = f (upv, nonsep) (exp1, annotFM)
		   (exp2', annotFM2) = f (upv, nonsep) (exp2, annotFM1)
	       MATCHexpA x rules -> (MATCHexpA x rules', annotFM')
		   where
		   (annotFM', rules') =
		       foldl (fM x (upv, nonsep)) (annotFM, []) (reverse rules)
--		   x = val2var val
	       LETexpA x exp1 exp2 -> 
		   mikdebugOFF ("LET " ++ x,nonsep_x) $
	           (LETexpA x exp1' exp2', annotFM2)
		   where
	           (exp1', annotFM1) = f (upv1, nonsep) (exp1, annotFM)
		   (exp2', annotFM2) = f (upv, nonsep2) (exp2, annotFM1)
		   upv1 = upv `union` (uv2 `delFromSet` x)
		   (ExpA _ _ _ _ (EAnnot _ (UsedVars uv2) _)) = exp2
		   nonsep2 = nonsep
			     `join_nonsep` nonsep_x
			     `join_nonsep` nonsep_cont_aa
			     `join_nonsep` nonsep_cont_inherit
		      -- nonsep_x : internal sharing within x
		      -- nonsep_cont_inherit : internal sharing inherited via containment
		      -- nonsep_cont_aa : x sharing with others via containment (and transitivity)
		   nonsep_x = NonSep $ mkSet $ map (mapCAddr addx) $
			      keysFM $ filterFM nc $ unSepGuar guar
		       where
		       nc _ cond = (not $ cond_consistent cond) ||
				   (not $ isEmptySet $ intersect unsimpcond (unNonSep nonsep))
			   where
			   unsimpcond = mapSet unsimp $ unSepCond cond
		       addx (CAddrRes zadr) = CAddr x zadr
		       addx _ = error "in nonsep LET rule"
	           (ExpA _ _ xtyp _ (EAnnot (TJAssert _ cont guar _) _ _)) = exp1
		   nonsep_cont_inherit =
		       NonSep $ unionManySets $ map fi $ setToList $ unNonSep nonsep
		       where
		       fi (AAsep (PortionCAddr cadr1) (PortionCAddr cadr2)) =
			   mkSet $ [aasep (PortionCAddr (CAddr x zadr1))
				    (PortionCAddr (CAddr x zadr2)) |
				    zadr1 <- invCont cadr1,
				    zadr2 <- invCont cadr2,
				    zadr1 /= zadr2]
		       fi (ALONGsep z2c zadr dtnm) =
			   mkSet $ [ALONGsep (CAddr x . to_fn radr) zadr dtnm |
				    radr <- invCont $ z2c $ AddrDataRec dtnm]
		       fi (ACROSSsep z2c zadr dtnm) =
			   mkSet $ [ACROSSsep (CAddr x . to_fn radr) zadr dtnm |
				    radr <- invCont $ z2c $ AddrDataRec dtnm]
		       to_fn radr = to_fn_aux id radr
		       to_fn_aux fn radr =
			   case radr of
			   AddrDataRec _ -> fn
			   AddrDataDown (consnm, i, a) ->
			       to_fn_aux (fn . \ ad -> AddrDataDown (consnm, i, ad)) a
			   AddrArray a ->
			       to_fn_aux (fn . AddrArray) a
			   _ -> error "in to_fn"
		       invCont cadr = lookupWithDefaultFM invContFM [] cadr
		       invContFM =
			   addListToFM_C ( ++ ) emptyFM $ concat $ map inv $
					 fmToList $ unContainment cont 
		       inv (zadr,(_,cadrs)) = [(cadr,[zadr]) | cadr <- setToList cadrs]
		   nonsep_cont_aa =
		       NonSep $ mkSet $ 
				  [aasep (PortionCAddr (CAddr x xzadr)) (PortionCAddr cadr) |
				   xzadr <- keysFM $ filterFM (\ _ (b,_) -> b) $ -- only portions
				            unContainment cont,
				   cadr_ <- setToList $ get_cont_cadrs cont xzadr,
				   cadr <- cadr_ : (nonsep_cadrs cadr_) -- transitivity
				  ]
			   where
			   nonsep_cadrs cadr =
			       concat $ map (fc $ PortionCAddr cadr) $ setToList $ unNonSep nonsep
			   fc cadr (AAsep cadr1 cadr2) | cadr1 == cadr = [unPortionCAddr cadr2]
						       | cadr2 == cadr = [unPortionCAddr cadr1]
			   fc _ _ = []
								    
	       _ -> (ea, annotFM)
	fM x (upv, nonsep) (prev_annotFM, prev_rules) (MATCHruleA loc consNmL varLs maybevar exp) =
	    mikdebugOFF("rule " ++ snd consNmL ++ " nonsep_int", nonsep_int)
	    (annotFM', rule : prev_rules)
		where
		rule = MATCHruleA loc consNmL varLs maybevar exp'
		(exp', annotFM') = f (upv, nonsep') (exp, prev_annotFM)
		nonsep' = nonsep
			  `join_nonsep` nonsep_int
			  `join_nonsep` nonsep_ext
		nonsep_int = NonSep $ unionManySets $
			     map fxx nonsep_xx
		    where
		    fxx = mapSet unsimp . unSepCond . get_guar_cond x_guar . mapCAddr delx
		    delx (CAddr _ zadr) = CAddrRes zadr
		    delx _ = error "in nonsep_int"
		nonsep_ext = NonSep $ unionManySets $
			     map fxa nonsep_xa
		    where
		    fxa (AAsep padr_x padr) =
			mapSet (aasep padr . PortionCAddr) $
			       get_cont_cadrs x_cont (cadr2zadr $ unPortionCAddr padr_x)
		    fxa _ = error "only AAseps should be in nonsep_xa"
		x_guar = mapVars tr_var c_guar
		x_cont = mapVars tr_var c_cont
		TJAssert _ c_cont c_guar _ = c_assert
		(_, (c_assert, _), _) = lookup_consFM consFM (snd consNmL)
		tr_var x = lookupWithDefaultFM vFM varerr x
		    where
		    varerr = error $ "Reference to an absent parameter: " ++ x ++ " " ++ (show vFM)
		    vFM = listToFM $ zip default_vars vars
		    vars = snd $ unzip varLs
		(nonsep_xx, nonsep_xa) =
		    pickxx_xa $ setToList $ unNonSep nonsep
		pickxx_xa [] = ([], [])
		pickxx_xa (zbs : rest) =
		    if isxx then (zbs : rest_xx, rest_xa)
		       else if isxa then (rest_xx, zbs' : rest_xa)
			    else (rest_xx, rest_xa)
			where
			(rest_xx, rest_xa) = pickxx_xa rest
			(isxx, isxa, zbs') =
			    case zbs
				 of
				 AAsep padr1 padr2 -> (isx1 && isx2, isx1 || isx2,
						       if isx1 then zbs else AAsep padr2 padr1)
						       -- x goes first
				     where
				     isx1 = padr2var padr1 == x
				     isx2 = padr2var padr2 == x
				 ALONGsep z2c zadr dtnm -> (isx, False, zbs)
				     where
				     isx = cadr2var (z2c $ AddrDataX) == x
				 ACROSSsep z2c zadr dtnm -> (isx, False, zbs)
				     where
				     isx = cadr2var (z2c $ AddrDataX) == x
					   
val2var (VARval x) = x
val2var (UNITval) = ""   -- kwxm:  FIX THIS 
val2var v = error ("Variable/unit expected: " ++ show v)

padr2var = cadr2var . unPortionCAddr

cadr2var (CAddr x _) = x
cadr2var _ = error "An address with a variable expected"

cadr2zadr (CAddr _ zadr) = zadr
cadr2zadr (CAddrRes zadr) = zadr
cadr2zadr _ = error "A proper address expected"

unsimp (SIMPLEsep zbsep) = zbsep
unsimp IMPOSSIBLEsep = error "expecting a consistent condition"

annotFM1 `join_annotFM_nonsep` annotFM2 = annotFM
    where
    annotFM = plusFM_C f annotFM1 annotFM2
    f (EAnnot assert uv (pv, nonsep1)) (EAnnot _ _ (_, nonsep2)) =
	EAnnot assert uv (pv, nonsep1 `join_nonsep` nonsep2)

nonsep1 `join_nonsep` nonsep2 =
    NonSep $ unNonSep nonsep1 `union` unNonSep nonsep2
    
pv1 `join_pv` pv2 =
    PreserveVars $ unPreserveVars pv1 `union` unPreserveVars pv2
    
get_cont_cadrs cont zadr =
    snd $ lookupWithDefaultFM (unContainment cont) (True, emptySet) zadr

---

complete_guars :: DataFM -> ProgramA -> ProgramA
complete_guars dataFM (PROGA typedecs valdecs afundef_groups) =
    PROGA typedecs valdecs afundef_groups'
	where
	afundef_groups' = map (map do_fundef) afundef_groups
	do_fundef (FUNdefA loc fnm params inst expa) =
	    FUNdefA loc fnm params inst (do_expa expa)
	do_expa (ExpA loc ea ty contextFM (EAnnot assert uv (pv, nonsep))) =
	    ExpA loc ea ty contextFM (EAnnot (do_assert assert) uv (pv, nonsep))
		where
		do_assert (TJAssert cond cont guar dset) =
		    TJAssert cond cont (do_guar guar) dset
		do_guar (SepGuar fm) = SepGuar $ triv_fm `plusFM` fm
		    where
		    triv_fm =
			listToFM $ zip (all_ZBasicSepCond dataFM id ty) (repeat min_SepCond)
