module Camelot_annot_html (camelot_annot2html) where

import Camelot_absyn_ASDL
import Camelot_absyn
import Camelot_annot
import Camelot_infer_annot
import Misc

import HTMLMonad hiding (map)

import Set
import FiniteMap
import Monad

camelot_annot2html :: DataFM -> ProgramA -> String -> IO String
camelot_annot2html dataFM prg prgname =
    liftM show $ build_document $
	  do
	  HTMLMonad.head $ title $ text $ prgname ++ ".cmlt"
	  body $ do
		 table $
		       do
		       tr $ td $ h1 $ text $ prgname ++ ".cmlt"
		       tr $ td $
			  do
			  text "click here to open the annotation display window"
			  attr "onmousedown" popup_js
			  setcolours (fgcolorA 0) (bgcolorA 0)
		 hr empty
		 htmlMonad (0, dataFM, True, prgname, Nothing) prg
		 signature

popup_js =
    "showin = window.open('','showin','height=600,width=800');\n"
    ++ "showin.document.writeln('" ++ contents_str ++ "');\n"
    ++ "showin.document.close()"
	where
	contents_str =  reformat $ show $ Prelude.head $ build_document $ contents
	contents =
	    do
	    HTMLMonad.head $ do
			     title $ text $ "annotations window"
	    body $ text $
		     "Move the mouse over the darker box left of a subterm to see its annotations here"


signature = address $
            do
            text "by "
            hlink "http://konecny.aow.cz/" (text "Michal Konecny")
            text ", May 2003"
            text "; powered by "
            hlink "http://www.informatik.uni-freiburg.de/~thiemann/haskell/WASH/" (text "WASH/HTML")

hlink url subs = a (attr "href" url ## subs)

{-
newtype DeecHTML x m a = DM { unDM :: (DataFM, Int) -> WithHTML x m a }

dm :: WithHTML x m a -> DeecHTML x m a
dm elems = DM $ \ param -> elems

instance Monad m => Monad (DeecHTML x m) where
    da >>= f = DM $ \ param -> do { a <- unDM da param; unDM (f a) param; }
    return a = dm $ return a

class HTMLable a where
    htmlMonad :: Monad m => a -> DeecHTML x m ()
    htmlMonad value = dm $ text "not yet [value]"
-}

class HTMLable a where
    htmlMonad :: Monad m => (Level, DataFM, IsActive, String, Maybe String) -> a -> WithHTML x m ()
    htmlMonad params value = text "not yet [params/value]"

type Level = Int
type IsActive = Bool

instance HTMLable ProgramA where
    htmlMonad params (PROGA typedecAs _valdecLs fundef_groups) =
	do
	h1 $ text "Type declarations"
	htmlMonad_list (br empty ## br empty) $ map (htmlMonad params) typedecAs
	hr empty
	h1 $ text "Function definitions"
	htmlMonad_list (hr empty) $
		       map (htmlMonad_list (br empty) . (map (htmlMonad params))) fundef_groups

htmlMonad_list sep list = f list
	where
	f [] = empty
	f [x] = x
	f (x:xs) = do { x; sep; f xs; }

instance HTMLable TypeDecA where
    htmlMonad params (TYPEdecA _ dataNm typeconLs zadrs) =
	do
	table $ tr $
	   do
	   td $ do
		attr "valign" "top"
		htmlMonad_keyword params "type"
		htmlMonad_data params dataNm
		text " "
	   td $ table $ do
			row " = " $ htmlMonad params $ snd $ Prelude.head typeconLs
			foldl ( ## ) empty $ map (row " | " . htmlMonad params . snd) $ tail typeconLs
	br empty
	text "portions: "
	br empty
	htmlMonad_list (text ", ") $ map (htmlMonad params) $ zadrs
	    where
	    row s subs = tr $ do
			      td $ text s
			      td $ subs

instance HTMLable TypeCon where
    htmlMonad params (TYPEcon (consNm, tys, heapUsage)) =
	do
	htmlMonad_cons params consNm
	case heapUsage of
		       HEAP -> empty
		       NOHEAP -> text "!"
	text " "
	case tys of
		 [] -> empty
		 _ -> do
		      htmlMonad_keyword params "of"
                      htmlMonad_list (text " * ") $ map (htmlMonad params) tys

instance HTMLable Ty where
    htmlMonad params ty =
	case simplify_ty ty of
	UNITty -> text "()"
	{- LISTty t -> do text "("
		       htmlMonad params t
		       text ") list" -}
	ARRAYty t -> do text "("
			htmlMonad params t
			text ") array"
	CONty ([], dataNm) -> htmlMonad_data params dataNm
	DIAMONDty str -> rawtext "&loz;"
	_ -> error $ "type cannot be htmlized yet: " ++ (show ty)

{----- FUNDEF -----}

instance HTMLable FunDefA where
    htmlMonad params (FUNdefA _ funcNm vars inst aexp) =  -- kwxm
	do
	h2 $ do
	     text funcNm
	     foldl ( ## ) empty $ map (text . (++) " ") (map varName vars) -- kwxm
	     text " ="
        htmlMonad params' aexp
	    where
	    params' = (i, dataFM, isActive, prgname, Just funcNm)
	    (i, dataFM, isActive, prgname, _) = params

instance HTMLable ExpA where
    htmlMonad params (ExpA _ ea ty contextFM eannot) =
	table $
	      do
	      attr "rules" "columns"
	      attr "cellpadding" "5"
	      attr "frame" "lhs"
	      tr $ do
		   td $
		      do
		      setcolours (fgcolorA i) (bgcolorA i)
		      -- attr "height" "20"
		      attr "width" "4"
		      if isActive
			 then attr "onmouseover" (showin_display_js params ea ty ctxt eannot)
			 else empty
		   td $
		      do
		      -- attr "colspan" "2"
		      setcolours (fgcolor i) (bgcolor i)
		      htmlMonad (i+1, dataFM, isActive, prgname, Just funcNm) ea
	    where
	    (i, dataFM, isActive, prgname, Just funcNm) = params
	    ctxt = fmToList contextFM

instance HTMLable ExpAi where
    htmlMonad params ea =
	case ea of
	VALexpA val -> htmlMonad params val
	UNARYexpA unop val -> do
			      htmlMonad params unop
			      htmlMonad params val
	BINexpA binop v1 v2 -> do
			       htmlMonad params v1
			       htmlMonad params binop
			       htmlMonad params v2
	IFexpA tst aexp1 aexp2 ->
	    do
	    htmlMonad_keyword params "if"
	    htmlMonad_test params tst
	    exp_table $
		  do
		  tr $ td $ (htmlMonad_keyword params "then" ## htmlMonad params aexp1)
		  tr $ td $ (htmlMonad_keyword params "else" ## htmlMonad params aexp2)
	MATCHexpA x rules ->
	    do
	    htmlMonad_keyword params "match"
	    text x  -- kwxm
	    htmlMonad_keyword params "with"
	    exp_table $ foldl ( ## ) empty $ map (tr . htmlMonad params) rules
	LETexpA x aexp1 aexp2 ->
	    do
	    htmlMonad_keyword params "let"
	    text x
	    exp_table $
		  do
		  tr $ do
		       td $ do
			    attr "valign" "top"
			    htmlMonad_keyword params " = " 
		       td $ htmlMonad params aexp1
		  tr $ do
		       td $ do
			    attr "valign" "top"
			    htmlMonad_keyword params "in"
		       td $ htmlMonad params aexp2
	APPexpA x vals _ext ->
	    do
	    text x                -- kwxm
	    text " "
	    case vals of
		      [] -> text "()"
		      _ -> foldl1 (##) $ map (htmlMonad params) vals
	CONexpA consNm vals maybevar ->
	    do
	    htmlMonad_cons params consNm
	    case vals of
		      [] -> empty
		      _ -> do
			   text "("
			   foldl1 comma $ map (htmlMonad params) vals
			   text ")"
	    case maybevar of
			  Nothing -> empty
			  Just (loc, d) -> text $ "@" ++ d
	    rawtext " "
		where
		comma h1 h2 = do { h1; rawtext ", "; h2; }
	{- LISTexpA vals ->
	    do
	    text "["
	    foldl (##) empty $ map (htmlMonad params) vals
	    rawtext "] " -}
	TYPEDexpA exp ty -> htmlMonad params exp
	ASSERTexpA exp conds guars -> htmlMonad params exp

htmlMonad_keyword params kw = do strong $ text kw
				 text " "

htmlMonad_cons params consnm = font $ do
				      attr "color" "green"
				      text consnm

htmlMonad_data params datanm = font $ do
				      attr "color" "blue"
				      text datanm

htmlMonad_test params (TESTA oper val1 val2) = font $ do
		       htmlMonad params val1
		       htmlMonad params oper
		       htmlMonad params val2
		       

exp_table elems = table $ do
			  attr "cellspacing" "5"
			  elems

instance HTMLable MatchRuleA where
    htmlMonad params (MATCHruleA _ (_, consNm) vars matchdiam aexp) =
	do
	td $ do
	     attr "valign" "top"
	     htmlMonad params $ CONexpA consNm (map (\ (_,x) -> VARval x) vars) maybevar
	     rawtext "-> "
	td $ htmlMonad params aexp
	    where
	    maybevar = case matchdiam of
		       NOWHERE -> Nothing
		       SOMEWHERE d -> Just d
		       DISPOSE -> Just $ (error "", "_")
	

instance HTMLable Value where
    htmlMonad params val = (theval ## rawtext " ")
	where
	theval = case val of
		 VARval x -> text x
		 INTval i -> text $ (show i)
		 FLOATval f -> text $ (show f)
		 STRINGval s -> text $ (show s)
		 BOOLval b -> htmlMonad params b
		 UNITval -> text "unit"
		 _ -> error $ show val ++ " found in Camelot_annot_html.htmlMonad"

instance HTMLable BoolX where
    htmlMonad params TRUEval = text "true"
    htmlMonad params FALSEval = text "false"

instance HTMLable UnaryOperator where
    htmlMonad params unop = rawtext (txt ++ " ")
	where
	txt = case unop of
	      NOTop -> "not"
	      ISNULLop -> "isnull"  -- kwxm
		       
instance HTMLable BinaryOperator where
    htmlMonad params binop = rawtext (txt ++ " ")
	where
	txt = case binop of
	      TIMESop -> "&times;" 
	      DIVop -> "/" 
	      PLUSop -> "+" 
	      MINUSop -> "-"
	      MODop -> "mod"
	      LANDop -> "land"
	      LORop -> "lor"
	      LXORop -> "lxor"
	      LSLop -> "lsl"
	      LSRop -> "lsr"
	      ASRop -> "asr"
	      FPLUSop -> "+<sub>fl</sub>"
	      FMINUSop -> "-<sub>fl</sub>"
	      FTIMESop -> "&times;<sub>fl</sub>"
	      FDIVop -> "/<sub>fl</sub>"
	      LESSop -> "&lt;" 
	      LTEQop -> "&le;"
	      EQUALSop -> "=" 
	      FEQUALSop -> "=<sub>fl</sub>"
              FLESSop -> "&lt;<sub>fl</sub>"
              FLTEQop -> "&le;<sub>fl</sub>"
	      BEQUALSop -> "=="
	      CONCATop -> "^"

{----- assertions -----}

instance HTMLable TJAssert where
    htmlMonad params (TJAssert cond cont guar dset) =
	table $
	do
	attr "rules" "all"
	tr $ do
	     td $ (text "pre-condition: " ## attr "valign" "top")
	     td $ htmlMonad params cond
	tr $ do
	     td $ (text "portion containment: " ## attr "valign" "top")
	     td $ htmlMonad params cont
	tr $ do
	     td $ (text "separation rely-guarantees: " ## attr "valign" "top")
	     td $ htmlMonad params guar
	tr $ do
	     td $ (text "not-preserved portions: " ## attr "valign" "top")
	     td $ htmlMonad params dset

instance HTMLable SepCond where
    htmlMonad params (SepCond set) =
	set_table_htmlMonad params set

instance HTMLable NonSep where
    htmlMonad params (NonSep set) =
	set_table_htmlMonad params set

set_table_htmlMonad params set =
    case list of
    [] -> rawtext "&empty;"
    [x] -> do { text "{"; htmlMonad params x; text "}"; }
    (x:xs) -> 
	table $
	do
	tr $ do
	     td $ text "{"
	     td $ do
		  htmlMonad params x
		  text ","
	h xs
	where
	h [] = error "in set_table_htmlMonad"
	h [x] = tr $ do { td empty; td $ htmlMonad params x; td $ text "}"; }
	h (x:xs) = do
		   tr $ do
			td empty
			td $ do
			     htmlMonad params x
			     text ","
		   h xs
    where
    list = setToList set

instance HTMLable CBasicSepCond where
    htmlMonad params csep =
	case csep of
	IMPOSSIBLEsep -> assertion_meta $ rawtext "&perp;"
	SIMPLEsep zsep -> htmlMonad params zsep
	-- ARROWsepset _ _ -> text $ show csep -- dummy

instance HTMLable ZBasicSepCond where
    htmlMonad params zsep =
	case zsep of
	AAsep cadr1 cadr2 -> do
			     htmlMonad params cadr1
			     assertion_meta $ rawtext " &otimes; "
			     htmlMonad params cadr2
	ALONGsep z2c zadr dtnm ->
	    do
	    assertion_meta $ rawtext "&otimes; "
	    htmlMonad params pcadr
	    assertion_meta $ text " / "
	    htmlMonad params rzadr
		where
		ALONGsepXX pcadr rcadr = zbsXX zsep
		rzadr = case unRecTypeCAddr rcadr of
			CAddr _ rzadr -> rzadr
			CAddrRes rzadr -> rzadr
			_ -> error "displaying /"
	ACROSSsep z2c zadr dtnm ->
	    do
	    assertion_meta $ rawtext "&otimes; "
	    htmlMonad params pcadr
	    if same_port_rec pcadr rcadr
	       then empty
	       else do
		    assertion_meta $ rawtext " &lambda; "
		    htmlMonad params rzadr
			where
			ACROSSsepXX pcadr rcadr = zbsXX zsep
			rzadr = case unRecTypeCAddr rcadr of
				CAddr _ rzadr -> rzadr
				CAddrRes rzadr -> rzadr
				_ -> error "displaying /\\"

same_port_rec (PortionCAddr a1) (RecTypeCAddr a2) = False -- needs a lot of work...not worth it


instance HTMLable PortionCAddr where
    htmlMonad params (PortionCAddr cadr) = htmlMonad params cadr

instance HTMLable RecTypeCAddr where
    htmlMonad params (RecTypeCAddr cadr) = htmlMonad params cadr


instance HTMLable CAddr where
    htmlMonad params cadr =
	case cadr of
	CAddrNew -> text "NEW"
	CAddrFree -> text "FREE"
	CAddr x zadr -> htmlAddrConcat (text x) (htmlMonad params zadr)
	-- CAddrArw x -> text $ show x
	CAddrRes zadr -> htmlMonad params zadr

instance HTMLable ZAddr where
    htmlMonad params zadr =
	case zadr of
	AddrDiam -> rawtext "&loz;P"
	AddrDataRec dataNm -> do
			      -- text "("
			      htmlMonad_data params dataNm
			      -- text ")"
			      -- htmlMonad_addrP params "R"
	AddrDataCons consNm -> do
			      -- text "("
			      -- htmlMonad_cons params consNm
			      htmlMonad_addrP params consNm
			      -- text ")"
			      -- htmlMonad_addrP params "P"
	AddrDataDown (consNm, si, adr) ->
	    htmlAddrConcat htcons (htmlMonad params adr)
		where
		htcons = do
			 --text "("
			 htmlMonad_cons params consNm
			 small $ text $ show si
			 -- text ")"
	AddrDataX -> text "X"
	-- AddrListHereRec -> text "[]R"
	-- AddrListHereBox -> text "[]P"
	-- AddrListDown adr -> htmlAddrConcat (text $ "[]") (htmlMonad params adr)
	AddrArray adr -> htmlAddrConcat (text $ "(ARRAY)") (htmlMonad params adr)
			
htmlAddrConcat h1 h2 = do { h1; text "."; h2; }

htmlMonad_addrP params s = font $ do
			     attr "color" "#FF6000"
			     b $ text s

instance HTMLable Containment where
    htmlMonad params (Containment contFM) = fm_table_htmlMonad "&sube;" params contFM

instance HTMLable b => HTMLable (a,b) where
    htmlMonad params (a,b) = htmlMonad params b -- a DIRTY trick...

instance HTMLable SepGuar where
    htmlMonad params (SepGuar guarFM) = fm_table_htmlMonad "&lArr;" params guarFM

fm_table_htmlMonad septext params fm =
    case list of
    [] -> rawtext "&empty;"
    _ -> table $ do
		 attr "rules" "all"
		 foldl1 (##) $ map f list
    where
    f (key, elt) = tr $ do
			 td (htmlMonad params key ## attr "align" "right" ## attr "valign" "top")
			 td (assertion_meta $ rawtext septext ## attr "valign" "top")
			 td (htmlMonad params elt ## attr "align" "left")
    list = fmToList fm

instance HTMLable DSet where
    htmlMonad params (DSet set) = htmlMonad params set

instance (HTMLable a) => (HTMLable (Set a)) where
    htmlMonad params set =
	case list of
	[] -> rawtext "&empty;"
	(x:xs) ->
	    do
	    text "{"
	    htmlMonad params x
	    foldl (##) empty $ map h xs
	    text "}"
	where
	h x = do
	      text ", "
	      htmlMonad params x
	list = setToList set

setcolours fg bg =
    do
    attr "bgcolor" bg
    attr "style" ("color:" ++ fg)


fgcolor i = "#000000"
bgcolor i = colorpref ++ pcthex
    where
    colorpref = if even i
		then "#E0E0"
		else "#E0FF"
    pcthex = hexdigit (floor $ pct/16) ++ hexdigit ((floor pct) `mod` 16)
    pct = ((3/4) ** fi) * 224
    fi = fromInteger $ toInteger i
	 
fgcolorA i = "#000000"
bgcolorA i = "#D0B0B0"

hexdigit i | i == 15 = "F"
	   | i == 14 = "E"
	   | i == 13 = "D"
	   | i == 12 = "C"
	   | i == 11 = "B"
	   | i == 10 = "A"
	   | otherwise = show i

assertion_meta elems = font $ do
			      attr "color" "red"
			      elems

showin_display_js params ea ty ctxt (EAnnot assert uv (pv, nonsep)) =
    "showin.document.writeln('" ++ contents_str ++ "');\n" ++
    "showin.document.close()"
	where
	contents_str =  reformat $ show $ Prelude.head $ build_document $ contents
	contents =
	    do
	    HTMLMonad.head $ do
			     title $ text $
				       "annotations - " ++ prgname ++ ".cmlt - " ++ funcnm ++ " level " ++ show i
			     {-
			     meta $ do
				    attr "content" "text/html; charset=ISO-8859-2"
				    attr "http-equiv" "Content-Type"
				    -}
	    body $
		       table $ do
			       tr $ td $ do
					 text "Non-guaranteeable separation: "
					 htmlMonad params nonsep
					 hr empty
					 htmlMonad params assert
			       tr $ td $ do
					 setcolours (fgcolorA i) (bgcolorA i)
					 htmlMonad_ctxt_ea_ty params ctxt ea ty uv pv
	(i, dataFM, isActive, prgname, Just funcnm) = params

reformat =
    concat . map e . htmlEncode
	where
	e '\n' = ""
	e '\'' = "\\'"
        e c = [c]

htmlMonad_ctxt_ea_ty params ctxt ea ty uv pv =
    table $ do
	    foldl ( ## ) empty $ map fc ctxt
	    tr $ td $ do
		      attr "colspan" "0"  -- spans all columns
		      setcolours (fgcolor i) (bgcolor i)
		      htmlMonad (i + 1, dataFM, False, prgname, maybefuncnm) ea
	    ft ty False False
	where
	(i, dataFM, isActive, prgname, maybefuncnm) = params
	fc (var, ty) = f (text var) ty (var `elementOf` (unUsedVars uv)) (var `elementOf` (unPreserveVars pv))
	ft ty = f (text "RESULT") ty
	f label ty isUsed isLive =
	    tr $ do
		 td $ label
		 td $ htmlMonad params ty
		 td $ htmlMonad_PR_names params ty
		 td $ if isUsed then greentext "used" else empty
		 td $ if isLive then redtext "live" else empty
	redtext s = font $ do
			   attr "color" "#900000"
			   text s
	greentext s = font $ do
			     attr "color" "green"
			     text s
		       
htmlMonad_PR_names params ty =
    empty

htmlEncode "" = ""
htmlEncode (x:xs) = 
	case x of
	  '&' -> "&amp;" ++ htmlEncode xs
	  '<' -> "&lt;"  ++ htmlEncode xs
	  '>' -> "&gt;"  ++ htmlEncode xs
	  '\"' -> "&quot;" ++ htmlEncode xs
	  _ -> x : htmlEncode xs

