module Camelot_annot_UA where

{-
  Camelot terms with embedded annotations
  HO deel annotation syntax
  type subterm addresses
-}

import Assertions_ASDL
import Camelot_absyn_ASDL hiding (Assn)
import Camelot_absyn
import Misc

import List (elemIndex)
import Set
import FiniteMap
import Numeric

{--- annotated programs ---}

data ProgramA = PROGA [TypeDecA] [ValDecL] [[FunDefA]]
    deriving (Eq, Ord, Show)

data TypeDecA = TYPEdecA Loc DataNm [TypeConL] [ZAddr]
    deriving (Eq, Ord, Show)

data FunDefA = FUNdefA Loc FuncNm [VarNm] ExpA
    deriving (Eq, Ord, Show)

data ExpA = ExpA Loc ExpAi Ty ContextFM EAnnot
    deriving (Eq, Ord, Show)
data ExpAi = VALexpA Value
           | UNARYexpA UnaryOperator Value
           | BINexpA BinaryOperator Value Value
           | IFexpA Value ExpA ExpA
           | MATCHexpA Value [MatchRuleA]
           | LETexpA VarNm ExpA ExpA
           | APPexpA Value [Value] External
           | CONexpA ConsNm [Value] (Maybe VarNmL)
           -- | LISTexpA [Value]
	   | TYPEDexpA ExpA Ty
	   | ASSERTexpA ExpA [Assn] [Assn]
    deriving (Eq, Ord, Show)
	    
data MatchRuleA = MATCHruleA Loc ConsNmL [VarNmL] MatchDiam ExpA
    deriving (Eq, Ord, Show)

type ContextFM = FiniteMap VarNm Ty
{- share with DEEL 

mkContextFM :: [VarNm] -> Ty -> ContextFM
mkContextFM [] _ = emptyFM
mkContextFM (x:rest) (ARROWty (typ, restyp)) =
    addToFM (mkContextFM rest restyp) x $ simplify_ty typ
mkContextFM _ _ = error $ "mkContextFM: function argument list does not match its type"
-}

{--- deel annotations ---}

data EAnnot = EAnnot MaxAspects UsedVars (PreserveVars, MinAspects)
    deriving (Eq, Ord, Show)
min_EAnnot = EAnnot (MaxAspects emptyFM) min_UsedVars (min_PreserveVars, (MinAspects emptyFM))

data MaxAspects = MaxAspects { unMaxAspects :: FiniteMap VarNm Aspect}
    deriving (Eq, Ord, Show)

data MinAspects = MinAspects { unMinAspects :: FiniteMap VarNm Aspect}
    deriving (Eq, Ord, Show)

data Aspect = A1 | A2 | A3
    deriving (Eq, Ord, Show)
min_Aspect = A1

newtype UsedVars = UsedVars { unUsedVars :: Set VarNm}
    deriving (Eq, Ord, Show)
min_UsedVars = UsedVars emptySet

newtype PreserveVars = PreserveVars { unPreserveVars :: Set VarNm}
    deriving (Eq, Ord, Show)
min_PreserveVars = PreserveVars emptySet

deannot_UA = error ""

{-----------------------------------------------------}

{- commented out until the end

-- all heap-free types are collapsed to UNITty

simplify_ty :: Ty -> Ty
simplify_ty t = s t
    where
    s t = case t of
	  TVARty tv -> error "program not monomorphised..."
	  ARROWty (t1, t2) -> ARROWty (s t1, s t2)
	  -- LISTty t -> LISTty (s t)
	  ARRAYty t -> ARRAYty (s t)
	  CONty (_, dataNm) -> CONty ([], no_dollar_prefix dataNm)
	  PRODUCTty tys -> PRODUCTty (map s tys)
	  DIAMONDty str -> DIAMONDty str
	  _ -> UNITty

no_dollar_prefix s =
    case elemIndex '$' s of
    Nothing -> s
    Just i -> drop (i+1) s

-- translation from normal Camelot terms

min_annot :: Program -> ProgramA
min_annot (PROG (typedecLs, valdecLs, fundef_groups)) =
    PROGA (map doTD typedecLs) valdecLs $ map (map doFD) fundef_groups
	where
	doFD (loc, FUNdef (funcnm, vars, expL)) =
	    FUNdefA loc funcnm vars $ min_annot_exp vars expL
	doTD (loc, TYPEdec (_, dataNm, typeconLs)) = TYPEdecA loc dataNm typeconLs []

min_annot_exp :: [VarNm] -> ExpL -> ExpA
min_annot_exp reserved_vars eL = t reserved_vars eL
    where
    t rvs (loc, e) = ExpA loc ea ty emptyFM min_EAnnot
	where
	ea = case e of
	     VALexp val -> VALexpA val
	     UNARYexp (unop, exp) -> UNARYexpA unop (exp2val exp)
	     BINexp (binop, exp1, exp2) -> BINexpA binop (exp2val exp1) (exp2val exp2)
	     IFexp (exp, exp1, exp2) ->
		 mkLet loc rvs [t rvs exp] (\ (val:_) -> IFexpA val (t rvs exp1) (t rvs exp2))
	     MATCHexp (exp, rules) -> MATCHexpA (exp2val exp) $ map (tM rvs) rules
	     LETexp (x, exp1, exp2) -> LETexpA x (t rvs exp1) (t (x:rvs) exp2)
	     APPexp (exp, exps, ext) -> APPexpA (exp2val exp) (map exp2val exps) ext
	     CONexp (var, exps, maybevar) -> CONexpA var (map exp2val exps) maybevar
	     -- LISTexp exps -> LISTexpA (map exp2val exps)
	     TYPEDexp (exp, ty) -> TYPEDexpA (t rvs exp) ty
	     ASSERTexp (exp, conds, guars) -> ASSERTexpA (t rvs exp) conds guars
	ty = case e of
	     TYPEDexp (_, ty) -> ty
	     _ -> UNITty -- serving as a dummy type here
    tM rvs (loc, MATCHrule (consnmL, varLs, matchdiam, expL)) =
	MATCHruleA loc consnmL varLs matchdiam (t (vars++rvs) expL)
	    where
	    vars = map snd varLs

exp2val (loc, VALexp val) = val
exp2val expL = error $ "expecting a value but got: " ++ (show expL)

mkLet :: Loc
      -> [VarNm] -- vars to avoid
      -> [ExpA] -- expressions to abstract
      -> ([Value] -> ExpAi)  -- expression constructor
      -> ExpAi
mkLet loc reserved_vars [] f = f []
mkLet loc reserved_vars (ea:eas) f =
    case e of
    VALexpA val -> mkLet loc reserved_vars eas (\ vals -> f (val:vals))
    _ -> LETexpA x ea $ ExpA loc restexp UNITty emptyFM min_EAnnot
	where
	x = newvar reserved_vars
	restexp = mkLet loc (x:reserved_vars) eas (\ vals -> f ((VARval x):vals))
    where ExpA _ e _ _ _ = ea

newvar :: [VarNm] -> VarNm
newvar notthese = "v" ++ (show $ (maxidx notthese) + 1)

maxidx :: [VarNm] -> Int
maxidx vars = foldl max 0 $ map getvaridx vars

getvaridx :: VarNm -> Int
getvaridx (char:digits) = case readDec digits of [] -> 0
						 ((i,_):_) -> i
getvaridx [] = error "in getvaridx: bad syntax"

-- translation to normal Camelot terms + assembling of assertions

deannot_UA :: ProgramA -> Program
deannot_UA (PROGA typedecs valdecs fundef_groups) =
    PROG ((map doTD typedecs), valdecs, map (map doFD) fundef_groups)
	where
	doFD (FUNdefA loc funcnm vars aexp) =
	    (loc, FUNdef (funcnm, vars, deannot_exp aexp))
	doTD (TYPEdecA loc dataNm typeconLs _) =
	    (loc, TYPEdec ([], dataNm, typeconLs))
	    
deannot_exp :: ExpA -> ExpL
deannot_exp (ExpA loc ea ty _ annot) = (loc, ASSERTexp ((loc, e), conds, guars))
    where
    e = case ea of
	VALexpA val -> VALexp val
	UNARYexpA unop val -> UNARYexp (unop, (loc, VALexp val))
	BINexpA binop val1 val2 -> BINexp (binop, (loc, VALexp val1), (loc, VALexp val2))
	IFexpA val exp1 exp2 -> IFexp ((loc, VALexp val), (deannot_exp exp1), (deannot_exp exp2))
	MATCHexpA val rules -> MATCHexp ((loc, VALexp val), map tM rules)
	LETexpA x exp1 exp2 -> LETexp (x, (deannot_exp exp1), (deannot_exp exp2))
	APPexpA val vals ext -> APPexp ((loc, VALexp val), (map valexpL vals), ext)
	CONexpA x vals maybevar -> CONexp (x, (map valexpL vals), maybevar)
	-- LISTexpA vals -> LISTexp (map valexpL vals)
	TYPEDexpA exp t -> TYPEDexp (deannot_exp exp,t)
	ASSERTexpA exp _ _ -> e
	    where
	    (_, ASSERTexp ((_, e), _, _)) = deannot_exp exp
	where
	tM (MATCHruleA loc consnmL varLs matchdiam exp) =
	    (loc, MATCHrule (consnmL, varLs, matchdiam, (deannot_exp exp)))
	valexpL v = (loc, VALexp v)
    (prev_conds, prev_guars) =
	case ea of
		ASSERTexpA exp conds1 guars1 ->
		    (conds2 ++ conds1, guars2 ++ guars1)
			where
			(_, ASSERTexp ((_, _), conds2, guars2)) = deannot_exp exp
		_ -> ([], [])
    conds = (mkAssns cond) ++ prev_conds
    guars = (mkAssns guar) ++ prev_guars -- make sure guar is complete - all zbseps have a value
    (EAnnot (TJAssert cond cont guar dset) _ _) = annot

class MkAssns a where
    mkAssns :: a -> [Assn]

instance MkAssns SepGuar where
    mkAssns guar =
	concat $ map f $ fmToList $ unSepGuar guar
	{- all basic assertions with trivial precondition have to be made present too -}
	    where
	    f (zbsep, cond) =
		case condAssns of
		[] -> [zbsepAssn]
		[ASSNfalse] -> []
		_ -> [ASSNimplies (condAssn, zbsepAssn)]
		where
		condAssn = foldr1 (\ a b -> ASSNand (a,b)) condAssns
		condAssns = mkAssns cond
		zbsepAssn = head $ mkAssns zbsep

instance MkAssns SepCond where
    mkAssns cond =
	concat $ map mkAssns $ setToList $ unSepCond cond
    
instance MkAssns CBasicSepCond where
    mkAssns IMPOSSIBLEsep = [ASSNfalse]
    mkAssns (SIMPLEsep zbsep) = mkAssns zbsep

instance MkAssns ZBasicSepCond where
    mkAssns zbsep = mkAssns $ zbsXX zbsep

instance MkAssns ZBasicSepCondXX where
    mkAssns (AAsepXX padr1 padr2) =
	[ASSNsep (mkPortion padr1, mkPortion padr2)]
    mkAssns (ALONGsepXX padr radr) =
	[ASSNalong (mkPortion padr, port2zadr $ mkPortion radr)]
    mkAssns (ACROSSsepXX padr radr) =
	[ASSNacross (mkPortion padr, port2zadr $ mkPortion radr)]

port2zadr (ReprArg (zadr, _)) = zadr
port2zadr (ReprRes zadr) = zadr

class MkPortion a where
    mkPortion :: a -> Portion

instance MkPortion PortionCAddr where
    mkPortion = mkPortion . unPortionCAddr

instance MkPortion RecTypeCAddr where
    mkPortion = mkPortion . unRecTypeCAddr

instance MkPortion CAddr where
    mkPortion (CAddr var zadr) = ReprArg (zadr, var)
    mkPortion (CAddrRes zadr) = ReprRes zadr
    mkPortion _ = error "in mkPortion/CAddr"

-}
