module Camelot_annot where

{-
  Camelot terms with embedded annotations
  DEEL annotation syntax
-}

import Assertions_ASDL
import Camelot_absyn_ASDL hiding (Assn)
import Camelot_absyn
import Misc

import List (elemIndex)
import Set
import FiniteMap
import Numeric

{--- annotated programs ---}

data ProgramA = PROGA [TypeDecA] [ValDecL] [[FunDefA]] -- NEED TO REPLACE WITH FunBlockA OR SOMETHING
    deriving (Eq, Ord, Show)

data TypeDecA = TYPEdecA Loc DataNm [TypeConL] [ZAddr]
    deriving (Eq, Ord, Show)

data FunDefA = FUNdefA Loc FuncNm [VarTy] Instance' ExpA  -- kwxm: added instance
    deriving (Eq, Ord, Show)

exposeFunBlock :: FunBlock -> [FunDefL]
exposeFunBlock (FUNblock fundefs) = fundefs


get_fundefA_funcnm (FUNdefA _ funcnm _ _ _) = funcnm

data ExpA = ExpA Loc ExpAi Ty ContextFM EAnnot
    deriving (Eq, Ord, Show)
data ExpAi = VALexpA Value
           | UNARYexpA UnaryOperator Value
           | BINexpA BinaryOperator Value Value
           | APPexpA VarNm [Value] External
           | CONexpA ConsNm [Value] (Maybe VarNmL)
           | LETexpA VarNm ExpA ExpA
           | IFexpA TestA ExpA ExpA
           | MATCHexpA VarNm [MatchRuleA]
	   | TYPEDexpA ExpA Ty
	   | ASSERTexpA ExpA [Assn] [Assn]
    deriving (Eq, Ord, Show)
	    
data TestA = TESTA BinaryOperator Value Value
	     deriving (Eq, Ord, Show)

data MatchRuleA = MATCHruleA Loc ConsNmL [VarNmL] MatchDiam ExpA
    deriving (Eq, Ord, Show)


type ContextFM = FiniteMap VarNm Ty

mkContextFM :: [VarTy] -> Ty -> ContextFM
mkContextFM [] _ = emptyFM
mkContextFM (UNITvar:rest) (ARROWty (_, restyp)) = mkContextFM rest restyp
mkContextFM (UNITvar:rest) _ = emptyFM  
{-- WARNING:  the program rejects valid code if the previous two lines are omitted.
    These are just a temporary fix until I understand what's going on --}

mkContextFM (x:rest) (ARROWty (typ, restyp)) =
    addToFM (mkContextFM rest restyp) (varName x) $ {--simplify_ty--} typ  -- kwxm
mkContextFM vars ty =
    error $ "mkContextFM: function argument list does not match its type.\n "
	      ++ show vars ++ " - " ++ show ty

-- OK this just doesn't work


{--- deel annotations ---}

data EAnnot = EAnnot TJAssert UsedVars (PreserveVars,NonSep)
    deriving (Eq, Ord, Show)
min_EAnnot = EAnnot min_TJAssert min_UsedVars (min_PreserveVars, min_NonSep)

newtype UsedVars = UsedVars { unUsedVars :: Set VarNm}
    deriving (Eq, Ord, Show)
min_UsedVars = UsedVars emptySet

newtype PreserveVars = PreserveVars { unPreserveVars :: Set VarNm}
    deriving (Eq, Ord, Show)
min_PreserveVars = PreserveVars emptySet

newtype NonSep = NonSep { unNonSep :: Set ZBasicSepCond }
    deriving (Eq, Ord, Show)
min_NonSep = NonSep emptySet

data TJAssert = TJAssert SepCond Containment SepGuar DSet
    deriving (Eq, Ord, Show)
min_TJAssert = TJAssert min_SepCond min_Containment min_SepGuar min_DSet

newtype SepCond = SepCond { unSepCond :: Set CBasicSepCond }
    deriving (Eq, Ord, Show)
min_SepCond = SepCond emptySet

newtype Containment = Containment { unContainment :: FiniteMap ZAddr (Bool, Set CAddr) }
    deriving (Eq, Ord, Show)
	     -- the Bool is True iff the addresses are portions
min_Containment = Containment emptyFM

newtype SepGuar = SepGuar { unSepGuar :: FiniteMap ZBasicSepCond SepCond }
    deriving (Eq, Ord, Show)
min_SepGuar = SepGuar emptyFM

newtype DSet = DSet { unDSet :: Set CAddr }
    deriving (Eq, Ord, Show)
min_DSet = DSet emptySet

data CBasicSepCond = IMPOSSIBLEsep
		   | SIMPLEsep ZBasicSepCond
		  -- | ARROWsepset (Set ArwsCondImpl) (Set ArwCondCopier)
    deriving (Eq, Ord, Show)

data ZBasicSepCond = AAsep PortionCAddr PortionCAddr
		   | ALONGsep Z2CAddr ZAddr DataNm
		   -- meaning: ALONGsep z2c a dtnm ~ ALONGsepXX (z2c a) (z2c $ AddrDataRec dtnm)
		   | ACROSSsep Z2CAddr ZAddr DataNm

type Z2CAddr = (ZAddr -> CAddr)

data ZBasicSepCondXX = AAsepXX PortionCAddr PortionCAddr
		   | ALONGsepXX PortionCAddr RecTypeCAddr 
		   | ACROSSsepXX PortionCAddr RecTypeCAddr
    deriving (Eq, Ord, Show)

zbsXX (AAsep padr1 padr2) = AAsepXX padr1 padr2
zbsXX (ALONGsep z2c zadr dtnm) =
    ALONGsepXX (PortionCAddr $ z2c zadr) (RecTypeCAddr $ z2c $ AddrDataRec dtnm)
zbsXX (ACROSSsep z2c zadr dtnm) =
    ACROSSsepXX (PortionCAddr $ z2c zadr) (RecTypeCAddr $ z2c $ AddrDataRec dtnm)

instance Eq ZBasicSepCond where
    zbs1 == zbs2 = zbsXX zbs1 == zbsXX zbs2

instance Ord ZBasicSepCond where
    compare zbs1 zbs2 = compare (zbsXX zbs1) (zbsXX zbs2)

instance Show ZBasicSepCond where
    show zbs = show $ zbsXX zbs

aasep padr1 padr2 | padr1 > padr2 = AAsep padr2 padr1
		  | otherwise = AAsep padr1 padr2

{-

data ArwsCondImpl = ArwsCondImpl (Set ArwCond) (Set ArwCond)
    deriving (Eq, Ord, Show)
data ArwCondCopier = ArwCondCopier ArwCond ArwAddrSubst
    deriving (Eq, Ord, Show)

data ArwCond = ArwCond ArrowCAddr ArwAnonCond
    deriving (Eq, Ord, Show)
data ArwAnonCond = PREarwCond
		 | GUARarwCond ZBasicSepCond
    deriving (Eq, Ord, Show)

type ArwAddrSubst = FiniteMap FAddr CAddr

-}

newtype PortionCAddr = PortionCAddr { unPortionCAddr :: CAddr }
    deriving (Eq, Ord, Show)
newtype RecTypeCAddr = RecTypeCAddr { unRecTypeCAddr :: CAddr }
    deriving (Eq, Ord, Show)


{--- type subterm addresses ---}

data CAddr = CAddrNew -- whatever would be allocated during execution (arg portion)
	   | CAddrFree -- whatever is freed during execution (res portion)
	   | CAddr VarNm ZAddr -- argument portion or recursive type constructor
	  -- | CAddrArw VarNm -- function-type argument address
	   | CAddrRes ZAddr -- result portion or recursive type constructor
    deriving (Eq, Ord, Show)

{-
-- like CAddr but using Int instead of VarNm - used inside arrow types
data FAddr = AAddrNew
	   | AAddrFree
	   | AAddr Int ZAddr
	   | AAddrArw Int
	   | AAddrRes ZAddr
    deriving (Eq, Ord, Show)
-}


{--- address mapping ---}

class MapAddr a where
    mapCAddr :: CAddrFn -> a -> a
    mapZAddr :: AddrFn -> a -> a
    mapZAddr f = mapCAddr cf
	where
	cf cadr = case cadr of
		  CAddr x zadr -> CAddr x (f zadr)
		  CAddrRes zadr -> CAddrRes (f zadr)
		  _ -> cadr
    mapVars :: (VarNm -> VarNm) -> a -> a
    mapVars f = mapCAddr cf
	where
	cf cadr = case cadr of
		  CAddr x zadr -> CAddr (f x) zadr
		  _ -> cadr

instance MapAddr CAddr where
    mapCAddr = id

type AddrFn = ZAddr -> ZAddr
type CAddrFn = CAddr -> CAddr

{--
instance MapAddr SepCond where
    mapAddr f (SepCond set) = (SepCond $ mapSet (mapAddr f) set)
    res2ctxt x (SepCond set) = (SepCond $ mapSet (res2ctxt x) set)

instance MapAddr CBasicSepCond where
    mapAddr f sep = case sep of
		    SIMPLEsep zsep -> SIMPLEsep (mapAddr f zsep)
		    _ -> sep
--}

instance MapAddr TJAssert where
    mapCAddr f (TJAssert cond cont guar dset) = TJAssert cond' cont' guar' dset'
	where
	cond' = mapCAddr f cond
	guar' = mapCAddr f guar
	cont' = mapCAddr f cont
	dset' = mapCAddr f dset

instance MapAddr SepCond where
    mapCAddr f (SepCond set) = SepCond $ mapSet (mapCAddr f) set

instance MapAddr NonSep where
    mapCAddr f (NonSep set) = NonSep $ mapSet (mapCAddr f) set

instance MapAddr CBasicSepCond where
    mapCAddr f (SIMPLEsep zbc) = SIMPLEsep $ mapCAddr f zbc
    mapCAddr f sep = sep

instance MapAddr ZBasicSepCond where
    mapCAddr f zsep = case zsep of
		      AAsep adr1 adr2 ->
			  aasep (mapCAddr f adr1) (mapCAddr f adr2)
		      ALONGsep z2c zadr dtnm ->
			  ALONGsep (f . z2c) zadr dtnm
		      ACROSSsep z2c zadr dtnm ->
			  ACROSSsep (f . z2c) zadr dtnm

instance MapAddr SepGuar where
    mapCAddr f (SepGuar guarFM) =
	SepGuar $ mapFM (\ key -> mapCAddr f) guarFM

instance MapAddr PortionCAddr where
    mapCAddr f (PortionCAddr adr) = PortionCAddr (f adr)

instance MapAddr RecTypeCAddr where
    mapCAddr f (RecTypeCAddr adr) = RecTypeCAddr (f adr)

instance MapAddr Containment where
    mapCAddr f (Containment contFM) =
	Containment $ mapFM (\ key (isPortion, set) -> (isPortion, mapSet f set)) contFM

instance MapAddr DSet where
    mapCAddr f (DSet set) = DSet $ mapSet f set

instance (MapAddr a) => (MapAddr [a]) where
    mapCAddr f = map (mapCAddr f)

{--- basic condition mapping ---}

class MapSC a where
    mapSC :: SCfn -> a -> a
    mapZBC :: ZBCFn -> a -> a
    mapZBC f = mapSC fsc
	where
	fsc (SepCond zbcset) = 
	    SepCond $ mkSet $ concat $ map cf $ setToList zbcset
	cf (SIMPLEsep sep) = f sep
	cf othersep = [othersep]

	
type SCfn = (SepCond -> SepCond)
type ZBCFn = (ZBasicSepCond -> [CBasicSepCond])

instance MapSC SepCond where
    mapSC = id

instance MapSC TJAssert where
    mapSC f (TJAssert cond cont guar dset) = TJAssert (f cond) cont guar' dset
	where
	guar' = mapSC f guar

instance MapSC SepGuar where
    mapSC f (SepGuar guarFM) = SepGuar $ mapFM ( \ key -> f ) guarFM


{-----------------------------------------------------}


-- all heap-free types (apart from arrays) are collapsed to UNITty
simplify_ty :: Ty -> Ty
simplify_ty t = s t
    where
    s t = case t of
	  TVARty tv -> UNITty -- error "program not monomorphised..."
	  -- kwxm: problem with polymorphic builtins get & arraylength
	  ARROWty (t1, t2) -> ARROWty (s t1, s t2)
	  -- LISTty t -> LISTty (s t)
	  ARRAYty t -> ARRAYty (s t)
	  CONty (_, dataNm) -> CONty ([], no_dollar_prefix dataNm)
	  PRODUCTty tys -> PRODUCTty (map s tys)
	  DIAMONDty str -> DIAMONDty str
	  _ -> UNITty

no_dollar_prefix s =
    case elemIndex '$' s of
    Nothing -> s
    Just i -> drop (i+1) s

-- if there is anything inconsistent, change it to {IMPOSSIBLEsep}
simplify_cond :: SepCond -> SepCond
simplify_cond cond =
    if consistent then cond else SepCond $ unitSet IMPOSSIBLEsep
	where
	consistent = all consistent_bc $ setToList $ unSepCond cond
	consistent_bc IMPOSSIBLEsep = False
	consistent_bc (SIMPLEsep zbc) = consistent_zbc zbc
	consistent_zbc (AAsep padr1 padr2) = padr1 /= padr2
	consistent_zbc _ = True
		 

-- translation from normal Camelot terms

varName :: VarTy -> VarNm  -- kwxm
varName (VAR (s,t)) = s
varName (UNITvar) = "()"
-- kwxm:  Camelot formal arguments now have type options attached for OO stuff
-- this gets rid of the types

min_annot :: Program -> ProgramA
min_annot (PROG (typedecLs, valdecLs, _IGNORED, funblocks)) =
    PROGA (map doTD typedecLs) valdecLs $ map doFB funblocks -- kwxm
	where
	doFB (FUNblock fundefs) = map doFD fundefs
	doFD (loc, FUNdef (funcnm, varts, inst, expL)) =
	     FUNdefA loc funcnm varts inst $ min_annot_exp (map varName varts) expL
	doTD (loc, TYPEdec (_, dataNm, typeconLs)) = TYPEdecA loc dataNm typeconLs []

min_annot_exp :: [VarNm] -> ExpL -> ExpA
min_annot_exp reserved_vars eL = t reserved_vars eL
    where
    t rvs (loc, e) = ExpA loc ea ty emptyFM min_EAnnot
	where
	ea = case e of
	     VALexp val -> VALexpA val
	     UNARYexp (unop, val) -> UNARYexpA unop val
	     BINexp (binop, val1, val2) -> BINexpA binop val1 val2
	     IFexp (tst, exp1, exp2) ->
		 IFexpA (dotest tst) (t rvs exp1) (t rvs exp2)
	     MATCHexp (x, rules) -> MATCHexpA x $ map (tM rvs) rules
	     LETexp (x, exp1, exp2) -> LETexpA x (t rvs exp1) (t (x:rvs) exp2)
	     APPexp (x, vs, ext) -> APPexpA x vs ext
	     CONexp (var, vals, maybevar) -> CONexpA var vals maybevar
	     TYPEDexp (exp, ty) -> TYPEDexpA (t rvs exp) ty
	     ASSERTexp (exp, conds, guars) -> ASSERTexpA (t rvs exp) conds guars
	     _ -> error $ "Unexpected expression: " ++ show e
	ty = case e of
	     TYPEDexp (_, ty) -> ty
	     _ -> UNITty -- serving as a dummy type here
    tM rvs (loc, MATCHrule (consnmL, varLs, matchdiam, expL)) =
	MATCHruleA loc consnmL varLs matchdiam (t (vars++rvs) expL) -- kwxm
	    where
	    vars = map snd varLs
    tM _ _ = error "Found OOMATCHrule in Camelot_annot.tM"

    dotest (TEST (b, v1, v2)) = TESTA b v1 v2

exp2val (loc, VALexp val) = val
exp2val expL = error $ "expecting a value but got: " ++ (show expL)

mkLet :: Loc
      -> [VarNm] -- vars to avoid
      -> [ExpA] -- expressions to abstract
      -> ([Value] -> ExpAi)  -- expression constructor
      -> ExpAi
mkLet loc reserved_vars [] f = f []
mkLet loc reserved_vars (ea:eas) f =
    case e of
    VALexpA val -> mkLet loc reserved_vars eas (\ vals -> f (val:vals))
    _ -> LETexpA x ea $ ExpA loc restexp UNITty emptyFM min_EAnnot
	where
	x = newvar reserved_vars
	restexp = mkLet loc (x:reserved_vars) eas (\ vals -> f ((VARval x):vals))
    where ExpA _ e _ _ _ = ea

newvar :: [VarNm] -> VarNm
newvar notthese = "v" ++ (show $ (maxidx notthese) + 1)

maxidx :: [VarNm] -> Int
maxidx vars = foldl max 0 $ map getvaridx vars

getvaridx :: VarNm -> Int
getvaridx (char:digits) = case readDec digits of [] -> 0
						 ((i,_):_) -> i
getvaridx [] = error "in getvaridx: bad syntax"

-- test for and report functions with inconsistent preconditions

report_status :: ProgramA -> IO Bool
report_status aprg =
    case bad_fns
	 of [] -> return True
	    _ ->
		do
		putStrLn "Inconsistent preconditions derived for functions:"
		mapM putStrLn $ bad_fns
		return False
    where
    bad_fns = mk_bad_fns aprg
    mk_bad_fns (PROGA _ _ funblocks) =
	concat $ map  chk_funblock funblocks
    chk_funblock fundefs = (map get_funcNm . filter bad_fundef) fundefs
    bad_fundef (FUNdefA _ _ _ _ (ExpA _ _ _ _ (EAnnot (TJAssert cond _ _ _) _ _))) =
	IMPOSSIBLEsep `elementOf` (unSepCond cond)
    get_funcNm (FUNdefA _ funcnm _ _ _) = funcnm
					      
-- translation to normal Camelot terms + assembling of assertions

deannot :: ProgramA -> Program
deannot (PROGA typedecs valdecs funblocks) =
    PROG ((map doTD typedecs), valdecs, [], map doFB funblocks)  -- kwxm
	where
	doFB (fundefs) = FUNblock (map doFD fundefs)
	doFD (FUNdefA loc funcnm vars inst aexp) =
	    (loc, FUNdef (funcnm, vars, inst, deannot_exp aexp))  -- kwxm
	doTD (TYPEdecA loc dataNm typeconLs _) =
	    (loc, TYPEdec ([], dataNm, typeconLs))
	    
deannot_exp :: ExpA -> ExpL
deannot_exp (ExpA loc ea ty _ annot) = (loc, ASSERTexp ((loc, e), conds, guars))
    where
    e = case ea of
	VALexpA val -> VALexp val
	UNARYexpA unop val -> UNARYexp (unop, val)
	BINexpA binop val1 val2 -> BINexp (binop, val1, val2)
	IFexpA tst exp1 exp2 -> IFexp (deannot_test tst, (deannot_exp exp1), (deannot_exp exp2))
	MATCHexpA x rules -> MATCHexp (x, map tM rules)
	LETexpA x exp1 exp2 -> LETexp (x, (deannot_exp exp1), (deannot_exp exp2))
	APPexpA x vals ext -> APPexp (x, vals, ext)
	CONexpA x vals maybevar -> CONexp (x, vals, maybevar)
	TYPEDexpA exp t -> TYPEDexp (deannot_exp exp,t)
	ASSERTexpA exp _ _ -> e
	    where
	    (_, ASSERTexp ((_, e), _, _)) = deannot_exp exp
	where
	tM (MATCHruleA loc consnmL varLs matchdiam exp) =
	    (loc, MATCHrule (consnmL, varLs, matchdiam, (deannot_exp exp)))
	valexpL v = (loc, VALexp v)
    (prev_conds, prev_guars) =
	case ea of
		ASSERTexpA exp conds1 guars1 ->
		    (conds2 ++ conds1, guars2 ++ guars1)
			where
			(_, ASSERTexp ((_, _), conds2, guars2)) = deannot_exp exp
		_ -> ([], [])
    conds = (mkAssns cond) ++ prev_conds
    guars = (mkAssns guar) ++ prev_guars -- make sure guar is complete - all zbseps have a value
    (EAnnot (TJAssert cond cont guar dset) _ _) = annot

deannot_test :: TestA -> Test
deannot_test (TESTA oper val1 val2) = TEST(oper, val1, val2)

class MkAssns a where
    mkAssns :: a -> [Assn]

instance MkAssns SepGuar where
    mkAssns guar =
	concat $ map f $ fmToList $ unSepGuar guar
	{- all basic assertions with trivial precondition have to be made present too -}
	    where
	    f (zbsep, cond) =
		case condAssns of
		[] -> [zbsepAssn]
		[ASSNfalse] -> []
		_ -> [ASSNimplies (condAssn, zbsepAssn)]
		where
		condAssn = foldr1 (\ a b -> ASSNand (a,b)) condAssns
		condAssns = mkAssns cond
		zbsepAssn = head $ mkAssns zbsep

instance MkAssns SepCond where
    mkAssns cond =
	concat $ map mkAssns $ setToList $ unSepCond cond
    
instance MkAssns CBasicSepCond where
    mkAssns IMPOSSIBLEsep = [ASSNfalse]
    mkAssns (SIMPLEsep zbsep) = mkAssns zbsep

instance MkAssns ZBasicSepCond where
    mkAssns zbsep = mkAssns $ zbsXX zbsep

instance MkAssns ZBasicSepCondXX where
    mkAssns (AAsepXX padr1 padr2) =
	[ASSNsep (mkPortion padr1, mkPortion padr2)]
    mkAssns (ALONGsepXX padr radr) =
	[ASSNalong (mkPortion padr, port2zadr $ mkPortion radr)]
    mkAssns (ACROSSsepXX padr radr) =
	[ASSNacross (mkPortion padr, port2zadr $ mkPortion radr)]

port2zadr (ReprArg (zadr, _)) = zadr
port2zadr (ReprRes zadr) = zadr

class MkPortion a where
    mkPortion :: a -> Portion

instance MkPortion PortionCAddr where
    mkPortion = mkPortion . unPortionCAddr

instance MkPortion RecTypeCAddr where
    mkPortion = mkPortion . unRecTypeCAddr

instance MkPortion CAddr where
    mkPortion (CAddr var zadr) = ReprArg (zadr, var)
    mkPortion (CAddrRes zadr) = ReprRes zadr
    mkPortion _ = error "in mkPortion/CAddr"

