import java.lang.String;
class GraphTest{
  private static void GraphOutput(Graph G){
        System.out.println("Begin of GraphOutput");
        System.out.println("Traversing Nodes:");	
        List L = G.Nodes;
        while (true) {
          if (L.tag == 0) {
             System.out.println("End of list");
             break;
          } else {
             System.out.println(((Node)L.head).ID);
             L = L.tail;
          }
        }
        System.out.println("Traversing Edges:");	
        L = G.Edges;	
        while (true) {
          if (L.tag == 0) {
             System.out.println("End of list");
             break;
          } else {
             System.out.println(((Edge)L.head).ID);
             L = L.tail;
          }
        }
        System.out.println("End of GraphOutput");
  }

  public static void main (String[] arg) {
        //creat graph
        Graph G = new Graph();

        //add empty lists of nodes and edges. Once we have constructors,
        // this would be part of  creating a new Graph.
        //If we don't add these empty lists, List.member (called from addNode) 
        //will run into a nullPointer exception
        List Nodes = new List();
        List Edges = new List();
        G.Nodes = Nodes;
        G.Edges = Edges;

        Node N1 = new Node(); N1.ID = "Node 1";
        Node N2 = new Node(); N2.ID = "Node 2";
	Node N3 = new Node(); N3.ID = "Node 3";
	Node N4 = new Node(); N4.ID = "Node 4";
	Node N5 = new Node(); N5.ID = "Node 5";
	Node N6 = new Node(); N6.ID = "Node 6";

	System.out.println("Now adding nodes 1 and 2...");
     
        Graph G1 = Graph.addNode(G,N1);
        System.out.println("...N1 added");

        Graph G2 = Graph.addNode(G,N2);
        System.out.println("...N2 added");

        //This is just to check that parameter passing works. 
        //Both pointer identities should hold.
        if (G1 == G) {
	  System.out.println("G1 == G holds.");
	} else {
	  System.out.println("G1 == G does not hold.");
	} 
        if (G2 == G1) {
	  System.out.println("G2 == G1 holds.");
	} else {
	  System.out.println("G2 == G1 does not hold.");
	} 

        //Output G
        GraphOutput(G);

        System.out.println("Adding edge 1->2");
        Edge E12 = new Edge(); 
        E12.ID = "Edge 12";
        E12.source = N1;
        E12.target = N2;
        G = Graph.addEdge(G,E12);
        GraphOutput(G);

        System.out.println("Adding edge 1->3");
        Edge E13 = new Edge(); E13.ID = "Edge 13";
        E13.source = N1;
        E13.target = N3;
        G = Graph.addEdge(G,E13);
        GraphOutput(G);
        
        System.out.println("Adding edge 4->2");
        Edge E42 = new Edge(); E42.ID = "Edge 42";
        E42.source = N4;
        E42.target = N2;
        G = Graph.addEdge(G,E42);
        GraphOutput(G);
        
        System.out.println("Adding edge 5->6");
        Edge E56 = new Edge(); E56.ID = "Edge 56";
        E56.source = N5;
        E56.target = N6;
        G = Graph.addEdge(G,E56);
        GraphOutput(G);
  }
}