%{
   open Syntax
   open Support.Error
     
   let actual = ref "No further parse error information available"
   let parse_error s = 
     raise (Failure (!actual))
     (* print_string ("\n\n Details: "^(!actual)^".\n\n") *)
%}

/* 

   Authors:  Steffen Jost  <jost@informatik.uni-muenchen.de>
	     using a template file from
	     David Aspinall	<da@dcs.ed.ac.uk> and
	     Martin Hofmann	<mhofmann@informatik.uni-muenchen.de> 
   Name:     $Name:  $
   File:     $RCSfile: parser.mly,v $
   Id:       $Id: parser.mly,v 1.11 2004/03/17 10:52:23 sjost Exp $ 

   This module contains the rules to generate a parser for the
   abstract syntax vir ocamlyacc.



   NOTE:
       Since the grammar of LF_<> restricts some subexpressions to values,
       we run into some problems here as both expression and values
       may be contained within parenthesis. Therefore this grammar-file
       becomes unusually complicated! 
       (Or maybe I'm just too stupid, as I havent done something like this before, 
        but it works and I dont want to waste much more time on this)


   TODOs: 

       - Resolve the two remaining reduce/reduce conflicts. As far as I can see, they are not harmful.
    
       - We just ignored SupportErroInfo, 
         i.e. always $1.v instead of $1
         Use it to give better Parse-Errors!!! 

       - Maybe document all differences to current Camelot

*/

/* Ordered by appearance as in lexer.mll */
%token <Support.Error.info> EOF
%token <int Support.Error.withinfo> DIASIZE
%token <string Support.Error.withinfo> 	IDENTIFIER
%token <string Support.Error.withinfo> 	CONSTRUCTOR
/* KEYWORDS ARE DEFINED BELOW */
%token <string Support.Error.withinfo> 	TYPEVAR
%token <Support.Error.info> 		UNITVAL
%token <int    Support.Error.withinfo> 	INTVAL
%token <float  Support.Error.withinfo> 	FLOATVAL
%token <char   Support.Error.withinfo> 	CHARVAL
%token <string Support.Error.withinfo> 	STRINGVAL
/* Den Unterschied zwischen QUOTEVAL und STRINGVAL in Camelot habe ich nicht verstanden.
   Deshalb ignoriere ich QUOTEVAL. 
   Das STRINGVAL als ein beliebiges unidentifiziertes KEYWORD definiert ist,
   finde ich auch ziemlich komisch, das mache ich anders, also so wie QUOTEVAL,
   so das ich letztendlich also STRINGVAL und nicht QUOTEVAL ignoriere! 
*/
%token <Support.Error.info> EQUALS
%token <Support.Error.info> LESS
%token <Support.Error.info> GREATER
%token <Support.Error.info> DIAMOND
%token <Support.Error.info> LTEQ
%token <Support.Error.info> GTEQ
%token <Support.Error.info> ARROW
%token <Support.Error.info> WARROW	
%token <Support.Error.info> LPAREN
%token <Support.Error.info> RPAREN
%token <Support.Error.info> EMPTYPAREN
%token <Support.Error.info> LBRACE
%token <Support.Error.info> RBRACE
%token <Support.Error.info> LBRAK
%token <Support.Error.info> RBRAK
%token <Support.Error.info> COMMA
%token <Support.Error.info> COLON 
%token <Support.Error.info> SEMICOLON
/* AND is also a keyword */
%token <Support.Error.info> BAR
%token <Support.Error.info> AT
%token <Support.Error.info> BANG
%token <Support.Error.info> DOLLAR
%token <Support.Error.info> SHARP
%token <Support.Error.info> POUND
%token <Support.Error.info> PARAGRAPH
/* %token <Support.Error.info> USCORE   This token was removed. */
%token <Support.Error.info> CARET
%token <Support.Error.info> PLUS 
%token <Support.Error.info> MINUS
%token <Support.Error.info> TIMES
%token <Support.Error.info> DIVIDE
%token <Support.Error.info> FPLUS 
%token <Support.Error.info> FMINUS
%token <Support.Error.info> FTIMES
%token <Support.Error.info> FDIVIDE
%token UMINUS
/* KEYWORDS */
%token <Support.Error.info> UNIT
%token <Support.Error.info> BOOL
%token <Support.Error.info> INTEGER
%token <Support.Error.info> FLOAT
%token <Support.Error.info> ARRAY
%token <Support.Error.info> CHAR
%token <Support.Error.info> STRING

%token <Support.Error.info> TYPE
%token <Support.Error.info> VAL
%token <Support.Error.info> ANNVAL
%token <Support.Error.info> OF

%token <Support.Error.info> TRUEVAL
%token <Support.Error.info> FALSEVAL

%token <Support.Error.info> BOOL
%token <Support.Error.info> NOT
%token <Support.Error.info> LAND
%token <Support.Error.info> LOR
%token <Support.Error.info> ANDALSO
%token <Support.Error.info> ORELSE
%token <Support.Error.info> MOD

%token <Support.Error.info> BEGIN
%token <Support.Error.info> END
%token <Support.Error.info> IF
%token <Support.Error.info> THEN
%token <Support.Error.info> ELSE
%token <Support.Error.info> MATCH
%token <Support.Error.info> MATCHPR
%token <Support.Error.info> WITH
%token <Support.Error.info> LET
%token <Support.Error.info> AND
%token <Support.Error.info> REC
%token <Support.Error.info> IN
%token <Support.Error.info> WHERE
%token <Support.Error.info> FUN

/* Das sind eigentlich keine Keywords, sondern Built-in functions die ich
   erst bei der Prfung der Identifier abfange... 
 %token <Support.Error.info> INT_OF_FLOAT
 %token <Support.Error.info> FLOAT_OF_INT
 %token <Support.Error.info> CHAR_OF_INT
 %token <Support.Error.info> INT_OF_CHAR
 %token <Support.Error.info> FLOAT_OF_STRING
 %token <Support.Error.info> STRING_OF_FLOAT
 %token <Support.Error.info> INT_OF_STRING
 %token <Support.Error.info> STRING_OF_INT
 %token <Support.Error.info> PRINT_OF_INT
 %token <Support.Error.info> PRINT_OF_FLOAT
 %token <Support.Error.info> PRINT_OF_CHAR
 %token <Support.Error.info> PRINT_OF_STRING
 %token <Support.Error.info> ARRAY_HEAD
*/


/* Operatorsymbole in aufsteigender Prioritt */
%nonassoc LET AND REC IN
%nonassoc MATCH MATCHPR WITH WARROW
%nonassoc IF THEN ELSE
%nonassoc COLON
%nonassoc ARRAY
%left WHERE
%right SEMICOLON COMMA
%right ARROW
%left ANDALSO ORELSE
%left LAND LOR  
%right NOT
%nonassoc EQUALS LESS GREATER LTEQ GTEQ
%left CARET /* String append */
%left PLUS MINUS FPLUS FMINUS
%left TIMES DIVIDE FTIMES FDIVIDE 
%nonassoc MOD
%nonassoc UMINUS UFMINUS


/* Starting symbols (must have type) */
%start pprogram
%type <Syntax.program> pprogram


%%

typname: /* Names of user-types may be upper or lower case */ 
	    IDENTIFIER   { $1 }
	|   CONSTRUCTOR  { $1 }
;

pprogram: 
	  ptypdeclist pvaldeclist pfundeflist EOF { Program($4,$1,$2,$3) }
;

ptypdeclist:
					{ [] }
	| ptypdec ptypdeclist		{ $1 :: $2 }
;

ptypdec:
	  TYPE ptypevarlist typname EQUALS pconstructordeclist psemicolonopt
		{ TypDec($1,$2,$3.v,$5) }
;

ptypevarlist:
	  			{ [] }
	| TYPEVAR ptypevarlist	{ $1.v :: $2 }
;

pconstructordeclist:	
	  pconstructordec				{ $1 :: [] }
	| pconstructordec BAR pconstructordeclist	{ $1 :: $3 }
;

pconstructordec:		
	   CONSTRUCTOR pconstrsize 				{ (if $2 = Syntax.Unspecified then Support.Error.warningAt $1.i "Unspecified Constructor size, using default size.");
                                                                  TypCon($1.i,$1.v,$2,[]) }
	|  BANG CONSTRUCTOR 	                                { TypCon($2.i,$2.v,Syntax.Specified(0),[]) }
	|  CONSTRUCTOR pconstrsize OF ptypedeclist	        { (if $2 = Syntax.Unspecified then Support.Error.warningAt $1.i "Unspecified Constructor size, using default size.");
								  TypCon($1.i,$1.v,$2,$4) }
;


pconstrsize:
	                        { Syntax.Unspecified }
	| DIASIZE               { Syntax.Specified($1.v) }
;


ptypedeclist:		/* Teil einer Typeklaration */
	  ptype		     		{ $1 :: [] } 
	| ptype TIMES ptypedeclist	{ $1 :: $3 }
;

pvaldeclist:
				{ [] }
	| pvaldec pvaldeclist	{ $1 :: $2 }
;

pvaldec:  
	  VAL typname COLON ptype psemicolonopt 	
	    { ValDec($1,$2.v,$4) }
	| ANNVAL typname COLON pdianumopt COMMA prtype COMMA pdianumopt psemicolonopt
	    { AnnValDec($1,$2.v,$4,$6,$8) }
;

psemicolonopt: /* There might be a semicolon, but it is not necessary */
	            { }
	| SEMICOLON { }
;

pdianum: /* Deprecated. Move into pdianumopt! */
	  LESS FLOATVAL GREATER { $2.v }
	| LESS   INTVAL GREATER { float_of_int($2.v) }
;

pdianumopt:
          pdianum             { Some $1 }
	| TIMES               { None    }
	| LESS TIMES GREATER  { None    } /* For convenience */
;

ptype: ptype_ { actual:= "Expecting a type here.";$1 }
ptype_:
	  psubtype			{ $1 }
	| ptype ARROW ptype	 	{ {i=$2; v=ArrowTyp($1,$3)} }   /* Erlaubt leider auch Higher-Order Types, die wir nicht behandeln knnen */
	| ptype ARRAY			{ {i=$2; v=ArrayTyp($1)} }      /* Arrays kennen wir eigentlich nicht! */
	| psubtypelist typname 	        { {i=$2.i; v=ConTyp($1,$2.v)} } /* Generische Konstruktor typen */
;

psubtypelist:
	  			{ [] }
	| psubtype psubtypelist	{ $1::$2 }
;


psubtype: psubtype_ { actual:= "Expecting a base type here. Other types must be enclosed in parenthesis.";$1 }
psubtype_:
	  UNIT				{ {i=$1; v=UnitTyp} }
	| DIAMOND			{ {i=$1; v=DiamondTyp} }
	| BOOL				{ {i=$1; v=BoolTyp} }
	| INTEGER			{ {i=$1; v=IntTyp} }
	| FLOAT				{ {i=$1; v=FloatTyp} }
	| CHAR				{ {i=$1; v=CharTyp} }
	| STRING			{ {i=$1; v=StringTyp} }
	| TYPEVAR			{ {i=$1.i; v=TvarTyp($1.v)} }
	| LPAREN ptype RPAREN		{ $2 }
;


prtype: /* Syntax.rich_type - does not contain any 'info'-elements 
           The idea is, that the user already states the wanted rich_type.
	   However, not all necessary informations are already computed,
	   hence the rich_type is not really valid and must be completed
           by Constraint.complete_annval_rt. This is a hack, yes. :-(
	*/
	  psubrbasetype			{ $1 }
	| prtype ARROW prtype	 	{ RArrowTyp($1,$3) }   /* Does not exclude Higher-Order Types, which we cant treat so far! */
	| psubrtypelist typname LBRAK pconrtlist RBRAK	       
                                        { RConTyp($1,$2.v,$4) } 
    /*	| prtype ARRAY	      	        { RArrayTyp($1) }         Arrays are not implemented yet! */
;

prrectype: /* A limited prtype, where constructor types are not allowed to have parameters in front. 
              Saves some parenthesis in the source code. */
   typname LBRAK pconrtlist RBRAK       { RConTyp([],$1.v,$3) } 
;


pconrtlist: /* Syntax.rt_contab */
	  pconrtarg pconrtlistend
	    {
 	     let (cnstr,rcinf) = $1 in
	     ConTab.add cnstr rcinf $2 
	   }
;
pconrtlistend: /* Syntax.rt_contab */
	                 { ConTab.empty }
	| BAR pconrtlist { $2 }
;

pconrtarg: /* (constructor * Syntax.rich_coninfo) */
          CONSTRUCTOR LPAREN pconrtarglist RPAREN
            { let (args, d) = $3 in 
	      ($1.v,
	       {
		rcvar = 
		(
		 match d with 
		 | None   -> "None"
		 | Some c -> string_of_float c
		); (* Must be converted back into a proper constant -> lp_solve does not accept linear arithmetic expressions as factors *)
		rorder = 0;                (* UNKNOWN!   0 denotes unknown order *)
		rarg_types = args;         (* May contain incomplete subdata *)
		rsize = Unspecified        (* UNKNOWN! *)  
	      }
	      )
	    }
;

pconrtarglist: /* (rich_typ list * float ) */
          pdianumopt                         { ([], $1) }
	| psubrtypeself COMMA pconrtarglist  { let (args, d) = $3 in (($1::args), d) }
;

psubrtypelist:
	                            { [] }
	|  psubrbasetype psubrtypelist  { $1::$2 }
;

/*
psubrtype:
	  psubrbasetype                 { $1 }
	| prrectype                     { $1 }
;
*/

psubrbasetype: psubrbasetype_ { actual:= "Expecting a base type here. Rich types must be enclosed in parenthesis.";$1 }
psubrbasetype_:
	  UNIT				{ RUnitTyp }
	| DIAMOND			{ RDiamantTyp }
	| BOOL				{ RBoolTyp }
	| INTEGER			{ RIntTyp }
	| FLOAT				{ RFloatTyp }
	| CHAR				{ RCharTyp }
	| STRING			{ RStringTyp }
/*	| TYPEVAR			{ {i=$1.i; v=TvarTyp($1.v)} } */
	| LPAREN prtype RPAREN		{ $2 }
;


psubrtypeself: 
          SHARP                         { rSelfTypUnknown }
	| prrectype                     { $1 }
	| psubrbasetype                 { $1 }
;


/* END of the ANNVAL-RICHTYPE-HACK */


pfundeflist:
	  				{ [] }
	| pfundef pfundeflist 		{ $1::$2 }	
;

pfundef:
	  LET precopt IDENTIFIER pvarlist EQUALS pexpression pandfundef	{ FunctionDef($1,$3.v,$4,$6) :: $7 }
;

pandfundef:
									{ [] }
	| AND         IDENTIFIER pvarlist EQUALS pexpression pandfundef	{ FunctionDef($1,$2.v,$3,$5) :: $6 }
;

precopt: /* Es darf ein REC kommen, muss aber nicht */
		{ }
	| REC	{ }
;

pexpression:
	  MATCH IDENTIFIER WITH pbaropt pmatchrulelist  	{ {i=$1; v=MatchExp($2.v,$5)}  }
/*	| psubexpression WHERE IDENTIFIER EQUALS pexpression	{ {i=$2; v=LetExp($3.v,$5,$1)} }   More Haskell-like convenience  */
	| psubexpression		                        { $1 } 
;

/* 
   Die obige Unterteilung ist notwendig, da bei aufeinanderfolgenden Matches die jeweiligen 
   Matchrules nicht korrekt zugeordnet werden knnen...
*/


pbaropt: /* Hier darf ein BAR kommen, muss aber nicht */
		{ }
	| BAR	{ }
;

at_loc: /* There is no need to distinguish it in this program, except for sandboxing */
  AT IDENTIFIER         
  { 
    let s = $2.v in 
    if (s = "_") 
    then (Syntax.New) 
    else (Syntax.Reuse(s))
  } 
;
/* Deprecated, since now USCORES are produced by Lexer anymore:
  AT USCORE             { Syntax.New }
| AT IDENTIFIER         { Syntax.Reuse($2.v) } 
*/


anyarrow:
     WARROW     { $1 }  /* For compatibility with OCAML... */
   |  ARROW     { $1 }  /* ...and for convenience.         */

pmatchrulelist:
	  pmatchrule				{ [$1] }
	| pmatchrule BAR pmatchrulelist		{ $1::$3 }
;

pmatchrule: pmatchrule_ { actual:= "Expecting a constructor for a pattern match rule here.";$1 }
pmatchrule_:
      CONSTRUCTOR pvarargs        anyarrow psubexpression   { Matchrule($3,$1.v,$2,true ,$4,Syntax.Void) } 
   |  CONSTRUCTOR pvarargs at_loc anyarrow psubexpression   { Matchrule($4,$1.v,$2,false,$5,$3) } 
;

psubexpression: psubexpression_ { actual:= "Expecting a subexpression. Other expressions must be enclosed by parenthesis here.";$1 }
psubexpression_:
	  IF pvalue_ext THEN pexpression ELSE psubexpression
					        { {i=$1; v=IfExp($2,$4,$6)} }
	| LET IDENTIFIER EQUALS pexpression IN psubexpression 
					        { if $2.v = "_" 
						  then {i=$1; v=SeqExp($4,$6)} 
						  else {i=$1; v=LetExp($2.v,$4,$6)} 
						}  /* Deprecated, as lexer does not identify USCORE anymore: | LET USCORE EQUALS pexpression IN psubexpression { {i=$1; v=SeqExp($4,$6)} } */
	| psubexpression SEMICOLON psubexpression	
	                                        { {i=$2; v=SeqExp($1,$3)} }
	| IDENTIFIER  pvaluelistnotempty 	{ {i=$1.i; v=AppExp($1.v,$2)} }        /* Function call */
	| CONSTRUCTOR pvalueargs  	        { {i=$1.i; v=ConstrExp($1.v,$2,Syntax.New)} }     /* Constructor application */
	| CONSTRUCTOR pvalueargs at_loc	        { {i=$1.i; v=ConstrExp($1.v,$2,$3)} }     /* Constructor application */
	| pvalue_exp                            { $1 }
;

pvalue_exp: pvalue_exp_ { actual:= "Expecting an atomic value. Arithmetic expressions must be enclosed in parenthesis here.";$1 }
pvalue_exp_: 
        | pvalue                              { {i=$1.i; v=ValueExp($1)} } 
	| LPAREN pexpression RPAREN           { $2 }
	| BEGIN pexpression END               { $2 }
;


pvalue:  /* Parenthesis are NOT an option... */
	  patomicvalue                            { let _ = actual := "Expecting an atomic value. Arithmetic expressions must be enclosed in parenthesis here."  in $1 } 
        | LPAREN pvalue_ext RPAREN                { $2 } 
/*
        | pvalue_ext_nonatomic                    { $1 }
        | LPAREN pvalue_ext_nonatomic RPAREN      { $2 } 
*/
;

pvalue_ext:
	  patomicvalue                          { $1 }
	| LPAREN pvalue_ext RPAREN               { $2 }
	| MINUS	 %prec UMINUS  pvalue_ext { {i=$1; v=UnaryOpVal({i=$1; v=UMinusOp },$2) } }
	| FMINUS %prec UFMINUS pvalue_ext { {i=$1; v=UnaryOpVal({i=$1; v=UFminusOp},$2) } }
	| NOT  		       pvalue_ext { {i=$1; v=UnaryOpVal({i=$1; v=NotOp},$2) } }
	| pvalue_ext TIMES   pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=TimesOp  },$1,$3)} } 
	| pvalue_ext DIVIDE  pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=DivOp    },$1,$3)} } 
	| pvalue_ext PLUS    pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=PlusOp   },$1,$3)} } 
	| pvalue_ext MINUS   pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=MinusOp  },$1,$3)} } 
	| pvalue_ext FTIMES  pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=FtimesOp },$1,$3)} } 
	| pvalue_ext FDIVIDE pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=FdivOp   },$1,$3)} } 
	| pvalue_ext FPLUS   pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=FplusOp  },$1,$3)} } 
	| pvalue_ext FMINUS  pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=FminusOp },$1,$3)} } 
	| pvalue_ext LESS    pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=LessOp   },$1,$3)} } 
	| pvalue_ext LTEQ    pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=LteqOp   },$1,$3)} } 
	| pvalue_ext GREATER pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=GreaterOp},$1,$3)} } 
	| pvalue_ext GTEQ    pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=GteqOp   },$1,$3)} } 
	| pvalue_ext EQUALS  pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=EqualOp  },$1,$3)} } 
	| pvalue_ext CARET   pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=AppendOp },$1,$3)} } 
	| pvalue_ext LAND    pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=AndOp    },$1,$3)} } 
	| pvalue_ext LOR     pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=OrOp     },$1,$3)} } 
	| pvalue_ext ANDALSO pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=AndalsoOp},$1,$3)} } 
	| pvalue_ext ORELSE  pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=OrelseOp },$1,$3)} } 
	| pvalue_ext MOD     pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=ModOp },$1,$3)} } 
;

/* This was another nice try that didnt work out... :-( 
pvalue_ext_nopar:
	  patomicvalue { $1 } 
	| MINUS	 %prec UMINUS  pvalue_ext { {i=$1; v=UnaryOpVal({i=$1; v=UMinusOp },$2) } }
	| FMINUS %prec UFMINUS pvalue_ext { {i=$1; v=UnaryOpVal({i=$1; v=UFminusOp},$2) } }
	| NOT  		       pvalue_ext { {i=$1; v=UnaryOpVal({i=$1; v=NotOp},$2) } }
	| pvalue_ext TIMES   pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=TimesOp  },$1,$3)} } 
	| pvalue_ext DIVIDE  pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=DivOp    },$1,$3)} } 
	| pvalue_ext PLUS    pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=PlusOp   },$1,$3)} } 
	| pvalue_ext MINUS   pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=MinusOp  },$1,$3)} } 
	| pvalue_ext FTIMES  pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=FtimesOp },$1,$3)} } 
	| pvalue_ext FDIVIDE pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=FdivOp   },$1,$3)} } 
	| pvalue_ext FPLUS   pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=FplusOp  },$1,$3)} } 
	| pvalue_ext FMINUS  pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=FminusOp },$1,$3)} } 
	| pvalue_ext LESS    pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=LessOp   },$1,$3)} } 
	| pvalue_ext LTEQ    pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=LteqOp   },$1,$3)} } 
	| pvalue_ext GREATER pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=GreaterOp},$1,$3)} } 
	| pvalue_ext GTEQ    pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=GteqOp   },$1,$3)} } 
	| pvalue_ext EQUALS  pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=EqualOp  },$1,$3)} } 
	| pvalue_ext CARET   pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=AppendOp },$1,$3)} } 
	| pvalue_ext LAND    pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=AndOp    },$1,$3)} } 
	| pvalue_ext LOR     pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=OrOp     },$1,$3)} } 
	| pvalue_ext ANDALSO pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=AndalsoOp},$1,$3)} } 
	| pvalue_ext ORELSE  pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=OrelseOp },$1,$3)} } 
	| pvalue_ext MOD     pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=ModOp },$1,$3)} } 
	| MINUS	 %prec UMINUS  pvalue { {i=$1; v=UnaryOpVal({i=$1; v=UMinusOp },$2) } }
	| FMINUS %prec UFMINUS pvalue { {i=$1; v=UnaryOpVal({i=$1; v=UFminusOp},$2) } }
	| NOT  		       pvalue { {i=$1; v=UnaryOpVal({i=$1; v=NotOp},$2) } }
	| pvalue TIMES   pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=TimesOp  },$1,$3)} } 
	| pvalue DIVIDE  pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=DivOp    },$1,$3)} } 
	| pvalue PLUS    pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=PlusOp   },$1,$3)} } 
	| pvalue MINUS   pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=MinusOp  },$1,$3)} } 
	| pvalue FTIMES  pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=FtimesOp },$1,$3)} } 
	| pvalue FDIVIDE pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=FdivOp   },$1,$3)} } 
	| pvalue FPLUS   pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=FplusOp  },$1,$3)} } 
	| pvalue FMINUS  pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=FminusOp },$1,$3)} } 
	| pvalue LESS    pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=LessOp   },$1,$3)} } 
	| pvalue LTEQ    pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=LteqOp   },$1,$3)} } 
	| pvalue GREATER pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=GreaterOp},$1,$3)} } 
	| pvalue GTEQ    pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=GteqOp   },$1,$3)} } 
	| pvalue EQUALS  pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=EqualOp  },$1,$3)} } 
	| pvalue CARET   pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=AppendOp },$1,$3)} } 
	| pvalue LAND    pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=AndOp    },$1,$3)} } 
	| pvalue LOR     pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=OrOp     },$1,$3)} } 
	| pvalue ANDALSO pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=AndalsoOp},$1,$3)} } 
	| pvalue ORELSE  pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=OrelseOp },$1,$3)} } 
	| pvalue MOD     pvalue       { {i=$2; v=BinaryOpVal({i=$2; v=ModOp    },$1,$3)} } 
;	 
*/   

/* This doesnt work either with the associativity mechanism:
[pvalue_ext:]
	| pvalue pbinop pvalue       { {i=$2.i; v=BinaryOpVal($2,$1,$3)} } 
	| pvalue_ext pbinop pvalue_ext { {i=$2.i; v=BinaryOpVal($2,$1,$3)} } 
pbinop:
	|  TIMES 	{ {i=$1; v=TimesOp} }
	|  DIVIDE 	{ {i=$1; v=DivOp} }
	|  PLUS 	{ {i=$1; v=PlusOp} }
	|  MINUS  	{ {i=$1; v=MinusOp} }
	|  FTIMES 	{ {i=$1; v=FtimesOp} }
	|  FDIVIDE  	{ {i=$1; v=FdivOp} }
	|  FPLUS 	{ {i=$1; v=FplusOp} }
	|  FMINUS 	{ {i=$1; v=FminusOp} }
	|  LESS 	{ {i=$1; v=LessOp} }
	|  LTEQ  	{ {i=$1; v=LteqOp} }
	|  GREATER 	{ {i=$1; v=GreaterOp} }
	|  GTEQ 	{ {i=$1; v=GteqOp} }
	|  EQUALS 	{ {i=$1; v=EqualOp} }
	|  CARET 	{ {i=$1; v=AppendOp} }
	|  LAND 	{ {i=$1; v=AndOp} }  * AND/LAND: both tokens represent "and", but AND must be at the beginning of a line. Additionally, LAND maybe a string like "&&" or "&" *
	|  LOR 	        { {i=$1; v=OrOp} }
	|  ANDALSO   	{ {i=$1; v=AndalsoOp} }
	|  ORELSE  	{ {i=$1; v=OrelseOp} }
;
punaop:
	| MINUS	%prec UMINUS  	{ {i=$1; v=UMinusOp} }
	| FMINUS %prec UFMINUS  { {i=$1; v=UFminusOp} }
	| NOT  			{ {i=$1; v=NotOp} }
;
*/


patomicvalue:
	  IDENTIFIER			{ {i=$1.i; v=VarVal($1.v)} } /* Could also be a 0-arity function call, but should not be! */
	| INTVAL			{ {i=$1.i; v=IntVal($1.v)} }
	| FLOATVAL			{ {i=$1.i; v=FloatVal($1.v)} }
	| CHARVAL			{ {i=$1.i; v=CharVal($1.v)} }
	| STRINGVAL			{ {i=$1.i; v=StringVal($1.v)} }
	| TRUEVAL			{ {i=$1; v=BoolVal(true)} }
	| FALSEVAL			{ {i=$1; v=BoolVal(false)} } 
	| UNITVAL			{ {i=$1; v=UnitVal} }        
;


/*
 For compatibility with CAMELOT, we must distinguish to kinds of argument lists:
 	list - lists like " a b c d ", " a ", " " 
   	args - lists like "(a,b,c,d)", "(a)", "()" or " "
 note that an arg-list consiting of a single unit argmuent must be written as "(())" 
*/

pvaluelist:
	                        { [] }
   |   pvalue pvaluelist	{ $1::$2 }
;

pvaluelistnotempty:
       pvalue pvaluelist	{ $1::$2 }                    
;

pvalueargs:
	                                       	 	{ [] }
	| EMPTYPAREN                           	 	{ [] }
	| UNITVAL                              	 	{ [] } /* Special Case: if there is a single argument of type unit, it must be enclosed in parenthesis in an argument-list */	
	| LPAREN RPAREN                       	 	{ [] }
	| LPAREN pvalue_ext pvalueargsaux RPAREN	{ $2 :: $3 }
;

pvalueargsaux:
	      					{ [] } 	
	| COMMA pvalue_ext pvalueargsaux  	{ $2 :: $3 }
;

pvarlist:
	  				{ [] }
	| IDENTIFIER pvarlist		{ $1.v :: $2 }
;

pvarargs: 
	                                        { [] }
	| EMPTYPAREN                            { [] }
	| UNITVAL                               { [] } /* Special Case: if there is a single argument of type unit, it must be enclosed in parenthesis in an argument-list */	
	| LPAREN RPAREN                         { [] }
	| LPAREN IDENTIFIER pvarargsaux RPAREN 	{ $2.v :: $3 }
;

pvarargsaux:
	      				{ [] } 	
	| COMMA IDENTIFIER pvarargsaux  { $2.v :: $3 }
;



