type token =
  | EOF of (Support.Error.info)
  | DIASIZE of (int Support.Error.withinfo)
  | IDENTIFIER of (string Support.Error.withinfo)
  | CONSTRUCTOR of (string Support.Error.withinfo)
  | TYPEVAR of (string Support.Error.withinfo)
  | UNITVAL of (Support.Error.info)
  | INTVAL of (int    Support.Error.withinfo)
  | FLOATVAL of (float  Support.Error.withinfo)
  | CHARVAL of (char   Support.Error.withinfo)
  | STRINGVAL of (string Support.Error.withinfo)
  | EQUALS of (Support.Error.info)
  | LESS of (Support.Error.info)
  | GREATER of (Support.Error.info)
  | DIAMOND of (Support.Error.info)
  | LTEQ of (Support.Error.info)
  | GTEQ of (Support.Error.info)
  | ARROW of (Support.Error.info)
  | WARROW of (Support.Error.info)
  | LPAREN of (Support.Error.info)
  | RPAREN of (Support.Error.info)
  | EMPTYPAREN of (Support.Error.info)
  | LBRACE of (Support.Error.info)
  | RBRACE of (Support.Error.info)
  | LBRAK of (Support.Error.info)
  | RBRAK of (Support.Error.info)
  | COMMA of (Support.Error.info)
  | COLON of (Support.Error.info)
  | SEMICOLON of (Support.Error.info)
  | BAR of (Support.Error.info)
  | AT of (Support.Error.info)
  | BANG of (Support.Error.info)
  | DOLLAR of (Support.Error.info)
  | SHARP of (Support.Error.info)
  | POUND of (Support.Error.info)
  | PARAGRAPH of (Support.Error.info)
  | CARET of (Support.Error.info)
  | PLUS of (Support.Error.info)
  | MINUS of (Support.Error.info)
  | TIMES of (Support.Error.info)
  | DIVIDE of (Support.Error.info)
  | FPLUS of (Support.Error.info)
  | FMINUS of (Support.Error.info)
  | FTIMES of (Support.Error.info)
  | FDIVIDE of (Support.Error.info)
  | UMINUS
  | UNIT of (Support.Error.info)
  | BOOL of (Support.Error.info)
  | INTEGER of (Support.Error.info)
  | FLOAT of (Support.Error.info)
  | ARRAY of (Support.Error.info)
  | CHAR of (Support.Error.info)
  | STRING of (Support.Error.info)
  | TYPE of (Support.Error.info)
  | VAL of (Support.Error.info)
  | ANNVAL of (Support.Error.info)
  | OF of (Support.Error.info)
  | TRUEVAL of (Support.Error.info)
  | FALSEVAL of (Support.Error.info)
  | NOT of (Support.Error.info)
  | LAND of (Support.Error.info)
  | LOR of (Support.Error.info)
  | ANDALSO of (Support.Error.info)
  | ORELSE of (Support.Error.info)
  | MOD of (Support.Error.info)
  | BEGIN of (Support.Error.info)
  | END of (Support.Error.info)
  | IF of (Support.Error.info)
  | THEN of (Support.Error.info)
  | ELSE of (Support.Error.info)
  | MATCH of (Support.Error.info)
  | MATCHPR of (Support.Error.info)
  | WITH of (Support.Error.info)
  | LET of (Support.Error.info)
  | AND of (Support.Error.info)
  | REC of (Support.Error.info)
  | IN of (Support.Error.info)
  | WHERE of (Support.Error.info)
  | FUN of (Support.Error.info)

val pprogram :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Syntax.program
