(*

   Author:   Steffen Jost <jost@informatik.uni-muenchen.de>
   Name:     $Name:  $
   File:     $RCSfile: main.ml,v $
   Id:       $Id: main.ml,v 1.8 2004/01/21 14:58:39 sjost Exp $ 

	

   What this File is all about:
   ----------------------------
   This file shall simply glue everything together. 
   It evolved from a file from M.Hofmann and D.Aspinall,
   but merely the last 7 lines have survived by now.


*)

open Support.Error
open Argument

let main () = 
  let _ = (* Ellbogenraum *)
    print_string (Argument.version_info^"\n");
    print_string ("written by "^author_info^"\n")
  in 
  let _ = queue_warnings () in
  let ((inchan,inname),(outchan,outname),opts) = Argument.my_parse_arg () in (* Parse command line.. *)
  let lexbuf =  Lexing.from_channel inchan  
  in 
  let _ = match inname with 
      Some s -> Lexer.setFilename s 
    | None   -> () 
  in 
  let parseerr s =
    errAt (Lexer.info lexbuf) (" Parse error: unexpected token '" ^ (Lexing.lexeme lexbuf) ^ "'.\n " ^s^" \n ")
  in
  let pr = 
    try 
      Parser.pprogram Lexer.token lexbuf 
    with 
      Parsing.Parse_error -> parseerr " "
    | Failure s -> parseerr s
  in (* pr vom typ syntax.program damit typcheck, execution...*)
  let _ = print_string ("\n Program '"^(Common.print_some inname)^"' parsed.\n") in
  let _ = print_warnings () in
  let _ = 
    try
      if inchan <> stdin then 
	let _ = 
	  if !the_options.debug 
	  then print_string (" Closing infile '"^(Common.print_some inname)^"'.\n") 
	in close_in inchan
    with _ -> ()   (*
		      This does not catch the error when closing stdin. 
		      Because the error is only raised at the next use of stdin! 
		    *)
  in

  let _ = if opts.inference 
          then
            try Constraint.iprogram opts pr (outchan,outname) 
	    with except -> 
		print_string "While building constraints.\n"; 
	        flush stdout;
		raise except 
  in
  let _ = if opts.execute
          then Exec.eprogram opts pr 
  in
  ()

(* Bis dahin nur Definitionen. Hier folgt nun Term der ausgewertet wird... *)

let () =   
  let runtime_main = Sys.time() in
  let fmain = (fun () -> 
    try  main(); 0                 (* Default exit-code 0 *) 
    with Support.Error.Exit x -> x (* Fehlerbehandlung *)
	      )
  in
  let res = Printexc.print fmain () in
  (
   (print_string ("\nTotal processing time: "^(string_of_float (Sys.time() -. runtime_main))^" seconds.\n"));
   (print_warnings ());
   (exit res)
  )
