(* temporary version of GrailDynSem.thy reworked by da *)

theory indDynsem = indState:

(* "Partial" projections from RTVal *)

lemma myLemma1[simp]: "Not (VALop V = BINop(b,U,W))"
apply(auto)
done
lemma myLemma2[simp]: "Not (BINop(b,U,W) = VALop V)"
apply(auto)
done

consts
 theInt :: "RTVal \<Rightarrow> int"
 theString :: "RTVal \<Rightarrow> string"
 theRef :: "RTVal \<Rightarrow> Reference"

(* da: could fill in remainder of cases with arbitrary *)
primrec
 "theInt(rtInt m) = m"
primrec
 "theString(rtString s) = s"
primrec
 "theRef(rtRef r) = r"


consts
 evalBOP  :: "BinOp \<Rightarrow> RTVal \<Rightarrow> RTVal \<Rightarrow> RTVal"

primrec
 "evalBOP ADDop n m  =  rtInt (theInt n  +  theInt m)"
 "evalBOP SUBop	n m  =  rtInt (theInt n  -  theInt m)"
 "evalBOP MULop	n m  =  rtInt (theInt n  *  theInt m)"   
 "evalBOP DIVop	n m  =  rtInt (theInt n  div  theInt m)"   
 "evalBOP MODop	n m  =  rtInt (theInt n  mod  theInt m)"   

consts 
  evalValue :: "valEnv \<Rightarrow> Value \<Rightarrow> RTVal"
primrec
  "evalValue E (VARval x)    = the(E x)"
  "evalValue E (INTval i)    = rtInt i"
  "evalValue E (STRINGval s) = rtString s"
  "evalValue E (NULLval s)   = rtRef nullRef"

consts evalTest :: "RTVal => Test => RTVal => bool"
primrec
"evalTest A EQtest B = (theInt A = theInt B)"
"evalTest A NEtest B = (Not (theInt A = theInt B))"
"evalTest A Ltest B = (theInt A < theInt B)"
"evalTest A LEtest B = ((theInt A = theInt B) | (theInt A < theInt B))"
"evalTest A Gtest B = (theInt B < theInt A)"
"evalTest A GEtest B = ((theInt A = theInt B) | (theInt B < theInt A))"

types
  fields = "FieldName \<leadsto> RTVal" (* fieldname to value mapping. *)
  obj    = "ClassName \<times> fields" (*class instance with class name and fields*)

  Heap = "loc \<leadsto> obj"
  (*later: Heap   = "loc => obj" ?*)

(*
consts 
  evalPrimop :: "valEnv \<Rightarrow> Heap \<Rightarrow> closEnv \<Rightarrow> PrimOp \<Rightarrow> (RTVal \<times> Heap)"

primrec
  "evalPrimop E H S (VALop v) = (evalValue E v,H)"

  "evalPrimop E H S (BINop bargs) =
			(let (b,v,w) = bargs in
			 (evalBOP b (evalValue E v) (evalValue E w), H))" 


  "evalPrimop E H S (GETFIELDop fargs) =
			(let (x,flddescr) = fargs in
			 let (Class, fields) = getObject (E x) in  \<dots>
*)


consts ePrimop::"(valEnv * Heap * closEnv * PrimOp * (RTVal * Heap)) set"
inductive ePrimop intros
eVALop[intro!]: "V = evalValue E v ==> (E,H,S,VALop v, (V,H)) \<in> ePrimop"
eBINop[intro!]: "V = evalValue E v &
        W = evalValue E w &
        U = evalBOP b V W
        ==> (E,H,S,BINop(b, v, w), (U,H)) \<in> ePrimop"

consts eFUNres:: "(valEnv * Heap * closEnv * 
                   ((valEnv * Var list * Expr) option) *
                   (Var list) * 
                   (RTVal * Heap)
                  ) set"
consts ePrimres :: "(valEnv * Heap * closEnv * PrimRes * (RTVal * Heap)) set"
consts eExpr :: "(valEnv * Heap * closEnv * Expr * (RTVal * Heap)) set"
consts eCHOICEres:: "(valEnv * Heap * closEnv * bool * PrimRes * PrimRes * 
                      (RTVal * Heap)) set"

inductive eCHOICEres ePrimres eExpr eFUNres intros
eTRUEchoice[intro!]: "(E,H,S,prT,RES) \<in> ePrimres
             ==> (E,H,S,True,prT,prE,RES) \<in> eCHOICEres"
eFALSEchoice[intro!]: "(E,H,S,prE,RES) \<in> ePrimres
             ==> (E,H,S,False,prT,prE,RES) \<in> eCHOICEres"

(*inductive eExpr intros*)
eVALdec[intro!]: "(E,H,S,p,(V,H')) \<in> ePrimop &
         (E_update E x V, H', S, e, RES) \<in> eExpr
         ==> (E,H,S, VALdec x p e,RES) \<in> eExpr"
eVOIDdec[intro!]: "(E,H,S,p,(V,H')) \<in> ePrimop &
          (E,H', S, e, RES) \<in> eExpr
          ==> (E,H,S, VOIDdec p e,RES) \<in> eExpr"
ePRIMres[intro!]: "(E,H, S, pr, RES) \<in> ePrimres
          ==> (E,H,S, PRIMres pr, RES) \<in> eExpr"
eCHOICEres[intro!]:"b = evalTest (evalValue E v) t (evalValue E w) &
           (E,H, S, b, prT, prE, RES) \<in> eCHOICEres
          ==> (E,H,S, CHOICEres v t w prT prE, RES) \<in> eExpr"
(*inductive eFUNres intros*)
eFUNnone[intro!]: "(E,H,S,None,xs,(rtWrong,H)) \<in> eFUNres"
eFUNsome[intro!]: "(Eprime,ys,body) = Sf &
          (E,H,S,xs,Eprime,ys,body,RES) \<in> eCall
          ==> (E,H,S, Some(Sf), xs, RES) \<in> eFUNres"

(*inductive ePrimres intros*)
eVOIDres[intro!]: "(E, H,S, VOIDres, (rtVoid, H)) \<in> ePrimres"
eOPres[intro!]: "(E, H, S, primop, (V,H')) \<in> ePrimop 
        ==> (E, H, S, (OPres primop), (V,H')) \<in> ePrimres"
eFUNres[intro!]: "(E,H,S, S f, xs, RES) \<in> eFUNres
         ==> (E, H, S, (FUNres (f,xs)), RES) \<in> ePrimres"

consts eCall:: "(valEnv * Heap * closEnv * (Var list) * valEnv * (Var list) *
                 Expr * (RTVal * Heap)) set"
consts eConsAux:: "(valEnv * Heap * closEnv * (Var list) * valEnv * Var * 
                    (Var list) * Expr * (RTVal option) * (RTVal * Heap)) set"
inductive eConsAux eCall intros
eConsAuxNone[intro!]: 
  "(E,H,S,xs,Eprime,y,ys,body,None,(rtWrong,H)) \<in> eConsAux"
eConsAuxSome[intro!]: "(E,H,S,xs,E_update Eprime y V,ys,body, RES) \<in> eCall
              ==> (E,H,S,xs,Eprime,y,ys,body,Some V,RES) \<in> eConsAux"
(*inductive eCall intros*)
eNILcall[intro!]: "(Eprime,H,S,body, RES) \<in> eExpr
            ==> (E,H,S, [], Eprime, [], body, RES) \<in> eCall"
eCONScall[intro!]: "(E,H,S,xs,Eprime,y,ys,body, E x, RES) \<in> eConsAux
            ==> (E,H,S, x # xs, Eprime, y # ys, body, RES) \<in> eCall"
eERR1call: "(E,H,S, x # xs, Eprime, [], body, (rtWrong,H)) \<in> eCall"
eERR2call: "(E,H,S, [], Eprime, y # ys, body, (rtWrong,H)) \<in> eCall"

constdefs one::"int"
"one == int 1"
constdefs two::"int"
"two == int 2"
constdefs three::"int"
"three == two + one"
constdefs four::"int"
"four == two + two"

constdefs six::"int"
"six == three + three"
constdefs  twentyfour::"int"
"twentyfour == six * four"

consts n::"Var"
       acc::"Var"
       m::"Var"
consts fac::"FunName"
consts elseBranch::"FunName"

constdefs thenPres:: "PrimRes"
"thenPres == OPres(VALop(VARval n))"
constdefs elsePres:: "PrimRes"
"elsePres == FUNres(elseBranch,[n,acc])"
constdefs facBody::"Expr"
"facBody == CHOICEres (VARval n) LEtest (INTval one) thenPres elsePres"
constdefs elseBody::"Expr"
"elseBody == VALdec m (BINop(SUBop,VARval n, INTval one))
             ( VALdec acc (BINop(MULop,VARval acc, VARval n))
               ( PRIMres (FUNres(fac,[acc,m]))))"

constdefs emptyValEnv::"valEnv"
"emptyValEnv ==(%x . None)"

constdefs emptyHeap:: "Heap"
"emptyHeap == (%l . None)"

constdefs cEnv:: "closEnv"
"cEnv ==  (%f . if (f = fac) then Some(emptyValEnv,[acc,n],facBody) else 
                if (f = elseBranch) then Some(emptyValEnv,[n,acc],elseBody) 
                else None)"

constdefs Fac:: "nat => Expr"
"Fac k == VALdec acc (VALop (INTval one))
           (VALdec n (VALop (INTval (int k)))
            (PRIMres (FUNres(fac,[acc,n]))))"

constdefs FacZero:: "Expr"
"FacZero == Fac 0"
constdefs FacOne:: "Expr"
"FacOne == Fac 1"
constdefs FacTwo:: "Expr"
"FacTwo == Fac 2"
constdefs FacThree:: "Expr"
"FacThree == Fac (1+2)"
constdefs FacFour:: "Expr"
"FacFour == Fac (2+2)"

lemma [simp]:
      "(emptyValEnv,emptyHeap,cEnv,FacZero,(rtInt one,emptyHeap)) \<in> eExpr"
apply(simp only: FacZero_def)
apply(simp only: Fac_def)
apply auto
apply(simp only: E_update_def)
apply(simp only: cEnv_def)
apply(auto)
done

lemma [simp]:
      "(emptyValEnv,emptyHeap,cEnv,FacOne,(rtInt one,emptyHeap)) \<in> eExpr"
apply(simp only: FacOne_def)
apply(simp only: Fac_def)
apply auto
apply(simp only: E_update_def)
apply(simp only: cEnv_def)
apply(auto)
done

lemma [simp]: 
      "(emptyValEnv,emptyHeap,cEnv,FacTwo,(rtInt two,emptyHeap)) \<in> eExpr"
apply(simp only: FacTwo_def)
apply(simp only: Fac_def)
apply auto
apply(simp only: E_update_def)
apply(simp only: cEnv_def)
apply(auto)
done

lemma [simp]:
      "(emptyValEnv,emptyHeap,cEnv,FacThree,(rtInt six,emptyHeap)) \<in> eExpr"
apply(simp only: FacThree_def)
apply(simp only: Fac_def)
apply auto
apply(simp only: E_update_def)
apply(simp only: cEnv_def)
apply(auto)
done

lemma [simp]:
      "(emptyValEnv,emptyHeap,cEnv,FacFour,(rtInt twentyfour,emptyHeap)) 
       \<in> eExpr"
apply(simp only: FacFour_def)
apply(simp only: Fac_def)
apply auto
apply(simp only: E_update_def)
apply(simp only: cEnv_def)
apply(auto)
done

consts facSpec:: "nat => int"
recdef facSpec "measure(%k . k)"
"facSpec 0 = int 1" 
"facSpec k = (int k) * (facSpec (k-1))"

lemma [simp]: "facSpec 0 = one"
apply(simp only:one_def)
apply(auto)
done

lemma [simp]: "facSpec (2+1) = six"
apply(simp only:six_def)
apply(simp only:three_def)
apply(simp only:two_def)
apply(simp only:one_def)
apply(auto)
done

lemma [simp]:
      "(emptyValEnv,emptyHeap,cEnv,Fac k,(rtInt (FacSpec k),emptyHeap)) 
       \<in> eExpr"
apply(induct_tac k)
apply(simp only:Fac_def)
apply auto
apply(simp only: E_update_def)
apply(simp only: cEnv_def)
apply(auto)
apply(simp only:Fac_def)
apply(auto)
apply(simp only: E_update_def)
apply(simp only: cEnv_def)
apply(auto)
done

lemma [simp]: "((FacSpec k = x) & (FacSpec k = y)) ==> (x=y)"
apply(auto)
done

declare eCHOICEres_ePrimres_eExpr_eFUNres.intros[simp]

lemma evalBOP_det: "((evalBOP OP a b = c) & (evalBOP OP a b =d)) --> (c=d)"
apply(clarify)
done

lemma evalValue_det: "((evalValue E v = c) & (evalValue E v = d)) --> (c=d)"
apply(clarify)
done

lemma evalPrimop_det: "((evalPrimop E H S PrimOp = c) &
                        (evalPrimop E H S PrimOp = d)) --> (c=d)"
apply(clarify)
done

lemma evalTest_det: "((evalTest v t w = c) & (evalTest v t w = d)) --> (c=d)"
apply(clarify)
done

lemma "evalTest (rtInt one) EQtest (rtInt one) = True"
apply(auto)
done

declare ePrimop.intros[simp]


lemma VAL: "((V = evalValue E v) = ((E,H,S,VALop v, (V,H)) \<in> ePrimop))"
apply(rule)
apply(rule eVALop)
apply(clarify)
apply(erule ePrimop.elims)
apply(clarify)
apply(clarify)
(*apply(simp only:myLemma1)*)
done
lemma BIN: "(\<exists> V. \<exists> W.
             (V = evalValue E v) & (W = evalValue E w) & (U = evalBOP b V W))
            = ((E,H,S,BINop(b, v, w), (U,H)) \<in> ePrimop)"
apply(rule)
apply(rule eBINop)
apply(blast)
apply(erule ePrimop.elims)
apply(clarify)
apply(simp only:myLemma2)
apply(blast)
done

lemma BINop_det: "(((E,H,S,BINop(b, v, w), (U,H)) \<in> ePrimop) & 
                 ((E,H,S,BINop(b, v, w), (UU,HH)) \<in> ePrimop))
                --> ((U,H) = (UU,HH))"
apply(clarify)
apply(rule)
apply(erule ePrimop.elims)
apply(erule ePrimop.elims)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
apply(erule ePrimop.elims)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
apply(erule ePrimop.elims)
apply(erule ePrimop.elims)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
apply(erule ePrimop.elims)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
done

lemma VALop_det: "\<forall> v.\<forall> E.\<forall> H.\<forall> S.
                         ( (((E,H,S,VALop v, (U,H)) \<in> ePrimop) & 
                            ((E,H,S,VALop v, (UU,HH)) \<in> ePrimop))
                           --> ((U,H) = (UU,HH))
                         )"
apply(clarify)
apply(rule)
apply(erule ePrimop.elims)
apply(erule ePrimop.elims)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
apply(simp only:myLemma1)
apply(clarify)
apply(erule ePrimop.elims)
apply(clarify)
(*apply(simp only:myLemma1)*)
(*apply(clarify)*)
apply(erule ePrimop.elims)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
apply(erule ePrimop.elims)
(*apply(erule ePrimop.elims)*)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
(*apply(simp only:myLemma2)
apply(clarify)
apply(erule ePrimop.elims)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
*)
done

(*The proof of the following theorem should of course follow from
  the two previous lemmas - I can't get that to work currently, so
  I repeat the proofs ...
*)
theorem PrimOp_det: "(((E,H,S,PrOp, (U,H)) \<in> ePrimop) & 
                 ((E,H,S,PrOp, (UU,HH)) \<in> ePrimop))
                --> ((U,H) = (UU,HH))"
apply(case_tac PrOp)
apply(clarify)
apply(rule)
apply(erule ePrimop.elims)
apply(erule ePrimop.elims)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
apply(simp only:myLemma1)
apply(clarify)
apply(erule ePrimop.elims)
apply(clarify)
(*apply(simp only:myLemma1)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
*)
apply(erule ePrimop.elims)
(*apply(erule ePrimop.elims)*)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
(*apply(erule ePrimop.elims)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
*)
(*Part BINop*)
apply(clarify)
apply(rule)
apply(erule ePrimop.elims)
apply(erule ePrimop.elims)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
apply(erule ePrimop.elims)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
apply(erule ePrimop.elims)
apply(erule ePrimop.elims)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
apply(erule ePrimop.elims)
apply(clarify)
apply(simp only:myLemma2)
apply(clarify)
(*Other PRIMop cases will follow here...*)
done


(*Not yet working:
lemma "((emptyValEnv,emptyHeap,cEnv,Fac 0,(rtInt l,emptyHeap)) \<in> eExpr) 
        \<longrightarrow> (l=one)"
apply(clarify)
apply(simp only:Fac_def)
apply(induct set: eExpr)
apply(clarify)
apply(auto)


apply(simp only: E_update_def)
apply(simp only: cEnv_def)
apply(auto)
apply(simp only:Fac_def)
apply(auto)
apply(simp only: E_update_def)
apply(simp only: cEnv_def)
apply(auto)

apply(auto)
*)
end

