(* temporary version of Absyn.thy reworked by da *)

(* This is a deep embedding --- we're formalising the syntax of
   GRAIL here.  It's likely to be challengin, may need to use
   semantic demains.
 *)

theory indAbsyn = Main:

(* da: semantic begin with lc, syntactic with uc *)

typedecl Var
typedecl ClassName

datatype Ty =       (*Types in GRAIL.*)
    BYTEty 
  | CHARty 
  | DOUBLEty 
  | FLOATty
  | INTty 
  | LONGty 
  | SHORTty 
  | BOOLEANty 
  | REFty "ClassName"
  | ARRAYty "Ty"

types RTy = "Ty option"   -- "Return type"  (* da: could include above *)
    

datatype Value =     (*"Values of GRAIL."*)
    VARval  "Var"
  | INTval  "int"
  | STRINGval string
  | NULLval  string
(*  | FLOATval real    da: real is available in HOL_Real logic
			   if we really need it. *)

datatype BinOp = ADDop | SUBop | MULop | DIVop | MODop


typedecl MethName
types MethDesc = "RTy \<times> MethName \<times> Ty list"

typedecl FieldName
types FieldDesc = "Ty \<times> FieldName"
	   
datatype PrimOp =  (*"Primitive operations of Grail"*)
    VALop Value
  | BINop "BinOp * Value * Value"
(*  | NEWop ClassName
  | CHECKCASTop "ClassName * Var"
  | INSTANCEop  "ClassName * Var"
  | INVOKESTATICop "MethDesc * Value list"
  | INVOKEVIRTUALop "Var * MethDesc * Value list"
  | GETFIELDop "Var * FieldDesc"
  | PUTFIELDop "Var * FieldDesc * Value"
  | GETSTATICop FieldDesc
  | PUTSTATICop "FieldDesc * Value"
*)

typedecl FunName
	
datatype PrimRes = (*"Results"*)
    OPres PrimOp
  | VOIDres
  | FUNres "FunName * Var list"

datatype Test = 
  EQtest | NEtest | Ltest | LEtest | Gtest | GEtest

datatype Expr =
    VALdec Var PrimOp Expr
  | VOIDdec PrimOp Expr
  | PRIMres PrimRes
  | CHOICEres Value Test Value PrimRes PrimRes
(*
datatype Result =
    PRIMres PrimRes
  |  CHOICEres Value Test Value PrimRes PrimRes


datatype LetDec = 
  VALdec Var PrimOp
| VOIDdec PrimOp
*)


end
