(* theory E = Q: *)
theory E = Q:

(* Q is CoreGrailDynSem without counting steps *)

section "Misc examples testing lookup of function names etc"

text {*
When looking up a function name in the State the simplifier sometimes
doesn't resolve the names properly ending up with statements like this:
 foo = bar --> ... &
 foo ~= bar --> ...

This test variants of defining mappings of function names to code etc
in order to get around this problem.
*}

subsection "Constants and stuff"

subsection "Generic constants"

constdefs one::"int"
"one \<equiv> int 1"
constdefs two::"int"
"two \<equiv> int 2"
constdefs three::"int"
"three \<equiv> two + one"
constdefs four::"int"
"four \<equiv> two + two"

constdefs six::"int"
"six \<equiv> three + three"
constdefs  twentyfour::"int"
"twentyfour \<equiv> six * four"

subsubsection "Foo-ish stuff"

consts foo :: "Fname"
consts bar :: "Fname"

text {*
I tried to add statements like foo~=bar as axioms and tell the
simplifier about it but he still ignores me.
*}

axioms
 ax1: "foo \<noteq> bar"

declare ax1 [simp]

constdefs fooCall :: "FunBody"
"fooCall \<equiv> FUNbody 
                    EMPTYdec
                    (PRIMres (FUNres foo EMPTYvar))"

constdefs fooBody :: "FunBody"
"fooBody \<equiv> FUNbody 
                    (FULLdec (VOIDdec (VALop (INTval 1))) EMPTYdec) 
                    (PRIMres (OPres (VALop (INTval 2))))"

constdefs barCall :: "FunBody"
"barCall \<equiv> FUNbody 
                    EMPTYdec
                    (PRIMres (FUNres bar EMPTYvar))"

constdefs barBody :: "FunBody"
"barBody \<equiv> FUNbody 
                    EMPTYdec
                    (PRIMres (OPres (BINop ADDop (INTval 1) (INTval 1))))"

constdefs fooHeap :: "Heap"
"fooHeap \<equiv>  
  emptyHeap ( foo := Some (EMPTYal, fooBody),
              bar := Some (EMPTYal, barBody)
            )"

constdefs fooState :: "State"
"fooState \<equiv> emptyState \<lparr> heap := fooHeap \<rparr>"

constdefs mainBody :: "FunBody"
 "mainBody \<equiv> FUNbody 
                     EMPTYdec
                     (PRIMres (FUNres bar EMPTYvar))"

subsubsection "cond"

text {*
Simple example mainly testing conditional.
*}

consts z :: "Vname"

constdefs condBody :: "FunBody"
"condBody \<equiv> FUNbody 
                (FULLdec (VALdec z (VALop (INTval 1))) EMPTYdec) 
                (CHOICEres (CONDhead (VARval z) LESStest (INTval 0)) 
                    (OPres (VALop (INTval 0)))
                    (OPres (BINop SUBop (VARval z) (INTval 1))))"

subsubsection "Recursive functions"

text {*
A simple recursive function implementing \<lambda> x . 0 
*}

consts q :: "Vname"
consts bonzo :: "Fname"
consts bonzoElseBranch :: "Fname"

constdefs bonzoThen :: "PrimRes"
 "bonzoThen \<equiv> OPres (VALop (VARval q))"
constdefs bonzoElseBranchBody :: "FunBody"
 "bonzoElseBranchBody \<equiv> FUNbody 
                            (FULLdec (VALdec q (BINop SUBop (VARval q) (INTval 1)))
                             EMPTYdec)
                            (PRIMres (FUNres bonzo (FULLvar q (EMPTYvar))))"
constdefs bonzoElse :: "PrimRes"
 "bonzoElse \<equiv> FUNres bonzoElseBranch (FULLvar q EMPTYvar)"
constdefs bonzoBody ::"FunBody"
 "bonzoBody \<equiv> FUNbody EMPTYdec (CHOICEres (CONDhead (VARval q) LESStest (INTval one)) bonzoThen bonzoElse)"

constdefs bonzoCall :: "int => FunBody"
 "bonzoCall k \<equiv> FUNbody
                           (FULLdec (VALdec q (VALop (INTval k))) EMPTYdec)
                           (PRIMres (FUNres bonzo (FULLvar q (EMPTYvar))))"

constdefs bonzoHeap :: "Heap"
"bonzoHeap \<equiv>  
    emptyHeap (bonzoElseBranch := Some ((FULLal (ARG INTty q) EMPTYal), bonzoElseBranchBody),
               bonzo := Some ((FULLal (ARG INTty q) EMPTYal), bonzoBody) )"

constdefs bonzoState :: "State"
"bonzoState \<equiv> emptyState \<lparr> heap := bonzoHeap \<rparr>"


subsubsection "Predicates over Resource Consumption"

constdefs 
  needsTime :: "FunBody \<Rightarrow> Time \<Rightarrow> bool"
 "needsTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. ? v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>b \<langle>v,s\<rangle>) & (clock s) = n))"

  boundedTime :: "FunBody \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. ? v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>b \<langle>v,s\<rangle>) & (clock s) <= n))"

  needsTimeWithState :: "State \<Rightarrow> FunBody \<Rightarrow> Time \<Rightarrow> bool"
 "needsTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>b \<langle>v,s'\<rangle>) & (clock s') = n))"

  boundedTimeWithState :: "State \<Rightarrow> FunBody \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>b \<langle>v,s'\<rangle>) & (clock s') <= n))"

subsection "Aux fcts"

text {*
Just to make sure that simplification is sufficient for these functions.
*}

lemma "evalTest LESStest (rtInt 1) (rtInt 2) = rtBool True"

apply (unfold evalTest_def)
apply (simp)
done

lemma "evalBOP ADDop (rtInt 1) (rtInt 1) = rtInt 2"

apply (unfold evalBOP_def)
apply (simp)
done

subsection "Lemmas and stuff"

consts zz :: "Vname"
(*
constdefs maddBody :: "FunBody"
"condBody \<equiv> FUNbody EMPTYdec
                    (PRIMres (OPres (BINop ADDop (VARval zz) ?mz)))"
*)
lemma 
  "\<forall> mz. boundedTime 
                 (FUNbody EMPTYdec
                    (PRIMres (OPres (BINop ADDop (VARval zz) ?mz))))
                 2"

apply (rule allI)
apply (unfold boundedTime_def)
apply (rule exI)+
apply (rule conjI)
apply (rule FUNbody)
apply  (rule EMPTYdec)
apply  (rule PRIMres)
apply   (rule OPres)
apply    (rule BINop)
apply     (rule VARval)
apply (simp_all)
apply (case_tac ?mz)
oops
(* should use cheapness theorem on Value here *)

lemma "boundedTime condBody 2"

apply (unfold boundedTime_def)
apply (unfold condBody_def)
apply (rule exI)+
apply (rule conjI)
apply (rule FUNbody)
apply  (rule FULLdec)
apply   (rule VALdec)
apply    (rule VALop)
apply     (rule INTval)
apply (simp_all)
apply (rule EMPTYdec)
apply  (rule CHOICEres_False)
apply   (rule CONDhead)
apply    (rule VARval)
apply (simp_all)
apply    (rule INTval)
apply (unfold lupd_def)
apply (unfold evalTest_def)
apply (simp)
(* predicate proven *)
apply (rule OPres)
apply  (rule BINop)
apply   (rule VARval)
apply (simp_all)
apply (rule INTval)
(* apply (simp add:tick_def) *)
done
(* OK *)

text {*
The current hack around this naming problem is to add the inequalities in the 
assumption set of the lemma to proof. It is \emph{very} ugly but sort-of works.
*}

(* Test function lookup etc *)

lemma "[| bar ~= foo |] ==> boundedTimeWithState fooState mainBody 1"

apply (unfold mainBody_def)
apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (rule conjI)
apply (rule Q.eval_PrimRes_eval_Result_eval_FunBody.FUNbody)
apply  (rule Q.eval_LetDecs.EMPTYdec)
apply  (rule Q.eval_PrimRes_eval_Result_eval_FunBody.PRIMres)
apply   (rule Q.eval_PrimRes_eval_Result_eval_FunBody.FUNres)
apply (unfold fooState_def)
apply (unfold fooHeap_def)
apply (unfold get_body_def)
apply (simp_all)
apply (unfold barBody_def)
apply (rule Q.eval_PrimRes_eval_Result_eval_FunBody.FUNbody)
apply  (rule Q.eval_LetDecs.EMPTYdec)
apply  (rule Q.eval_PrimRes_eval_Result_eval_FunBody.PRIMres)
apply   (rule Q.eval_PrimRes_eval_Result_eval_FunBody.OPres)
apply    (rule Q.eval_PrimOp.BINop)
apply     (rule Q.eval_Value.INTval)
apply     (rule Q.eval_Value.INTval)
apply (simp_all add:tick_def)
done

(* Recursive function returning constant in base case *)

lemma "[| bonzo~=bonzoElseBranch |] ==> boundedTimeWithState bonzoState (bonzoCall 1) 3"

apply (unfold bonzoCall_def)
apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (rule conjI)
apply (rule Q.eval_PrimRes_eval_Result_eval_FunBody.FUNbody)
apply  (rule Q.eval_LetDecs.FULLdec)
apply   (rule Q.eval_LetDec.VALdec)
apply    (rule Q.eval_PrimOp.VALop)
apply     (rule Q.eval_Value.INTval)
apply (simp_all)
apply  (rule Q.eval_LetDecs.EMPTYdec)
apply (rule Q.eval_PrimRes_eval_Result_eval_FunBody.PRIMres)
apply  (rule Q.eval_PrimRes_eval_Result_eval_FunBody.FUNres)
apply (unfold bonzoState_def)
apply (unfold bonzoHeap_def)
apply (unfold lupd_def)
apply (unfold get_body_def)
apply (simp_all)
apply (unfold bonzoBody_def)
apply (rule Q.eval_PrimRes_eval_Result_eval_FunBody.FUNbody)
apply  (rule Q.EMPTYdec)
apply   (rule Q.eval_PrimRes_eval_Result_eval_FunBody.CHOICEres_False)
apply    (rule Q.eval_CondHead.CONDhead)
apply     (rule Q.eval_Value.VARval)
apply (simp_all)
apply     (rule Q.eval_Value.INTval)
apply     (unfold evalTest_def)
apply (simp)
defer 1
apply (unfold bonzoElse_def)
apply  (rule Q.eval_PrimRes_eval_Result_eval_FunBody.FUNres)
apply (unfold get_body_def)
apply (simp_all)
apply (simp)
apply (rule conjI)
apply (rule impI)
defer 1
apply (rule impI)
apply (unfold bonzoElseBranchBody_def)
apply (rule Q.eval_PrimRes_eval_Result_eval_FunBody.FUNbody)
apply  (rule Q.FULLdec)
apply   (rule Q.VALdec)
apply    (rule Q.BINop)
apply     (rule Q.VARval)
apply (simp_all)
apply     (rule Q.INTval)
apply     (rule Q.EMPTYdec)
apply   (rule Q.PRIMres)
(* rec function call; make use of the theorem *)
(* the rest just unfolds the function till the end *)
apply    (rule Q.FUNres)
apply (unfold get_body_def)
apply (unfold evalBOP_def)
apply (unfold lupd_def)
apply (simp_all)
apply     (rule Q.FUNbody)
apply      (rule Q.EMPTYdec)
apply   (rule Q.CHOICEres_True)
apply    (rule Q.CONDhead)
apply     (rule Q.VARval)
apply (simp_all)
apply     (rule Q.INTval)
apply (unfold evalTest_def)
apply (simp)
apply (unfold one_def)
apply (simp)
apply (unfold bonzoThen_def)
apply (rule Q.OPres)
apply  (rule Q.VALop)
apply   (rule Q.VARval)
apply (simp_all)
apply (simp add:tick_def)
done
(* OK *)

subsection "Local Function Definitions"

(* This uses slightly different grammar with both local function definitions *)
(*
consts xx :: "Vname"
       yy :: "Vname"


constdefs xx_plus_yy :: "FunBody"
"xx_plus_yy \<equiv> FUNbody 
                         (FULLdec (VALdec xx (VALop (INTval 1))) EMPTYdec)
                         (FULLfundec 
                            (FDEC inc_by 
                                      (FULLal (ARG intty yy) EMPTYal) 
                                      (FUNbody (PRIMres (OPres (BINop ADDop (VARval xx) (VARval yy))))))
                         EMPTYfundec)
                     (PRIMres (OPres (FUNres inc_by (VARval yy))))"
*)