(*  
   File:        ToyVCGtest9.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVCGtest9.thy,v 1.1 2003/06/24 23:21:56 da Exp $

   More tests of the VCG (testing invoke). 
*)

theory ToyVCGtest9 = ToyVCG0 + ToyPrelude + ToyHLbasic0:

subsection {* const *}
locale const9_example =
  fixes    m         :: iname
    and	   n         :: iname
    and	   q         :: iname
    and    l1        :: locn
    and    count     :: ifldname
    and    const     :: mname
    and    ConstClass:: cname
    and    constBody :: expr
    and    constMBody :: methbody
    and    constClassmtable  :: "mname \<Rightarrow> methbody"
 defines  "constBody \<equiv> GetFi self count"
    and   "constMBody \<equiv> (({n},{}),constBody)"
(*     and   "classtable ConstClass == \<lparr> iflds = [count], rflds = [], meths = (\<lambda> mn. K mn)(const := constMBody) \<rparr>" *)
 assumes  constclassmtable [simp]: "constClassmtable const = constMBody"
 assumes  const_class:  "classtable ConstClass == \<lparr> iflds = [count], rflds = [], 
						    meths = constClassmtable \<rparr>"
    and    vardistinct: "distinct [m,n,q]"
    and   const_methbody: "methtable const == constBody"
    and   const_wfmeasure: "meth_wfmeasure_table const == {}"

declare (in const9_example) constBody_def [simp]
declare (in const9_example) constMBody_def [simp]
declare (in const9_example) const_class [simp]
declare (in const9_example) const_methbody [simp]
declare (in const9_example) const_wfmeasure [simp]

(* all-in-one; std1 ... *)
lemma (in const9_example)
   "\<Turnstile> {(z,s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (ConstClass, emptyi(count := (z<n>)), emptyr) \<and> s<q>=1}	
      IF q
        THEN self\<bullet>const(self)
        ELSE 99\<^sup>z
      {(z,s,v). v = IVal (z<n>)}"
apply (insert vardistinct)
apply (simp)
(* apply hoare2_simp *)
apply hoare2_step
defer 1
(*
apply (tactic {* assume_tac 1 *})
ORELSE
*)
(* apply (tactic {* rtac (thm "HSP") 1 *}) *)
apply (tactic {* rtac (thm "HKleymanAdapt1") 1 *})
(* apply (tactic {* rtac allI 1 *}) *)
apply (tactic {* HoareRecWFInvoke 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HInvoke") 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac allI 1 *})
apply auto
oops

lemma (in const9_example) bonzo_1702:
 "[| s\<lfloor>self\<rfloor> = Ref l1 ; obj = (ConstClass, istor, rstor) ; s\<lless>l1\<ggreater> = Some obj|]
  ==>	
 meths (classtable (fst obj)) const = constMBody"
apply simp
done

lemma (in const9_example) bonzo_1703:
 "[| s\<lfloor>self\<rfloor> = Ref l1 ; obj = (ConstClass, istor, rstor) ; s\<lless>l1\<ggreater> = Some obj|]
  ==>	
 snd (meths (classtable (fst obj)) const) = constBody"
apply simp
done

lemma (in const9_example) bonzo_1701:
  "classtable ConstClass = \<lparr> iflds = [count], rflds = [], meths = (\<lambda> mn. K mn)(const := constMBody) \<rparr>"
(* apply (simp add: const_class constclassmtable) *)
oops
(* wow, what a great system *)

(* old
lemma (in const9_example)
 "[| s\<lfloor>self\<rfloor> = Ref l1 ; obj = (ConstClass, istor, rstor) ; s\<lless>l1\<ggreater> = Some obj|]
  ==>	
 meths (classtable ConstClass) const = constMBody"
apply (simp only:  const_class)
apply (unfold constMBody_def)
*)

lemma (in const9_example)
 "[| s\<lfloor>self\<rfloor> = Ref l1 ; obj = (ConstClass, istor, rstor) ; s\<lless>l1\<ggreater> = Some obj|]
  ==>	
 meths (classtable ConstClass) const = constMBody"
apply (simp only: const_class)
apply (unfold constMBody_def)
apply simp
(* apply (simp only: const_class constMBody_def) *)
done
(* doesn't expand that bloody classtable *)

lemma (in const9_example) bonzo_1703:
 "[| s\<lfloor>self\<rfloor> = Ref l1 ; obj = (ConstClass, istor, rstor) ; s\<lless>l1\<ggreater> = Some obj|]
  ==>	
  let ccc = (classtable ConstClass) in
  let mmm = (meths ccc) in
  snd (mmm const) 
  = 
  constBody"
apply (simp only: const_class)
apply (simp add: constBody_def constMBody_def const_class const_methbody)+
oops
(* doesn't expand that bloody classtable *)

(* single stepping within Invoke rule *)
lemma (in const9_example)
   "\<Turnstile> {(z,s). s\<lfloor>self\<rfloor>=Ref l1 \<and> s\<lless>l1\<ggreater>=Some (ConstClass, emptyi(count := (z<n>)), emptyr)  \<and> s<q>=1}	
      IF q
        THEN self\<bullet>const(self)
        ELSE 99\<^sup>z
      {(z,s,v). v = IVal (z<n>)}"
apply (insert vardistinct)
apply (simp)
(* apply hoare1_simp *)
apply hoare1_step
defer 1
(* apply hoare_step *)
(* apply (tactic {* HoareRecWFInvoke 1 *}) *)
apply hoare_check_invoke
(* apply (tactic {* res_inst_tac [("r","meth_wfmeasure_table " ^ "const")] (thm "HRecWF'") 1 *}) *)
apply (tactic {* HoareRecWFInvoke 1*})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HInvoke") 1 *})
apply (tactic {* rtac allI 1 *})  
apply (tactic {* rtac allI 1 *})  
apply (tactic {* rtac allI 1 *})  
apply clarsimp
oops
(* stuck on unexpanded method body *)

(* single stepping within Invoke rule *)
lemma (in const9_example)
   "\<Turnstile> {(z,s). s\<lfloor>self\<rfloor>=Ref l1 \<and> s\<lless>l1\<ggreater>=Some (ConstClass, emptyi(count := z), emptyr)  \<and> s<q>=1}	
      IF q
        THEN [class DecClass]\<bullet>const(self)
        ELSE 99\<^sup>z
      {(z,s,v). v = IVal z}"
apply (insert vardistinct)
apply (simp)
(* apply hoare_simp *)
apply hoare_step
defer 1
(* apply hoare_step *)
(* apply (tactic {* HoareRecWFInvoke 1 *}) *)
apply (tactic {* HoareRecWFInvokeStatic 1*})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HInvokeStatic") 1 *})
apply (tactic {* rtac allI 1 *})  
apply (tactic {* simp_tac (HOL_basic_ss addsimps [(thm "const_class")]) 1 *})
apply simp
apply clarsimp
oops
(* stuck on unexpanded method body *)

subsection {* dec *}

locale dec9_example =
  fixes    m         	:: iname
    and	   n         	:: iname
    and	   z1        	:: iname
    and	   z2        	:: iname
    and	   i'1       	:: iname
    and	   r'1       	:: rname
    and	   q1        	:: iname
    and	   zero      	:: iname
    and	   zero'     	:: iname
    and    l1        	:: locn
    and    N         	:: int    
    and    count     	:: ifldname
    and	   dec       	:: mname
    and    DecClass  	:: cname 
    and	   decBody   	:: expr
    and	   decMBody  	:: methbody
    and    const     	:: funame
    and	   constBody    :: expr
    and    constPreInv  :: "int preassn"
    and    constPostInv :: "int postassn"
  defines "decBody \<equiv>  LET 
                m  = GetFi self count ;
                n  = Primop (\<lambda> x y . x - 1) m m ;
                z1 = PutFi self count n ; 
                zero = expr.Int 0 ;
                q1 = Primop (\<lambda> x y . if \<not> y<x then (1::int) else (0::int)) n zero
              IN
                IF q1 
                  THEN IVar zero
                  ELSE IVar n
              END"
  and     "decMBody \<equiv> (({m,n,z1,zero,q1},{}), decBody)"
  and     "constBody \<equiv> IVar n"
  and     "constPreInv == {(z, s). s<n> = z}"
  and     "constPostInv == {(z, s, v). v = IVal z \<and> s<n> = z}"
  assumes  dec_class:  "classtable DecClass = \<lparr> iflds = [count], rflds = [], meths = (\<lambda> mn. K mn)(dec := decMBody) \<rparr>"
      and  vardistinct: "distinct [m,n,z1,z2,i'1,q1,zero]"
      and  vardistinct': "distinct [zero,q1]"
      and  vardistinct'': "distinct [r'1]"
      (* function tables *)
      and  dec_methbdy: "methtable dec = decBody"
      and  const_fnbdy: "funtable const = constBody "
      (* measures *)
      and  dec_wfmeasure: "meth_wfmeasure_table dec = inv_image less_than (the_ifld self count)"
      and  const_wfmeasure: "fun_wfmeasure_table const = {}"
      (*
      and  const_inv: "fun_assn_table const = (
             {(z, s). s<n>=z \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := N), emptyr)},
             {(z, s, v). v = IVal z \<and> s<n>=z \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and>
             s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := N), emptyr)} )"
      *)
      (* invariants *)
      and  dec_preinv: "meth_preassn_table dec == {(z, s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := z), emptyr)}"
      and  dec_postinv: "meth_postassn_table dec == {(z, s, v). s\<lfloor>self\<rfloor> = Ref l1 \<and> v = IVal (z - 1)}"
      and  const_preinv: "fun_preassn_table const == constPreInv"
      and  const_postinv: "fun_postassn_table const == constPostInv"
      and  dec_inv_holds: "\<forall> c foo. \<Turnstile> (meth_preassn_table dec) c\<bullet>dec(foo) (meth_postassn_table dec)"
      and  const_inv_holds: "\<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const)"

declare (in dec9_example) decBody_def[simp]
declare (in dec9_example) constBody_def[simp]
declare (in dec9_example) const_fnbdy[simp]
declare (in dec9_example) dec_methbdy[simp]
declare (in dec9_example) dec_wfmeasure[simp]
declare (in dec9_example) dec_preinv[simp]
declare (in dec9_example) dec_postinv[simp]
declare (in dec9_example) const_preinv[simp]
declare (in dec9_example) const_postinv[simp]
declare (in dec9_example) constPreInv_def[simp]
declare (in dec9_example) constPostInv_def[simp]

(* all-in-one; std ... *)
lemma (in dec9_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z \<and> s<z1>=1}	
      IF z1
        THEN CALL const
        ELSE IVar n
      {(z,s,v). v = IVal z}"
apply (insert vardistinct)
apply (simp)
apply hoare_simp
apply auto
oops

(* invoke *)
lemma (in dec9_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) |] ==>
    \<Turnstile> {(z::int,s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := z), emptyr) \<and> 0 < z}	
       self\<bullet>dec(self)
      {(z,s,v). v = IVal (z - 1)}"
apply (insert vardistinct)
apply (simp)
apply hoare_simp
oops
(* bummer *)

end
