(*  
   File:        ToyVCGtest.ML
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVCGtest8.thy,v 1.1 2003/06/24 23:21:47 da Exp $

   More tests of the VCG (coast/pedal).
*)

theory ToyVCGtest8 = ToyVCG0 + ToyPrelude + ToyHLbasic0:

section {* Testing the VCGen *}

subsection {* \texttt{coast/pedal} example (mut-rec CALL) taken from~\cite{Nipkow-CSL02} *}

(* doesn't work yet *)

locale coast_pedal_example =
    fixes    m  :: iname
      and    n  :: iname
      and    q1 :: iname
      and    q2 :: iname
      and    q3 :: iname
      and    q4 :: iname
      and    q5 :: iname
      and    M :: int
      and    N :: int
      and pedal :: funame
      and coast :: funame
      and pedalBody :: expr
      and coastBody :: expr
  defines "pedalBody == LET
                         q1 = n :0? ;
                         q2 = m :0? ;
                         q3 = q1 :& q3
                       IN
                       	 IF q3 
                       	   THEN IVar q3 
                       	   ELSE LET
                       	          q4 = n :< m
                       	        IN
                       	          IF q4
                       	            THEN LET
                       	                   n = n :-- ;
                       	                   m = m :--
                       	                 IN 
                       	                   CALL coast
                       	                 END
                       	             ELSE LET
                       	                   n = n :--
                       	                  IN 
                       	                   CALL pedal
                       	                  END
	                        END
                       END"
      and "coastBody == LET
                         q5 = n :< m
                       IN
                         IF q5
                           THEN LET
                                  m = m :--
                                IN
                                  CALL coast
                                END
                           ELSE CALL pedal
                       END"
  assumes pedalfnbdy : "funtable pedal = pedalBody"
      and coastfnbdy : "funtable coast = coastBody"
      and vardistinct : "distinct [m,n,q1,q2,q3,q4,q5]"

      (* ToDo: use lexicographic ordering on (n,m) as measure
         and  wfmeasure [simp]:  "fun_wfmeasure_table countfn = inv_image less_than (\<lambda> s. nat (get_ivar s n))"*)

declare (in coast_pedal_example) pedalfnbdy [simp]  (* function body lookup *)
declare (in coast_pedal_example) coastfnbdy [simp]  (* function body lookup *)
declare (in coast_pedal_example) pedalBody_def [simp]  (* unfold function body *)
declare (in coast_pedal_example) coastBody_def [simp]  (* unfold function body *)

lemma (in coast_pedal_example) 
   "\<forall> M N .
    \<Turnstile> {(z,s). (s<m>=M) \<and> (s<n>=N) \<and> (0<N) \<and> (0<M)} 
	pedalBody
      {(z,s,v). (v = IVal 1) \<and> (s<m>=0) \<and> (s<n>=0)}"
apply (insert vardistinct)
apply (simp)
oops
(* apply hoare_simp*) (* loops *)

subsection {* ping (INVOKE version) *}

(*
locale example_ping =
  fixes    m :: iname
    and	   n :: iname
    and	   z1 :: iname
    and	   q1 :: iname
    and	   zero :: iname
    and	   dummyarg :: iname
    and	   count    :: ifldname
    and	   ping     :: mname
    and	   countfn  :: funame
    and    PingClass :: cname 
    and	   pingBody :: expr
  defines "pingBody \<equiv>  LET 
                m  = GetFi self count ;
                n  = Primop (\<lambda> x y . x - 1) m m ;
                z1 = PutFi self count n ; 
                zero = expr.Int 0 ;
                q1 = Primop (\<lambda> x y . if y<x then (1::int) else (0::int)) n zero
              IN
                IF q1 
                  THEN Invoke self ping dummyarg
                  ELSE Var z1
              END"
  assumes  PingClass: "classtable PingClass = \<lparr> flds = [count], meths = empty ( ping \<mapsto> ({m,n,z1,q1,zero}, pingBody) ) \<rparr>"
      and  vardistinct: "distinct [m,n,z1,q1,zero]"
*)
end

(* -- doing single stepping through the derivation *)
apply hoare_simp_step (* step 1 *)
defer 1
apply hoare_simp_step (* step 2 *)
defer 1
apply hoare_simp_step (* step 3 *)
defer 1
apply hoare_simp_step (* step 4 *)
defer 1
apply hoare_simp_step (* step 5 *)
defer 1
apply hoare_simp_step
apply (tactic {* HoareRecWFCall 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HCall0") 1 *})
apply (tactic {* rtac allI 1 *})
apply (simp)
(* body now unfolded *)
apply hoare_simp_step (* step 1 *)
defer 1
apply hoare_simp_step (* step 2 *)
defer 1
apply hoare_simp_step (* step 3 *)
defer 1
apply hoare_simp_step (* step 4 *)
defer 1
apply hoare_simp_step (* step 5 *)
defer 1
apply hoare_simp_step
(* at CALL again; we should be able to apply assumption now *)
apply (tactic {* (assume_tac 1) *})
apply hoare_simp_step (* IVar *)
defer 1
apply hoare_simp_step (* IVar *)
apply hoare_simp_step (* GetFi self count *)
(* needs simp *)
(* apply (tactic {* (BasicSimpTac tac 1) *} *)
defer 1
apply hoare_simp_step (* Primop *)
apply hoare_simp_step (* GetFi self count *)
apply hoare_simp_step (* Int 0 *)
apply hoare_simp_step (* Primop *)
apply hoare_simp_step (* GetFi self count *)
(* needs simp *)
defer 1
apply hoare_simp_step (* Primop *)
apply hoare_simp_step (* GetFi self count *)
apply hoare_simp_step (* Int 0 *)
apply hoare_simp_step (* Primop *)
(* wf-ness follows from assumption *)
apply (assumption)
(* -- now only VCs left *)
apply (auto)
(* False; petaQ!!!! *)
oops

(*ping*)
apply hoare_simp_step (* IF *)
(* the next step should introduce an ind hyp *)
apply hoare_simp_step (* IF *)
(* needs debugging to figure out where the VCG gets stuck *)
apply (tactic {* HoareRecWFCall 1 *})
apply (tactic {* rtac allI 1 *})
apply (tactic {* rtac impI 1 *})
apply (tactic {* rtac (thm "HCall0") 1 *})
apply (tactic {* rtac allI 1 *})
(* apply (tactic {* rtac (thm "subset_refl") 1 *}) *)
(* apply (tactic {* BasicSimpTac all_tac 1 *}) *)
apply (simp)
apply hoare_simp
apply (fastsimp)
defer 1
apply simp
defer 1
apply (simp add: state_functions)
apply hoare_simp_step
apply (fastsimp)
apply hoare_simp_step
defer 1
apply hoare_simp_step
apply (fastsimp)


apply (rule HCall)

apply hoare_simp_step
apply (simp)

apply (simp add: state_functions)

end
